/*
 * Decompiled with CFR 0.152.
 */
package com.tugos.dst.admin.controller;

import com.tugos.dst.admin.common.ResultVO;
import com.tugos.dst.admin.service.SettingService;
import com.tugos.dst.admin.vo.GameConfigVO;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/setting"})
public class SettingController {
    private static final Logger log = LoggerFactory.getLogger(SettingController.class);
    private SettingService settingService;

    @GetMapping(value={"/index"})
    @RequiresAuthentication
    public String index(HttpServletRequest request) {
        log.info("\u8fdb\u5165\u6e38\u620f\u8bbe\u7f6e\u9875");
        Locale locale = LocaleContextHolder.getLocale();
        if (Locale.CHINA.getLanguage().equals(locale.getLanguage())) {
            request.setAttribute("lang", (Object)"zh");
        } else {
            request.setAttribute("lang", (Object)"en");
        }
        return "/setting/index";
    }

    @PostMapping(value={"/saveConfig"})
    @RequiresAuthentication
    @ResponseBody
    public ResultVO<String> saveConfig(@RequestBody GameConfigVO model) throws Exception {
        log.info("\u4fdd\u5b58\u6e38\u620f\u914d\u7f6e\uff0c{}", (Object)StringUtils.deleteWhitespace((String)model.toString()));
        return this.settingService.saveConfig(model);
    }

    @GetMapping(value={"/getConfig"})
    @RequiresAuthentication
    @ResponseBody
    public ResultVO<GameConfigVO> getConfig() throws Exception {
        log.info("\u8bfb\u53d6\u6e38\u620f\u914d\u7f6e");
        GameConfigVO config = this.settingService.getConfig();
        return ResultVO.data((Object)config);
    }

    @Autowired
    public void setSettingService(SettingService settingService) {
        this.settingService = settingService;
    }
}

