/*
 * Decompiled with CFR 0.152.
 */
package com.tugos.dst.admin.controller;

import cn.hutool.core.io.FileUtil;
import cn.hutool.json.JSONUtil;
import com.tugos.dst.admin.common.ResultVO;
import com.tugos.dst.admin.config.I18nResourcesConfig;
import com.tugos.dst.admin.service.BackupService;
import com.tugos.dst.admin.vo.BackupFileVO;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/backup"})
public class BackupController {
    private static final Logger log = LoggerFactory.getLogger(BackupController.class);
    private BackupService backupService;

    @GetMapping(value={"/index"})
    @RequiresAuthentication
    public String index() {
        return "/backup/index";
    }

    @GetMapping(value={"/getBackupList"})
    @ResponseBody
    @RequiresAuthentication
    public ResultVO<List<BackupFileVO>> getBackupList() {
        return ResultVO.data((Object)this.backupService.getBackupFileInfo());
    }

    @GetMapping(value={"/download"})
    @RequiresAuthentication
    public void download(String fileName, HttpServletResponse response) throws Exception {
        log.info("\u4e0b\u8f7d\u6587\u4ef6\uff1a" + fileName);
        this.backupService.download(fileName, response);
    }

    @PostMapping(value={"/upload"})
    @RequiresAuthentication
    @ResponseBody
    public ResultVO<String> upload(@RequestParam(value="file") MultipartFile file) throws Exception {
        String suffix = FileUtil.extName((String)file.getOriginalFilename());
        if (!"tar".equalsIgnoreCase(suffix) && !"zip".equalsIgnoreCase(suffix)) {
            return ResultVO.fail((String)I18nResourcesConfig.getMessage((String)"tip.backup.tarfile"));
        }
        return this.backupService.upload(file);
    }

    @PostMapping(value={"/deleteBackup"})
    @ResponseBody
    @RequiresAuthentication
    public ResultVO<String> deleteBackup(@RequestBody String[] fileNames) {
        log.info("\u5220\u9664\u5907\u4efd:{}", (Object)JSONUtil.toJsonStr((Object)fileNames));
        if (fileNames != null && fileNames.length > 0) {
            for (String s : fileNames) {
                this.backupService.deleteBackup(s);
            }
        }
        return ResultVO.success();
    }

    @GetMapping(value={"/rename"})
    @ResponseBody
    @RequiresAuthentication
    public ResultVO<String> rename(String fileName, String newFileName) {
        log.info("\u91cd\u547d\u540d\u5907\u4efd:{},\u65b0\u6587\u4ef6\u540d:{}", (Object)fileName, (Object)newFileName);
        return this.backupService.rename(fileName, newFileName);
    }

    @Autowired
    public void setBackupService(BackupService backupService) {
        this.backupService = backupService;
    }
}

