/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools.generic;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPathExpressionException;
import org.apache.velocity.tools.ConversionUtils;
import org.apache.velocity.tools.XmlUtils;
import org.apache.velocity.tools.config.DefaultKey;
import org.apache.velocity.tools.generic.ImportSupport;
import org.apache.velocity.tools.generic.SafeConfig;
import org.apache.velocity.tools.generic.ValueParser;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

@DefaultKey(value="xml")
public class XmlTool
extends SafeConfig
implements Serializable {
    private static final long serialVersionUID = 8217744660691416595L;
    protected transient ImportSupport importSupport = null;
    private List<Node> nodes = null;

    protected synchronized void initializeImportSupport(ValueParser config) {
        if (this.importSupport == null) {
            this.importSupport = new ImportSupport();
            this.importSupport.configure(config);
        }
    }

    @Override
    protected void configure(ValueParser values) {
        super.configure(values);
        this.initializeImportSupport(values);
        String resource = values.getString("resource");
        if (resource != null) {
            this.read(resource);
        } else {
            String url = values.getString("url");
            if (url != null) {
                boolean safeMode = this.importSupport.isSafeMode();
                this.importSupport.setSafeMode(false);
                this.fetch(url);
                this.importSupport.setSafeMode(safeMode);
            }
        }
    }

    public XmlTool() {
    }

    public XmlTool(Node node) {
        this(Collections.singletonList(node));
    }

    public XmlTool(List<Node> nodes) {
        this.nodes = nodes;
    }

    protected void setRoot(Node node) {
        if (node == null) {
            this.nodes = null;
        } else {
            if (node instanceof Document) {
                node = ((Document)node).getDocumentElement();
            }
            this.nodes = new ArrayList<Node>(1);
            this.nodes.add(node);
        }
    }

    public XmlTool parse(String xml) {
        try {
            if (xml != null) {
                this.setRoot(XmlUtils.parse(xml));
            }
        }
        catch (Exception e) {
            this.getLog().error("could not parse given XML string", (Throwable)e);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlTool read(String resource) {
        Reader reader = null;
        try {
            if (this.importSupport == null) {
                this.initializeImportSupport(new ValueParser());
            }
            if ((reader = this.importSupport.getResourceReader(resource)) != null) {
                this.setRoot(XmlUtils.parse(reader));
            }
        }
        catch (Exception e) {
            this.getLog().error("could not read XML resource {}", (Object)resource, (Object)e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlTool fetch(String url) {
        Reader reader = null;
        try {
            if (this.importSupport == null) {
                this.initializeImportSupport(new ValueParser());
            }
            if ((reader = this.importSupport.acquireReader(url)) != null) {
                this.setRoot(XmlUtils.parse(reader));
            }
        }
        catch (Exception e) {
            this.getLog().error("could not fetch XML content from URL {}", (Object)url, (Object)e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return this;
    }

    public Object get(Object o) {
        if (this.isEmpty() || o == null) {
            return null;
        }
        String attr = this.attr(o);
        if (attr != null && attr.length() > 0) {
            return attr;
        }
        Number i = ConversionUtils.toNumber(o);
        if (i != null) {
            return this.get(i);
        }
        Object s = String.valueOf(o);
        if (((String)s).length() == 0) {
            return null;
        }
        if (((String)s).indexOf(47) < 0) {
            s = this.getPath() + "/" + (String)s;
        }
        return this.find((String)s);
    }

    public Object getName() {
        Object name = this.get("name");
        if (name != null && !"".equals(name)) {
            return name;
        }
        return this.getNodeName();
    }

    public String getNodeName() {
        if (this.isEmpty()) {
            return null;
        }
        return this.node().getNodeName();
    }

    @Deprecated
    public String getPath() {
        return this.getNodePath();
    }

    public String getNodePath() {
        if (this.isEmpty()) {
            return null;
        }
        return XmlUtils.nodePath(this.node());
    }

    public String attr(Object o) {
        String value;
        if (o == null) {
            return null;
        }
        String key = String.valueOf(o);
        Node node = this.node();
        if (node instanceof Element && (value = ((Element)node).getAttribute(key)).length() > 0) {
            return value;
        }
        return null;
    }

    public Map<String, String> attributes() {
        Node node = this.node();
        if (node instanceof Element) {
            HashMap<String, String> attrs = new HashMap<String, String>();
            NamedNodeMap map = node.getAttributes();
            for (int i = 0; i < map.getLength(); ++i) {
                Attr attr = (Attr)map.item(i);
                attrs.put(attr.getName(), attr.getValue());
            }
            return attrs;
        }
        return null;
    }

    public boolean isEmpty() {
        return this.nodes == null || this.nodes.isEmpty();
    }

    public int size() {
        if (this.isEmpty()) {
            return 0;
        }
        return this.nodes.size();
    }

    public Iterator<XmlTool> iterator() {
        if (this.isEmpty()) {
            return null;
        }
        return new NodeIterator(this.nodes.iterator());
    }

    public XmlTool getFirst() {
        if (this.size() == 1) {
            return this;
        }
        if (this.isEmpty()) {
            return null;
        }
        return new XmlTool(this.node());
    }

    public XmlTool getLast() {
        if (this.size() == 1) {
            return this;
        }
        if (this.isEmpty()) {
            return null;
        }
        return new XmlTool(this.nodes.get(this.size() - 1));
    }

    public XmlTool get(Number n) {
        if (n == null || this.isEmpty()) {
            return null;
        }
        int i = n.intValue();
        if (i < 0 || i > this.size() - 1) {
            return null;
        }
        return new XmlTool(this.nodes.get(i));
    }

    public Node node() {
        if (this.isEmpty()) {
            return null;
        }
        return this.nodes.get(0);
    }

    public XmlTool find(Object o) {
        if (o == null || this.isEmpty()) {
            return null;
        }
        return this.find(String.valueOf(o));
    }

    public XmlTool find(String xpath) {
        if (xpath == null || ((String)xpath).length() == 0 || this.isEmpty()) {
            return null;
        }
        if (((String)xpath).indexOf(47) < 0) {
            xpath = "//" + (String)xpath;
        }
        ArrayList<Node> found = new ArrayList<Node>();
        for (Node n : this.nodes) {
            NodeList lst;
            try {
                lst = XmlUtils.search((String)xpath, n);
            }
            catch (XPathExpressionException xpee) {
                this.getLog().error("could not parse XML expression '{}'", xpath, (Object)xpee);
                return null;
            }
            if (lst == null) continue;
            for (int i = 0; i < lst.getLength(); ++i) {
                found.add(lst.item(i));
            }
        }
        if (found.isEmpty()) {
            return null;
        }
        return new XmlTool(found);
    }

    public XmlTool getParent() {
        if (this.isEmpty()) {
            return null;
        }
        Node parent = this.node().getParentNode();
        if (parent == null || parent instanceof Document) {
            return null;
        }
        return new XmlTool(parent);
    }

    public XmlTool parents() {
        if (this.isEmpty()) {
            return null;
        }
        if (this.size() == 1) {
            return this.getParent();
        }
        ArrayList<Node> parents = new ArrayList<Node>(this.size());
        for (Node n : this.nodes) {
            Element parent = null;
            if (n instanceof Element) {
                parent = (Element)n.getParentNode();
            } else if (n instanceof Attr) {
                parent = ((Attr)n).getOwnerElement();
            }
            if (parent == null || parents.contains(parent)) continue;
            parents.add(parent);
        }
        if (parents.isEmpty()) {
            return null;
        }
        return new XmlTool(parents);
    }

    public XmlTool children() {
        if (this.isEmpty()) {
            return null;
        }
        ArrayList<Node> kids = new ArrayList<Node>();
        for (Node n : this.nodes) {
            if (!(n instanceof Element)) continue;
            NodeList lst = n.getChildNodes();
            for (int i = 0; i < lst.getLength(); ++i) {
                String value;
                Node child = lst.item(i);
                if (child instanceof Text && (value = child.getNodeValue().trim()).length() == 0) continue;
                kids.add(child);
            }
        }
        return new XmlTool(kids);
    }

    public String getText() {
        if (this.isEmpty()) {
            return null;
        }
        StringBuilder out = new StringBuilder();
        for (Node n : this.nodes) {
            String text = n.getTextContent().trim();
            if (text == null || text.length() <= 0) continue;
            out.append(text);
        }
        String result = out.toString().trim();
        if (result.length() > 0) {
            return result;
        }
        return null;
    }

    public String toString() {
        if (this.isEmpty()) {
            return super.toString();
        }
        StringBuilder out = new StringBuilder();
        for (Node n : this.nodes) {
            if (n instanceof Attr) {
                out.append(((Attr)n).getValue().trim());
                continue;
            }
            out.append(XmlUtils.nodeToString(n));
        }
        return out.toString().trim();
    }

    public static class NodeIterator
    implements Iterator<XmlTool> {
        private Iterator<Node> i;

        public NodeIterator(Iterator<Node> i) {
            this.i = i;
        }

        @Override
        public boolean hasNext() {
            return this.i.hasNext();
        }

        @Override
        public XmlTool next() {
            return new XmlTool(this.i.next());
        }

        @Override
        public void remove() {
            this.i.remove();
        }
    }
}

