/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.concurrent.LinkedBlockingDeque;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class XmlUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(XmlUtils.class);
    private static final ErrorHandler errorHandler = new ErrorHandler(){

        @Override
        public void error(SAXParseException exception) throws SAXException {
            throw exception;
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            throw exception;
        }

        @Override
        public void warning(SAXParseException exception) {
            LOGGER.info("warning during parsing", (Throwable)exception);
        }
    };
    private static boolean canReuseBuilders = false;
    private static final DocumentBuilderFactory builderFactory = XmlUtils.createDocumentBuilderFactory();
    private static final ThreadLocal<DocumentBuilder> reusableBuilder = new ThreadLocal<DocumentBuilder>(){

        @Override
        protected DocumentBuilder initialValue() {
            try {
                LOGGER.trace("Created a new document builder");
                return builderFactory.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                throw new RuntimeException(e);
            }
        }
    };
    private static LinkedBlockingDeque<SoftReference<DocumentBuilder>> builderPool;
    private static int maxBuildersCount;
    private static int currentBuildersCount;
    private static final String BUILDER_MAX_INSTANCES_KEY = "velocity.tools.xml.documentbuilder.max.instances";

    public static final DocumentBuilderFactory createDocumentBuilderFactory() {
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        builderFactory.setNamespaceAware(true);
        builderFactory.setValidating(false);
        try {
            builderFactory.setAttribute("http://xml.org/sax/features/external-general-entities", false);
        }
        catch (IllegalArgumentException e) {
            LOGGER.info("Error parsing external general entities: ", (Throwable)e);
        }
        try {
            builderFactory.setAttribute("http://xml.org/sax/features/external-parameter-entities", false);
        }
        catch (IllegalArgumentException e) {
            LOGGER.info("Error parsing external parameter entities: ", (Throwable)e);
        }
        try {
            builderFactory.setAttribute("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        catch (IllegalArgumentException e) {
            LOGGER.info("Error parsing external DTD: ", (Throwable)e);
        }
        try {
            builderFactory.setAttribute("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (IllegalArgumentException e) {
            LOGGER.info("Error parsing secure XML: ", (Throwable)e);
        }
        return builderFactory;
    }

    private static synchronized DocumentBuilder getDocumentBuilder() {
        DocumentBuilder builder = null;
        if (canReuseBuilders && builderPool.size() > 0) {
            builder = builderPool.pollFirst().get();
        }
        if (builder == null) {
            if (!canReuseBuilders || currentBuildersCount < maxBuildersCount) {
                try {
                    builder = builderFactory.newDocumentBuilder();
                    builder.setErrorHandler(errorHandler);
                    ++currentBuildersCount;
                }
                catch (Exception e) {
                    throw new RuntimeException("could not create a new XML DocumentBuilder instance", e);
                }
            }
            try {
                LOGGER.warn("reached XML DocumentBuilder pool size limit, current thread needs to wait; you can increase pool size with the {} system property", (Object)BUILDER_MAX_INSTANCES_KEY);
                builder = builderPool.takeFirst().get();
            }
            catch (InterruptedException ie) {
                LOGGER.warn("caught an InterruptedException while waiting for a DocumentBuilder instance");
            }
        }
        return builder;
    }

    private static synchronized void releaseBuilder(DocumentBuilder builder) {
        builder.reset();
        builderPool.addLast(new SoftReference<DocumentBuilder>(builder));
    }

    private XmlUtils() {
    }

    public static String getAttribute(Node node, String attr, String def) {
        NamedNodeMap attrs = node.getAttributes();
        Node val = attrs.getNamedItem(attr);
        if (val != null) {
            return val.getNodeValue();
        }
        return def;
    }

    public static String getAttribute(Node node, String attr) {
        return XmlUtils.getAttribute(node, attr, null);
    }

    public static boolean getBoolAttribute(Node node, String attr, boolean def) {
        String value = XmlUtils.getAttribute(node, attr);
        if (value == null) {
            return def;
        }
        return Boolean.parseBoolean(value);
    }

    public static boolean getBoolAttribute(Node node, String attr) {
        return XmlUtils.getBoolAttribute(node, attr, false);
    }

    public static int getIntAttribute(Node node, String attr, int def) {
        String value = XmlUtils.getAttribute(node, attr);
        if (value == null) {
            return def;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    public static int getIntAttribute(Node node, String attr) {
        return XmlUtils.getIntAttribute(node, attr, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element parse(Reader xml) {
        Element ret = null;
        DocumentBuilder builder = XmlUtils.getDocumentBuilder();
        try {
            ret = builder.parse(new InputSource(xml)).getDocumentElement();
            XmlUtils.releaseBuilder(builder);
            Element element = ret;
            return element;
        }
        catch (Exception e) {
            LOGGER.error("could not parse given xml", (Throwable)e);
        }
        finally {
            XmlUtils.releaseBuilder(builder);
        }
        return ret;
    }

    public static Element parse(String xml) {
        return XmlUtils.parse(new StringReader(xml));
    }

    public static NodeList search(String xpath, Node context) throws XPathExpressionException {
        NodeList ret = null;
        XPath xp = XPathFactory.newInstance().newXPath();
        XPathExpression exp = xp.compile(xpath);
        ret = (NodeList)exp.evaluate(context, XPathConstants.NODESET);
        return ret;
    }

    public static List<Node> getNodes(String xpath, Node context) throws XPathExpressionException {
        ArrayList<Node> ret = new ArrayList<Node>();
        NodeList lst = XmlUtils.search(xpath, context);
        for (int i = 0; i < lst.getLength(); ++i) {
            ret.add(lst.item(i));
        }
        return ret;
    }

    public static List<Element> getElements(String xpath, Node context) throws XPathExpressionException {
        ArrayList<Element> ret = new ArrayList<Element>();
        NodeList lst = XmlUtils.search(xpath, context);
        for (int i = 0; i < lst.getLength(); ++i) {
            ret.add((Element)lst.item(i));
        }
        return ret;
    }

    public static String nodePath(Node n) {
        if (null == n) {
            return null;
        }
        Node parent = null;
        Stack<Node> hierarchy = new Stack<Node>();
        StringBuffer buffer = new StringBuffer(47);
        hierarchy.push(n);
        switch (n.getNodeType()) {
            case 2: {
                parent = ((Attr)n).getOwnerElement();
                break;
            }
            case 1: 
            case 8: 
            case 9: {
                parent = n.getParentNode();
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected Node type" + n.getNodeType());
            }
        }
        while (null != parent && parent.getNodeType() != 9) {
            hierarchy.push(parent);
            parent = parent.getParentNode();
        }
        Object obj = null;
        while (!hierarchy.isEmpty()) {
            Object e = hierarchy.pop();
            obj = e;
            if (null == e) break;
            Node node = obj;
            boolean handled = false;
            if (node.getNodeType() == 1) {
                Element e2 = (Element)node;
                if (buffer.length() == 1) {
                    buffer.append(node.getNodeName());
                    continue;
                }
                buffer.append("/");
                buffer.append(node.getNodeName());
                if (node.hasAttributes()) {
                    if (e2.hasAttribute("id")) {
                        buffer.append("[@id='" + e2.getAttribute("id") + "']");
                        handled = true;
                    } else if (e2.hasAttribute("name")) {
                        buffer.append("[@name='" + e2.getAttribute("name") + "']");
                        handled = true;
                    }
                }
                if (handled) continue;
                int prev_siblings = 1;
                for (Node prev_sibling = node.getPreviousSibling(); null != prev_sibling; prev_sibling = prev_sibling.getPreviousSibling()) {
                    if (prev_sibling.getNodeType() != node.getNodeType() || !prev_sibling.getNodeName().equalsIgnoreCase(node.getNodeName())) continue;
                    ++prev_siblings;
                }
                buffer.append("[" + prev_siblings + "]");
                continue;
            }
            if (node.getNodeType() != 2) continue;
            buffer.append("/@");
            buffer.append(node.getNodeName());
        }
        return buffer.toString();
    }

    public static String nodeToString(Node node) {
        StringWriter sw = new StringWriter();
        try {
            Transformer t = TransformerFactory.newInstance().newTransformer();
            t.setOutputProperty("omit-xml-declaration", "yes");
            t.setOutputProperty("indent", "no");
            t.setOutputProperty("encoding", "UTF-8");
            t.transform(new DOMSource(node), new StreamResult(sw));
        }
        catch (TransformerException te) {
            LOGGER.error("could not convert XML node to string", (Throwable)te);
        }
        return sw.toString();
    }

    public static boolean isXmlMimeType(String mimeType) {
        return mimeType != null && ("text/xml".equals(mimeType) || "application/xml".equals(mimeType) || mimeType.endsWith("+xml"));
    }

    static {
        try {
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            builder.reset();
            canReuseBuilders = true;
            LOGGER.trace("reusing document builders");
        }
        catch (UnsupportedOperationException e) {
            canReuseBuilders = false;
            LOGGER.trace("not reusing document builders");
        }
        catch (ParserConfigurationException e) {
            canReuseBuilders = false;
            LOGGER.trace("not reusing document builders");
        }
        builderPool = new LinkedBlockingDeque();
        maxBuildersCount = 100;
        currentBuildersCount = 0;
        try {
            String configuredMax = System.getProperty(BUILDER_MAX_INSTANCES_KEY);
            if (configuredMax != null) {
                maxBuildersCount = Integer.parseInt(configuredMax);
            }
        }
        catch (Exception e) {
            LOGGER.error("could not configure XML document builder max instances count", (Throwable)e);
        }
    }
}

