/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.request.jsp;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.jsp.JspContext;
import jakarta.servlet.jsp.PageContext;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.tiles.request.AbstractViewRequest;
import org.apache.tiles.request.ApplicationContext;
import org.apache.tiles.request.DispatchRequest;
import org.apache.tiles.request.attribute.AttributeExtractor;
import org.apache.tiles.request.collection.ScopeMap;
import org.apache.tiles.request.jsp.JspPrintWriterAdapter;
import org.apache.tiles.request.jsp.extractor.ScopeExtractor;
import org.apache.tiles.request.jsp.extractor.SessionScopeExtractor;
import org.apache.tiles.request.servlet.ServletRequest;
import org.apache.tiles.request.servlet.ServletUtil;

public class JspRequest
extends AbstractViewRequest {
    private static final List<String> SCOPES = Collections.unmodifiableList(Arrays.asList("page", "request", "session", "application"));
    private PageContext pageContext;
    private Map<String, Object> pageScope = null;
    private Map<String, Object> requestScope = null;
    private Map<String, Object> sessionScope = null;
    private Map<String, Object> applicationScope = null;

    public static JspRequest createServletJspRequest(ApplicationContext applicationContext, PageContext pageContext) {
        return new JspRequest((DispatchRequest)new ServletRequest(applicationContext, (HttpServletRequest)pageContext.getRequest(), (HttpServletResponse)pageContext.getResponse()), pageContext);
    }

    public JspRequest(DispatchRequest enclosedRequest, PageContext pageContext) {
        super(enclosedRequest);
        this.pageContext = pageContext;
    }

    public List<String> getAvailableScopes() {
        return SCOPES;
    }

    protected void doInclude(String path) throws IOException {
        try {
            this.pageContext.include(path, false);
        }
        catch (ServletException e) {
            throw ServletUtil.wrapServletException((ServletException)e, (String)("JSPException including path '" + path + "'."));
        }
    }

    public PrintWriter getPrintWriter() {
        return new JspPrintWriterAdapter(this.pageContext.getOut());
    }

    public Writer getWriter() {
        return this.pageContext.getOut();
    }

    public Map<String, Object> getPageScope() {
        if (this.pageScope == null && this.pageContext != null) {
            this.pageScope = new ScopeMap((AttributeExtractor)new ScopeExtractor((JspContext)this.pageContext, 1));
        }
        return this.pageScope;
    }

    public Map<String, Object> getRequestScope() {
        if (this.requestScope == null && this.pageContext != null) {
            this.requestScope = new ScopeMap((AttributeExtractor)new ScopeExtractor((JspContext)this.pageContext, 2));
        }
        return this.requestScope;
    }

    public Map<String, Object> getSessionScope() {
        if (this.sessionScope == null && this.pageContext != null) {
            this.sessionScope = new ScopeMap((AttributeExtractor)new SessionScopeExtractor(this.pageContext));
        }
        return this.sessionScope;
    }

    public Map<String, Object> getApplicationScope() {
        if (this.applicationScope == null && this.pageContext != null) {
            this.applicationScope = new ScopeMap((AttributeExtractor)new ScopeExtractor((JspContext)this.pageContext, 4));
        }
        return this.applicationScope;
    }

    public PageContext getPageContext() {
        return this.pageContext;
    }

    public Map<String, Object> getContext(String scope) {
        if ("page".equals(scope)) {
            return this.getPageScope();
        }
        if ("request".equals(scope)) {
            return this.getRequestScope();
        }
        if ("session".equals(scope)) {
            return this.getSessionScope();
        }
        if ("application".equals(scope)) {
            return this.getApplicationScope();
        }
        throw new IllegalArgumentException(scope + " does not exist. Call getAvailableScopes() first to check.");
    }
}

