/*
 * Decompiled with CFR 0.152.
 */
package com.github.phillipkruger.profiling;

import com.github.phillipkruger.profiling.UserEvent;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonReader;
import javax.json.JsonValue;

@Dependent
public class UserEventConverter {
    public static final String USER_ID = "userId";
    public static final String EVENT_NAME = "eventName";
    public static final String LOCATION = "location";
    public static final String PARTNER_NAME = "partnerName";
    public static final String TIME_OCCURED = "timeOccured";
    public static final String TIME_RECEIVED = "timeReceived";
    public static final String DURATION_IN_MINUTES = "durationInMinutes";
    public static final String METADATA = "metaData";
    private static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ssX";

    public JsonObject toJsonObject(UserEvent event) {
        JsonObjectBuilder objectBuilder = Json.createObjectBuilder();
        objectBuilder.add(USER_ID, event.getUserId());
        objectBuilder.add(EVENT_NAME, event.getEventName());
        objectBuilder.add(LOCATION, event.getLocation());
        objectBuilder.add(PARTNER_NAME, event.getPartnerName());
        objectBuilder.add(TIME_OCCURED, this.toString(event.getTimeOccured()));
        objectBuilder.add(TIME_RECEIVED, this.toString(event.getTimeReceived()));
        objectBuilder.add(DURATION_IN_MINUTES, event.getDurationInMinutes());
        Set entrySet = event.getMetadata().entrySet();
        JsonObjectBuilder metadataBuilder = Json.createObjectBuilder();
        for (Map.Entry entry : entrySet) {
            metadataBuilder.add((String)entry.getKey(), (String)entry.getValue());
        }
        objectBuilder.add(METADATA, (JsonValue)metadataBuilder.build());
        return objectBuilder.build();
    }

    public String toJsonString(UserEvent event) {
        JsonObject jsonObject = this.toJsonObject(event);
        return jsonObject.toString();
    }

    public UserEvent fromJsonObject(JsonObject jsonObject) {
        JsonObject jsonMetadata;
        UserEvent event = new UserEvent();
        event.setUserId(jsonObject.getJsonNumber(USER_ID).intValue());
        event.setEventName(jsonObject.getString(EVENT_NAME));
        event.setLocation(jsonObject.getString(LOCATION));
        event.setPartnerName(jsonObject.getString(PARTNER_NAME));
        event.setTimeOccured(this.toDate(jsonObject.getString(TIME_OCCURED)));
        event.setTimeReceived(this.toDate(jsonObject.getString(TIME_RECEIVED)));
        event.setDurationInMinutes(jsonObject.getJsonNumber(DURATION_IN_MINUTES).intValue());
        if (!jsonObject.isNull(METADATA) && !(jsonMetadata = jsonObject.getJsonObject(METADATA)).isEmpty()) {
            Set keySet = jsonMetadata.keySet();
            for (String key : keySet) {
                event.addMetadata(key, jsonMetadata.getString(key));
            }
        }
        return event;
    }

    public UserEvent fromJsonString(String json) {
        try (JsonReader jsonReader = Json.createReader((Reader)new StringReader(json));){
            JsonObject object = jsonReader.readObject();
            UserEvent userEvent = this.fromJsonObject(object);
            return userEvent;
        }
    }

    public UserEvent fromJsonStream(InputStream is) {
        try (JsonReader jsonReader = Json.createReader((InputStream)is);){
            JsonObject object = jsonReader.readObject();
            UserEvent userEvent = this.fromJsonObject(object);
            return userEvent;
        }
    }

    private Date toDate(String d) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
            return sdf.parse(d);
        }
        catch (ParseException ex) {
            throw new RuntimeException(ex);
        }
    }

    private String toString(Date d) {
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
        return sdf.format(d);
    }
}

