/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.bootstrap.util;

import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.jar.JarFile;
import org.wildfly.swarm.bootstrap.util.TempFileManager;

public class JarFileManager {
    public static final JarFileManager INSTANCE = new JarFileManager();
    private Map<File, JarFile> jarFileToClose = new LinkedHashMap<File, JarFile>();

    private JarFileManager() {
    }

    public JarFile getJarFile(File file) throws IOException {
        return TempFileManager.isTempFile(file) ? this.addJarFile(file) : new JarFile(file);
    }

    public JarFile addJarFile(File file) throws IOException {
        JarFile jarFile = this.jarFileToClose.get(file);
        if (jarFile == null) {
            jarFile = new JarFile(file);
            this.jarFileToClose.put(file, jarFile);
        }
        return jarFile;
    }

    public void close() throws IOException {
        IOException ex = null;
        for (JarFile jarFile : this.jarFileToClose.values()) {
            try {
                jarFile.close();
            }
            catch (IOException e) {
                ex = e;
            }
        }
        if (ex != null) {
            throw ex;
        }
    }
}

