/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.numbers;

import com.upokecenter.numbers.EIntegerByteArrayString;
import com.upokecenter.numbers.EIntegerCharArrayString;
import com.upokecenter.numbers.EIntegerTextString;
import com.upokecenter.numbers.FastInteger;
import com.upokecenter.numbers.NumberUtility;
import java.util.Arrays;

public final class EInteger
implements Comparable<EInteger> {
    private static final String Digits = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final int Toom3Threshold = 100;
    private static final int Toom4Threshold = 400;
    private static final int MultRecursionThreshold = 10;
    private static final int RecursiveDivisionLimit = 201;
    private static final int CacheFirst = -24;
    private static final int CacheLast = 128;
    private static final int ShortMask = 65535;
    static final int[] CharToDigit = new int[]{36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 36, 36, 36, 36, 36, 36, 36, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 36, 36, 36, 36, 36, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 36, 36, 36, 36};
    static final int[] MaxSafeInts = new int[]{0x3FFFFFFF, 0x2AAAAAA9, 0x1FFFFFFF, 0x19999998, 0x15555554, 306783377, 0xFFFFFFF, 238609293, 0xCCCCCCB, 195225785, 0xAAAAAA9, 0x9D89D88, 153391688, 0x8888887, 0x7FFFFFF, 0x7878786, 119304646, 113025454, 0x6666665, 102261125, 97612892, 93368853, 0x5555554, 85899344, 82595523, 79536430, 76695843, 74051159, 0x4444443, 69273665, 0x3FFFFFF, 65075261, 0x3C3C3C2, 61356674, 59652322};
    private static final EInteger ValueOne = new EInteger(1, new short[]{1}, false);
    private static final EInteger ValueTen = new EInteger(1, new short[]{10}, false);
    private static final EInteger ValueZero = new EInteger(0, new short[]{0}, false);
    private final boolean negative;
    private final int wordCount;
    private final short[] words;
    private static final EInteger[] Cache = EInteger.EIntegerCache(-24, 128);
    static final int[] DigitsInWord = new int[]{0, 0, 1600, 1010, 800, 690, 619, 570, 534, 505, 482, 463, 447, 433, 421, 410, 400, 392, 384, 377, 371, 365, 359, 354, 349, 345, 341, 337, 333, 330, 327, 323, 320, 318, 315, 312, 310, 308};
    private static int[] estimatedHalfDigitCountPerWord = new int[]{0, 0, 128, 80, 64, 55, 49, 45, 42, 40, 38, 37, 35, 34, 33, 32, 32, 31, 30, 30, 29, 29, 28, 28, 27, 27, 27, 26, 26, 26, 26, 25, 25, 25, 25, 24, 24};

    private static EInteger[] EIntegerCache(int first, int last) {
        int i = 0;
        EInteger[] cache = new EInteger[last - first + 1];
        for (i = first; i <= last; ++i) {
            if (i == 0) {
                cache[i - first] = ValueZero;
                continue;
            }
            if (i == 1) {
                cache[i - first] = ValueOne;
                continue;
            }
            if (i == 10) {
                cache[i - first] = ValueTen;
                continue;
            }
            int iabs = Math.abs(i);
            short[] words = new short[]{(short)iabs};
            cache[i - first] = new EInteger(1, words, i < 0);
        }
        return cache;
    }

    EInteger(int wordCount, short[] reg, boolean negative) {
        this.wordCount = wordCount;
        this.words = reg;
        this.negative = negative;
    }

    public static EInteger getOne() {
        return ValueOne;
    }

    public static EInteger getTen() {
        return ValueTen;
    }

    public static EInteger getZero() {
        return ValueZero;
    }

    public final boolean isEven() {
        return !this.GetUnsignedBit(0);
    }

    public final boolean isPowerOfTwo() {
        int wc = this.wordCount;
        if (this.negative || wc == 0 || wc > 1 && this.words[0] != 0) {
            return false;
        }
        for (int i = 0; i < wc - 1; ++i) {
            if (this.words[i] == 0) continue;
            return false;
        }
        int lastw = this.words[wc - 1] & 0xFFFF;
        if (lastw == 0) {
            throw new IllegalStateException();
        }
        while ((lastw & 1) == 0) {
            lastw >>= 1;
        }
        return lastw == 1;
    }

    public final boolean isZero() {
        return this.wordCount == 0;
    }

    public final int signum() {
        return this.wordCount == 0 ? 0 : (this.negative ? -1 : 1);
    }

    static EInteger FromInts(int[] intWords, int count) {
        int newwordCount;
        short[] words = new short[count << 1];
        int j = 0;
        int i = 0;
        while (i < count) {
            int w = intWords[i];
            words[j] = (short)w;
            words[j + 1] = (short)(w >> 16);
            ++i;
            j += 2;
        }
        for (newwordCount = words.length; newwordCount != 0 && words[newwordCount - 1] == 0; --newwordCount) {
        }
        return newwordCount == 0 ? EInteger.FromInt32(0) : new EInteger(newwordCount, words, false);
    }

    public static EInteger FromBytes(byte[] bytes, boolean littleEndian) {
        int newwordCount;
        int i;
        if (bytes == null) {
            throw new NullPointerException("bytes");
        }
        if (bytes.length == 0) {
            return EInteger.FromInt32(0);
        }
        if (bytes.length == 1) {
            return (bytes[0] & 0x80) == 0 ? EInteger.FromInt32(bytes[0]) : EInteger.FromInt32(-1 - (~bytes[0] & 0x7F));
        }
        int len = bytes.length;
        int wordLength = (len >> 1) + (len & 1);
        short[] newreg = new short[wordLength];
        int valueJIndex = littleEndian ? len - 1 : 0;
        boolean numIsNegative = false;
        boolean odd = (len & 1) != 0;
        int evenedLen = odd ? len - 1 : len;
        int j = 0;
        if (littleEndian) {
            i = 0;
            while (i < evenedLen) {
                int index2 = i + 1;
                int nrj = bytes[i] & 0xFF;
                newreg[j] = (short)(nrj |= bytes[i + 1] << 8);
                i += 2;
                ++j;
            }
            if (odd) {
                newreg[evenedLen >> 1] = (short)(bytes[evenedLen] & 0xFF);
            }
            numIsNegative = (bytes[len - 1] & 0x80) != 0;
        } else {
            i = 0;
            while (i < evenedLen) {
                int index = len - 1 - i;
                int index2 = len - 2 - i;
                int nrj = bytes[index] & 0xFF;
                newreg[j] = (short)(nrj |= bytes[index2] << 8);
                i += 2;
                ++j;
            }
            if (odd) {
                newreg[evenedLen >> 1] = (short)(bytes[0] & 0xFF);
            }
            boolean bl = numIsNegative = (bytes[0] & 0x80) != 0;
        }
        if (numIsNegative) {
            if (odd) {
                int n = len >> 1;
                newreg[n] = (short)(newreg[n] | 0xFFFFFF00);
            }
            for (j = (len >> 1) + 1; j < newreg.length; ++j) {
                newreg[j] = -1;
            }
            EInteger.TwosComplement(newreg, 0, newreg.length);
        }
        for (newwordCount = newreg.length; newwordCount != 0 && newreg[newwordCount - 1] == 0; --newwordCount) {
        }
        return newwordCount == 0 ? EInteger.FromInt32(0) : new EInteger(newwordCount, newreg, numIsNegative);
    }

    public static EInteger FromBoolean(boolean boolValue) {
        return boolValue ? ValueOne : ValueZero;
    }

    public static EInteger FromInt32(int intValue) {
        int retwordcount;
        short[] retreg;
        boolean retnegative;
        if (intValue >= -24 && intValue <= 128) {
            return Cache[intValue - -24];
        }
        boolean bl = retnegative = intValue < 0;
        if (intValue >> 15 == 0) {
            retreg = new short[2];
            if (retnegative) {
                intValue = -intValue;
            }
            retreg[0] = (short)(intValue & 0xFFFF);
            retwordcount = 1;
        } else if (intValue == Integer.MIN_VALUE) {
            retreg = new short[]{0, Short.MIN_VALUE};
            retwordcount = 2;
        } else {
            retreg = new short[2];
            if (retnegative) {
                intValue = -intValue;
            }
            retreg[0] = (short)(intValue & 0xFFFF);
            retreg[1] = (short)((intValue >>= 16) & 0xFFFF);
            retwordcount = retreg[1] == 0 ? 1 : 2;
        }
        return new EInteger(retwordcount, retreg, retnegative);
    }

    public static EInteger FromInt64(long longerValue) {
        int retwordcount;
        short[] retreg;
        boolean retnegative;
        if (longerValue >= -24L && longerValue <= 128L) {
            return Cache[(int)(longerValue - -24L)];
        }
        boolean bl = retnegative = longerValue < 0L;
        if (longerValue >> 16 == 0L) {
            retreg = new short[1];
            int intValue = (int)longerValue;
            if (retnegative) {
                intValue = -intValue;
            }
            retreg[0] = (short)(intValue & 0xFFFF);
            retwordcount = 1;
        } else if (longerValue >> 31 == 0L) {
            retreg = new short[2];
            int intValue = (int)longerValue;
            if (retnegative) {
                intValue = -intValue;
            }
            retreg[0] = (short)(intValue & 0xFFFF);
            retreg[1] = (short)(intValue >> 16 & 0xFFFF);
            retwordcount = 2;
        } else if (longerValue == Long.MIN_VALUE) {
            retreg = new short[]{0, 0, 0, Short.MIN_VALUE};
            retwordcount = 4;
        } else {
            retreg = new short[4];
            long ut = longerValue;
            if (retnegative) {
                ut = -ut;
            }
            retreg[0] = (short)(ut & 0xFFFFL);
            retreg[1] = (short)((ut >>= 16) & 0xFFFFL);
            retreg[2] = (short)((ut >>= 16) & 0xFFFFL);
            retreg[3] = (short)((ut >>= 16) & 0xFFFFL);
            for (retwordcount = 4; retwordcount != 0 && retreg[retwordcount - 1] == 0; --retwordcount) {
            }
        }
        return new EInteger(retwordcount, retreg, retnegative);
    }

    public static EInteger FromRadixString(String str, int radix) {
        if (str == null) {
            throw new NullPointerException("str");
        }
        return EInteger.FromRadixSubstring(str, radix, 0, str.length());
    }

    public static EInteger FromRadixSubstring(String str, int radix, int index, int endIndex) {
        if (str == null) {
            throw new NullPointerException("str");
        }
        return EIntegerTextString.FromRadixSubstringImpl(str, radix, index, endIndex);
    }

    public static EInteger FromSubstring(char[] cs, int index, int endIndex) {
        if (cs == null) {
            throw new NullPointerException("cs");
        }
        return EInteger.FromRadixSubstring(cs, 10, index, endIndex);
    }

    public static EInteger FromString(char[] cs) {
        if (cs == null) {
            throw new NullPointerException("cs");
        }
        int len = cs.length;
        if (len == 1) {
            char c = cs[0];
            if (c >= '0' && c <= '9') {
                return EInteger.FromInt32(c - 48);
            }
            throw new NumberFormatException();
        }
        return EInteger.FromRadixSubstring(cs, 10, 0, len);
    }

    public static EInteger FromRadixString(char[] cs, int radix) {
        if (cs == null) {
            throw new NullPointerException("cs");
        }
        return EInteger.FromRadixSubstring(cs, radix, 0, cs.length);
    }

    public static EInteger FromRadixSubstring(char[] cs, int radix, int index, int endIndex) {
        if (cs == null) {
            throw new NullPointerException("cs");
        }
        return EIntegerCharArrayString.FromRadixSubstringImpl(cs, radix, index, endIndex);
    }

    public static EInteger FromSubstring(byte[] bytes, int index, int endIndex) {
        if (bytes == null) {
            throw new NullPointerException("bytes");
        }
        return EInteger.FromRadixSubstring(bytes, 10, index, endIndex);
    }

    public static EInteger FromString(byte[] bytes) {
        if (bytes == null) {
            throw new NullPointerException("bytes");
        }
        int len = bytes.length;
        if (len == 1) {
            byte c = bytes[0];
            if (c >= 48 && c <= 57) {
                return EInteger.FromInt32(c - 48);
            }
            throw new NumberFormatException();
        }
        return EInteger.FromRadixSubstring(bytes, 10, 0, len);
    }

    public static EInteger FromRadixString(byte[] bytes, int radix) {
        if (bytes == null) {
            throw new NullPointerException("bytes");
        }
        return EInteger.FromRadixSubstring(bytes, radix, 0, bytes.length);
    }

    public static EInteger FromRadixSubstring(byte[] bytes, int radix, int index, int endIndex) {
        if (bytes == null) {
            throw new NullPointerException("bytes");
        }
        return EIntegerByteArrayString.FromRadixSubstringImpl(bytes, radix, index, endIndex);
    }

    public static EInteger FromString(String str) {
        if (str == null) {
            throw new NullPointerException("str");
        }
        int len = str.length();
        if (len == 1) {
            char c = str.charAt(0);
            if (c >= '0' && c <= '9') {
                return EInteger.FromInt32(c - 48);
            }
            throw new NumberFormatException();
        }
        return EInteger.FromRadixSubstring(str, 10, 0, len);
    }

    public static EInteger FromSubstring(String str, int index, int endIndex) {
        if (str == null) {
            throw new NullPointerException("str");
        }
        return EInteger.FromRadixSubstring(str, 10, index, endIndex);
    }

    public EInteger Abs() {
        return this.wordCount == 0 || !this.negative ? this : new EInteger(this.wordCount, this.words, false);
    }

    public EInteger Add(EInteger bigintAugend) {
        if (bigintAugend == null) {
            throw new NullPointerException("bigintAugend");
        }
        if (this.wordCount == 0) {
            return bigintAugend;
        }
        if (bigintAugend.wordCount == 0) {
            return this;
        }
        if (bigintAugend.wordCount == 1 && this.wordCount == 1) {
            if (this.negative == bigintAugend.negative) {
                int intSum = (this.words[0] & 0xFFFF) + (bigintAugend.words[0] & 0xFFFF);
                short[] sumreg = new short[]{(short)intSum, (short)(intSum >> 16)};
                return new EInteger(intSum >> 16 == 0 ? 1 : 2, sumreg, this.negative);
            }
            int a = this.words[0] & 0xFFFF;
            int b = bigintAugend.words[0] & 0xFFFF;
            if (a == b) {
                return EInteger.FromInt32(0);
            }
            if (a > b) {
                short[] sumreg = new short[2];
                sumreg[0] = (short)(a -= b);
                return new EInteger(1, sumreg, this.negative);
            }
            short[] sumreg = new short[2];
            sumreg[0] = (short)(b -= a);
            return new EInteger(1, sumreg, !this.negative);
        }
        if (!this.negative == !bigintAugend.negative) {
            int sumwordCount;
            int carry;
            int addendCount = this.wordCount;
            int augendCount = bigintAugend.wordCount;
            if (!(augendCount > 2 || addendCount > 2 || this.wordCount >= 2 && this.words[1] >> 15 != 0 || bigintAugend.wordCount >= 2 && bigintAugend.words[1] >> 15 != 0)) {
                int a = this.words[0] & 0xFFFF;
                if (this.wordCount == 2) {
                    a |= (this.words[1] & 0xFFFF) << 16;
                }
                int b = bigintAugend.words[0] & 0xFFFF;
                if (bigintAugend.wordCount == 2) {
                    b |= (bigintAugend.words[1] & 0xFFFF) << 16;
                }
                short[] sumreg = new short[]{(short)((a += b) & 0xFFFF), (short)(a >> 16 & 0xFFFF)};
                int wcount = sumreg[1] == 0 ? 1 : 2;
                return new EInteger(wcount, sumreg, this.negative);
            }
            if (augendCount <= 2 && addendCount <= 2) {
                int a = this.words[0] & 0xFFFF;
                if (this.wordCount == 2) {
                    a |= (this.words[1] & 0xFFFF) << 16;
                }
                int b = bigintAugend.words[0] & 0xFFFF;
                if (bigintAugend.wordCount == 2) {
                    b |= (bigintAugend.words[1] & 0xFFFF) << 16;
                }
                long longResult = (long)a & 0xFFFFFFFFL;
                if ((longResult += (long)b & 0xFFFFFFFFL) >> 32 == 0L) {
                    a = (int)longResult;
                    short[] sumreg = new short[]{(short)(a & 0xFFFF), (short)(a >> 16 & 0xFFFF)};
                    int wcount = sumreg[1] == 0 ? 1 : 2;
                    return new EInteger(wcount, sumreg, this.negative);
                }
            }
            int wordLength2 = Math.max(this.words.length, bigintAugend.words.length);
            short[] sumreg = new short[wordLength2];
            int desiredLength = Math.max(addendCount, augendCount);
            if (addendCount == augendCount) {
                carry = EInteger.AddInternal(sumreg, 0, this.words, 0, bigintAugend.words, 0, addendCount);
            } else if (addendCount > augendCount) {
                carry = EInteger.AddInternal(sumreg, 0, this.words, 0, bigintAugend.words, 0, augendCount);
                System.arraycopy(this.words, augendCount, sumreg, augendCount, addendCount - augendCount);
                if (carry != 0) {
                    carry = EInteger.IncrementWords(sumreg, augendCount, addendCount - augendCount, (short)carry);
                }
            } else {
                carry = EInteger.AddInternal(sumreg, 0, this.words, 0, bigintAugend.words, 0, addendCount);
                System.arraycopy(bigintAugend.words, addendCount, sumreg, addendCount, augendCount - addendCount);
                if (carry != 0) {
                    carry = EInteger.IncrementWords(sumreg, addendCount, augendCount - addendCount, (short)carry);
                }
            }
            boolean needShorten = true;
            if (carry != 0) {
                int nextIndex = desiredLength;
                int len = nextIndex + 1;
                sumreg = EInteger.CleanGrow(sumreg, len);
                sumreg[nextIndex] = (short)carry;
                needShorten = false;
            }
            if ((sumwordCount = EInteger.CountWords(sumreg)) == 0) {
                return EInteger.FromInt32(0);
            }
            if (needShorten) {
                sumreg = EInteger.ShortenArray(sumreg, sumwordCount);
            }
            return new EInteger(sumwordCount, sumreg, this.negative);
        }
        EInteger minuend = this;
        EInteger subtrahend = bigintAugend;
        if (this.negative) {
            minuend = bigintAugend;
            subtrahend = this;
        }
        int words1Size = minuend.wordCount;
        int words2Size = subtrahend.wordCount;
        boolean diffNeg = false;
        int wordLength = Math.max(minuend.words.length, subtrahend.words.length);
        short[] diffReg = new short[wordLength];
        if (words1Size == words2Size) {
            if (EInteger.Compare(minuend.words, 0, subtrahend.words, 0, words1Size) >= 0) {
                EInteger.SubtractInternal(diffReg, 0, minuend.words, 0, subtrahend.words, 0, words1Size);
            } else {
                EInteger.SubtractInternal(diffReg, 0, subtrahend.words, 0, minuend.words, 0, words1Size);
                diffNeg = true;
            }
        } else if (words1Size > words2Size) {
            short borrow = (short)EInteger.SubtractInternal(diffReg, 0, minuend.words, 0, subtrahend.words, 0, words2Size);
            System.arraycopy(minuend.words, words2Size, diffReg, words2Size, words1Size - words2Size);
            EInteger.DecrementWords(diffReg, words2Size, words1Size - words2Size, borrow);
        } else {
            short borrow = (short)EInteger.SubtractInternal(diffReg, 0, subtrahend.words, 0, minuend.words, 0, words1Size);
            System.arraycopy(subtrahend.words, words1Size, diffReg, words1Size, words2Size - words1Size);
            EInteger.DecrementWords(diffReg, words1Size, words2Size - words1Size, borrow);
            diffNeg = true;
        }
        int count = EInteger.CountWords(diffReg);
        if (count == 0) {
            return EInteger.FromInt32(0);
        }
        diffReg = EInteger.ShortenArray(diffReg, count);
        return new EInteger(count, diffReg, diffNeg);
    }

    @Deprecated
    public int AsInt32Checked() {
        return this.ToInt32Checked();
    }

    @Deprecated
    public int AsInt32Unchecked() {
        return this.ToInt32Unchecked();
    }

    @Deprecated
    public long AsInt64Checked() {
        return this.ToInt64Checked();
    }

    @Deprecated
    public long AsInt64Unchecked() {
        return this.ToInt64Unchecked();
    }

    public boolean CanFitInInt32() {
        int c = this.wordCount;
        if (c > 2) {
            return false;
        }
        if (c == 2 && (this.words[1] & 0x8000) != 0) {
            return this.negative && this.words[1] == Short.MIN_VALUE && this.words[0] == 0;
        }
        return true;
    }

    public boolean CanFitInInt64() {
        int c = this.wordCount;
        if (c > 4) {
            return false;
        }
        if (c == 4 && (this.words[3] & 0x8000) != 0) {
            return this.negative && this.words[3] == Short.MIN_VALUE && this.words[2] == 0 && this.words[1] == 0 && this.words[0] == 0;
        }
        return true;
    }

    @Override
    public int compareTo(EInteger other) {
        int sb;
        int sa;
        if (other == null) {
            return 1;
        }
        if (this == other) {
            return 0;
        }
        int size = this.wordCount;
        int tempSize = other.wordCount;
        int n = size == 0 ? 0 : (sa = this.negative ? -1 : 1);
        int n2 = tempSize == 0 ? 0 : (sb = other.negative ? -1 : 1);
        if (sa != sb) {
            return sa < sb ? -1 : 1;
        }
        if (sa == 0) {
            return 0;
        }
        if (size == tempSize) {
            if (size == 1 && this.words[0] == other.words[0]) {
                return 0;
            }
            short[] words1 = this.words;
            short[] words2 = other.words;
            while (size-- != 0) {
                int an = words1[size] & 0xFFFF;
                int bn = words2[size] & 0xFFFF;
                if (an > bn) {
                    return sa > 0 ? 1 : -1;
                }
                if (an >= bn) continue;
                return sa > 0 ? -1 : 1;
            }
            return 0;
        }
        return size > tempSize ^ sa <= 0 ? 1 : -1;
    }

    public static EInteger Max(EInteger first, EInteger second) {
        if (first == null) {
            throw new NullPointerException("first");
        }
        if (second == null) {
            throw new NullPointerException("second");
        }
        return first.compareTo(second) > 0 ? first : second;
    }

    public static EInteger Min(EInteger first, EInteger second) {
        if (first == null) {
            throw new NullPointerException("first");
        }
        if (second == null) {
            throw new NullPointerException("second");
        }
        return first.compareTo(second) < 0 ? first : second;
    }

    public static EInteger MaxMagnitude(EInteger first, EInteger second) {
        if (first == null) {
            throw new NullPointerException("first");
        }
        if (second == null) {
            throw new NullPointerException("second");
        }
        int cmp = first.Abs().compareTo(second.Abs());
        return cmp == 0 ? EInteger.Max(first, second) : (cmp > 0 ? first : second);
    }

    public static EInteger MinMagnitude(EInteger first, EInteger second) {
        if (first == null) {
            throw new NullPointerException("first");
        }
        if (second == null) {
            throw new NullPointerException("second");
        }
        int cmp = first.Abs().compareTo(second.Abs());
        return cmp == 0 ? EInteger.Min(first, second) : (cmp < 0 ? first : second);
    }

    public EInteger Add(int intValue) {
        if (intValue == 0) {
            return this;
        }
        if (this.wordCount == 0) {
            return EInteger.FromInt32(intValue);
        }
        if (this.wordCount == 1 && intValue >= -2147352576 && intValue < 2147352576) {
            int intSum;
            int n = intSum = this.negative ? intValue - (this.words[0] & 0xFFFF) : intValue + (this.words[0] & 0xFFFF);
            if (intSum >= -24 && intSum <= 128) {
                return Cache[intSum - -24];
            }
            if (intSum >> 16 == 0) {
                short[] sumreg = new short[]{(short)intSum};
                return new EInteger(1, sumreg, false);
            }
            if (intSum > 0) {
                short[] sumreg = new short[]{(short)intSum, (short)(intSum >> 16)};
                return new EInteger(2, sumreg, false);
            }
            if (intSum > -65536) {
                short[] sumreg = new short[1];
                intSum = -intSum;
                sumreg[0] = (short)intSum;
                return new EInteger(1, sumreg, true);
            }
            short[] sumreg = new short[2];
            intSum = -intSum;
            sumreg[0] = (short)intSum;
            sumreg[1] = (short)(intSum >> 16);
            return new EInteger(2, sumreg, true);
        }
        return this.Add(EInteger.FromInt32(intValue));
    }

    public EInteger Subtract(int intValue) {
        return intValue == Integer.MIN_VALUE ? this.Subtract(EInteger.FromInt32(intValue)) : (intValue == 0 ? this : this.Add(-intValue));
    }

    public EInteger Multiply(int intValue) {
        return this.Multiply(EInteger.FromInt32(intValue));
    }

    public EInteger Divide(int intValue) {
        return this.Divide(EInteger.FromInt32(intValue));
    }

    public EInteger Remainder(int intValue) {
        return this.Remainder(EInteger.FromInt32(intValue));
    }

    @Override
    public int compareTo(int intValue) {
        int c = this.wordCount;
        if (c > 2) {
            return this.negative ? -1 : 1;
        }
        if (c == 2 && (this.words[1] & 0x8000) != 0) {
            if (this.negative && this.words[1] == Short.MIN_VALUE && this.words[0] == 0) {
                return intValue == Integer.MIN_VALUE ? 0 : -1;
            }
            return this.negative ? -1 : 1;
        }
        int thisInt = this.ToInt32Unchecked();
        return thisInt == intValue ? 0 : (thisInt < intValue ? -1 : 1);
    }

    public EInteger Divide(EInteger bigintDivisor) {
        int quotwordCount;
        if (bigintDivisor == null) {
            throw new NullPointerException("bigintDivisor");
        }
        int words1Size = this.wordCount;
        int words2Size = bigintDivisor.wordCount;
        if (words2Size == 0) {
            throw new ArithmeticException();
        }
        if (words1Size < words2Size) {
            return EInteger.FromInt32(0);
        }
        if (words1Size <= 2 && words2Size <= 2 && this.CanFitInInt32() && bigintDivisor.CanFitInInt32()) {
            int valueASmall = this.ToInt32Checked();
            int valueBSmall = bigintDivisor.ToInt32Checked();
            if (valueASmall != Integer.MIN_VALUE || valueBSmall != -1) {
                int result = valueASmall / valueBSmall;
                return EInteger.FromInt32(result);
            }
        }
        if (words1Size <= 4 && words2Size <= 4 && this.CanFitInInt64() && bigintDivisor.CanFitInInt64()) {
            long valueALong = this.ToInt64Checked();
            long valueBLong = bigintDivisor.ToInt64Checked();
            if (valueALong != Long.MIN_VALUE || valueBLong != -1L) {
                long resultLong = valueALong / valueBLong;
                return EInteger.FromInt64(resultLong);
            }
        }
        if (words2Size == 1) {
            short[] quotReg = new short[this.words.length];
            EInteger.FastDivide(quotReg, this.words, words1Size, bigintDivisor.words[0]);
            for (quotwordCount = this.wordCount; quotwordCount != 0 && quotReg[quotwordCount - 1] == 0; --quotwordCount) {
            }
            return quotwordCount != 0 ? new EInteger(quotwordCount, quotReg, this.negative ^ bigintDivisor.negative) : EInteger.FromInt32(0);
        }
        short[] quotReg = new short[words1Size - words2Size + 1];
        EInteger.GeneralDivide(this.words, 0, this.wordCount, bigintDivisor.words, 0, bigintDivisor.wordCount, quotReg, 0, null, 0);
        quotwordCount = EInteger.CountWords(quotReg);
        quotReg = EInteger.ShortenArray(quotReg, quotwordCount);
        return quotwordCount != 0 ? new EInteger(quotwordCount, quotReg, this.negative ^ bigintDivisor.negative) : EInteger.FromInt32(0);
    }

    private static int LinearMultiplySubtractMinuend1Bigger(short[] resultArr, int resultStart, short[] minuendArr, int minuendArrStart, int factor1, short[] factor2, int factor2Start, int factor2Count) {
        int a = 0;
        int b = 0;
        int SMask = 65535;
        int cc = 0;
        if (factor1 == 0) {
            for (int i = 0; i < factor2Count; ++i) {
                b = (minuendArr[minuendArrStart + i] & SMask) - cc;
                resultArr[resultStart + i] = (short)b;
                cc = b >> 31 & 1;
            }
        } else {
            for (int i = 0; i < factor2Count; ++i) {
                a = (factor2[factor2Start + i] & SMask) * factor1;
                b = (minuendArr[minuendArrStart + i] & SMask) - ((a += cc) & SMask);
                resultArr[resultStart + i] = (short)b;
                cc = (a >> 16) + (b >> 31 & 1);
                cc &= SMask;
            }
        }
        a = cc;
        b = (minuendArr[minuendArrStart + factor2Count] & SMask) - a;
        resultArr[resultStart + factor2Count] = (short)b;
        cc = b >> 31 & 1;
        return cc;
    }

    private static void DivideThreeBlocksByTwo(short[] valueALow, int posALow, short[] valueAMidHigh, int posAMidHigh, short[] b, int posB, int blockCount, short[] quot, int posQuot, short[] rem, int posRem, short[] tmp) {
        int c;
        if (EInteger.WordsCompare(valueAMidHigh, posAMidHigh + blockCount, blockCount, b, posB + blockCount, blockCount) < 0) {
            EInteger.RecursiveDivideInner(valueAMidHigh, posAMidHigh, b, posB + blockCount, quot, posQuot, rem, posRem, blockCount);
            System.arraycopy(rem, posRem, tmp, blockCount * 4, blockCount);
            Arrays.fill(tmp, blockCount * 5, blockCount * 5 + blockCount, (short)0);
        } else {
            int allones = -1;
            for (int i = 0; i < blockCount; ++i) {
                quot[posQuot + i] = allones;
            }
            Arrays.fill(quot, posQuot + blockCount, posQuot + blockCount + blockCount, (short)0);
            System.arraycopy(valueAMidHigh, posAMidHigh, tmp, blockCount * 4, blockCount * 2);
            EInteger.SubtractInternal(tmp, blockCount * 5, tmp, blockCount * 5, b, posB + blockCount, blockCount);
            c = EInteger.AddInternal(tmp, blockCount * 4, tmp, blockCount * 4, b, posB + blockCount, blockCount);
            EInteger.IncrementWords(tmp, blockCount * 5, blockCount, (short)c);
        }
        EInteger.AsymmetricMultiply(tmp, 0, tmp, blockCount * 2, quot, posQuot, blockCount, b, posB, blockCount);
        int bc3 = blockCount * 3;
        System.arraycopy(valueALow, posALow, tmp, bc3, blockCount);
        Arrays.fill(tmp, blockCount * 2, blockCount * 2 + blockCount, (short)0);
        c = EInteger.SubtractInternal(tmp, bc3, tmp, bc3, tmp, 0, blockCount * 3);
        if (c != 0) {
            do {
                c = EInteger.AddInternal(tmp, bc3, tmp, bc3, b, posB, blockCount * 2);
                c = EInteger.IncrementWords(tmp, blockCount * 5, blockCount, (short)c);
                EInteger.DecrementWords(quot, posQuot, blockCount * 2, (short)1);
            } while (c == 0);
        }
        System.arraycopy(tmp, bc3, rem, posRem, blockCount * 2);
    }

    private static void RecursiveDivideInner(short[] a, int posA, short[] b, int posB, short[] quot, int posQuot, short[] rem, int posRem, int blockSize) {
        if (blockSize < 201 || (blockSize & 1) == 1) {
            EInteger.GeneralDivide(a, posA, blockSize * 2, b, posB, blockSize, quot, posQuot, rem, posRem);
        } else {
            int halfBlock = blockSize >> 1;
            short[] tmp = new short[halfBlock * 10];
            Arrays.fill(quot, posQuot, posQuot + blockSize * 2, (short)0);
            Arrays.fill(rem, posRem, posRem + blockSize, (short)0);
            EInteger.DivideThreeBlocksByTwo(a, posA + halfBlock, a, posA + blockSize, b, posB, halfBlock, tmp, halfBlock * 6, tmp, halfBlock * 8, tmp);
            EInteger.DivideThreeBlocksByTwo(a, posA, tmp, halfBlock * 8, b, posB, halfBlock, quot, posQuot, rem, posRem, tmp);
            System.arraycopy(tmp, halfBlock * 6, quot, posQuot + halfBlock, halfBlock);
        }
    }

    private static void RecursiveDivide(short[] a, int posA, int countA, short[] b, int posB, int countB, short[] quot, int posQuot, short[] rem, int posRem) {
        short[] workA = a;
        short[] workB = b;
        int workPosA = posA;
        int workPosB = posB;
        int blocksB = 201;
        int shiftB = 0;
        int m = 1;
        while (blocksB < countB) {
            blocksB <<= 1;
            m <<= 1;
        }
        workB = new short[blocksB];
        workPosB = 0;
        System.arraycopy(b, posB, workB, blocksB - countB, countB);
        int shiftA = 0;
        int extraWord = 0;
        int wordsA = countA + (blocksB - countB);
        if ((b[countB - 1] & 0x8000) == 0) {
            int x = b[countB - 1];
            while ((x & 0x8000) == 0) {
                ++shiftB;
                x <<= 1;
            }
            x = a[countA - 1];
            while ((x & 0x8000) == 0) {
                ++shiftA;
                x <<= 1;
            }
            if (shiftA < shiftB) {
                ++extraWord;
            }
            EInteger.ShiftWordsLeftByBits(workB, workPosB + blocksB - countB, countB, shiftB);
        }
        int blocksA = (wordsA + extraWord + (blocksB - 1)) / blocksB;
        int totalWordsA = blocksA * blocksB;
        workA = new short[totalWordsA];
        workPosA = 0;
        System.arraycopy(a, posA, workA, workPosA + (blocksB - countB), countA);
        EInteger.ShiftWordsLeftByBits(workA, workPosA + (blocksB - countB), countA + extraWord, shiftB);
        short[] tmprem = new short[blocksB * 5];
        int size = 0;
        for (int i = blocksA - 1; i >= 0; --i) {
            int workAIndex = workPosA + i * blocksB;
            System.arraycopy(workA, workAIndex, tmprem, blocksB, blocksB);
            Arrays.fill(tmprem, blocksB * 3, blocksB * 3 + (blocksB << 1), (short)0);
            EInteger.RecursiveDivideInner(tmprem, blocksB, workB, workPosB, tmprem, blocksB * 3, tmprem, 0, blocksB);
            if (quot != null && (size = Math.min(blocksB, quot.length - i * blocksB)) > 0) {
                System.arraycopy(tmprem, blocksB * 3, quot, posQuot + i * blocksB, size);
            }
            System.arraycopy(tmprem, 0, tmprem, blocksB << 1, blocksB);
        }
        if (rem != null) {
            System.arraycopy(tmprem, blocksB - countB, rem, posRem, countB);
            EInteger.ShiftWordsRightByBits(rem, posRem, countB, shiftB);
        }
    }

    private static String WordsToString(short[] a, int pos, int len) {
        while (len != 0 && a[pos + len - 1] == 0) {
            --len;
        }
        if (len == 0) {
            return "\"0\"";
        }
        short[] words = new short[len];
        System.arraycopy(a, pos, words, 0, len);
        return "\"" + new EInteger(len, words, false).toString() + "\"";
    }

    private static String WordsToStringHex(short[] a, int pos, int len) {
        while (len != 0 && a[pos + len - 1] == 0) {
            --len;
        }
        if (len == 0) {
            return "\"0\"";
        }
        short[] words = new short[len];
        System.arraycopy(a, pos, words, 0, len);
        return "\"" + new EInteger(len, words, false).ToRadixString(16) + "\"";
    }

    private static String WordsToString2(short[] a, int pos, int len, short[] b, int pos2, int len2) {
        short[] words = new short[len + len2];
        System.arraycopy(a, pos, words, 0, len);
        System.arraycopy(b, pos2, words, len, len2);
        len += len2;
        while (len != 0 && words[len - 1] == 0) {
            --len;
        }
        return len == 0 ? "\"0\"" : "\"" + new EInteger(len, words, false).toString() + "\"";
    }

    private static void GeneralDivide(short[] a, int posA, int countA, short[] b, int posB, int countB, short[] quot, int posQuot, short[] rem, int posRem) {
        int origQuotSize = countA - countB + 1;
        int origCountA = countA;
        int origCountB = countB;
        while (countB > 0 && b[posB + countB - 1] == 0) {
            --countB;
        }
        while (countA > 0 && a[posA + countA - 1] == 0) {
            --countA;
        }
        int newQuotSize = countA - countB + 1;
        if (quot != null) {
            if (newQuotSize < 0 || newQuotSize >= origQuotSize) {
                Arrays.fill(quot, posQuot, posQuot + Math.max(0, origQuotSize), (short)0);
            } else {
                Arrays.fill(quot, posQuot + newQuotSize, posQuot + newQuotSize + Math.max(0, origQuotSize - newQuotSize), (short)0);
            }
        }
        if (rem != null) {
            Arrays.fill(rem, posRem + countB, posRem + countB + (origCountB - countB), (short)0);
        }
        if (countA < countB) {
            if (quot != null) {
                Arrays.fill(quot, posQuot, posQuot + Math.max(0, origQuotSize), (short)0);
            }
            if (rem != null) {
                System.arraycopy(a, posA, rem, posRem, origCountA);
            }
            return;
        }
        if (countA == countB) {
            int cmp = EInteger.Compare(a, posA, b, posB, countA);
            if (cmp == 0) {
                if (quot != null) {
                    quot[posQuot] = 1;
                    Arrays.fill(quot, posQuot + 1, posQuot + 1 + Math.max(0, origQuotSize - 1), (short)0);
                }
                if (rem != null) {
                    Arrays.fill(rem, posRem, posRem + countA, (short)0);
                }
                return;
            }
            if (cmp < 0) {
                if (quot != null) {
                    Arrays.fill(quot, posQuot, posQuot + Math.max(0, origQuotSize), (short)0);
                }
                if (rem != null) {
                    System.arraycopy(a, posA, rem, posRem, origCountA);
                }
                return;
            }
        }
        if (countB == 1) {
            short shortRemainder = EInteger.FastDivideAndRemainder(quot, posQuot, a, posA, countA, b[posB]);
            if (rem != null) {
                rem[posRem] = shortRemainder;
            }
            return;
        }
        short[] workAB = null;
        short[] workA = a;
        short[] workB = b;
        int workPosA = posA;
        int workPosB = posB;
        if (countB > 201) {
            EInteger.RecursiveDivide(a, posA, countA, b, posB, countB, quot, posQuot, rem, posRem);
            return;
        }
        int sh = 0;
        boolean noShift = false;
        if ((b[posB + countB - 1] & 0x8000) == 0) {
            int x = b[posB + countB - 1];
            if (x == 0) {
                throw new IllegalStateException();
            }
            while ((x & 0x8000) == 0) {
                ++sh;
                x <<= 1;
            }
            workAB = new short[countA + 1 + countB];
            workPosA = 0;
            workPosB = countA + 1;
            workA = workAB;
            workB = workAB;
            System.arraycopy(a, posA, workA, workPosA, countA);
            System.arraycopy(b, posB, workB, workPosB, countB);
            EInteger.ShiftWordsLeftByBits(workA, workPosA, countA + 1, sh);
            EInteger.ShiftWordsLeftByBits(workB, workPosB, countB, sh);
        } else {
            noShift = true;
            workA = new short[countA + 1];
            workPosA = 0;
            System.arraycopy(a, posA, workA, workPosA, countA);
        }
        int c = 0;
        short pieceBHigh = workB[workPosB + countB - 1];
        int pieceBHighInt = pieceBHigh & 0xFFFF;
        int endIndex = workPosA + countA;
        short pieceBNextHigh = workB[workPosB + countB - 2];
        int pieceBNextHighInt = pieceBNextHigh & 0xFFFF;
        for (int offset = countA - countB; offset >= 0; --offset) {
            int q1;
            int wpoffset = workPosA + offset;
            int wpaNextHigh = workA[wpoffset + countB - 1] & 0xFFFF;
            int wpaHigh = 0;
            if (!noShift || wpoffset + countB < endIndex) {
                wpaHigh = workA[wpoffset + countB] & 0xFFFF;
            }
            int dividend = wpaNextHigh + (wpaHigh << 16);
            int divnext = workA[wpoffset + countB - 2] & 0xFFFF;
            int quorem0 = dividend >> 31 == 0 ? dividend / pieceBHighInt : (int)(((long)dividend & 0xFFFFFFFFL) / (long)pieceBHighInt);
            int quorem1 = dividend - quorem0 * pieceBHighInt;
            long t = (long)quorem1 << 16 | (long)divnext & 0xFFFFL;
            if (quorem0 >> 16 != 0 || ((long)(quorem0 * pieceBNextHighInt) & 0xFFFFFFFFL) > t) {
                --quorem0;
                if ((quorem1 += pieceBHighInt) >> 16 == 0) {
                    t = (long)quorem1 << 16 | (long)divnext & 0xFFFFL;
                    if (quorem0 >> 16 != 0 || ((long)(quorem0 * pieceBNextHighInt) & 0xFFFFFFFFL) > t) {
                        --quorem0;
                        if (rem == null && offset == 0) {
                            if (quot == null) break;
                            quot[posQuot + offset] = (short)quorem0;
                            break;
                        }
                    }
                }
            }
            if ((c = EInteger.LinearMultiplySubtractMinuend1Bigger(workA, wpoffset, workA, wpoffset, q1 = quorem0 & 0xFFFF, workB, workPosB, countB)) != 0) {
                c = EInteger.AddInternal(workA, wpoffset, workA, wpoffset, workB, workPosB, countB);
                c = EInteger.IncrementWords(workA, wpoffset + countB, 1, (short)c);
                --quorem0;
            }
            if (quot == null) continue;
            quot[posQuot + offset] = (short)quorem0;
        }
        if (rem != null) {
            if (sh != 0) {
                EInteger.ShiftWordsRightByBits(workA, workPosA, countB + 1, sh);
            }
            System.arraycopy(workA, workPosA, rem, posRem, countB);
        }
    }

    public EInteger[] DivRem(int intDivisor) {
        return this.DivRem(EInteger.FromInt32(intDivisor));
    }

    public EInteger Add(long longValue) {
        return this.Add(EInteger.FromInt64(longValue));
    }

    public EInteger Subtract(long longValue) {
        return this.Subtract(EInteger.FromInt64(longValue));
    }

    public EInteger Multiply(long longValue) {
        return this.Multiply(EInteger.FromInt64(longValue));
    }

    public EInteger Divide(long longValue) {
        return this.Divide(EInteger.FromInt64(longValue));
    }

    public EInteger Remainder(long longValue) {
        return this.Remainder(EInteger.FromInt64(longValue));
    }

    @Override
    public int compareTo(long longValue) {
        return this.compareTo(EInteger.FromInt64(longValue));
    }

    public EInteger[] DivRem(long intDivisor) {
        return this.DivRem(EInteger.FromInt64(intDivisor));
    }

    public EInteger[] DivRem(EInteger divisor) {
        if (divisor == null) {
            throw new NullPointerException("divisor");
        }
        int words1Size = this.wordCount;
        int words2Size = divisor.wordCount;
        if (words2Size == 0) {
            throw new ArithmeticException();
        }
        if (words1Size < words2Size) {
            return new EInteger[]{EInteger.FromInt32(0), this};
        }
        if (words2Size == 1) {
            int count;
            int smallRemainder;
            short[] quotient = new short[this.wordCount];
            switch (divisor.words[0]) {
                case 2: {
                    smallRemainder = EInteger.FastDivideAndRemainderTwo(quotient, 0, this.words, 0, words1Size);
                    break;
                }
                case 10: {
                    smallRemainder = EInteger.FastDivideAndRemainderTen(quotient, 0, this.words, 0, words1Size);
                    break;
                }
                default: {
                    smallRemainder = EInteger.FastDivideAndRemainder(quotient, 0, this.words, 0, words1Size, divisor.words[0]) & 0xFFFF;
                }
            }
            for (count = this.wordCount; count != 0 && quotient[count - 1] == 0; --count) {
            }
            if (count == 0) {
                return new EInteger[]{EInteger.FromInt32(0), this};
            }
            quotient = EInteger.ShortenArray(quotient, count);
            EInteger bigquo = new EInteger(count, quotient, this.negative ^ divisor.negative);
            if (this.negative) {
                smallRemainder = -smallRemainder;
            }
            return new EInteger[]{bigquo, EInteger.FromInt64(smallRemainder)};
        }
        if (this.CanFitInInt32() && divisor.CanFitInInt32()) {
            long dividendSmall = this.ToInt32Checked();
            long divisorSmall = divisor.ToInt32Checked();
            if (dividendSmall != Integer.MIN_VALUE || divisorSmall != -1L) {
                long quotientSmall = dividendSmall / divisorSmall;
                long remainderSmall = dividendSmall - quotientSmall * divisorSmall;
                return new EInteger[]{EInteger.FromInt64(quotientSmall), EInteger.FromInt64(remainderSmall)};
            }
        } else if (this.CanFitInInt64() && divisor.CanFitInInt64()) {
            long dividendLong = this.ToInt64Checked();
            long divisorLong = divisor.ToInt64Checked();
            if (dividendLong != Long.MIN_VALUE || divisorLong != -1L) {
                long quotientLong = dividendLong / divisorLong;
                long remainderLong = dividendLong - quotientLong * divisorLong;
                return new EInteger[]{EInteger.FromInt64(quotientLong), EInteger.FromInt64(remainderLong)};
            }
        }
        short[] bigRemainderreg = new short[words2Size];
        short[] quotientreg = new short[words1Size - words2Size + 1];
        EInteger.GeneralDivide(this.words, 0, this.wordCount, divisor.words, 0, divisor.wordCount, quotientreg, 0, bigRemainderreg, 0);
        int remCount = EInteger.CountWords(bigRemainderreg);
        int quoCount = EInteger.CountWords(quotientreg);
        bigRemainderreg = EInteger.ShortenArray(bigRemainderreg, remCount);
        quotientreg = EInteger.ShortenArray(quotientreg, quoCount);
        EInteger bigrem = remCount == 0 ? EInteger.FromInt32(0) : new EInteger(remCount, bigRemainderreg, this.negative);
        EInteger bigquo2 = quoCount == 0 ? EInteger.FromInt32(0) : new EInteger(quoCount, quotientreg, this.negative ^ divisor.negative);
        return new EInteger[]{bigquo2, bigrem};
    }

    public boolean equals(Object obj) {
        EInteger other;
        EInteger eInteger = other = obj instanceof EInteger ? (EInteger)obj : null;
        if (other == null) {
            return false;
        }
        if (this.wordCount == other.wordCount) {
            if (this.negative != other.negative) {
                return false;
            }
            for (int i = 0; i < this.wordCount; ++i) {
                if (this.words[i] == other.words[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static EInteger LeftShiftBigIntVar(EInteger ei, EInteger bigShift) {
        if (ei.isZero()) {
            return ei;
        }
        while (bigShift.signum() > 0) {
            int shift = 1000000;
            if (bigShift.compareTo(EInteger.FromInt64(1000000L)) < 0) {
                shift = bigShift.ToInt32Checked();
            }
            ei = ei.ShiftLeft(shift);
            bigShift = bigShift.Subtract(EInteger.FromInt32(shift));
        }
        return ei;
    }

    private static EInteger GcdLong(long u, long v) {
        int shl = 0;
        while (u != 0L && v != 0L && u != v) {
            boolean ev;
            boolean eu = (u & 1L) == 0L;
            boolean bl = ev = (v & 1L) == 0L;
            if (eu && ev) {
                ++shl;
                u >>= 1;
                v >>= 1;
                continue;
            }
            if (eu && !ev) {
                u >>= 1;
                continue;
            }
            if (!eu && ev) {
                v >>= 1;
                continue;
            }
            if (u >= v) {
                u = u - v >> 1;
                continue;
            }
            long tmp = u;
            u = v - u >> 1;
            v = tmp;
        }
        EInteger eret = u == 0L ? EInteger.FromInt64(v << shl) : EInteger.FromInt64(u << shl);
        return eret;
    }

    public EInteger Gcd(EInteger bigintSecond) {
        boolean bigger;
        if (bigintSecond == null) {
            throw new NullPointerException("bigintSecond");
        }
        if (this.isZero()) {
            return bigintSecond.Abs();
        }
        EInteger thisValue = this.Abs();
        if (bigintSecond.isZero()) {
            return thisValue;
        }
        if ((bigintSecond = bigintSecond.Abs()).equals(EInteger.FromInt32(1)) || thisValue.equals(bigintSecond)) {
            return bigintSecond;
        }
        if (thisValue.equals(EInteger.FromInt32(1))) {
            return thisValue;
        }
        if (thisValue.CanFitInInt64() && bigintSecond.CanFitInInt64()) {
            long u = thisValue.ToInt64Unchecked();
            long v = bigintSecond.ToInt64Unchecked();
            return EInteger.GcdLong(u, v);
        }
        boolean bl = bigger = thisValue.compareTo(bigintSecond) >= 0;
        if (!bigger) {
            EInteger ta = thisValue;
            thisValue = bigintSecond;
            bigintSecond = ta;
        }
        EInteger eia = thisValue;
        EInteger eib = bigintSecond;
        block0: while (eib.wordCount > 3) {
            EInteger eicc;
            EInteger eidd;
            EInteger eish = eia.GetUnsignedBitLengthAsEInteger().Subtract(48);
            EInteger eiee = eia.ShiftRight(eish);
            EInteger eiff = eib.ShiftRight(eish);
            EInteger eiaa = eidd = EInteger.FromInt32(1);
            EInteger eibb = eicc = EInteger.FromInt32(0);
            while (true) {
                EInteger eiq2;
                EInteger eifc = eiff.Add(eicc);
                EInteger eifd = eiff.Add(eidd);
                if (eifc.isZero() || eifd.isZero()) {
                    EInteger ta = eibb.isZero() ? eib : eia.Multiply(eiaa).Add(eib.Multiply(eibb));
                    EInteger tb = eibb.isZero() ? eia.Remainder(eib) : eia.Multiply(eicc).Add(eib.Multiply(eidd));
                    eia = ta;
                    eib = tb;
                    continue block0;
                }
                EInteger eiq = eiee.Add(eiaa).Divide(eifc);
                if (!eiq.equals(eiq2 = eiee.Add(eibb).Divide(eifd))) {
                    EInteger ta = eibb.isZero() ? eib : eia.Multiply(eiaa).Add(eib.Multiply(eibb));
                    EInteger tb = eibb.isZero() ? eia.Remainder(eib) : eia.Multiply(eicc).Add(eib.Multiply(eidd));
                    eia = ta;
                    eib = tb;
                    continue block0;
                }
                EInteger t = eiff;
                eiff = eiee.Subtract(eiff.Multiply(eiq));
                eiee = t;
                t = eicc;
                eicc = eiaa.Subtract(eicc.Multiply(eiq));
                eiaa = t;
                t = eidd;
                eidd = eibb.Subtract(eidd.Multiply(eiq));
                eibb = t;
            }
        }
        if (eib.isZero()) {
            return eia;
        }
        while (!eib.isZero()) {
            if (eia.wordCount <= 3 && eib.wordCount <= 3) {
                return EInteger.GcdLong(eia.ToInt64Checked(), eib.ToInt64Checked());
            }
            EInteger ta = eib;
            eib = eia.Remainder(eib);
            eia = ta;
        }
        return eia;
    }

    public EInteger GetDigitCountAsEInteger() {
        return EInteger.FromInt64(this.GetDigitCountAsInt64());
    }

    @Deprecated
    public int GetDigitCount() {
        long dc = this.GetDigitCountAsInt64();
        if (dc < Integer.MIN_VALUE || dc > Integer.MAX_VALUE) {
            throw new ArithmeticException();
        }
        return (int)dc;
    }

    public long GetDigitCountAsInt64() {
        EInteger ei = this;
        if (ei.isZero()) {
            return 1L;
        }
        long retval = 0L;
        block0: while (true) {
            if (ei.CanFitInInt64()) {
                long value = ei.ToInt64Checked();
                if (value == 0L) break;
                if (value == Long.MIN_VALUE) {
                    retval += 19L;
                    break;
                }
                if (value < 0L) {
                    value = -value;
                }
                if (value >= 1000000000L) {
                    retval += value >= 1000000000000000000L ? 19L : (long)(value >= 100000000000000000L ? 18 : (value >= 10000000000000000L ? 17 : (value >= 1000000000000000L ? 16 : (value >= 100000000000000L ? 15 : (value >= 10000000000000L ? 14 : (value >= 1000000000000L ? 13 : (value >= 100000000000L ? 12 : (value >= 10000000000L ? 11 : (value >= 1000000000L ? 10 : 9)))))))));
                    break;
                }
                int v2 = (int)value;
                retval += v2 >= 100000000 ? 9L : (long)(v2 >= 10000000 ? 8 : (v2 >= 1000000 ? 7 : (v2 >= 100000 ? 6 : (v2 >= 10000 ? 5 : (v2 >= 1000 ? 4 : (v2 >= 100 ? 3 : (v2 >= 10 ? 2 : 1)))))));
                break;
            }
            int bitlen = ei.wordCount < 1000000 ? (int)ei.GetUnsignedBitLengthAsInt64() : Integer.MAX_VALUE;
            int maxDigits = 0;
            int minDigits = 0;
            if (bitlen <= 2135) {
                minDigits = 1 + ((bitlen - 1) * 631305 >> 21);
                maxDigits = 1 + (bitlen * 631305 >> 21);
                if (minDigits == maxDigits) {
                    retval += (long)minDigits;
                    break;
                }
            } else if (bitlen <= 6432162 && (minDigits = 1 + (int)((long)(bitlen - 1) * 661971961083L >> 41)) == (maxDigits = 1 + (int)((long)bitlen * 661971961083L >> 41))) {
                retval += (long)minDigits;
                break;
            }
            if (ei.wordCount >= 100) {
                long digits = ei.wordCount * 3;
                EInteger pow = NumberUtility.FindPowerOfTen(digits);
                EInteger div = ei.Divide(pow);
                retval += digits;
                ei = div;
                continue;
            }
            if (bitlen <= 2135) {
                retval += ei.Abs().compareTo(NumberUtility.FindPowerOfTen(minDigits)) >= 0 ? (long)maxDigits : (long)minDigits;
                break;
            }
            if (bitlen < 50000) {
                retval += ei.Abs().compareTo(NumberUtility.FindPowerOfTen(minDigits + 1)) >= 0 ? (long)(maxDigits + 1) : (long)(minDigits + 1);
                break;
            }
            short[] tempReg = null;
            int currentCount = ei.wordCount;
            boolean done = false;
            while (true) {
                short[] dividend;
                if (done || currentCount == 0) continue block0;
                if (currentCount == 1 || currentCount == 2 && tempReg[1] == false) {
                    int rest = tempReg[0] & 0xFFFF;
                    if (rest >= 10000) {
                        retval += 5L;
                        continue block0;
                    }
                    if (rest >= 1000) {
                        retval += 4L;
                        continue block0;
                    }
                    if (rest >= 100) {
                        retval += 3L;
                        continue block0;
                    }
                    if (rest >= 10) {
                        retval += 2L;
                        continue block0;
                    }
                    ++retval;
                    continue block0;
                }
                if (currentCount == 2 && tempReg[1] > 0 && tempReg[1] <= Short.MAX_VALUE) {
                    int rest = tempReg[0] & 0xFFFF;
                    if ((rest |= (tempReg[1] & 0xFFFF) << 16) >= 1000000000) {
                        retval += 10L;
                        continue block0;
                    }
                    if (rest >= 100000000) {
                        retval += 9L;
                        continue block0;
                    }
                    if (rest >= 10000000) {
                        retval += 8L;
                        continue block0;
                    }
                    if (rest >= 1000000) {
                        retval += 7L;
                        continue block0;
                    }
                    if (rest >= 100000) {
                        retval += 6L;
                        continue block0;
                    }
                    if (rest >= 10000) {
                        retval += 5L;
                        continue block0;
                    }
                    if (rest >= 1000) {
                        retval += 4L;
                        continue block0;
                    }
                    if (rest >= 100) {
                        retval += 3L;
                        continue block0;
                    }
                    if (rest >= 10) {
                        retval += 2L;
                        continue block0;
                    }
                    ++retval;
                    continue block0;
                }
                int wci = currentCount;
                int remainderShort = 0;
                boolean firstdigit = false;
                short[] sArray = dividend = tempReg == null ? ei.words : tempReg;
                while (!done && wci-- > 0) {
                    int curValue = dividend[wci] & 0xFFFF;
                    int currentDividend = curValue | remainderShort << 16;
                    int quo = currentDividend / 10000;
                    if (!firstdigit && quo != 0) {
                        firstdigit = true;
                        int n = bitlen = wci < 1000000 ? EInteger.GetUnsignedBitLengthEx(quo, wci + 1) : Integer.MAX_VALUE;
                        if (bitlen <= 2135) {
                            minDigits = 1 + ((bitlen - 1) * 631305 >> 21);
                            maxDigits = 1 + (bitlen * 631305 >> 21);
                            if (minDigits == maxDigits) {
                                retval += (long)(minDigits + 4);
                                done = true;
                                break;
                            }
                            if (minDigits > 1) {
                                int maxDigitEstimate = maxDigits + 4;
                                int minDigitEstimate = minDigits + 4;
                                retval += ei.Abs().compareTo(NumberUtility.FindPowerOfTen(minDigitEstimate)) >= 0 ? retval + (long)maxDigitEstimate : retval + (long)minDigitEstimate;
                                done = true;
                                break;
                            }
                        } else if (bitlen <= 6432162 && (minDigits = 1 + (int)((long)(bitlen - 1) * 661971961083L >> 41)) == (maxDigits = 1 + (int)((long)bitlen * 661971961083L >> 41))) {
                            retval += (long)(minDigits + 4);
                            done = true;
                            break;
                        }
                    }
                    if (tempReg == null) {
                        if (quo != 0) {
                            tempReg = new short[ei.wordCount];
                            System.arraycopy(ei.words, 0, tempReg, 0, tempReg.length);
                            currentCount = wci + 1;
                            tempReg[wci] = (short)quo;
                        }
                    } else {
                        tempReg[wci] = (short)quo;
                    }
                    int rem = currentDividend - 10000 * quo;
                    remainderShort = (short)rem;
                }
                while (currentCount != 0 && tempReg[currentCount - 1] == 0) {
                    --currentCount;
                }
                retval += 4L;
            }
            break;
        }
        return retval;
    }

    public int hashCode() {
        int hashCodeValue = 0;
        hashCodeValue += 1000000007 * this.signum();
        if (this.words != null) {
            for (int i = 0; i < this.wordCount; ++i) {
                hashCodeValue += 1000000013 * this.words[i];
            }
        }
        return hashCodeValue;
    }

    @Deprecated
    public int GetLowBit() {
        return this.GetLowBitAsEInteger().ToInt32Checked();
    }

    public long GetLowBitAsInt64() {
        long retSetBitLong = 0L;
        for (int i = 0; i < this.wordCount; ++i) {
            int c = this.words[i] & 0xFFFF;
            if (c == 0) {
                retSetBitLong += 16L;
                continue;
            }
            int rsb = (c << 15 & 0xFFFF) != 0 ? 0 : ((c << 14 & 0xFFFF) != 0 ? 1 : ((c << 13 & 0xFFFF) != 0 ? 2 : ((c << 12 & 0xFFFF) != 0 ? 3 : ((c << 11 & 0xFFFF) != 0 ? 4 : ((c << 10 & 0xFFFF) != 0 ? 5 : ((c << 9 & 0xFFFF) != 0 ? 6 : ((c << 8 & 0xFFFF) != 0 ? 7 : ((c << 7 & 0xFFFF) != 0 ? 8 : ((c << 6 & 0xFFFF) != 0 ? 9 : ((c << 5 & 0xFFFF) != 0 ? 10 : ((c << 4 & 0xFFFF) != 0 ? 11 : ((c << 3 & 0xFFFF) != 0 ? 12 : ((c << 2 & 0xFFFF) != 0 ? 13 : ((c << 1 & 0xFFFF) != 0 ? 14 : 15))))))))))))));
            return retSetBitLong += (long)rsb;
        }
        return -1L;
    }

    public EInteger GetLowBitAsEInteger() {
        return EInteger.FromInt64(this.GetLowBitAsInt64());
    }

    public boolean GetSignedBit(EInteger bigIndex) {
        if (bigIndex == null) {
            throw new NullPointerException("bigIndex");
        }
        if (bigIndex.signum() < 0) {
            throw new IllegalArgumentException("bigIndex");
        }
        if (this.negative) {
            int mod15;
            if (bigIndex.CanFitInInt32()) {
                return this.GetSignedBit(bigIndex.ToInt32Checked());
            }
            EInteger valueEWordPos = bigIndex.Divide(16);
            if (valueEWordPos.compareTo(this.words.length) >= 0) {
                return true;
            }
            long tcindex = 0L;
            while (valueEWordPos.compareTo(EInteger.FromInt64(tcindex)) > 0 && this.words[(int)tcindex] == 0) {
                ++tcindex;
            }
            int wordpos = valueEWordPos.ToInt32Checked();
            short tc = this.words[wordpos];
            if (tcindex == (long)wordpos) {
                tc = (short)(tc - 1);
            }
            return ((tc = (short)(~tc)) >> (mod15 = bigIndex.Remainder(16).ToInt32Checked()) & 1) != 0;
        }
        return this.GetUnsignedBit(bigIndex);
    }

    public boolean GetSignedBit(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("index");
        }
        if (this.wordCount == 0) {
            return false;
        }
        if (this.negative) {
            int tcindex;
            int wordpos = index / 16;
            if (wordpos >= this.words.length) {
                return true;
            }
            for (tcindex = 0; tcindex < wordpos && this.words[tcindex] == 0; ++tcindex) {
            }
            short tc = this.words[wordpos];
            if (tcindex == wordpos) {
                tc = (short)(tc - 1);
            }
            return ((tc = (short)(~tc)) >> (index & 0xF) & 1) != 0;
        }
        return this.GetUnsignedBit(index);
    }

    public EInteger GetSignedBitLengthAsEInteger() {
        return EInteger.FromInt64(this.GetSignedBitLengthAsInt64());
    }

    public long GetSignedBitLengthAsInt64() {
        int wc = this.wordCount;
        if (wc != 0) {
            if (this.negative) {
                EInteger eiabs = this.Abs();
                long eiabsbl = eiabs.GetSignedBitLengthAsInt64();
                if (eiabs.isPowerOfTwo()) {
                    --eiabsbl;
                }
                return eiabsbl;
            }
            int numberValue = this.words[wc - 1] & 0xFFFF;
            int wcextra = 0;
            if (numberValue != 0) {
                wcextra = 16;
                if (numberValue >> 8 == 0) {
                    numberValue <<= 8;
                    wcextra -= 8;
                }
                if (numberValue >> 12 == 0) {
                    numberValue <<= 4;
                    wcextra -= 4;
                }
                if (numberValue >> 14 == 0) {
                    numberValue <<= 2;
                    wcextra -= 2;
                }
                wcextra = numberValue >> 15 == 0 ? wcextra - 1 : wcextra;
            }
            return ((long)wc - 1L) * 16L + (long)wcextra;
        }
        return 0L;
    }

    @Deprecated
    public int GetSignedBitLength() {
        return this.GetSignedBitLengthAsEInteger().ToInt32Checked();
    }

    public boolean GetUnsignedBit(EInteger bigIndex) {
        int indexmod;
        if (bigIndex == null) {
            throw new NullPointerException("bigIndex");
        }
        if (bigIndex.signum() < 0) {
            throw new IllegalArgumentException("bigIndex(" + bigIndex + ") is less than 0");
        }
        if (bigIndex.CanFitInInt32()) {
            return this.GetUnsignedBit(bigIndex.ToInt32Checked());
        }
        if (bigIndex.Divide(16).compareTo(this.words.length) < 0) {
            return false;
        }
        int index = bigIndex.ShiftRight(4).ToInt32Checked();
        return (this.words[index] >> (indexmod = bigIndex.Remainder(16).ToInt32Checked()) & 1) != 0;
    }

    public boolean GetUnsignedBit(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("index(" + index + ") is less than 0");
        }
        return index >> 4 < this.words.length && (this.words[index >> 4] >> (index & 0xF) & 1) != 0;
    }

    public EInteger GetUnsignedBitLengthAsEInteger() {
        return EInteger.FromInt64(this.GetUnsignedBitLengthAsInt64());
    }

    public long GetUnsignedBitLengthAsInt64() {
        int wc = this.wordCount;
        if (wc != 0) {
            int numberValue = this.words[wc - 1] & 0xFFFF;
            long longBase = (long)wc - 1L << 4;
            if (numberValue == 0) {
                return longBase;
            }
            wc = 16;
            if (numberValue >> 8 == 0) {
                numberValue <<= 8;
                wc -= 8;
            }
            if (numberValue >> 12 == 0) {
                numberValue <<= 4;
                wc -= 4;
            }
            if (numberValue >> 14 == 0) {
                numberValue <<= 2;
                wc -= 2;
            }
            if (numberValue >> 15 == 0) {
                --wc;
            }
            return longBase + (long)wc;
        }
        return 0L;
    }

    @Deprecated
    public int GetUnsignedBitLength() {
        return this.GetUnsignedBitLengthAsEInteger().ToInt32Checked();
    }

    public EInteger Mod(EInteger divisor) {
        if (divisor == null) {
            throw new NullPointerException("divisor");
        }
        if (divisor.signum() < 0) {
            throw new ArithmeticException("Divisor is negative");
        }
        EInteger remainderEInt = this.Remainder(divisor);
        if (remainderEInt.signum() < 0) {
            remainderEInt = divisor.Add(remainderEInt);
        }
        return remainderEInt;
    }

    public EInteger Mod(int smallDivisor) {
        if (smallDivisor < 0) {
            throw new ArithmeticException("Divisor is negative");
        }
        EInteger remainderEInt = this.Remainder(smallDivisor);
        if (remainderEInt.signum() < 0) {
            remainderEInt = EInteger.FromInt32(smallDivisor).Add(remainderEInt);
        }
        return remainderEInt;
    }

    public EInteger ModPow(EInteger pow, EInteger mod) {
        if (pow == null) {
            throw new NullPointerException("pow");
        }
        if (mod == null) {
            throw new NullPointerException("mod");
        }
        if (pow.signum() < 0) {
            throw new IllegalArgumentException("pow(" + pow + ") is less than 0");
        }
        if (mod.signum() <= 0) {
            throw new IllegalArgumentException("mod(" + mod + ") is not greater than 0");
        }
        EInteger r = EInteger.FromInt32(1);
        EInteger eiv = this;
        while (!pow.isZero()) {
            if (!pow.isEven()) {
                r = r.Multiply(eiv).Mod(mod);
            }
            if ((pow = pow.ShiftRight(1)).isZero()) continue;
            eiv = eiv.Multiply(eiv).Mod(mod);
        }
        return r;
    }

    public EInteger Multiply(EInteger bigintMult) {
        int words1Size;
        int productwordCount;
        short[] productreg;
        int wc;
        if (bigintMult == null) {
            throw new NullPointerException("bigintMult");
        }
        if (this.wordCount == 0 || bigintMult.wordCount == 0) {
            return EInteger.FromInt32(0);
        }
        if (this.wordCount == 1 && this.words[0] == 1) {
            return this.negative ? bigintMult.Negate() : bigintMult;
        }
        if (bigintMult.wordCount == 1 && bigintMult.words[0] == 1) {
            return bigintMult.negative ? this.Negate() : this;
        }
        boolean needShorten = true;
        if (this.wordCount == 1) {
            if (bigintMult.wordCount == 1) {
                short[] productreg2 = new short[2];
                int ba = this.words[0] & 0xFFFF;
                int bb = bigintMult.words[0] & 0xFFFF;
                productreg2[0] = (short)((ba *= bb) & 0xFFFF);
                productreg2[1] = (short)(ba >> 16 & 0xFFFF);
                short preg = productreg2[1];
                int wc2 = preg == 0 ? 1 : 2;
                return new EInteger(wc2, productreg2, this.negative ^ bigintMult.negative);
            }
            wc = bigintMult.wordCount;
            int regLength = wc + 1;
            productreg = new short[regLength];
            productreg[wc] = EInteger.LinearMultiply(productreg, 0, bigintMult.words, 0, this.words[0], wc);
            productwordCount = productreg.length;
            needShorten = false;
        } else if (bigintMult.wordCount == 1) {
            wc = this.wordCount;
            int regLength = wc + 1;
            productreg = new short[regLength];
            productreg[wc] = EInteger.LinearMultiply(productreg, 0, this.words, 0, bigintMult.words[0], wc);
            productwordCount = productreg.length;
            needShorten = false;
        } else if (this.equals(bigintMult)) {
            words1Size = this.wordCount;
            productreg = new short[words1Size + words1Size];
            productwordCount = productreg.length;
            short[] workspace = new short[words1Size + words1Size];
            EInteger.RecursiveSquare(productreg, 0, workspace, 0, this.words, 0, words1Size);
        } else if (this.wordCount <= 10 && bigintMult.wordCount <= 10) {
            wc = this.wordCount + bigintMult.wordCount;
            productreg = new short[wc];
            productwordCount = productreg.length;
            EInteger.SchoolbookMultiply(productreg, 0, this.words, 0, this.wordCount, bigintMult.words, 0, bigintMult.wordCount);
            needShorten = false;
        } else {
            words1Size = this.wordCount;
            int words2Size = bigintMult.wordCount;
            productreg = new short[words1Size + words2Size];
            short[] workspace = new short[words1Size + words2Size];
            productwordCount = productreg.length;
            EInteger.AsymmetricMultiply(productreg, 0, workspace, 0, this.words, 0, words1Size, bigintMult.words, 0, words2Size);
        }
        while (productwordCount != 0 && productreg[productwordCount - 1] == 0) {
            --productwordCount;
        }
        if (needShorten) {
            productreg = EInteger.ShortenArray(productreg, productwordCount);
        }
        return new EInteger(productwordCount, productreg, this.negative ^ bigintMult.negative);
    }

    private static EInteger MakeEInteger(short[] words, int wordsEnd, int offset, int count) {
        int ct;
        if (offset >= wordsEnd) {
            return EInteger.FromInt32(0);
        }
        for (ct = Math.min(count, wordsEnd - offset); ct != 0 && words[offset + ct - 1] == 0; --ct) {
        }
        if (ct == 0) {
            return EInteger.FromInt32(0);
        }
        short[] newwords = new short[ct];
        System.arraycopy(words, offset, newwords, 0, ct);
        return new EInteger(ct, newwords, false);
    }

    private static void Toom3(short[] resultArr, int resultStart, short[] wordsA, int wordsAStart, int countA, short[] wordsB, int wordsBStart, int countB) {
        EInteger wt3;
        EInteger wt2;
        EInteger wt1;
        EInteger w4;
        EInteger w0;
        int imal = Math.max(countA, countB);
        int im3 = imal / 3 + (imal % 3 + 2) / 3;
        EInteger m3mul16 = EInteger.FromInt32(im3).ShiftLeft(4);
        EInteger x0 = EInteger.MakeEInteger(wordsA, wordsAStart + countA, wordsAStart, im3);
        EInteger x1 = EInteger.MakeEInteger(wordsA, wordsAStart + countA, wordsAStart + im3, im3);
        EInteger x2 = EInteger.MakeEInteger(wordsA, wordsAStart + countA, wordsAStart + im3 * 2, im3);
        if (wordsA == wordsB && wordsAStart == wordsBStart && countA == countB) {
            w0 = x0.Multiply(x0);
            w4 = x2.Multiply(x2);
            EInteger x2x0 = x2.Add(x0);
            wt1 = x2x0.Add(x1);
            wt2 = x2x0.Subtract(x1);
            wt3 = x2.ShiftLeft(2).Add(x1.ShiftLeft(1)).Add(x0);
            wt1 = wt1.Multiply(wt1);
            wt2 = wt2.Multiply(wt2);
            wt3 = wt3.Multiply(wt3);
        } else {
            EInteger y0 = EInteger.MakeEInteger(wordsB, wordsBStart + countB, wordsBStart, im3);
            EInteger y1 = EInteger.MakeEInteger(wordsB, wordsBStart + countB, wordsBStart + im3, im3);
            EInteger y2 = EInteger.MakeEInteger(wordsB, wordsBStart + countB, wordsBStart + im3 * 2, im3);
            w0 = x0.Multiply(y0);
            w4 = x2.Multiply(y2);
            EInteger x2x0 = x2.Add(x0);
            EInteger y2y0 = y2.Add(y0);
            wt1 = x2x0.Add(x1).Multiply(y2y0.Add(y1));
            wt2 = x2x0.Subtract(x1).Multiply(y2y0.Subtract(y1));
            wt3 = x2.ShiftLeft(2).Add(x1.ShiftLeft(1)).Add(x0).Multiply(y2.ShiftLeft(2).Add(y1.ShiftLeft(1)).Add(y0));
        }
        EInteger w4mul2 = w4.ShiftLeft(1);
        EInteger w4mul12 = w4mul2.Multiply(6);
        EInteger w0mul3 = w0.Multiply(3);
        EInteger w3 = w0mul3.Subtract(w4mul12).Subtract(wt1.Multiply(3)).Subtract(wt2).Add(wt3).Divide(6);
        EInteger w2 = wt1.Add(wt2).Subtract(w0.ShiftLeft(1)).Subtract(w4mul2).ShiftRight(1);
        EInteger w1 = wt1.Multiply(6).Add(w4mul12).Subtract(wt3).Subtract(wt2).Subtract(wt2).Subtract(w0mul3).Divide(6);
        if (m3mul16.compareTo(0x70000000) < 0) {
            w0 = w0.Add(w1.ShiftLeft(im3 <<= 4));
            w0 = w0.Add(w2.ShiftLeft(im3 * 2));
            w0 = w0.Add(w3.ShiftLeft(im3 * 3));
            w0 = w0.Add(w4.ShiftLeft(im3 * 4));
        } else {
            w0 = w0.Add(w1.ShiftLeft(m3mul16));
            w0 = w0.Add(w2.ShiftLeft(m3mul16.Multiply(2)));
            w0 = w0.Add(w3.ShiftLeft(m3mul16.Multiply(3)));
            w0 = w0.Add(w4.ShiftLeft(m3mul16.Multiply(4)));
        }
        Arrays.fill(resultArr, resultStart, resultStart + (countA + countB), (short)0);
        System.arraycopy(w0.words, 0, resultArr, resultStart, Math.min(countA + countB, w0.wordCount));
    }

    private static EInteger Interpolate(EInteger[] wts, int[] values, int divisor) {
        EInteger ret = EInteger.FromInt32(0);
        for (int i = 0; i < wts.length; ++i) {
            int v = values[i];
            if (v == 0) continue;
            ret = v == 1 ? ret.Add(wts[i]) : (v == -1 ? ret.Subtract(wts[i]) : ret.Add(wts[i].Multiply(v)));
        }
        return ret.Divide(divisor);
    }

    private static void Toom4(short[] resultArr, int resultStart, short[] wordsA, int wordsAStart, int countA, short[] wordsB, int wordsBStart, int countB) {
        EInteger wt5;
        EInteger wt4;
        EInteger wt3;
        EInteger wt2;
        EInteger wt1;
        EInteger w6;
        EInteger w0;
        int imal = Math.max(countA, countB);
        int im3 = imal / 4 + (imal % 4 + 3) / 4;
        EInteger m3mul16 = EInteger.FromInt32(im3).ShiftLeft(4);
        EInteger x0 = EInteger.MakeEInteger(wordsA, wordsAStart + countA, wordsAStart, im3);
        EInteger x1 = EInteger.MakeEInteger(wordsA, wordsAStart + countA, wordsAStart + im3, im3);
        EInteger x2 = EInteger.MakeEInteger(wordsA, wordsAStart + countA, wordsAStart + im3 * 2, im3);
        EInteger x3 = EInteger.MakeEInteger(wordsA, wordsAStart + countA, wordsAStart + im3 * 3, im3);
        if (wordsA == wordsB && wordsAStart == wordsBStart && countA == countB) {
            w0 = x0.Multiply(x0);
            w6 = x3.Multiply(x3);
            EInteger x2mul2 = x2.ShiftLeft(1);
            EInteger x1mul4 = x1.ShiftLeft(2);
            EInteger x0mul8 = x0.ShiftLeft(3);
            EInteger x1x3 = x1.Add(x3);
            EInteger x0x2 = x0.Add(x2);
            wt1 = x3.Add(x2mul2).Add(x1mul4).Add(x0mul8);
            wt2 = x3.Negate().Add(x2mul2).Subtract(x1mul4).Add(x0mul8);
            wt3 = x0x2.Add(x1x3);
            wt4 = x0x2.Subtract(x1x3);
            wt5 = x0.Add(x3.ShiftLeft(3)).Add(x2.ShiftLeft(2)).Add(x1.ShiftLeft(1));
            wt1 = wt1.Multiply(wt1);
            wt2 = wt2.Multiply(wt2);
            wt3 = wt3.Multiply(wt3);
            wt4 = wt4.Multiply(wt4);
            wt5 = wt5.Multiply(wt5);
        } else {
            EInteger y0 = EInteger.MakeEInteger(wordsB, wordsBStart + countB, wordsBStart, im3);
            EInteger y1 = EInteger.MakeEInteger(wordsB, wordsBStart + countB, wordsBStart + im3, im3);
            EInteger y2 = EInteger.MakeEInteger(wordsB, wordsBStart + countB, wordsBStart + im3 * 2, im3);
            EInteger y3 = EInteger.MakeEInteger(wordsB, wordsBStart + countB, wordsBStart + im3 * 3, im3);
            w0 = x0.Multiply(y0);
            w6 = x3.Multiply(y3);
            EInteger x2mul2 = x2.ShiftLeft(1);
            EInteger x1mul4 = x1.ShiftLeft(2);
            EInteger x0mul8 = x0.ShiftLeft(3);
            EInteger y2mul2 = y2.ShiftLeft(1);
            EInteger y1mul4 = y1.ShiftLeft(2);
            EInteger y0mul8 = y0.ShiftLeft(3);
            EInteger x1x3 = x1.Add(x3);
            EInteger x0x2 = x0.Add(x2);
            EInteger y1y3 = y1.Add(y3);
            EInteger y0y2 = y0.Add(y2);
            wt1 = x3.Add(x2mul2).Add(x1mul4).Add(x0mul8);
            wt1 = wt1.Multiply(y3.Add(y2mul2).Add(y1mul4).Add(y0mul8));
            wt2 = x3.Negate().Add(x2mul2).Subtract(x1mul4).Add(x0mul8);
            wt2 = wt2.Multiply(y3.Negate().Add(y2mul2).Subtract(y1mul4).Add(y0mul8));
            wt3 = x0x2.Add(x1x3);
            wt3 = wt3.Multiply(y0y2.Add(y1y3));
            wt4 = x0x2.Subtract(x1x3);
            wt4 = wt4.Multiply(y0y2.Subtract(y1y3));
            wt5 = x0.Add(x3.ShiftLeft(3)).Add(x2.ShiftLeft(2)).Add(x1.ShiftLeft(1));
            wt5 = wt5.Multiply(y0.Add(y3.ShiftLeft(3)).Add(y2.ShiftLeft(2)).Add(y1.ShiftLeft(1)));
        }
        EInteger[] wts = new EInteger[]{w0, wt1, wt2, wt3, wt4, wt5, w6};
        int[] wts2 = new int[]{-90, 5, -3, -60, 20, 2, -90};
        EInteger w1 = EInteger.Interpolate(wts, wts2, 180);
        wts2 = new int[]{-120, 1, 1, -4, -4, 0, 6};
        EInteger w2 = EInteger.Interpolate(wts, wts2, 24);
        wts2 = new int[]{45, -1, 0, 27, -7, -1, 45};
        EInteger w3 = EInteger.Interpolate(wts, wts2, 18);
        wts2 = new int[]{96, -1, -1, 16, 16, 0, -30};
        EInteger w4 = EInteger.Interpolate(wts, wts2, 24);
        wts2 = new int[]{-360, 5, 3, -120, -40, 8, -360};
        EInteger w5 = EInteger.Interpolate(wts, wts2, 180);
        if (m3mul16.compareTo(0x70000000) < 0) {
            w0 = w0.Add(w1.ShiftLeft(im3 <<= 4));
            w0 = w0.Add(w2.ShiftLeft(im3 * 2));
            w0 = w0.Add(w3.ShiftLeft(im3 * 3));
            w0 = w0.Add(w4.ShiftLeft(im3 * 4));
            w0 = w0.Add(w5.ShiftLeft(im3 * 5));
            w0 = w0.Add(w6.ShiftLeft(im3 * 6));
        } else {
            w0 = w0.Add(w1.ShiftLeft(m3mul16));
            w0 = w0.Add(w2.ShiftLeft(m3mul16.Multiply(2)));
            w0 = w0.Add(w3.ShiftLeft(m3mul16.Multiply(3)));
            w0 = w0.Add(w4.ShiftLeft(m3mul16.Multiply(4)));
            w0 = w0.Add(w5.ShiftLeft(m3mul16.Multiply(5)));
            w0 = w0.Add(w6.ShiftLeft(m3mul16.Multiply(6)));
        }
        Arrays.fill(resultArr, resultStart, resultStart + (countA + countB), (short)0);
        System.arraycopy(w0.words, 0, resultArr, resultStart, Math.min(countA + countB, w0.wordCount));
    }

    public EInteger Negate() {
        return this.wordCount == 0 ? this : new EInteger(this.wordCount, this.words, !this.negative);
    }

    public EInteger Pow(EInteger bigPower) {
        if (bigPower == null) {
            throw new NullPointerException("bigPower");
        }
        if (bigPower.signum() < 0) {
            throw new IllegalArgumentException("bigPower is negative");
        }
        if (bigPower.signum() == 0) {
            return EInteger.FromInt32(1);
        }
        if (bigPower.compareTo(1) == 0) {
            return this;
        }
        if (this.isZero() || this.compareTo(1) == 0) {
            return this;
        }
        if (this.compareTo(-1) == 0) {
            return this.isEven() ? EInteger.FromInt32(1) : this;
        }
        EInteger bitLength = this.GetUnsignedBitLengthAsEInteger();
        if (!this.isPowerOfTwo()) {
            bitLength = bitLength.Subtract(1);
        }
        if (bigPower.CanFitInInt32()) {
            return this.Pow(bigPower.ToInt32Checked());
        }
        EInteger bp = bigPower;
        EInteger ret = EInteger.FromInt32(1);
        EInteger rmax = this.Pow(Integer.MAX_VALUE);
        while (!bp.CanFitInInt32()) {
            ret = ret.Multiply(rmax);
            bp = bp.Subtract(Integer.MAX_VALUE);
        }
        int lastp = bp.ToInt32Checked();
        ret = lastp == Integer.MAX_VALUE ? ret.Multiply(rmax) : ret.Multiply(this.Pow(lastp));
        return ret;
    }

    public EInteger Pow(int powerSmall) {
        if (powerSmall < 0) {
            throw new IllegalArgumentException("powerSmall(" + powerSmall + ") is less than 0");
        }
        EInteger thisVar = this;
        if (powerSmall == 0) {
            return EInteger.FromInt32(1);
        }
        if (powerSmall == 1) {
            return this;
        }
        if (this.isZero() || this.compareTo(1) == 0) {
            return this;
        }
        if (this.compareTo(-1) == 0) {
            return this.isEven() ? EInteger.FromInt32(1) : this;
        }
        if (powerSmall == 2) {
            return thisVar.Multiply(thisVar);
        }
        if (powerSmall == 3) {
            return thisVar.Multiply(thisVar).Multiply(thisVar);
        }
        EInteger r = EInteger.FromInt32(1);
        while (powerSmall != 0) {
            if ((powerSmall & 1) != 0) {
                r = r.Multiply(thisVar);
            }
            if ((powerSmall >>= 1) == 0) continue;
            thisVar = thisVar.Multiply(thisVar);
        }
        return r;
    }

    public EInteger PowBigIntVar(EInteger power) {
        if (power == null) {
            throw new NullPointerException("power");
        }
        int sign = power.signum();
        if (sign < 0) {
            throw new IllegalArgumentException("sign (" + sign + ") is less than 0");
        }
        EInteger thisVar = this;
        if (sign == 0) {
            return EInteger.FromInt32(1);
        }
        if (power.equals(EInteger.FromInt32(1))) {
            return this;
        }
        if (power.wordCount == 1 && power.words[0] == 2) {
            return thisVar.Multiply(thisVar);
        }
        if (power.wordCount == 1 && power.words[0] == 3) {
            return thisVar.Multiply(thisVar).Multiply(thisVar);
        }
        EInteger r = EInteger.FromInt32(1);
        while (!power.isZero()) {
            if (!power.isEven()) {
                r = r.Multiply(thisVar);
            }
            if ((power = power.ShiftRight(1)).isZero()) continue;
            thisVar = thisVar.Multiply(thisVar);
        }
        return r;
    }

    public EInteger Remainder(EInteger divisor) {
        if (divisor == null) {
            throw new NullPointerException("divisor");
        }
        int words1Size = this.wordCount;
        int words2Size = divisor.wordCount;
        if (words2Size == 0) {
            throw new ArithmeticException();
        }
        if (words1Size < words2Size) {
            return this;
        }
        if (words2Size == 1) {
            short shortRemainder = EInteger.FastRemainder(this.words, this.wordCount, divisor.words[0]);
            int smallRemainder = shortRemainder & 0xFFFF;
            if (this.negative) {
                smallRemainder = -smallRemainder;
            }
            return EInteger.FromInt64(smallRemainder);
        }
        if (this.PositiveCompare(divisor) < 0) {
            return this;
        }
        short[] remainderReg = new short[words2Size];
        EInteger.GeneralDivide(this.words, 0, this.wordCount, divisor.words, 0, divisor.wordCount, null, 0, remainderReg, 0);
        int count = EInteger.CountWords(remainderReg);
        if (count == 0) {
            return EInteger.FromInt32(0);
        }
        remainderReg = EInteger.ShortenArray(remainderReg, count);
        return new EInteger(count, remainderReg, this.negative);
    }

    public EInteger ShiftRight(EInteger eshift) {
        if (eshift == null) {
            throw new NullPointerException("eshift");
        }
        EInteger valueETempShift = eshift;
        EInteger ret = this;
        if (valueETempShift.signum() < 0) {
            return ret.ShiftLeft(valueETempShift.Negate());
        }
        while (!valueETempShift.CanFitInInt32()) {
            valueETempShift = valueETempShift.Subtract(0x7FFFFFF0);
            ret = ret.ShiftRight(0x7FFFFFF0);
        }
        return ret.ShiftRight(valueETempShift.ToInt32Checked());
    }

    public EInteger ShiftLeft(EInteger eshift) {
        if (eshift == null) {
            throw new NullPointerException("eshift");
        }
        EInteger valueETempShift = eshift;
        EInteger ret = this;
        if (valueETempShift.signum() < 0) {
            return ret.ShiftRight(valueETempShift.Negate());
        }
        while (!valueETempShift.CanFitInInt32()) {
            valueETempShift = valueETempShift.Subtract(0x7FFFFFF0);
            ret = ret.ShiftLeft(0x7FFFFFF0);
        }
        return ret.ShiftLeft(valueETempShift.ToInt32Checked());
    }

    public EInteger ShiftLeft(int numberBits) {
        if (numberBits == 0 || this.wordCount == 0) {
            return this;
        }
        if (numberBits < 0) {
            return numberBits == Integer.MIN_VALUE ? this.ShiftRight(1).ShiftRight(Integer.MAX_VALUE) : this.ShiftRight(-numberBits);
        }
        int numWords = this.wordCount;
        int shiftWords = numberBits >> 4;
        int shiftBits = numberBits & 0xF;
        if (!this.negative) {
            int lastWord = this.words[this.wordCount - 1] & 0xFFFF;
            int lastWordBL = NumberUtility.BitLength(lastWord) + shiftBits;
            int newWordCount = 0;
            newWordCount = lastWordBL <= 16 ? numWords + shiftWords : numWords + EInteger.BitsToWords(numberBits);
            short[] ret = new short[newWordCount];
            System.arraycopy(this.words, 0, ret, shiftWords, numWords);
            EInteger.ShiftWordsLeftByBits(ret, shiftWords, newWordCount - shiftWords, shiftBits);
            return new EInteger(newWordCount, ret, false);
        }
        short[] ret = new short[numWords + EInteger.BitsToWords(numberBits)];
        System.arraycopy(this.words, 0, ret, 0, numWords);
        EInteger.TwosComplement(ret, 0, ret.length);
        EInteger.ShiftWordsLeftByWords(ret, 0, numWords + shiftWords, shiftWords);
        EInteger.ShiftWordsLeftByBits(ret, shiftWords, numWords + EInteger.BitsToWords(shiftBits), shiftBits);
        EInteger.TwosComplement(ret, 0, ret.length);
        return new EInteger(EInteger.CountWords(ret), ret, true);
    }

    private static void OrWords(short[] r, short[] a, short[] b, int n) {
        for (int i = 0; i < n; ++i) {
            r[i] = (short)(a[i] | b[i]);
        }
    }

    private static void XorWords(short[] r, short[] a, short[] b, int n) {
        for (int i = 0; i < n; ++i) {
            r[i] = (short)(a[i] ^ b[i]);
        }
    }

    private static void NotWords(short[] r, int n) {
        for (int i = 0; i < n; ++i) {
            r[i] = ~r[i];
        }
    }

    private static void AndWords(short[] r, short[] a, short[] b, int n) {
        for (int i = 0; i < n; ++i) {
            r[i] = (short)(a[i] & b[i]);
        }
    }

    public EInteger Not() {
        if (this.wordCount == 0) {
            return EInteger.FromInt32(-1);
        }
        boolean valueXaNegative = false;
        int valueXaWordCount = 0;
        short[] valueXaReg = new short[this.wordCount];
        System.arraycopy(this.words, 0, valueXaReg, 0, valueXaReg.length);
        valueXaWordCount = this.wordCount;
        if (this.negative) {
            EInteger.TwosComplement(valueXaReg, 0, valueXaReg.length);
        }
        EInteger.NotWords(valueXaReg, valueXaReg.length);
        if (this.negative) {
            EInteger.TwosComplement(valueXaReg, 0, valueXaReg.length);
        }
        valueXaNegative = !this.negative;
        valueXaWordCount = EInteger.CountWords(valueXaReg);
        return valueXaWordCount == 0 ? EInteger.FromInt32(0) : new EInteger(valueXaWordCount, valueXaReg, valueXaNegative);
    }

    public EInteger And(EInteger other) {
        if (other == null) {
            throw new NullPointerException("other");
        }
        if (other.isZero() || this.isZero()) {
            return EInteger.FromInt32(0);
        }
        if (!this.negative && !other.negative) {
            int smallerCount = Math.min(this.wordCount, other.wordCount);
            short[] smaller = this.wordCount == smallerCount ? this.words : other.words;
            short[] bigger = this.wordCount == smallerCount ? other.words : this.words;
            short[] result = new short[smallerCount];
            for (int i = 0; i < smallerCount; ++i) {
                result[i] = (short)(smaller[i] & bigger[i]);
            }
            smallerCount = EInteger.CountWords(result);
            return smallerCount == 0 ? EInteger.FromInt32(0) : new EInteger(smallerCount, result, false);
        }
        boolean valueXaNegative = false;
        int valueXaWordCount = 0;
        short[] valueXaReg = new short[this.wordCount];
        System.arraycopy(this.words, 0, valueXaReg, 0, valueXaReg.length);
        boolean valueXbNegative = false;
        short[] valueXbReg = new short[other.wordCount];
        System.arraycopy(other.words, 0, valueXbReg, 0, valueXbReg.length);
        valueXaNegative = this.negative;
        valueXaWordCount = this.wordCount;
        valueXbNegative = other.negative;
        valueXaReg = EInteger.CleanGrow(valueXaReg, Math.max(valueXaReg.length, valueXbReg.length));
        valueXbReg = EInteger.CleanGrow(valueXbReg, Math.max(valueXaReg.length, valueXbReg.length));
        if (valueXaNegative) {
            EInteger.TwosComplement(valueXaReg, 0, valueXaReg.length);
        }
        if (valueXbNegative) {
            EInteger.TwosComplement(valueXbReg, 0, valueXbReg.length);
        }
        EInteger.AndWords(valueXaReg, valueXaReg, valueXbReg, valueXaReg.length);
        if (valueXaNegative &= valueXbNegative) {
            EInteger.TwosComplement(valueXaReg, 0, valueXaReg.length);
        }
        return (valueXaWordCount = EInteger.CountWords(valueXaReg)) == 0 ? EInteger.FromInt32(0) : new EInteger(valueXaWordCount, valueXaReg, valueXaNegative);
    }

    public EInteger Or(EInteger second) {
        if (second == null) {
            throw new NullPointerException("second");
        }
        if (this.wordCount == 0) {
            return second;
        }
        if (second.wordCount == 0) {
            return this;
        }
        if (!this.negative && !second.negative) {
            int smallerCount = Math.min(this.wordCount, second.wordCount);
            int biggerCount = Math.max(this.wordCount, second.wordCount);
            short[] smaller = this.wordCount == smallerCount ? this.words : second.words;
            short[] bigger = this.wordCount == smallerCount ? second.words : this.words;
            short[] result = new short[biggerCount];
            for (int i = 0; i < smallerCount; ++i) {
                result[i] = (short)(smaller[i] | bigger[i]);
            }
            System.arraycopy(bigger, smallerCount, result, smallerCount, biggerCount - smallerCount);
            return new EInteger(biggerCount, result, false);
        }
        boolean valueXaNegative = false;
        int valueXaWordCount = 0;
        short[] valueXaReg = new short[this.wordCount];
        System.arraycopy(this.words, 0, valueXaReg, 0, valueXaReg.length);
        boolean valueXbNegative = false;
        short[] valueXbReg = new short[second.wordCount];
        System.arraycopy(second.words, 0, valueXbReg, 0, valueXbReg.length);
        valueXaNegative = this.negative;
        valueXaWordCount = this.wordCount;
        valueXbNegative = second.negative;
        valueXaReg = EInteger.CleanGrow(valueXaReg, Math.max(valueXaReg.length, valueXbReg.length));
        valueXbReg = EInteger.CleanGrow(valueXbReg, Math.max(valueXaReg.length, valueXbReg.length));
        if (valueXaNegative) {
            EInteger.TwosComplement(valueXaReg, 0, valueXaReg.length);
        }
        if (valueXbNegative) {
            EInteger.TwosComplement(valueXbReg, 0, valueXbReg.length);
        }
        EInteger.OrWords(valueXaReg, valueXaReg, valueXbReg, valueXaReg.length);
        if (valueXaNegative |= valueXbNegative) {
            EInteger.TwosComplement(valueXaReg, 0, valueXaReg.length);
        }
        return (valueXaWordCount = EInteger.CountWords(valueXaReg)) == 0 ? EInteger.FromInt32(0) : new EInteger(valueXaWordCount, valueXaReg, valueXaNegative);
    }

    public EInteger AndNot(EInteger second) {
        if (second == null) {
            throw new NullPointerException("second");
        }
        return this.And(second.Not());
    }

    public EInteger OrNot(EInteger second) {
        if (second == null) {
            throw new NullPointerException("second");
        }
        return this.Or(second.Not());
    }

    public EInteger Imp(EInteger second) {
        return this.OrNot(second);
    }

    public EInteger XorNot(EInteger second) {
        if (second == null) {
            throw new NullPointerException("second");
        }
        return this.Xor(second.Not());
    }

    public EInteger Eqv(EInteger second) {
        if (second == null) {
            throw new NullPointerException("second");
        }
        return this.XorNot(second);
    }

    public EInteger Xor(EInteger other) {
        if (other == null) {
            throw new NullPointerException("other");
        }
        if (this.equals(other)) {
            return EInteger.FromInt32(0);
        }
        if (this.wordCount == 0) {
            return other;
        }
        if (other.wordCount == 0) {
            return this;
        }
        if (!this.negative && !other.negative) {
            int smallerCount = Math.min(this.wordCount, other.wordCount);
            int biggerCount = Math.max(this.wordCount, other.wordCount);
            short[] smaller = this.wordCount == smallerCount ? this.words : other.words;
            short[] bigger = this.wordCount == smallerCount ? other.words : this.words;
            short[] result = new short[biggerCount];
            for (int i = 0; i < smallerCount; ++i) {
                result[i] = (short)(smaller[i] ^ bigger[i]);
            }
            System.arraycopy(bigger, smallerCount, result, smallerCount, biggerCount - smallerCount);
            smallerCount = smallerCount == biggerCount ? EInteger.CountWords(result) : biggerCount;
            return smallerCount == 0 ? EInteger.FromInt32(0) : new EInteger(smallerCount, result, false);
        }
        boolean valueXaNegative = false;
        int valueXaWordCount = 0;
        short[] valueXaReg = new short[this.wordCount];
        System.arraycopy(this.words, 0, valueXaReg, 0, valueXaReg.length);
        boolean valueXbNegative = false;
        short[] valueXbReg = new short[other.wordCount];
        System.arraycopy(other.words, 0, valueXbReg, 0, valueXbReg.length);
        valueXaNegative = this.negative;
        valueXaWordCount = this.wordCount;
        valueXbNegative = other.negative;
        valueXaReg = EInteger.CleanGrow(valueXaReg, Math.max(valueXaReg.length, valueXbReg.length));
        valueXbReg = EInteger.CleanGrow(valueXbReg, Math.max(valueXaReg.length, valueXbReg.length));
        if (valueXaNegative) {
            EInteger.TwosComplement(valueXaReg, 0, valueXaReg.length);
        }
        if (valueXbNegative) {
            EInteger.TwosComplement(valueXbReg, 0, valueXbReg.length);
        }
        EInteger.XorWords(valueXaReg, valueXaReg, valueXbReg, valueXaReg.length);
        if (valueXaNegative ^= valueXbNegative) {
            EInteger.TwosComplement(valueXaReg, 0, valueXaReg.length);
        }
        return (valueXaWordCount = EInteger.CountWords(valueXaReg)) == 0 ? EInteger.FromInt32(0) : new EInteger(valueXaWordCount, valueXaReg, valueXaNegative);
    }

    private short[] Copy() {
        short[] words = new short[this.words.length];
        System.arraycopy(this.words, 0, words, 0, this.wordCount);
        return words;
    }

    private static int WordsCompare(short[] words, int wordCount, short[] words2, int wordCount2) {
        return EInteger.WordsCompare(words, 0, wordCount, words2, 0, wordCount2);
    }

    private static int WordsCompare(short[] words, int pos1, int wordCount, short[] words2, int pos2, int wordCount2) {
        int size = wordCount;
        if (size == 0) {
            return wordCount2 == 0 ? 0 : -1;
        }
        if (wordCount2 == 0) {
            return 1;
        }
        if (size == wordCount2) {
            if (size == 1 && words[pos1] == words2[pos2]) {
                return 0;
            }
            int p1 = pos1 + size - 1;
            int p2 = pos2 + size - 1;
            while (size-- != 0) {
                int an = words[p1] & 0xFFFF;
                int bn = words2[p2] & 0xFFFF;
                if (an > bn) {
                    return 1;
                }
                if (an < bn) {
                    return -1;
                }
                --p1;
                --p2;
            }
            return 0;
        }
        return size > wordCount2 ? 1 : -1;
    }

    private static long WordsToLongUnchecked(short[] words, int wordCount) {
        int c = wordCount;
        if (c == 0) {
            return 0L;
        }
        long ivv = 0L;
        int intRetValue = words[0] & 0xFFFF;
        if (c > 1) {
            intRetValue |= (words[1] & 0xFFFF) << 16;
        }
        if (c > 2) {
            int intRetValue2 = words[2] & 0xFFFF;
            if (c > 3) {
                intRetValue2 |= (words[3] & 0xFFFF) << 16;
            }
            ivv = (long)intRetValue & 0xFFFFFFFFL;
            return ivv |= (long)intRetValue2 << 32;
        }
        ivv = (long)intRetValue & 0xFFFFFFFFL;
        return ivv;
    }

    private static boolean WordsEqual(short[] words, int wordCount, short[] words2, int wordCount2) {
        if (wordCount == wordCount2) {
            for (int i = 0; i < wordCount; ++i) {
                if (words[i] == words2[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean WordsIsEven(short[] words, int wordCount) {
        return wordCount == 0 || (words[0] & 1) == 0;
    }

    private static int WordsShiftRightTwo(short[] words, int wordCount) {
        if (wordCount != 0) {
            int carry = 0;
            for (int i = wordCount - 1; i >= 0; --i) {
                short w = words[i];
                int u = (w & 0xFFFC) >> 2 | carry;
                carry = w << 14 & 0xC000;
                words[i] = (short)u;
            }
            if (words[wordCount - 1] == 0) {
                --wordCount;
            }
        }
        return wordCount;
    }

    private static int WordsShiftRightEight(short[] words, int wordCount) {
        if (wordCount != 0) {
            int carry = 0;
            for (int i = wordCount - 1; i >= 0; --i) {
                short w = words[i];
                int u = (w & 0xFF00) >> 8 | carry;
                carry = w << 8 & 0xFF00;
                words[i] = (short)u;
            }
            if (words[wordCount - 1] == 0) {
                --wordCount;
            }
        }
        return wordCount;
    }

    private static int WordsShiftRightFour(short[] words, int wordCount) {
        if (wordCount != 0) {
            int carry = 0;
            for (int i = wordCount - 1; i >= 0; --i) {
                short w = words[i];
                int u = (w & 0xFFF0) >> 4 | carry;
                carry = w << 12 & 0xF000;
                words[i] = (short)u;
            }
            if (words[wordCount - 1] == 0) {
                --wordCount;
            }
        }
        return wordCount;
    }

    private static int WordsShiftRightOne(short[] words, int wordCount) {
        if (wordCount != 0) {
            int carry = 0;
            for (int i = wordCount - 1; i >= 0; --i) {
                short w = words[i];
                int u = (w & 0xFFFE) >> 1 | carry;
                carry = w << 15 & 0x8000;
                words[i] = (short)u;
            }
            if (words[wordCount - 1] == 0) {
                --wordCount;
            }
        }
        return wordCount;
    }

    private static int WordsSubtract(short[] words, int wordCount, short[] subtrahendWords, int subtrahendCount) {
        short borrow = (short)EInteger.SubtractInternal(words, 0, words, 0, subtrahendWords, 0, subtrahendCount);
        if (borrow != 0) {
            EInteger.DecrementWords(words, subtrahendCount, wordCount - subtrahendCount, borrow);
        }
        while (wordCount != 0 && words[wordCount - 1] == 0) {
            --wordCount;
        }
        return wordCount;
    }

    public EInteger ShiftRight(int numberBits) {
        int retWordCount;
        short[] ret;
        if (numberBits == 0 || this.wordCount == 0) {
            return this;
        }
        if (numberBits < 0) {
            return numberBits == Integer.MIN_VALUE ? this.ShiftLeft(1).ShiftLeft(Integer.MAX_VALUE) : this.ShiftLeft(-numberBits);
        }
        int numWords = this.wordCount;
        int shiftWords = numberBits >> 4;
        int shiftBits = numberBits & 0xF;
        if (this.negative) {
            ret = new short[this.words.length];
            System.arraycopy(this.words, 0, ret, 0, numWords);
            EInteger.TwosComplement(ret, 0, ret.length);
            EInteger.ShiftWordsRightByWordsSignExtend(ret, 0, numWords, shiftWords);
            if (numWords > shiftWords) {
                EInteger.ShiftWordsRightByBitsSignExtend(ret, 0, numWords - shiftWords, shiftBits);
            }
            EInteger.TwosComplement(ret, 0, ret.length);
            retWordCount = ret.length;
        } else {
            if (shiftWords >= numWords) {
                return EInteger.FromInt32(0);
            }
            ret = new short[this.words.length];
            System.arraycopy(this.words, shiftWords, ret, 0, numWords - shiftWords);
            if (shiftBits != 0) {
                EInteger.ShiftWordsRightByBits(ret, 0, numWords - shiftWords, shiftBits);
            }
            retWordCount = numWords - shiftWords;
        }
        while (retWordCount != 0 && ret[retWordCount - 1] == 0) {
            --retWordCount;
        }
        if (retWordCount == 0) {
            return EInteger.FromInt32(0);
        }
        if (shiftWords > 2) {
            ret = EInteger.ShortenArray(ret, retWordCount);
        }
        return new EInteger(retWordCount, ret, this.negative);
    }

    public EInteger Sqrt() {
        EInteger[] srrem = this.SqrtRemInternal(false);
        return srrem[0];
    }

    public EInteger[] SqrtRem() {
        return this.SqrtRemInternal(true);
    }

    public EInteger Root(EInteger root) {
        if (root == null) {
            throw new NullPointerException("root");
        }
        EInteger[] srrem = this.RootRemInternal(root, false);
        return srrem[0];
    }

    public EInteger[] RootRem(EInteger root) {
        if (root == null) {
            throw new NullPointerException("root");
        }
        return this.RootRemInternal(root, true);
    }

    public EInteger Root(int root) {
        EInteger[] srrem = this.RootRemInternal(EInteger.FromInt32(root), false);
        return srrem[0];
    }

    public EInteger[] RootRem(int root) {
        return this.RootRemInternal(EInteger.FromInt32(root), true);
    }

    public EInteger Subtract(EInteger subtrahend) {
        if (subtrahend == null) {
            throw new NullPointerException("subtrahend");
        }
        return this.wordCount == 0 ? subtrahend.Negate() : (subtrahend.wordCount == 0 ? this : this.Add(subtrahend.Negate()));
    }

    public byte[] ToBytes(boolean littleEndian) {
        int sign = this.signum();
        if (sign == 0) {
            return new byte[]{0};
        }
        if (sign > 0) {
            int byteCount;
            int byteArrayLength = byteCount = this.ByteCount();
            if (this.GetUnsignedBit(byteCount * 8 - 1)) {
                ++byteArrayLength;
            }
            byte[] bytes = new byte[byteArrayLength];
            int j = 0;
            int i = 0;
            while (i < byteCount) {
                int index = littleEndian ? i : bytes.length - 1 - i;
                int index2 = littleEndian ? i + 1 : bytes.length - 2 - i;
                bytes[index] = (byte)(this.words[j] & 0xFF);
                if (index2 >= 0 && index2 < byteArrayLength) {
                    bytes[index2] = (byte)(this.words[j] >> 8 & 0xFF);
                }
                i += 2;
                ++j;
            }
            return bytes;
        }
        short[] regdata = new short[this.words.length];
        System.arraycopy(this.words, 0, regdata, 0, this.words.length);
        EInteger.TwosComplement(regdata, 0, regdata.length);
        int byteCount = regdata.length * 2;
        for (int i = regdata.length - 1; i >= 0; --i) {
            if (regdata[i] == -1) {
                byteCount -= 2;
                continue;
            }
            if ((regdata[i] & 0xFF80) == 65408) {
                --byteCount;
                break;
            }
            if ((regdata[i] & 0x8000) == 32768) break;
            ++byteCount;
            break;
        }
        if (byteCount == 0) {
            byteCount = 1;
        }
        byte[] bytes = new byte[byteCount];
        bytes[littleEndian ? bytes.length - 1 : 0] = -1;
        byteCount = Math.min(byteCount, regdata.length * 2);
        int j = 0;
        int i = 0;
        while (i < byteCount) {
            int index = littleEndian ? i : bytes.length - 1 - i;
            int index2 = littleEndian ? i + 1 : bytes.length - 2 - i;
            bytes[index] = (byte)(regdata[j] & 0xFF);
            if (index2 >= 0 && index2 < byteCount) {
                bytes[index2] = (byte)(regdata[j] >> 8 & 0xFF);
            }
            i += 2;
            ++j;
        }
        return bytes;
    }

    public int ToInt32Checked() {
        int count = this.wordCount;
        if (count == 0) {
            return 0;
        }
        if (count > 2) {
            throw new ArithmeticException();
        }
        if (count == 2 && (this.words[1] & 0x8000) != 0) {
            if (this.negative && this.words[1] == Short.MIN_VALUE && this.words[0] == 0) {
                return Integer.MIN_VALUE;
            }
            throw new ArithmeticException();
        }
        return this.ToInt32Unchecked();
    }

    public int ToInt32Unchecked() {
        int c = this.wordCount;
        if (c == 0) {
            return 0;
        }
        int intRetValue = this.words[0] & 0xFFFF;
        if (c > 1) {
            intRetValue |= (this.words[1] & 0xFFFF) << 16;
        }
        if (this.negative) {
            --intRetValue;
            intRetValue ^= 0xFFFFFFFF;
        }
        return intRetValue;
    }

    public long ToInt64Checked() {
        int count = this.wordCount;
        if (count == 0) {
            return 0L;
        }
        if (count > 4) {
            throw new ArithmeticException();
        }
        if (count == 4 && (this.words[3] & 0x8000) != 0) {
            if (this.negative && this.words[3] == Short.MIN_VALUE && this.words[2] == 0 && this.words[1] == 0 && this.words[0] == 0) {
                return Long.MIN_VALUE;
            }
            throw new ArithmeticException();
        }
        return this.ToInt64Unchecked();
    }

    public long ToInt64Unchecked() {
        int c = this.wordCount;
        if (c == 0) {
            return 0L;
        }
        long ivv = 0L;
        int intRetValue = this.words[0] & 0xFFFF;
        if (c > 1) {
            intRetValue |= (this.words[1] & 0xFFFF) << 16;
        }
        if (c > 2) {
            int intRetValue2 = this.words[2] & 0xFFFF;
            if (c > 3) {
                intRetValue2 |= (this.words[3] & 0xFFFF) << 16;
            }
            if (this.negative) {
                if (intRetValue == 0) {
                    --intRetValue;
                    --intRetValue2;
                } else {
                    --intRetValue;
                }
                intRetValue ^= 0xFFFFFFFF;
                intRetValue2 ^= 0xFFFFFFFF;
            }
            ivv = (long)intRetValue & 0xFFFFFFFFL;
            return ivv |= (long)intRetValue2 << 32;
        }
        ivv = (long)intRetValue & 0xFFFFFFFFL;
        if (this.negative) {
            ivv = -ivv;
        }
        return ivv;
    }

    private void ToRadixStringGeneral(StringBuilder outputSB, int radix) {
        int numWordCount;
        int i = 0;
        if (this.wordCount >= 100) {
            StringBuilder rightBuilder = new StringBuilder();
            long digits = (long)estimatedHalfDigitCountPerWord[radix] * (long)this.wordCount / 16L;
            EInteger pow = null;
            pow = radix == 10 ? NumberUtility.FindPowerOfTen(digits) : (radix == 5 ? NumberUtility.FindPowerOfFiveFromBig(EInteger.FromInt64(digits)) : EInteger.FromInt32(radix).Pow(EInteger.FromInt64(digits)));
            EInteger[] divrem = this.DivRem(pow);
            divrem[0].ToRadixStringGeneral(outputSB, radix);
            divrem[1].ToRadixStringGeneral(rightBuilder, radix);
            i = rightBuilder.length();
            while ((long)i < digits) {
                outputSB.append('0');
                ++i;
            }
            outputSB.append(rightBuilder.toString());
            return;
        }
        if (radix == 10) {
            int numWordCount2;
            if (this.CanFitInInt64()) {
                outputSB.append(FastInteger.LongToString(this.ToInt64Unchecked()));
                return;
            }
            short[] tempReg = new short[this.wordCount];
            System.arraycopy(this.words, 0, tempReg, 0, tempReg.length);
            for (numWordCount2 = tempReg.length; numWordCount2 != 0 && tempReg[numWordCount2 - 1] == 0; --numWordCount2) {
            }
            char[] s = new char[(numWordCount2 << 4) + 1];
            while (numWordCount2 != 0) {
                int newrest;
                int rest;
                if (numWordCount2 == 1 && tempReg[0] > 0 && tempReg[0] <= Short.MAX_VALUE) {
                    rest = tempReg[0];
                    while (rest != 0) {
                        newrest = rest * 26215 >> 18;
                        s[i++] = Digits.charAt(rest - newrest * 10);
                        rest = newrest;
                    }
                    break;
                }
                if (numWordCount2 == 2 && tempReg[1] > 0 && tempReg[1] <= Short.MAX_VALUE) {
                    rest = tempReg[0] & 0xFFFF;
                    rest |= (tempReg[1] & 0xFFFF) << 16;
                    while (rest != 0) {
                        newrest = rest < 81920 ? rest * 52429 >> 19 & 0x1FFF : rest / 10;
                        s[i++] = Digits.charAt(rest - newrest * 10);
                        rest = newrest;
                    }
                    break;
                }
                int wci = numWordCount2;
                int remainderShort = 0;
                while (wci-- > 0) {
                    int currentDividend = tempReg[wci] & 0xFFFF | remainderShort << 16;
                    int quo = currentDividend / 10000;
                    tempReg[wci] = (short)quo;
                    int rem = currentDividend - 10000 * quo;
                    remainderShort = (short)rem;
                }
                int remainderSmall = remainderShort;
                while (numWordCount2 != 0 && tempReg[numWordCount2 - 1] == 0) {
                    --numWordCount2;
                }
                int newrest2 = remainderSmall * 3277 >> 15;
                s[i++] = Digits.charAt(remainderSmall - newrest2 * 10);
                remainderSmall = newrest2;
                newrest2 = remainderSmall * 3277 >> 15;
                s[i++] = Digits.charAt(remainderSmall - newrest2 * 10);
                remainderSmall = newrest2;
                newrest2 = remainderSmall * 3277 >> 15;
                s[i++] = Digits.charAt(remainderSmall - newrest2 * 10);
                remainderSmall = newrest2;
                s[i++] = Digits.charAt(remainderSmall);
            }
            EInteger.ReverseChars(s, 0, i);
            outputSB.append(s, 0, i);
            return;
        }
        short[] tempReg = new short[this.wordCount];
        System.arraycopy(this.words, 0, tempReg, 0, tempReg.length);
        for (numWordCount = tempReg.length; numWordCount != 0 && tempReg[numWordCount - 1] == 0; --numWordCount) {
        }
        i = 0;
        char[] s = new char[(numWordCount << 4) + 1];
        while (numWordCount != 0) {
            int newrest;
            int rest;
            if (numWordCount == 1 && tempReg[0] > 0 && tempReg[0] <= Short.MAX_VALUE) {
                rest = tempReg[0];
                while (rest != 0) {
                    newrest = rest / radix;
                    s[i++] = Digits.charAt(rest - newrest * radix);
                    rest = newrest;
                }
                break;
            }
            if (numWordCount == 2 && tempReg[1] > 0 && tempReg[1] <= Short.MAX_VALUE) {
                rest = tempReg[0] & 0xFFFF;
                rest |= (tempReg[1] & 0xFFFF) << 16;
                while (rest != 0) {
                    newrest = rest / radix;
                    s[i++] = Digits.charAt(rest - newrest * radix);
                    rest = newrest;
                }
                break;
            }
            int wci = numWordCount;
            int remainderShort = 0;
            while (wci-- > 0) {
                int currentDividend = tempReg[wci] & 0xFFFF | remainderShort << 16;
                int quo = currentDividend / radix;
                tempReg[wci] = (short)quo;
                int rem = currentDividend - radix * quo;
                remainderShort = (short)rem;
            }
            int remainderSmall = remainderShort;
            while (numWordCount != 0 && tempReg[numWordCount - 1] == 0) {
                --numWordCount;
            }
            s[i++] = Digits.charAt(remainderSmall);
        }
        EInteger.ReverseChars(s, 0, i);
        outputSB.append(s, 0, i);
    }

    public String ToRadixString(int radix) {
        if (radix < 2) {
            throw new IllegalArgumentException("radix(" + radix + ") is less than 2");
        }
        if (radix > 36) {
            throw new IllegalArgumentException("radix(" + radix + ") is more than 36");
        }
        if (this.wordCount == 0) {
            return "0";
        }
        if (radix == 10) {
            if (this.CanFitInInt64()) {
                return FastInteger.LongToString(this.ToInt64Unchecked());
            }
            StringBuilder sb = new StringBuilder();
            if (this.negative) {
                sb.append('-');
            }
            this.Abs().ToRadixStringGeneral(sb, radix);
            return sb.toString();
        }
        if (radix == 16) {
            StringBuilder sb = new StringBuilder();
            if (this.negative) {
                sb.append('-');
            }
            boolean firstBit = true;
            int word = this.words[this.wordCount - 1];
            for (int i = 0; i < 4; ++i) {
                if (!firstBit || (word & 0xF000) != 0) {
                    sb.append(Digits.charAt(word >> 12 & 0xF));
                    firstBit = false;
                }
                word <<= 4;
            }
            for (int j = this.wordCount - 2; j >= 0; --j) {
                word = this.words[j];
                for (int i = 0; i < 4; ++i) {
                    sb.append(Digits.charAt(word >> 12 & 0xF));
                    word <<= 4;
                }
            }
            return sb.toString();
        }
        if (radix == 2) {
            StringBuilder sb = new StringBuilder();
            if (this.negative) {
                sb.append('-');
            }
            boolean firstBit = true;
            int word = this.words[this.wordCount - 1];
            for (int i = 0; i < 16; ++i) {
                if (!firstBit || (word & 0x8000) != 0) {
                    sb.append((word & 0x8000) == 0 ? (char)'0' : '1');
                    firstBit = false;
                }
                word <<= 1;
            }
            for (int j = this.wordCount - 2; j >= 0; --j) {
                word = this.words[j];
                for (int i = 0; i < 16; ++i) {
                    sb.append((word & 0x8000) == 0 ? (char)'0' : '1');
                    word <<= 1;
                }
            }
            return sb.toString();
        }
        StringBuilder sb = new StringBuilder();
        if (this.negative) {
            sb.append('-');
        }
        this.Abs().ToRadixStringGeneral(sb, radix);
        return sb.toString();
    }

    public String toString() {
        if (this.isZero()) {
            return "0";
        }
        return this.CanFitInInt64() ? FastInteger.LongToString(this.ToInt64Unchecked()) : this.ToRadixString(10);
    }

    private static int AddInternal(short[] c, int cstart, short[] words1, int astart, short[] words2, int bstart, int n) {
        int u = 0;
        boolean evn = (n & 1) == 0;
        int valueNEven = evn ? n : n - 1;
        for (int i = 0; i < valueNEven; ++i) {
            u = (words1[astart + i] & 0xFFFF) + (words2[bstart + i] & 0xFFFF) + (u >> 16);
            c[cstart + i] = (short)u;
            u = (words1[astart + ++i] & 0xFFFF) + (words2[bstart + i] & 0xFFFF) + (u >> 16);
            c[cstart + i] = (short)u;
        }
        if (!evn) {
            u = (words1[astart + valueNEven] & 0xFFFF) + (words2[bstart + valueNEven] & 0xFFFF) + (u >> 16);
            c[cstart + valueNEven] = (short)u;
        }
        return u >> 16;
    }

    private static int AddUnevenSize(short[] c, int cstart, short[] wordsBigger, int astart, int acount, short[] wordsSmaller, int bstart, int bcount) {
        int i;
        int u = 0;
        for (i = 0; i < bcount; ++i) {
            u = (wordsBigger[astart + i] & 0xFFFF) + (wordsSmaller[bstart + i] & 0xFFFF) + (short)(u >> 16);
            c[cstart + i] = (short)u;
        }
        for (i = bcount; i < acount; ++i) {
            u = (wordsBigger[astart + i] & 0xFFFF) + (short)(u >> 16);
            c[cstart + i] = (short)u;
        }
        return u >> 16 & 0xFFFF;
    }

    private static void AsymmetricMultiply(short[] resultArr, int resultStart, short[] tempArr, int tempStart, short[] words1, int words1Start, int words1Count, short[] words2, int words2Start, int words2Count) {
        if (words1Count == words2Count) {
            if (words1Start == words2Start && words1 == words2) {
                EInteger.RecursiveSquare(resultArr, resultStart, tempArr, tempStart, words1, words1Start, words1Count);
            } else if (words1Count == 2) {
                EInteger.BaselineMultiply2(resultArr, resultStart, words1, words1Start, words2, words2Start);
            } else {
                EInteger.SameSizeMultiply(resultArr, resultStart, tempArr, tempStart, words1, words1Start, words2, words2Start, words1Count);
            }
            return;
        }
        if (words1Count > words2Count) {
            short[] tmp1 = words1;
            words1 = words2;
            words2 = tmp1;
            int tmp3 = words1Start;
            words1Start = words2Start;
            words2Start = tmp3;
            int tmp2 = words1Count;
            words1Count = words2Count;
            words2Count = tmp2;
        }
        if (words1Count == 1 || words1Count == 2 && words1[words1Start + 1] == 0) {
            switch (words1[words1Start]) {
                case 0: {
                    Arrays.fill(resultArr, resultStart, resultStart + (words2Count + 2), (short)0);
                    return;
                }
                case 1: {
                    System.arraycopy(words2, words2Start, resultArr, resultStart, words2Count);
                    resultArr[resultStart + words2Count] = 0;
                    resultArr[resultStart + words2Count + 1] = 0;
                    return;
                }
            }
            resultArr[resultStart + words2Count] = EInteger.LinearMultiply(resultArr, resultStart, words2, words2Start, words1[words1Start], words2Count);
            resultArr[resultStart + words2Count + 1] = 0;
            return;
        }
        if (words1Count == 2 && (words2Count & 1) == 0) {
            int a0 = words1[words1Start] & 0xFFFF;
            int a1 = words1[words1Start + 1] & 0xFFFF;
            resultArr[resultStart + words2Count] = 0;
            resultArr[resultStart + words2Count + 1] = 0;
            EInteger.AtomicMultiplyOpt(resultArr, resultStart, a0, a1, words2, words2Start, 0, words2Count);
            EInteger.AtomicMultiplyAddOpt(resultArr, resultStart, a0, a1, words2, words2Start, 2, words2Count);
            return;
        }
        if (words1Count <= 10 && words2Count <= 10) {
            EInteger.SchoolbookMultiply(resultArr, resultStart, words1, words1Start, words1Count, words2, words2Start, words2Count);
        } else if (words1Count >= 400 && words2Count >= 400) {
            EInteger.Toom4(resultArr, resultStart, words1, words1Start, words1Count, words2, words2Start, words2Count);
        } else if (words1Count >= 100 && words2Count >= 100) {
            EInteger.Toom3(resultArr, resultStart, words1, words1Start, words1Count, words2, words2Start, words2Count);
        } else {
            int wordsRem = words2Count % words1Count;
            int evenmult = words2Count / words1Count & 1;
            if (wordsRem == 0) {
                int i;
                if (evenmult == 0) {
                    EInteger.SameSizeMultiply(resultArr, resultStart, tempArr, tempStart, words1, words1Start, words2, words2Start, words1Count);
                    System.arraycopy(resultArr, resultStart + words1Count, tempArr, tempStart + (words1Count << 1), words1Count);
                    for (i = words1Count << 1; i < words2Count; i += words1Count << 1) {
                        EInteger.SameSizeMultiply(tempArr, tempStart + words1Count + i, tempArr, tempStart, words1, words1Start, words2, words2Start + i, words1Count);
                    }
                    for (i = words1Count; i < words2Count; i += words1Count << 1) {
                        EInteger.SameSizeMultiply(resultArr, resultStart + i, tempArr, tempStart, words1, words1Start, words2, words2Start + i, words1Count);
                    }
                } else {
                    for (i = 0; i < words2Count; i += words1Count << 1) {
                        EInteger.SameSizeMultiply(resultArr, resultStart + i, tempArr, tempStart, words1, words1Start, words2, words2Start + i, words1Count);
                    }
                    for (i = words1Count; i < words2Count; i += words1Count << 1) {
                        EInteger.SameSizeMultiply(tempArr, tempStart + words1Count + i, tempArr, tempStart, words1, words1Start, words2, words2Start + i, words1Count);
                    }
                }
                if (EInteger.AddInternal(resultArr, resultStart + words1Count, resultArr, resultStart + words1Count, tempArr, tempStart + (words1Count << 1), words2Count - words1Count) != 0) {
                    EInteger.IncrementWords(resultArr, resultStart + words2Count, words1Count, (short)1);
                }
            } else if (words1Count + words2Count >= words1Count << 2) {
                EInteger.ChunkedLinearMultiply(resultArr, resultStart, tempArr, tempStart, words2, words2Start, words2Count, words1, words1Start, words1Count);
            } else if (words1Count + 1 == words2Count || words1Count + 2 == words2Count && words2[words2Start + words2Count - 1] == 0) {
                short carry;
                Arrays.fill(resultArr, resultStart, resultStart + (words1Count + words2Count), (short)0);
                EInteger.SameSizeMultiply(resultArr, resultStart, tempArr, tempStart, words1, words1Start, words2, words2Start, words1Count);
                resultArr[resultStart + words1Count + words1Count] = carry = EInteger.LinearMultiplyAdd(resultArr, resultStart + words1Count, words1, words1Start, words2[words2Start + words1Count], words1Count);
            } else {
                short[] t2 = new short[words1Count << 2];
                EInteger.ChunkedLinearMultiply(resultArr, resultStart, t2, 0, words2, words2Start, words2Count, words1, words1Start, words1Count);
            }
        }
    }

    private static void AtomicMultiplyAddOpt(short[] c, int valueCstart, int valueA0, int valueA1, short[] words2, int words2Start, int istart, int iend) {
        int first1MinusFirst0 = valueA1 - valueA0 & 0xFFFF;
        if ((valueA1 &= 0xFFFF) >= (valueA0 &= 0xFFFF)) {
            for (int i = istart; i < iend; i += 4) {
                int d;
                short s;
                int b0 = words2[words2Start + i] & 0xFFFF;
                int b1 = words2[words2Start + i + 1] & 0xFFFF;
                int csi = valueCstart + i;
                if (b0 >= b1) {
                    s = 0;
                    d = first1MinusFirst0 * (b0 - b1 & 0xFFFF);
                } else {
                    s = (short)first1MinusFirst0;
                    d = (s & 0xFFFF) * (b0 - b1 & 0xFFFF);
                }
                int valueA0B0 = valueA0 * b0;
                int a0b0high = valueA0B0 >> 16 & 0xFFFF;
                int tempInt = valueA0B0 + (c[csi] & 0xFFFF);
                c[csi] = (short)(tempInt & 0xFFFF);
                int valueA1B1 = valueA1 * b1;
                int a1b1low = valueA1B1 & 0xFFFF;
                int a1b1high = valueA1B1 >> 16 & 0xFFFF;
                tempInt = (tempInt >> 16 & 0xFFFF) + (valueA0B0 & 0xFFFF) + (d & 0xFFFF) + a1b1low + (c[csi + 1] & 0xFFFF);
                c[csi + 1] = (short)(tempInt & 0xFFFF);
                tempInt = (tempInt >> 16 & 0xFFFF) + a1b1low + a0b0high + (d >> 16 & 0xFFFF) + a1b1high - (s & 0xFFFF) + (c[csi + 2] & 0xFFFF);
                c[csi + 2] = (short)(tempInt & 0xFFFF);
                tempInt = (tempInt >> 16 & 0xFFFF) + a1b1high + (c[csi + 3] & 0xFFFF);
                c[csi + 3] = (short)(tempInt & 0xFFFF);
                if (tempInt >> 16 == 0) continue;
                int n = csi + 4;
                c[n] = (short)(c[n] + 1);
                int n2 = csi + 5;
                c[n2] = (short)(c[n2] + (short)(c[csi + 4] == 0 ? 1 : 0));
            }
        } else {
            for (int i = istart; i < iend; i += 4) {
                int d;
                short s;
                int valueB0 = words2[words2Start + i] & 0xFFFF;
                int valueB1 = words2[words2Start + i + 1] & 0xFFFF;
                int csi = valueCstart + i;
                if (valueB0 > valueB1) {
                    s = (short)(valueB0 - valueB1 & 0xFFFF);
                    d = first1MinusFirst0 * (s & 0xFFFF);
                } else {
                    s = 0;
                    d = (valueA0 - valueA1 & 0xFFFF) * (valueB1 - valueB0 & 0xFFFF);
                }
                int valueA0B0 = valueA0 * valueB0;
                int a0b0high = valueA0B0 >> 16 & 0xFFFF;
                int tempInt = valueA0B0 + (c[csi] & 0xFFFF);
                c[csi] = (short)(tempInt & 0xFFFF);
                int valueA1B1 = valueA1 * valueB1;
                int a1b1low = valueA1B1 & 0xFFFF;
                int a1b1high = valueA1B1 >> 16 & 0xFFFF;
                tempInt = (tempInt >> 16 & 0xFFFF) + (valueA0B0 & 0xFFFF) + (d & 0xFFFF) + a1b1low + (c[csi + 1] & 0xFFFF);
                c[csi + 1] = (short)(tempInt & 0xFFFF);
                tempInt = (tempInt >> 16 & 0xFFFF) + a1b1low + a0b0high + (d >> 16 & 0xFFFF) + a1b1high - (s & 0xFFFF) + (c[csi + 2] & 0xFFFF);
                c[csi + 2] = (short)(tempInt & 0xFFFF);
                tempInt = (tempInt >> 16 & 0xFFFF) + a1b1high + (c[csi + 3] & 0xFFFF);
                c[csi + 3] = (short)(tempInt & 0xFFFF);
                if (tempInt >> 16 == 0) continue;
                int n = csi + 4;
                c[n] = (short)(c[n] + 1);
                int n3 = csi + 5;
                c[n3] = (short)(c[n3] + (short)(c[csi + 4] == 0 ? 1 : 0));
            }
        }
    }

    private static void AtomicMultiplyOpt(short[] c, int valueCstart, int valueA0, int valueA1, short[] words2, int words2Start, int istart, int iend) {
        int first1MinusFirst0 = valueA1 - valueA0 & 0xFFFF;
        if ((valueA1 &= 0xFFFF) >= (valueA0 &= 0xFFFF)) {
            for (int i = istart; i < iend; i += 4) {
                int d;
                short s;
                int valueB0 = words2[words2Start + i] & 0xFFFF;
                int valueB1 = words2[words2Start + i + 1] & 0xFFFF;
                int csi = valueCstart + i;
                if (valueB0 >= valueB1) {
                    s = 0;
                    d = first1MinusFirst0 * (valueB0 - valueB1 & 0xFFFF);
                } else {
                    s = (short)first1MinusFirst0;
                    d = (s & 0xFFFF) * (valueB0 - valueB1 & 0xFFFF);
                }
                int valueA0B0 = valueA0 * valueB0;
                c[csi] = (short)(valueA0B0 & 0xFFFF);
                int a0b0high = valueA0B0 >> 16 & 0xFFFF;
                int valueA1B1 = valueA1 * valueB1;
                int tempInt = a0b0high + (valueA0B0 & 0xFFFF) + (d & 0xFFFF) + (valueA1B1 & 0xFFFF);
                c[csi + 1] = (short)tempInt;
                tempInt = valueA1B1 + (tempInt >> 16 & 0xFFFF) + a0b0high + (d >> 16 & 0xFFFF) + (valueA1B1 >> 16 & 0xFFFF) - (s & 0xFFFF);
                c[csi + 2] = (short)tempInt;
                c[csi + 3] = (short)(tempInt >>= 16);
            }
        } else {
            for (int i = istart; i < iend; i += 4) {
                int d;
                short s;
                int valueB0 = words2[words2Start + i] & 0xFFFF;
                int valueB1 = words2[words2Start + i + 1] & 0xFFFF;
                int csi = valueCstart + i;
                if (valueB0 > valueB1) {
                    s = (short)(valueB0 - valueB1 & 0xFFFF);
                    d = first1MinusFirst0 * (s & 0xFFFF);
                } else {
                    s = 0;
                    d = (valueA0 - valueA1 & 0xFFFF) * (valueB1 - valueB0 & 0xFFFF);
                }
                int valueA0B0 = valueA0 * valueB0;
                int a0b0high = valueA0B0 >> 16 & 0xFFFF;
                c[csi] = (short)(valueA0B0 & 0xFFFF);
                int valueA1B1 = valueA1 * valueB1;
                int tempInt = a0b0high + (valueA0B0 & 0xFFFF) + (d & 0xFFFF) + (valueA1B1 & 0xFFFF);
                c[csi + 1] = (short)tempInt;
                tempInt = valueA1B1 + (tempInt >> 16 & 0xFFFF) + a0b0high + (d >> 16 & 0xFFFF) + (valueA1B1 >> 16 & 0xFFFF) - (s & 0xFFFF);
                c[csi + 2] = (short)tempInt;
                c[csi + 3] = (short)(tempInt >>= 16);
            }
        }
    }

    private static void BaselineMultiply2(short[] result, int rstart, short[] words1, int astart, short[] words2, int bstart) {
        int a0 = words1[astart] & 0xFFFF;
        int a1 = words1[astart + 1] & 0xFFFF;
        int b0 = words2[bstart] & 0xFFFF;
        int b1 = words2[bstart + 1] & 0xFFFF;
        int p = a0 * b0;
        short c = (short)p;
        int d = p >> 16 & 0xFFFF;
        result[rstart] = c;
        c = (short)d;
        d = d >> 16 & 0xFFFF;
        p = a0 * b1;
        p += c & 0xFFFF;
        c = (short)p;
        d += p >> 16 & 0xFFFF;
        p = a1 * b0;
        d += (p += c & 0xFFFF) >> 16 & 0xFFFF;
        result[rstart + 1] = (short)p;
        p = a1 * b1;
        result[rstart + 2] = (short)(p += d);
        result[rstart + 3] = (short)(p >> 16);
    }

    private static void BaselineMultiply4(short[] result, int rstart, short[] words1, int astart, short[] words2, int bstart) {
        long a0 = (long)words1[astart] & 0xFFFFL;
        a0 |= ((long)words1[astart + 1] & 0xFFFFL) << 16;
        long a1 = (long)words1[astart + 2] & 0xFFFFL;
        a1 |= ((long)words1[astart + 3] & 0xFFFFL) << 16;
        long b0 = (long)words2[bstart] & 0xFFFFL;
        long b1 = (long)words2[bstart + 2] & 0xFFFFL;
        b1 |= ((long)words2[bstart + 3] & 0xFFFFL) << 16;
        long p = a0 * (b0 |= ((long)words2[bstart + 1] & 0xFFFFL) << 16);
        long d = p >> 32 & 0xFFFFFFFFL;
        result[rstart] = (short)p;
        result[rstart + 1] = (short)(p >> 16);
        int c = (int)d;
        d = d >> 32 & 0xFFFFFFFFL;
        p = a0 * b1;
        p += (long)c & 0xFFFFFFFFL;
        c = (int)p;
        d += p >> 32 & 0xFFFFFFFFL;
        p = a1 * b0;
        d += (p += (long)c & 0xFFFFFFFFL) >> 32 & 0xFFFFFFFFL;
        result[rstart + 2] = (short)p;
        result[rstart + 3] = (short)(p >> 16);
        p = a1 * b1;
        result[rstart + 4] = (short)(p += d);
        result[rstart + 5] = (short)(p >> 16);
        result[rstart + 6] = (short)(p >> 32);
        result[rstart + 7] = (short)(p >> 48);
    }

    private static void BaselineMultiply8(short[] result, int rstart, short[] words1, int astart, short[] words2, int bstart) {
        int SMask = 65535;
        int a0 = words1[astart] & SMask;
        int a1 = words1[astart + 1] & SMask;
        int a2 = words1[astart + 2] & SMask;
        int a3 = words1[astart + 3] & SMask;
        int a4 = words1[astart + 4] & SMask;
        int a5 = words1[astart + 5] & SMask;
        int a6 = words1[astart + 6] & SMask;
        int a7 = words1[astart + 7] & SMask;
        int b0 = words2[bstart] & SMask;
        int b1 = words2[bstart + 1] & SMask;
        int b2 = words2[bstart + 2] & SMask;
        int b3 = words2[bstart + 3] & SMask;
        int b4 = words2[bstart + 4] & SMask;
        int b5 = words2[bstart + 5] & SMask;
        int b6 = words2[bstart + 6] & SMask;
        int b7 = words2[bstart + 7] & SMask;
        int p = a0 * b0;
        short c = (short)p;
        int d = p >> 16 & SMask;
        result[rstart] = c;
        c = (short)d;
        d = d >> 16 & SMask;
        p = a0 * b1;
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        p = a1 * b0;
        p += c & SMask;
        c = (short)p;
        result[rstart + 1] = c;
        c = (short)(d += p >> 16 & SMask);
        d = d >> 16 & SMask;
        p = a0 * b2;
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        p = a1 * b1;
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        p = a2 * b0;
        p += c & SMask;
        c = (short)p;
        result[rstart + 2] = c;
        c = (short)(d += p >> 16 & SMask);
        d = d >> 16 & SMask;
        p = a0 * b3;
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        p = a1 * b2;
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        p = a2 * b1;
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        p = a3 * b0;
        p += c & SMask;
        c = (short)p;
        result[rstart + 3] = c;
        c = (short)(d += p >> 16 & SMask);
        d = d >> 16 & SMask;
        p = a0 * b4;
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        p = a1 * b3;
        d += (p += c & SMask) >> 16 & SMask;
        p = a2 * b2 + (p & 0xFFFF);
        d += p >> 16 & SMask;
        p = a3 * b1 + (p & 0xFFFF);
        d += p >> 16 & SMask;
        p = a4 * b0 + (p & 0xFFFF);
        result[rstart + 4] = (short)p;
        c = (short)(d += p >> 16 & SMask);
        d = d >> 16 & SMask;
        p = a0 * b5;
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        p = a1 * b4;
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        p = a2 * b3;
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        p = a3 * b2;
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        p = a4 * b1;
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        p = a5 * b0;
        p += c & SMask;
        c = (short)p;
        result[rstart + 5] = c;
        c = (short)(d += p >> 16 & SMask);
        d = d >> 16 & SMask;
        p = a0 * b6;
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        p = a1 * b5;
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        p = a2 * b4;
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        p = a3 * b3;
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        p = a4 * b2;
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        p = a5 * b1;
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        p = a6 * b0;
        p += c & SMask;
        c = (short)p;
        result[rstart + 6] = c;
        c = (short)(d += p >> 16 & SMask);
        d = d >> 16 & SMask;
        p = a0 * b7;
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        p = a1 * b6;
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        p = a2 * b5;
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        p = a3 * b4;
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        p = a4 * b3;
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        p = a5 * b2;
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        p = a6 * b1;
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        p = a7 * b0;
        p += c & SMask;
        c = (short)p;
        result[rstart + 7] = c;
        c = (short)(d += p >> 16 & SMask);
        d = d >> 16 & SMask;
        p = a1 * b7;
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        p = a2 * b6;
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        p = a3 * b5;
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        p = a4 * b4;
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        p = a5 * b3;
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        p = a6 * b2;
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        p = a7 * b1;
        p += c & SMask;
        c = (short)p;
        result[rstart + 8] = c;
        c = (short)(d += p >> 16 & SMask);
        d = d >> 16 & SMask;
        p = a2 * b7;
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        p = a3 * b6;
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        p = a4 * b5;
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        p = a5 * b4;
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        p = a6 * b3;
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        p = a7 * b2;
        p += c & SMask;
        c = (short)p;
        result[rstart + 9] = c;
        c = (short)(d += p >> 16 & SMask);
        d = d >> 16 & SMask;
        p = a3 * b7;
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        p = a4 * b6;
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        p = a5 * b5;
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        p = a6 * b4;
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        p = a7 * b3;
        p += c & SMask;
        c = (short)p;
        result[rstart + 10] = c;
        c = (short)(d += p >> 16 & SMask);
        d = d >> 16 & SMask;
        p = a4 * b7;
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        p = a5 * b6;
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        p = a6 * b5;
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        p = a7 * b4;
        p += c & SMask;
        c = (short)p;
        result[rstart + 11] = c;
        c = (short)(d += p >> 16 & SMask);
        d = d >> 16 & SMask;
        p = a5 * b7;
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        p = a6 * b6;
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        p = a7 * b5;
        p += c & SMask;
        c = (short)p;
        result[rstart + 12] = c;
        c = (short)(d += p >> 16 & SMask);
        d = d >> 16 & SMask;
        p = a6 * b7;
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        p = a7 * b6;
        p += c & SMask;
        c = (short)p;
        d += p >> 16 & SMask;
        result[rstart + 13] = c;
        p = a7 * b7;
        result[rstart + 14] = (short)(p += d);
        result[rstart + 15] = (short)(p >> 16);
    }

    private static void BaselineSquare2(short[] result, int rstart, short[] words1, int astart) {
        int p = (words1[astart] & 0xFFFF) * (words1[astart] & 0xFFFF);
        result[rstart] = (short)p;
        int e = p >> 16 & 0xFFFF;
        p = (words1[astart] & 0xFFFF) * (words1[astart + 1] & 0xFFFF);
        short c = (short)p;
        int d = p >> 16 & 0xFFFF;
        d = (d << 1) + (c >> 15 & 1);
        c = (short)(c << 1);
        e += c & 0xFFFF;
        c = (short)e;
        e = d + (e >> 16 & 0xFFFF);
        result[rstart + 1] = c;
        p = (words1[astart + 1] & 0xFFFF) * (words1[astart + 1] & 0xFFFF);
        result[rstart + 2] = (short)(p += e);
        result[rstart + 3] = (short)(p >> 16);
    }

    private static void BaselineSquare4(short[] result, int rstart, short[] words1, int astart) {
        int p = (words1[astart] & 0xFFFF) * (words1[astart] & 0xFFFF);
        result[rstart] = (short)p;
        int e = p >> 16 & 0xFFFF;
        p = (words1[astart] & 0xFFFF) * (words1[astart + 1] & 0xFFFF);
        short c = (short)p;
        int d = p >> 16 & 0xFFFF;
        d = (d << 1) + (c >> 15 & 1);
        c = (short)(c << 1);
        e += c & 0xFFFF;
        c = (short)e;
        e = d + (e >> 16 & 0xFFFF);
        result[rstart + 1] = c;
        p = (words1[astart] & 0xFFFF) * (words1[astart + 2] & 0xFFFF);
        c = (short)p;
        d = p >> 16 & 0xFFFF;
        d = (d << 1) + (c >> 15 & 1);
        c = (short)(c << 1);
        p = (words1[astart + 1] & 0xFFFF) * (words1[astart + 1] & 0xFFFF);
        p += c & 0xFFFF;
        c = (short)p;
        e += c & 0xFFFF;
        c = (short)e;
        e = (d += p >> 16 & 0xFFFF) + (e >> 16 & 0xFFFF);
        result[rstart + 2] = c;
        p = (words1[astart] & 0xFFFF) * (words1[astart + 3] & 0xFFFF);
        c = (short)p;
        d = p >> 16 & 0xFFFF;
        p = (words1[astart + 1] & 0xFFFF) * (words1[astart + 2] & 0xFFFF);
        p += c & 0xFFFF;
        c = (short)p;
        d += p >> 16 & 0xFFFF;
        d = (d << 1) + (c >> 15 & 1);
        c = (short)(c << 1);
        e += c & 0xFFFF;
        c = (short)e;
        e = d + (e >> 16 & 0xFFFF);
        result[rstart + 3] = c;
        p = (words1[astart + 1] & 0xFFFF) * (words1[astart + 3] & 0xFFFF);
        c = (short)p;
        d = p >> 16 & 0xFFFF;
        d = (d << 1) + (c >> 15 & 1);
        c = (short)(c << 1);
        p = (words1[astart + 2] & 0xFFFF) * (words1[astart + 2] & 0xFFFF);
        p += c & 0xFFFF;
        c = (short)p;
        e += c & 0xFFFF;
        c = (short)e;
        e = (d += p >> 16 & 0xFFFF) + (e >> 16 & 0xFFFF);
        result[rstart + 4] = c;
        p = (words1[astart + 2] & 0xFFFF) * (words1[astart + 3] & 0xFFFF);
        c = (short)p;
        d = p >> 16 & 0xFFFF;
        d = (d << 1) + (c >> 15 & 1);
        c = (short)(c << 1);
        e += c & 0xFFFF;
        c = (short)e;
        e = d + (e >> 16 & 0xFFFF);
        result[rstart + 8 - 3] = c;
        p = (words1[astart + 3] & 0xFFFF) * (words1[astart + 3] & 0xFFFF);
        result[rstart + 6] = (short)(p += e);
        result[rstart + 7] = (short)(p >> 16);
    }

    private static void BaselineSquare8(short[] result, int rstart, short[] words1, int astart) {
        int p = (words1[astart] & 0xFFFF) * (words1[astart] & 0xFFFF);
        result[rstart] = (short)p;
        int e = p >> 16 & 0xFFFF;
        p = (words1[astart] & 0xFFFF) * (words1[astart + 1] & 0xFFFF);
        short c = (short)p;
        int d = p >> 16 & 0xFFFF;
        d = (d << 1) + (c >> 15 & 1);
        c = (short)(c << 1);
        e += c & 0xFFFF;
        c = (short)e;
        e = d + (e >> 16 & 0xFFFF);
        result[rstart + 1] = c;
        p = (words1[astart] & 0xFFFF) * (words1[astart + 2] & 0xFFFF);
        c = (short)p;
        d = p >> 16 & 0xFFFF;
        d = (d << 1) + (c >> 15 & 1);
        c = (short)(c << 1);
        p = (words1[astart + 1] & 0xFFFF) * (words1[astart + 1] & 0xFFFF);
        p += c & 0xFFFF;
        c = (short)p;
        e += c & 0xFFFF;
        c = (short)e;
        e = (d += p >> 16 & 0xFFFF) + (e >> 16 & 0xFFFF);
        result[rstart + 2] = c;
        p = (words1[astart] & 0xFFFF) * (words1[astart + 3] & 0xFFFF);
        c = (short)p;
        d = p >> 16 & 0xFFFF;
        p = (words1[astart + 1] & 0xFFFF) * (words1[astart + 2] & 0xFFFF);
        p += c & 0xFFFF;
        c = (short)p;
        d += p >> 16 & 0xFFFF;
        d = (d << 1) + (c >> 15 & 1);
        c = (short)(c << 1);
        e += c & 0xFFFF;
        c = (short)e;
        e = d + (e >> 16 & 0xFFFF);
        result[rstart + 3] = c;
        p = (words1[astart] & 0xFFFF) * (words1[astart + 4] & 0xFFFF);
        c = (short)p;
        d = p >> 16 & 0xFFFF;
        p = (words1[astart + 1] & 0xFFFF) * (words1[astart + 3] & 0xFFFF);
        p += c & 0xFFFF;
        c = (short)p;
        d += p >> 16 & 0xFFFF;
        d = (d << 1) + (c >> 15 & 1);
        c = (short)(c << 1);
        p = (words1[astart + 2] & 0xFFFF) * (words1[astart + 2] & 0xFFFF);
        p += c & 0xFFFF;
        c = (short)p;
        e += c & 0xFFFF;
        c = (short)e;
        e = (d += p >> 16 & 0xFFFF) + (e >> 16 & 0xFFFF);
        result[rstart + 4] = c;
        p = (words1[astart] & 0xFFFF) * (words1[astart + 5] & 0xFFFF);
        c = (short)p;
        d = p >> 16 & 0xFFFF;
        p = (words1[astart + 1] & 0xFFFF) * (words1[astart + 4] & 0xFFFF);
        p += c & 0xFFFF;
        c = (short)p;
        d += p >> 16 & 0xFFFF;
        p = (words1[astart + 2] & 0xFFFF) * (words1[astart + 3] & 0xFFFF);
        p += c & 0xFFFF;
        c = (short)p;
        d += p >> 16 & 0xFFFF;
        d = (d << 1) + (c >> 15 & 1);
        c = (short)(c << 1);
        e += c & 0xFFFF;
        c = (short)e;
        e = d + (e >> 16 & 0xFFFF);
        result[rstart + 5] = c;
        p = (words1[astart] & 0xFFFF) * (words1[astart + 6] & 0xFFFF);
        c = (short)p;
        d = p >> 16 & 0xFFFF;
        p = (words1[astart + 1] & 0xFFFF) * (words1[astart + 5] & 0xFFFF);
        p += c & 0xFFFF;
        c = (short)p;
        d += p >> 16 & 0xFFFF;
        p = (words1[astart + 2] & 0xFFFF) * (words1[astart + 4] & 0xFFFF);
        p += c & 0xFFFF;
        c = (short)p;
        d += p >> 16 & 0xFFFF;
        d = (d << 1) + (c >> 15 & 1);
        c = (short)(c << 1);
        p = (words1[astart + 3] & 0xFFFF) * (words1[astart + 3] & 0xFFFF);
        p += c & 0xFFFF;
        c = (short)p;
        e += c & 0xFFFF;
        c = (short)e;
        e = (d += p >> 16 & 0xFFFF) + (e >> 16 & 0xFFFF);
        result[rstart + 6] = c;
        p = (words1[astart] & 0xFFFF) * (words1[astart + 7] & 0xFFFF);
        c = (short)p;
        d = p >> 16 & 0xFFFF;
        p = (words1[astart + 1] & 0xFFFF) * (words1[astart + 6] & 0xFFFF);
        p += c & 0xFFFF;
        c = (short)p;
        d += p >> 16 & 0xFFFF;
        p = (words1[astart + 2] & 0xFFFF) * (words1[astart + 5] & 0xFFFF);
        p += c & 0xFFFF;
        c = (short)p;
        d += p >> 16 & 0xFFFF;
        p = (words1[astart + 3] & 0xFFFF) * (words1[astart + 4] & 0xFFFF);
        p += c & 0xFFFF;
        c = (short)p;
        d += p >> 16 & 0xFFFF;
        d = (d << 1) + (c >> 15 & 1);
        c = (short)(c << 1);
        e += c & 0xFFFF;
        c = (short)e;
        e = d + (e >> 16 & 0xFFFF);
        result[rstart + 7] = c;
        p = (words1[astart + 1] & 0xFFFF) * (words1[astart + 7] & 0xFFFF);
        c = (short)p;
        d = p >> 16 & 0xFFFF;
        p = (words1[astart + 2] & 0xFFFF) * (words1[astart + 6] & 0xFFFF);
        p += c & 0xFFFF;
        c = (short)p;
        d += p >> 16 & 0xFFFF;
        p = (words1[astart + 3] & 0xFFFF) * (words1[astart + 5] & 0xFFFF);
        p += c & 0xFFFF;
        c = (short)p;
        d += p >> 16 & 0xFFFF;
        d = (d << 1) + (c >> 15 & 1);
        c = (short)(c << 1);
        p = (words1[astart + 4] & 0xFFFF) * (words1[astart + 4] & 0xFFFF);
        p += c & 0xFFFF;
        c = (short)p;
        e += c & 0xFFFF;
        c = (short)e;
        e = (d += p >> 16 & 0xFFFF) + (e >> 16 & 0xFFFF);
        result[rstart + 8] = c;
        p = (words1[astart + 2] & 0xFFFF) * (words1[astart + 7] & 0xFFFF);
        c = (short)p;
        d = p >> 16 & 0xFFFF;
        p = (words1[astart + 3] & 0xFFFF) * (words1[astart + 6] & 0xFFFF);
        p += c & 0xFFFF;
        c = (short)p;
        d += p >> 16 & 0xFFFF;
        p = (words1[astart + 4] & 0xFFFF) * (words1[astart + 5] & 0xFFFF);
        p += c & 0xFFFF;
        c = (short)p;
        d += p >> 16 & 0xFFFF;
        d = (d << 1) + (c >> 15 & 1);
        c = (short)(c << 1);
        e += c & 0xFFFF;
        c = (short)e;
        e = d + (e >> 16 & 0xFFFF);
        result[rstart + 9] = c;
        p = (words1[astart + 3] & 0xFFFF) * (words1[astart + 7] & 0xFFFF);
        c = (short)p;
        d = p >> 16 & 0xFFFF;
        p = (words1[astart + 4] & 0xFFFF) * (words1[astart + 6] & 0xFFFF);
        p += c & 0xFFFF;
        c = (short)p;
        d += p >> 16 & 0xFFFF;
        d = (d << 1) + (c >> 15 & 1);
        c = (short)(c << 1);
        p = (words1[astart + 5] & 0xFFFF) * (words1[astart + 5] & 0xFFFF);
        p += c & 0xFFFF;
        c = (short)p;
        e += c & 0xFFFF;
        c = (short)e;
        e = (d += p >> 16 & 0xFFFF) + (e >> 16 & 0xFFFF);
        result[rstart + 10] = c;
        p = (words1[astart + 4] & 0xFFFF) * (words1[astart + 7] & 0xFFFF);
        c = (short)p;
        d = p >> 16 & 0xFFFF;
        p = (words1[astart + 5] & 0xFFFF) * (words1[astart + 6] & 0xFFFF);
        p += c & 0xFFFF;
        c = (short)p;
        d += p >> 16 & 0xFFFF;
        d = (d << 1) + (c >> 15 & 1);
        c = (short)(c << 1);
        e += c & 0xFFFF;
        c = (short)e;
        e = d + (e >> 16 & 0xFFFF);
        result[rstart + 11] = c;
        p = (words1[astart + 5] & 0xFFFF) * (words1[astart + 7] & 0xFFFF);
        c = (short)p;
        d = p >> 16 & 0xFFFF;
        d = (d << 1) + (c >> 15 & 1);
        c = (short)(c << 1);
        p = (words1[astart + 6] & 0xFFFF) * (words1[astart + 6] & 0xFFFF);
        p += c & 0xFFFF;
        c = (short)p;
        e += c & 0xFFFF;
        c = (short)e;
        e = (d += p >> 16 & 0xFFFF) + (e >> 16 & 0xFFFF);
        result[rstart + 12] = c;
        p = (words1[astart + 6] & 0xFFFF) * (words1[astart + 7] & 0xFFFF);
        c = (short)p;
        d = p >> 16 & 0xFFFF;
        d = (d << 1) + (c >> 15 & 1);
        c = (short)(c << 1);
        e += c & 0xFFFF;
        c = (short)e;
        e = d + (e >> 16 & 0xFFFF);
        result[rstart + 13] = c;
        p = (words1[astart + 7] & 0xFFFF) * (words1[astart + 7] & 0xFFFF);
        result[rstart + 14] = (short)(p += e);
        result[rstart + 15] = (short)(p >> 16);
    }

    private static int BitPrecision(short numberValue) {
        if (numberValue == 0) {
            return 0;
        }
        int i = 16;
        if (numberValue >> 8 == 0) {
            numberValue = (short)(numberValue << 8);
            i -= 8;
        }
        if (numberValue >> 12 == 0) {
            numberValue = (short)(numberValue << 4);
            i -= 4;
        }
        if (numberValue >> 14 == 0) {
            numberValue = (short)(numberValue << 2);
            i -= 2;
        }
        if (numberValue >> 15 == 0) {
            --i;
        }
        return i;
    }

    private static int BitsToWords(int bitCount) {
        return bitCount + 15 >> 4;
    }

    private static void ChunkedLinearMultiply(short[] productArr, int cstart, short[] tempArr, int tempStart, short[] words1, int astart, int acount, short[] words2, int bstart, int bcount) {
        int carryPos = 0;
        Arrays.fill(productArr, cstart, cstart + bcount, (short)0);
        for (int i = 0; i < acount; i += bcount) {
            int diff = acount - i;
            if (diff > bcount) {
                EInteger.SameSizeMultiply(tempArr, tempStart, tempArr, tempStart + bcount + bcount, words1, astart + i, words2, bstart, bcount);
                EInteger.AddUnevenSize(tempArr, tempStart, tempArr, tempStart, bcount + bcount, productArr, cstart + carryPos, bcount);
                System.arraycopy(tempArr, tempStart, productArr, cstart + i, bcount + bcount);
                carryPos += bcount;
                continue;
            }
            EInteger.AsymmetricMultiply(tempArr, tempStart, tempArr, tempStart + diff + bcount, words1, astart + i, diff, words2, bstart, bcount);
            EInteger.AddUnevenSize(tempArr, tempStart, tempArr, tempStart, diff + bcount, productArr, cstart + carryPos, bcount);
            System.arraycopy(tempArr, tempStart, productArr, cstart + i, diff + bcount);
        }
    }

    static short[] CleanGrow(short[] a, int size) {
        if (size > a.length) {
            short[] newa = new short[size];
            System.arraycopy(a, 0, newa, 0, a.length);
            return newa;
        }
        return a;
    }

    private static int Compare(short[] words1, int astart, short[] words2, int bstart, int n) {
        while (n-- != 0) {
            int an = words1[astart + n] & 0xFFFF;
            int bn = words2[bstart + n] & 0xFFFF;
            if (an > bn) {
                return 1;
            }
            if (an >= bn) continue;
            return -1;
        }
        return 0;
    }

    private static int CompareWithWords1IsOneBigger(short[] words1, int astart, short[] words2, int bstart, int words1Count) {
        block2: {
            int bn;
            int an;
            if (words1[astart + words1Count - 1] != 0) {
                return 1;
            }
            int w1c = words1Count;
            do {
                int n = --w1c;
                --w1c;
                if (n == 0) break block2;
                an = words1[astart + w1c] & 0xFFFF;
                bn = words2[bstart + w1c] & 0xFFFF;
                if (an <= bn) continue;
                return 1;
            } while (an >= bn);
            return -1;
        }
        return 0;
    }

    static int CountWords(short[] array) {
        int n;
        for (n = array.length; n != 0 && array[n - 1] == 0; --n) {
        }
        return n;
    }

    static int CountWords(short[] array, int pos, int len) {
        int n;
        for (n = len; n != 0 && array[pos + n - 1] == 0; --n) {
        }
        return n;
    }

    private static int DecrementWords(short[] words1, int words1Start, int n, short words2) {
        short tmp = words1[words1Start];
        words1[words1Start] = (short)(tmp - words2);
        if ((words1[words1Start] & 0xFFFF) <= (tmp & 0xFFFF)) {
            return 0;
        }
        for (int i = 1; i < n; ++i) {
            tmp = words1[words1Start + i];
            int n2 = words1Start + i;
            words1[n2] = (short)(words1[n2] - 1);
            if (tmp == 0) continue;
            return 0;
        }
        return 1;
    }

    private static short Divide32By16(int dividendLow, short divisorShort, boolean returnRemainder) {
        int dividendHigh = 0;
        int intDivisor = divisorShort & 0xFFFF;
        for (int i = 0; i < 32; ++i) {
            int tmpInt = dividendHigh >> 31;
            dividendHigh <<= 1;
            if ((tmpInt |= (dividendHigh |= (dividendLow <<= 1) >> 31 & 1)) >> 31 == 0 && tmpInt < intDivisor) continue;
            dividendHigh -= intDivisor;
            ++dividendLow;
        }
        return returnRemainder ? (short)(dividendHigh & 0xFFFF) : (short)(dividendLow & 0xFFFF);
    }

    private static short DivideUnsigned(int x, short y) {
        if (x >> 31 == 0) {
            int iy = y & 0xFFFF;
            return (short)(x / iy);
        }
        long longX = (long)x & 0xFFFFFFFFL;
        int iy = y & 0xFFFF;
        return (short)(longX / (long)iy);
    }

    private static void FastDivide(short[] quotientReg, short[] dividendReg, int count, short divisorSmall) {
        switch (divisorSmall) {
            case 2: {
                EInteger.FastDivideAndRemainderTwo(quotientReg, 0, dividendReg, 0, count);
                break;
            }
            case 10: {
                EInteger.FastDivideAndRemainderTen(quotientReg, 0, dividendReg, 0, count);
                break;
            }
            default: {
                EInteger.FastDivideAndRemainder(quotientReg, 0, dividendReg, 0, count, divisorSmall);
            }
        }
    }

    private static short FastDivideAndRemainderTwo(short[] quotientReg, int quotientStart, short[] dividendReg, int dividendStart, int count) {
        int rem = 0;
        int ds = dividendStart + count - 1;
        int qs = quotientStart + count - 1;
        for (int i = 0; i < count; ++i) {
            int currentDividend = dividendReg[ds] & 0xFFFF;
            int quo = (currentDividend |= rem << 16) >> 1;
            quotientReg[qs] = (short)quo;
            rem = currentDividend & 1;
            --ds;
            --qs;
        }
        return (short)rem;
    }

    private static short FastDivideAndRemainderTen(short[] quotientReg, int quotientStart, short[] dividendReg, int dividendStart, int count) {
        int rem = 0;
        int ds = dividendStart + count - 1;
        int qs = quotientStart + count - 1;
        for (int i = 0; i < count; ++i) {
            int currentDividend = dividendReg[ds] & 0xFFFF;
            int quo = (currentDividend |= rem << 16) >= 81920 ? currentDividend / 10 : currentDividend * 52429 >> 19 & 0x1FFF;
            quotientReg[qs] = (short)quo;
            rem = currentDividend - 10 * quo;
            --ds;
            --qs;
        }
        return (short)rem;
    }

    private static short FastDivideAndRemainder(short[] quotientReg, int quotientStart, short[] dividendReg, int dividendStart, int count, short divisorSmall) {
        int idivisor = divisorSmall & 0xFFFF;
        int rem = 0;
        int ds = dividendStart + count - 1;
        int qs = quotientStart + count - 1;
        if (idivisor < 32768) {
            for (int i = 0; i < count; ++i) {
                int currentDividend = dividendReg[ds] & 0xFFFF;
                int quo = (currentDividend |= rem << 16) / idivisor;
                quotientReg[qs] = (short)quo;
                rem = currentDividend - idivisor * quo;
                --ds;
                --qs;
            }
        } else {
            for (int i = 0; i < count; ++i) {
                int quo;
                int currentDividend = dividendReg[ds] & 0xFFFF;
                if ((currentDividend |= rem << 16) >> 31 == 0) {
                    quo = currentDividend / idivisor;
                    quotientReg[qs] = (short)quo;
                    rem = currentDividend - idivisor * quo;
                } else {
                    quo = EInteger.DivideUnsigned(currentDividend, divisorSmall) & 0xFFFF;
                    quotientReg[qs] = (short)quo;
                    rem = currentDividend - idivisor * quo;
                }
                --ds;
                --qs;
            }
        }
        return (short)rem;
    }

    private static short FastRemainder(short[] dividendReg, int count, short divisorSmall) {
        int i = count;
        short remainder = 0;
        while (i-- > 0) {
            int dividendSmall = dividendReg[i] & 0xFFFF | remainder << 16;
            remainder = EInteger.RemainderUnsigned(dividendSmall, divisorSmall);
        }
        return remainder;
    }

    private static short GetHighHalfAsBorrow(int val) {
        return (short)(0 - (val >> 16 & 0xFFFF));
    }

    private static int GetLowHalf(int val) {
        return val & 0xFFFF;
    }

    private static int GetUnsignedBitLengthEx(int numberValue, int wordCount) {
        int wc = wordCount;
        if (wc != 0) {
            wc = wc - 1 << 4;
            if (numberValue == 0) {
                return wc;
            }
            wc += 16;
            if (numberValue >> 8 == 0) {
                numberValue <<= 8;
                wc -= 8;
            }
            if (numberValue >> 12 == 0) {
                numberValue <<= 4;
                wc -= 4;
            }
            if (numberValue >> 14 == 0) {
                numberValue <<= 2;
                wc -= 2;
            }
            if (numberValue >> 15 == 0) {
                --wc;
            }
            return wc;
        }
        return 0;
    }

    static short[] GrowForCarry(short[] a, short carry) {
        int oldLength = a.length;
        short[] ret = EInteger.CleanGrow(a, oldLength + 1);
        ret[oldLength] = carry;
        return ret;
    }

    static int IncrementWords(short[] words1, int words1Start, int n, short words2) {
        short tmp = words1[words1Start];
        words1[words1Start] = (short)(tmp + words2);
        if ((words1[words1Start] & 0xFFFF) >= (tmp & 0xFFFF)) {
            return 0;
        }
        for (int i = 1; i < n; ++i) {
            int n2 = words1Start + i;
            words1[n2] = (short)(words1[n2] + 1);
            if (words1[words1Start + i] == 0) continue;
            return 0;
        }
        return 1;
    }

    private static short LinearMultiply(short[] productArr, int cstart, short[] words1, int astart, short words2, int n) {
        short carry = 0;
        int bint = words2 & 0xFFFF;
        for (int i = 0; i < n; ++i) {
            int p = (words1[astart + i] & 0xFFFF) * bint;
            productArr[cstart + i] = (short)(p += carry & 0xFFFF);
            carry = (short)(p >> 16);
        }
        return carry;
    }

    private static short LinearMultiplyAdd(short[] productArr, int cstart, short[] words1, int astart, short words2, int n) {
        short carry = 0;
        int bint = words2 & 0xFFFF;
        for (int i = 0; i < n; ++i) {
            int p = (words1[astart + i] & 0xFFFF) * bint;
            p += carry & 0xFFFF;
            productArr[cstart + i] = (short)(p += productArr[cstart + i] & 0xFFFF);
            carry = (short)(p >> 16);
        }
        return carry;
    }

    private static void RecursiveSquare(short[] resultArr, int resultStart, short[] tempArr, int tempStart, short[] words1, int words1Start, int count) {
        if (count <= 10) {
            switch (count) {
                case 2: {
                    EInteger.BaselineSquare2(resultArr, resultStart, words1, words1Start);
                    break;
                }
                case 4: {
                    EInteger.BaselineSquare4(resultArr, resultStart, words1, words1Start);
                    break;
                }
                case 8: {
                    EInteger.BaselineSquare8(resultArr, resultStart, words1, words1Start);
                    break;
                }
                default: {
                    EInteger.SchoolbookSquare(resultArr, resultStart, words1, words1Start, count);
                    break;
                }
            }
        } else if (count >= 400) {
            EInteger.Toom4(resultArr, resultStart, words1, words1Start, count, words1, words1Start, count);
        } else if (count >= 100) {
            EInteger.Toom3(resultArr, resultStart, words1, words1Start, count, words1, words1Start, count);
        } else if ((count & 1) == 0) {
            int count2 = count >> 1;
            EInteger.RecursiveSquare(resultArr, resultStart, tempArr, tempStart + count, words1, words1Start, count2);
            EInteger.RecursiveSquare(resultArr, resultStart + count, tempArr, tempStart + count, words1, words1Start + count2, count2);
            EInteger.SameSizeMultiply(tempArr, tempStart, tempArr, tempStart + count, words1, words1Start, words1, words1Start + count2, count2);
            int carry = EInteger.AddInternal(resultArr, resultStart + count2, resultArr, resultStart + count2, tempArr, tempStart, count);
            EInteger.IncrementWords(resultArr, resultStart + count + count2, count2, (short)(carry += EInteger.AddInternal(resultArr, resultStart + count2, resultArr, resultStart + count2, tempArr, tempStart, count)));
        } else {
            EInteger.SameSizeMultiply(resultArr, resultStart, tempArr, tempStart, words1, words1Start, words1, words1Start, count);
        }
    }

    private static short RemainderUnsigned(int x, short y) {
        int iy = y & 0xFFFF;
        return x >> 31 == 0 ? (short)(x % iy & 0xFFFF) : EInteger.Divide32By16(x, y, true);
    }

    private static void ReverseChars(char[] chars, int offset, int length) {
        int half = length >> 1;
        int right = offset + length - 1;
        int i = 0;
        while (i < half) {
            char value = chars[offset + i];
            chars[offset + i] = chars[right];
            chars[right] = value;
            ++i;
            --right;
        }
    }

    private static void SameSizeMultiply(short[] resultArr, int resultStart, short[] tempArr, int tempStart, short[] words1, int words1Start, short[] words2, int words2Start, int count) {
        if (count <= 10) {
            switch (count) {
                case 2: {
                    EInteger.BaselineMultiply2(resultArr, resultStart, words1, words1Start, words2, words2Start);
                    break;
                }
                case 4: {
                    EInteger.BaselineMultiply4(resultArr, resultStart, words1, words1Start, words2, words2Start);
                    break;
                }
                case 8: {
                    EInteger.BaselineMultiply8(resultArr, resultStart, words1, words1Start, words2, words2Start);
                    break;
                }
                default: {
                    EInteger.SchoolbookMultiply(resultArr, resultStart, words1, words1Start, count, words2, words2Start, count);
                    break;
                }
            }
        } else if (count >= 400) {
            EInteger.Toom4(resultArr, resultStart, words1, words1Start, count, words2, words2Start, count);
        } else if (count >= 100) {
            EInteger.Toom3(resultArr, resultStart, words1, words1Start, count, words2, words2Start, count);
        } else {
            int countB;
            int countA;
            for (countA = count; countA != 0 && words1[words1Start + countA - 1] == 0; --countA) {
            }
            for (countB = count; countB != 0 && words2[words2Start + countB - 1] == 0; --countB) {
            }
            int offset2For1 = 0;
            int offset2For2 = 0;
            if (countA == 0 || countB == 0) {
                Arrays.fill(resultArr, resultStart, resultStart + (count << 1), (short)0);
                return;
            }
            if ((count & 1) == 0) {
                int c2;
                int count2 = count >> 1;
                if (countA <= count2 && countB <= count2) {
                    Arrays.fill(resultArr, resultStart + count, resultStart + count + count, (short)0);
                    if (count2 == 8) {
                        EInteger.BaselineMultiply8(resultArr, resultStart, words1, words1Start, words2, words2Start);
                    } else {
                        EInteger.SameSizeMultiply(resultArr, resultStart, tempArr, tempStart, words1, words1Start, words2, words2Start, count2);
                    }
                    return;
                }
                int resultMediumHigh = resultStart + count;
                int resultHigh = resultMediumHigh + count2;
                int resultMediumLow = resultStart + count2;
                int tsn = tempStart + count;
                offset2For1 = EInteger.Compare(words1, words1Start, words1, words1Start + count2, count2) > 0 ? 0 : count2;
                int tmpvar = words1Start + (count2 ^ offset2For1);
                EInteger.SubtractInternal(resultArr, resultStart, words1, words1Start + offset2For1, words1, tmpvar, count2);
                offset2For2 = EInteger.Compare(words2, words2Start, words2, words2Start + count2, count2) > 0 ? 0 : count2;
                int tmp = words2Start + (count2 ^ offset2For2);
                EInteger.SubtractInternal(resultArr, resultMediumLow, words2, words2Start + offset2For2, words2, tmp, count2);
                EInteger.SameSizeMultiply(resultArr, resultMediumHigh, tempArr, tsn, words1, words1Start + count2, words2, words2Start + count2, count2);
                EInteger.SameSizeMultiply(tempArr, tempStart, tempArr, tsn, resultArr, resultStart, resultArr, resultMediumLow, count2);
                EInteger.SameSizeMultiply(resultArr, resultStart, tempArr, tsn, words1, words1Start, words2, words2Start, count2);
                int c3 = c2 = EInteger.AddInternal(resultArr, resultMediumHigh, resultArr, resultMediumHigh, resultArr, resultMediumLow, count2);
                c3 += EInteger.AddInternal(resultArr, resultMediumHigh, resultArr, resultMediumHigh, resultArr, resultHigh, count2);
                c3 = offset2For1 == offset2For2 ? (c3 -= EInteger.SubtractInternal(resultArr, resultMediumLow, resultArr, resultMediumLow, tempArr, tempStart, count)) : (c3 += EInteger.AddInternal(resultArr, resultMediumLow, resultArr, resultMediumLow, tempArr, tempStart, count));
                if ((c3 += EInteger.IncrementWords(resultArr, resultMediumHigh, count2, (short)(c2 += EInteger.AddInternal(resultArr, resultMediumLow, resultArr, resultMediumHigh, resultArr, resultStart, count2)))) != 0) {
                    EInteger.IncrementWords(resultArr, resultHigh, count2, (short)c3);
                }
            } else {
                int c2;
                int countHigh = count >> 1;
                int countLow = count - countHigh;
                int n = offset2For1 = EInteger.CompareWithWords1IsOneBigger(words1, words1Start, words1, words1Start + countLow, countLow) > 0 ? 0 : countLow;
                if (offset2For1 == 0) {
                    EInteger.SubtractWords1IsOneBigger(resultArr, resultStart, words1, words1Start, words1, words1Start + countLow, countLow);
                } else {
                    EInteger.SubtractWords2IsOneBigger(resultArr, resultStart, words1, words1Start + countLow, words1, words1Start, countLow);
                }
                int n2 = offset2For2 = EInteger.CompareWithWords1IsOneBigger(words2, words2Start, words2, words2Start + countLow, countLow) > 0 ? 0 : countLow;
                if (offset2For2 == 0) {
                    EInteger.SubtractWords1IsOneBigger(tempArr, tempStart, words2, words2Start, words2, words2Start + countLow, countLow);
                } else {
                    EInteger.SubtractWords2IsOneBigger(tempArr, tempStart, words2, words2Start + countLow, words2, words2Start, countLow);
                }
                int shorterOffset = countHigh << 1;
                int longerOffset = countLow << 1;
                EInteger.SameSizeMultiply(tempArr, tempStart + shorterOffset, resultArr, resultStart + shorterOffset, resultArr, resultStart, tempArr, tempStart, countLow);
                short resultTmp0 = tempArr[tempStart + shorterOffset];
                short resultTmp1 = tempArr[tempStart + shorterOffset + 1];
                EInteger.SameSizeMultiply(resultArr, resultStart + longerOffset, resultArr, resultStart, words1, words1Start + countLow, words2, words2Start + countLow, countHigh);
                EInteger.SameSizeMultiply(resultArr, resultStart, tempArr, tempStart, words1, words1Start, words2, words2Start, countLow);
                tempArr[tempStart + shorterOffset] = resultTmp0;
                tempArr[tempStart + shorterOffset + 1] = resultTmp1;
                int countMiddle = countLow << 1;
                int c3 = c2 = EInteger.AddInternal(resultArr, resultStart + countMiddle, resultArr, resultStart + countMiddle, resultArr, resultStart + countLow, countLow);
                c3 += EInteger.AddUnevenSize(resultArr, resultStart + countMiddle, resultArr, resultStart + countMiddle, countLow, resultArr, resultStart + countMiddle + countLow, countLow - 2);
                c3 = offset2For1 == offset2For2 ? (c3 -= EInteger.SubtractInternal(resultArr, resultStart + countLow, resultArr, resultStart + countLow, tempArr, tempStart + shorterOffset, countLow << 1)) : (c3 += EInteger.AddInternal(resultArr, resultStart + countLow, resultArr, resultStart + countLow, tempArr, tempStart + shorterOffset, countLow << 1));
                if ((c3 += EInteger.IncrementWords(resultArr, resultStart + countMiddle, countLow, (short)(c2 += EInteger.AddInternal(resultArr, resultStart + countLow, resultArr, resultStart + countMiddle, resultArr, resultStart, countLow)))) != 0) {
                    EInteger.IncrementWords(resultArr, resultStart + countMiddle + countLow, countLow - 2, (short)c3);
                }
            }
        }
    }

    private static void SchoolbookMultiplySameLengthEven(short[] resultArr, int resultStart, short[] words1, int words1Start, short[] words2, int words2Start, int count) {
        long p;
        long carry = 0L;
        long valueBint = words2[words2Start] & 0xFFFF;
        valueBint |= ((long)words2[words2Start + 1] & 0xFFFFL) << 16;
        for (int j = 0; j < count; j += 2) {
            p = words1[words1Start + j] & 0xFFFF;
            p |= ((long)words1[words1Start + j + 1] & 0xFFFFL) << 16;
            resultArr[resultStart + j] = (short)(p *= valueBint + carry);
            resultArr[resultStart + j + 1] = (short)(p >> 16);
            carry = p >> 32 & 0xFFFFFFFFL;
        }
        resultArr[resultStart + count] = (short)carry;
        resultArr[resultStart + count + 1] = (short)(carry >> 16);
        for (int i = 2; i < count; i += 2) {
            int resultPos = resultStart + i;
            carry = 0L;
            valueBint = words2[words2Start + i] & 0xFFFF;
            valueBint |= ((long)words2[words2Start + i + 1] & 0xFFFFL) << 16;
            int j = 0;
            while (j < count) {
                p = words1[words1Start + j] & 0xFFFF;
                p |= ((long)words1[words1Start + j + 1] & 0xFFFFL) << 16;
                p *= valueBint + carry;
                p += (long)(resultArr[resultPos] & 0xFFFF);
                resultArr[resultPos] = (short)(p += (long)((resultArr[resultPos + 1] & 0xFFFF) << 16));
                resultArr[resultPos + 1] = (short)(p >> 16);
                carry = p >> 32 & 0xFFFFFFFFL;
                j += 2;
                resultPos += 2;
            }
            resultArr[resultStart + i + count] = (short)carry;
            resultArr[resultStart + i + count + 1] = (short)(carry >> 16);
        }
    }

    private static void SchoolbookMultiplySameLengthOdd(short[] resultArr, int resultStart, short[] words1, int words1Start, short[] words2, int words2Start, int count) {
        long p;
        long carry = 0L;
        long valueBint = words2[words2Start] & 0xFFFF;
        valueBint |= count > 1 ? ((long)words2[words2Start + 1] & 0xFFFFL) << 16 : 0L;
        for (int j = 0; j < count; j += 2) {
            p = words1[words1Start + j] & 0xFFFF;
            if (j + 1 < count) {
                p |= (long)words1[words1Start + j + 1] & 0xFFFFL;
            }
            resultArr[resultStart + j] = (short)(p *= valueBint + carry);
            if (j + 1 < count) {
                resultArr[resultStart + j + 1] = (short)(p >> 16);
            }
            carry = p >> 32 & 0xFFFFFFFFL;
        }
        resultArr[resultStart + count] = (short)carry;
        if (count > 1) {
            resultArr[resultStart + count + 1] = (short)(carry >> 16);
        }
        for (int i = 2; i < count; i += 2) {
            int resultPos = resultStart + i;
            carry = 0L;
            valueBint = words2[words2Start + i] & 0xFFFF;
            if (i + 1 < count) {
                valueBint |= ((long)words2[words2Start + i + 1] & 0xFFFFL) << 16;
            }
            int j = 0;
            while (j < count) {
                p = words1[words1Start + j] & 0xFFFF;
                if (j + 1 < count) {
                    p |= ((long)words1[words1Start + j + 1] & 0xFFFFL) << 16;
                }
                p *= valueBint + carry;
                p += (long)(resultArr[resultPos] & 0xFFFF);
                if (j + 1 < count) {
                    resultArr[resultPos] = (short)(p += (long)((resultArr[resultPos + 1] & 0xFFFF) << 16));
                    resultArr[resultPos + 1] = (short)(p >> 16);
                    carry = p >> 32 & 0xFFFFFFFFL;
                } else {
                    resultArr[resultPos] = (short)p;
                    carry = p >> 16;
                }
                j += 2;
                resultPos += 2;
            }
            resultArr[resultStart + i + count] = (short)carry;
            if (i + 1 >= count) continue;
            resultArr[resultStart + i + count + 1] = (short)(carry >> 16);
        }
    }

    private static void SchoolbookMultiply(short[] resultArr, int resultStart, short[] words1, int words1Start, int words1Count, short[] words2, int words2Start, int words2Count) {
        if (words1Count != words2Count || (words1Count & 1) == 0) {
            // empty if block
        }
        if (words1Count < words2Count) {
            int carry = 0;
            int valueBint = words1[words1Start] & 0xFFFF;
            for (int j = 0; j < words2Count; ++j) {
                int p = (words2[words2Start + j] & 0xFFFF) * valueBint;
                resultArr[resultStart + j] = (short)(p += carry);
                carry = p >> 16 & 0xFFFF;
            }
            resultArr[resultStart + words2Count] = (short)carry;
            for (int i = 1; i < words1Count; ++i) {
                int resultPos = resultStart + i;
                carry = 0;
                valueBint = words1[words1Start + i] & 0xFFFF;
                int j = 0;
                while (j < words2Count) {
                    int p = (words2[words2Start + j] & 0xFFFF) * valueBint;
                    p += carry;
                    resultArr[resultPos] = (short)(p += resultArr[resultPos] & 0xFFFF);
                    carry = p >> 16 & 0xFFFF;
                    ++j;
                    ++resultPos;
                }
                resultArr[resultStart + i + words2Count] = (short)carry;
            }
        } else {
            int carry = 0;
            int valueBint = words2[words2Start] & 0xFFFF;
            for (int j = 0; j < words1Count; ++j) {
                int p = (words1[words1Start + j] & 0xFFFF) * valueBint;
                resultArr[resultStart + j] = (short)(p += carry);
                carry = p >> 16 & 0xFFFF;
            }
            resultArr[resultStart + words1Count] = (short)carry;
            for (int i = 1; i < words2Count; ++i) {
                int resultPos = resultStart + i;
                carry = 0;
                valueBint = words2[words2Start + i] & 0xFFFF;
                int j = 0;
                while (j < words1Count) {
                    int p = (words1[words1Start + j] & 0xFFFF) * valueBint;
                    p += carry;
                    resultArr[resultPos] = (short)(p += resultArr[resultPos] & 0xFFFF);
                    carry = p >> 16 & 0xFFFF;
                    ++j;
                    ++resultPos;
                }
                resultArr[resultStart + i + words1Count] = (short)carry;
            }
        }
    }

    private static void SchoolbookSquare(short[] resultArr, int resultStart, short[] words1, int words1Start, int words1Count) {
        for (int i = 0; i < words1Count; ++i) {
            int cstart = resultStart + i;
            short carry = 0;
            int valueBint = words1[words1Start + i] & 0xFFFF;
            for (int j = 0; j < words1Count; ++j) {
                int p = (words1[words1Start + j] & 0xFFFF) * valueBint;
                p += carry & 0xFFFF;
                if (i != 0) {
                    p += resultArr[cstart + j] & 0xFFFF;
                }
                resultArr[cstart + j] = (short)p;
                carry = (short)(p >> 16);
            }
            resultArr[cstart + words1Count] = carry;
        }
    }

    private static short ShiftWordsLeftByBits(short[] r, int rstart, int count, int shiftBits) {
        int carry = 0;
        if (shiftBits != 0) {
            int sb16 = 16 - shiftBits;
            int rs = rstart;
            int i = 0;
            while (i < count) {
                short u = r[rs];
                r[rs] = (short)(u << shiftBits | carry);
                carry = (u & 0xFFFF) >> sb16;
                ++i;
                ++rs;
            }
        }
        return (short)carry;
    }

    private static void ShiftWordsLeftByWords(short[] r, int rstart, int n, int shiftWords) {
        if ((shiftWords = Math.min(shiftWords, n)) != 0) {
            for (int i = n - 1; i >= shiftWords; --i) {
                r[rstart + i] = r[rstart + i - shiftWords];
            }
            Arrays.fill(r, rstart, rstart + shiftWords, (short)0);
        }
    }

    private static short ShiftWordsRightByBits(short[] r, int rstart, int n, int shiftBits) {
        short carry = 0;
        if (shiftBits != 0) {
            for (int i = n; i > 0; --i) {
                short u = r[rstart + i - 1];
                r[rstart + i - 1] = (short)((u & 0xFFFF) >> shiftBits & 0xFFFF | carry & 0xFFFF);
                carry = (short)((u & 0xFFFF) << 16 - shiftBits);
            }
        }
        return carry;
    }

    private static short ShiftWordsRightByBitsSignExtend(short[] r, int rstart, int n, int shiftBits) {
        short carry = (short)(65535 << 16 - shiftBits);
        if (shiftBits != 0) {
            for (int i = n; i > 0; --i) {
                short u = r[rstart + i - 1];
                r[rstart + i - 1] = (short)((u & 0xFFFF) >> shiftBits | carry & 0xFFFF);
                carry = (short)((u & 0xFFFF) << 16 - shiftBits);
            }
        }
        return carry;
    }

    private static void ShiftWordsRightByWordsSignExtend(short[] r, int rstart, int n, int shiftWords) {
        if ((shiftWords = Math.min(shiftWords, n)) != 0) {
            int i = 0;
            while (i + shiftWords < n) {
                r[rstart + i] = r[rstart + i + shiftWords];
                ++i;
            }
            rstart += n - shiftWords;
            for (i = 0; i < shiftWords; ++i) {
                r[rstart + i] = -1;
            }
        }
    }

    private static short[] ShortenArray(short[] reg, int wordCount) {
        int newLength;
        if (reg.length > 32 && (newLength = wordCount) < reg.length && reg.length - newLength >= 16) {
            short[] newreg = new short[newLength];
            System.arraycopy(reg, 0, newreg, 0, Math.min(newLength, reg.length));
            reg = newreg;
        }
        return reg;
    }

    private static int SubtractWords1IsOneBigger(short[] c, int cstart, short[] words1, int astart, short[] words2, int bstart, int words1Count) {
        int u = 0;
        int cm1 = words1Count - 1;
        for (int i = 0; i < cm1; ++i) {
            u = (words1[astart] & 0xFFFF) - (words2[bstart] & 0xFFFF) - (u >> 31 & 1);
            c[cstart++] = (short)u;
            ++astart;
            ++bstart;
        }
        u = (words1[astart] & 0xFFFF) - (u >> 31 & 1);
        c[cstart++] = (short)u;
        return u >> 31 & 1;
    }

    private static int SubtractWords2IsOneBigger(short[] c, int cstart, short[] words1, int astart, short[] words2, int bstart, int words2Count) {
        int u = 0;
        int cm1 = words2Count - 1;
        for (int i = 0; i < cm1; ++i) {
            u = (words1[astart] & 0xFFFF) - (words2[bstart] & 0xFFFF) - (u >> 31 & 1);
            c[cstart++] = (short)u;
            ++astart;
            ++bstart;
        }
        u = 0 - ((words2[bstart] & 0xFFFF) - (u >> 31 & 1));
        c[cstart++] = (short)u;
        return u >> 31 & 1;
    }

    private static int SubtractInternal(short[] c, int cstart, short[] words1, int astart, short[] words2, int bstart, int n) {
        boolean odd;
        int u = 0;
        boolean bl = odd = (n & 1) != 0;
        if (odd) {
            --n;
        }
        int mask = 65535;
        for (int i = 0; i < n; i += 2) {
            int wb0 = words2[bstart] & mask;
            int wb1 = words2[bstart + 1] & mask;
            int wa0 = words1[astart] & mask;
            int wa1 = words1[astart + 1] & mask;
            u = wa0 - wb0 - (u >> 31 & 1);
            c[cstart++] = (short)u;
            u = wa1 - wb1 - (u >> 31 & 1);
            c[cstart++] = (short)u;
            astart += 2;
            bstart += 2;
        }
        if (odd) {
            u = (words1[astart] & mask) - (words2[bstart] & mask) - (u >> 31 & 1);
            c[cstart++] = (short)u;
            ++astart;
            ++bstart;
        }
        return u >> 31 & 1;
    }

    private static void TwosComplement(short[] words1, int words1Start, int n) {
        EInteger.DecrementWords(words1, words1Start, n, (short)1);
        for (int i = 0; i < n; ++i) {
            words1[words1Start + i] = ~words1[words1Start + i];
        }
    }

    private int ByteCount() {
        int wc = this.wordCount;
        if (wc == 0) {
            return 0;
        }
        short s = this.words[wc - 1];
        wc = wc - 1 << 1;
        return s == 0 ? wc : (s >> 8 == 0 ? wc + 1 : wc + 2);
    }

    private int PositiveCompare(EInteger t) {
        int size = this.wordCount;
        int tempSize = t.wordCount;
        return size == tempSize ? EInteger.Compare(this.words, 0, t.words, 0, size) : (size > tempSize ? 1 : -1);
    }

    private EInteger[] RootRemInternal(EInteger root, boolean useRem) {
        EInteger oldret;
        if (root.compareTo(1) == 0) {
            EInteger thisValue = this;
            return new EInteger[]{thisValue, EInteger.FromInt32(0)};
        }
        if (root.compareTo(1) < 0) {
            throw new IllegalArgumentException("root");
        }
        if (root.compareTo(2) == 0) {
            return this.SqrtRemInternal(useRem);
        }
        if (this.signum() <= 0) {
            return new EInteger[]{EInteger.FromInt32(0), EInteger.FromInt32(0)};
        }
        if (this.equals(EInteger.FromInt32(1))) {
            return new EInteger[]{EInteger.FromInt32(1), EInteger.FromInt32(0)};
        }
        EInteger bl = this.GetUnsignedBitLengthAsEInteger();
        EInteger rm1 = root.Subtract(1);
        EInteger shift = bl.Multiply(rm1).Divide(root);
        EInteger ret = this.ShiftRight(shift);
        while (!(oldret = ret).equals(ret = this.Divide(ret.Pow(rm1)).Add(ret.Multiply(rm1)).Divide(root))) {
        }
        if (useRem) {
            EInteger erem = this.Subtract(ret.Pow(root));
            if (erem.signum() < 0) {
                throw new IllegalStateException();
            }
            return new EInteger[]{ret, erem};
        }
        return new EInteger[]{ret, null};
    }

    private EInteger[] SqrtRemInternal(boolean useRem) {
        if (this.signum() <= 0) {
            return new EInteger[]{EInteger.FromInt32(0), EInteger.FromInt32(0)};
        }
        if (this.equals(EInteger.FromInt32(1))) {
            return new EInteger[]{EInteger.FromInt32(1), EInteger.FromInt32(0)};
        }
        EInteger thisValue = this;
        if (thisValue.CanFitInInt32()) {
            int smallValue = thisValue.ToInt32Checked();
            int smallPowerBits = (thisValue.GetUnsignedBitLengthAsEInteger().ToInt32Checked() + 1) / 2;
            int smallintX = 0;
            int smallintY = 1 << smallPowerBits;
            do {
                smallintX = smallintY;
                smallintY = smallValue / smallintX;
                smallintY += smallintX;
            } while ((smallintY >>= 1) < smallintX);
            if (!useRem) {
                return new EInteger[]{EInteger.FromInt32(smallintX), null};
            }
            smallintY = smallintX * smallintX;
            smallintY = smallValue - smallintY;
            return new EInteger[]{EInteger.FromInt32(smallintX), EInteger.FromInt32(smallintY)};
        }
        EInteger valueEPowerBits = thisValue.GetUnsignedBitLengthAsEInteger().Add(1).Divide(2);
        if (this.wordCount >= 4) {
            int wordsPerPart = (this.wordCount >> 2) + ((this.wordCount & 3) > 0 ? 1 : 0);
            long bitsPerPart = wordsPerPart * 16;
            EInteger valueEBitsPerPart = EInteger.FromInt64(bitsPerPart);
            long totalBits = bitsPerPart * 4L;
            EInteger valueEBitLength = this.GetUnsignedBitLengthAsEInteger();
            boolean bitLengthEven = valueEBitLength.isEven();
            EInteger bigintX = this;
            EInteger eshift = EInteger.FromInt32(0);
            if (valueEBitLength.compareTo(EInteger.FromInt64(totalBits).Subtract(1)) < 0) {
                long targetLength = bitLengthEven ? totalBits : totalBits - 1L;
                eshift = EInteger.FromInt64(targetLength).Subtract(valueEBitLength);
                bigintX = bigintX.ShiftLeft(eshift);
            }
            short[] ww = bigintX.words;
            short[] w1 = new short[wordsPerPart];
            short[] w2 = new short[wordsPerPart];
            short[] w3 = new short[wordsPerPart * 2];
            System.arraycopy(ww, 0, w1, 0, wordsPerPart);
            System.arraycopy(ww, wordsPerPart, w2, 0, wordsPerPart);
            System.arraycopy(ww, wordsPerPart * 2, w3, 0, wordsPerPart * 2);
            EInteger e1 = new EInteger(EInteger.CountWords(w1), w1, false);
            EInteger e2 = new EInteger(EInteger.CountWords(w2), w2, false);
            EInteger e3 = new EInteger(EInteger.CountWords(w3), w3, false);
            EInteger[] srem = e3.SqrtRemInternal(true);
            EInteger[] qrem = srem[1].ShiftLeft(valueEBitsPerPart).Add(e2).DivRem(srem[0].ShiftLeft(1));
            EInteger sqroot = srem[0].ShiftLeft(valueEBitsPerPart).Add(qrem[0]);
            EInteger sqrem = qrem[1].ShiftLeft(valueEBitsPerPart).Add(e1).Subtract(qrem[0].Multiply(qrem[0]));
            if (sqrem.signum() < 0) {
                if (useRem) {
                    sqrem = sqrem.Add(sqroot.ShiftLeft(1)).Subtract(EInteger.FromInt32(1));
                }
                sqroot = sqroot.Subtract(EInteger.FromInt32(1));
            }
            EInteger[] retarr = new EInteger[2];
            retarr[0] = sqroot.ShiftRight(eshift.ShiftRight(1));
            if (useRem) {
                retarr[1] = eshift.isZero() ? sqrem : this.Subtract(retarr[0].Multiply(retarr[0]));
            }
            return retarr;
        }
        EInteger bigintX = EInteger.FromInt32(0);
        EInteger bigintY = EInteger.FromInt32(1).ShiftLeft(valueEPowerBits);
        do {
            bigintX = bigintY;
            bigintY = thisValue.Divide(bigintX);
            bigintY = bigintY.Add(bigintX);
        } while ((bigintY = bigintY.ShiftRight(1)) != null && bigintY.compareTo(bigintX) < 0);
        if (!useRem) {
            return new EInteger[]{bigintX, null};
        }
        bigintY = bigintX.Multiply(bigintX);
        bigintY = thisValue.Subtract(bigintY);
        return new EInteger[]{bigintX, bigintY};
    }

    public EInteger Increment() {
        return this.Add(EInteger.FromInt32(1));
    }

    public EInteger Decrement() {
        return this.Subtract(EInteger.FromInt32(1));
    }

    public byte ToByteChecked() {
        int val = this.ToInt32Checked();
        if (val < 0 || val > 255) {
            throw new ArithmeticException("This Object's value is out of range");
        }
        return (byte)(val & 0xFF);
    }

    public byte ToByteUnchecked() {
        int val = this.ToInt32Unchecked();
        return (byte)(val & 0xFF);
    }

    public static EInteger FromByte(byte inputByte) {
        int val = inputByte & 0xFF;
        return EInteger.FromInt32(val);
    }

    public short ToInt16Checked() {
        int val = this.ToInt32Checked();
        if (val < Short.MIN_VALUE || val > Short.MAX_VALUE) {
            throw new ArithmeticException("This Object's value is out of range");
        }
        return (short)(val & 0xFFFF);
    }

    public short ToInt16Unchecked() {
        int val = this.ToInt32Unchecked();
        return (short)(val & 0xFFFF);
    }

    public static EInteger FromInt16(short inputInt16) {
        short val = inputInt16;
        return EInteger.FromInt32(val);
    }
}

