/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.numbers;

import com.upokecenter.numbers.EContext;
import com.upokecenter.numbers.EInteger;
import com.upokecenter.numbers.ERounding;
import com.upokecenter.numbers.FastInteger;
import com.upokecenter.numbers.FastIntegerFixed;
import com.upokecenter.numbers.IRadixMath;
import com.upokecenter.numbers.IRadixMathHelper;
import com.upokecenter.numbers.IShiftAccumulator;
import com.upokecenter.numbers.NumberUtility;

class RadixMath<T>
implements IRadixMath<T> {
    private static final int IntegerModeFixedScale = 1;
    private static final int IntegerModeRegular = 0;
    private static final int[] BitMasks = new int[]{Integer.MAX_VALUE, 0x3FFFFFFF, 0x1FFFFFFF, 0xFFFFFFF, 0x7FFFFFF, 0x3FFFFFF, 0x1FFFFFF, 0xFFFFFF, 0x7FFFFF, 0x3FFFFF, 0x1FFFFF, 1048575, 524287, 262143, 131071, 65535, Short.MAX_VALUE, 16383, 8191, 4095, 2047, 1023, 511, 255, 127, 63, 31, 15, 7, 3, 1};
    private static final long[] BitMasks64 = new long[]{Long.MAX_VALUE, 0x3FFFFFFFFFFFFFFFL, 0x1FFFFFFFFFFFFFFFL, 0xFFFFFFFFFFFFFFFL, 0x7FFFFFFFFFFFFFFL, 0x3FFFFFFFFFFFFFFL, 0x1FFFFFFFFFFFFFFL, 0xFFFFFFFFFFFFFFL, 0x7FFFFFFFFFFFFFL, 0x3FFFFFFFFFFFFFL, 0x1FFFFFFFFFFFFFL, 0xFFFFFFFFFFFFFL, 0x7FFFFFFFFFFFFL, 0x3FFFFFFFFFFFFL, 0x1FFFFFFFFFFFFL, 0xFFFFFFFFFFFFL, 0x7FFFFFFFFFFFL, 0x3FFFFFFFFFFFL, 0x1FFFFFFFFFFFL, 0xFFFFFFFFFFFL, 0x7FFFFFFFFFFL, 0x3FFFFFFFFFFL, 0x1FFFFFFFFFFL, 0xFFFFFFFFFFL, 0x7FFFFFFFFFL, 0x3FFFFFFFFFL, 0x1FFFFFFFFFL, 0xFFFFFFFFFL, 0x7FFFFFFFFL, 0x3FFFFFFFFL, 0x1FFFFFFFFL, 0xFFFFFFFFL, Integer.MAX_VALUE, 0x3FFFFFFFL, 0x1FFFFFFFL, 0xFFFFFFFL, 0x7FFFFFFL, 0x3FFFFFFL, 0x1FFFFFFL, 0xFFFFFFL, 0x7FFFFFL, 0x3FFFFFL, 0x1FFFFFL, 1048575L, 524287L, 262143L, 131071L, 65535L, 32767L, 16383L, 8191L, 4095L, 2047L, 1023L, 511L, 255L, 127L, 63L, 31L, 15L, 7L, 3L, 1L};
    private static final int[] OverflowMaxes = new int[]{Integer.MAX_VALUE, 0xCCCCCCC, 21474836, 2147483, 214748, 21474, 2147, 214, 21, 2};
    private static final EInteger ValueMinusOne = EInteger.FromInt32(0).Subtract(EInteger.FromInt64(1L));
    private static final int[] ValueTenPowers = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000, 1000000000};
    private static final long[] OverflowMaxes64 = new long[]{Long.MAX_VALUE, 0xCCCCCCCCCCCCCCCL, 92233720368547758L, 9223372036854775L, 922337203685477L, 92233720368547L, 9223372036854L, 922337203685L, 92233720368L, 9223372036L, 922337203L, 92233720L, 0x8CBCCCL, 922337L, 92233L, 9223L, 922L, 92L, 9L};
    private static final long[] ValueTenPowers64 = new long[]{1L, 10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L, 10000000000L, 100000000000L, 1000000000000L, 10000000000000L, 100000000000000L, 1000000000000000L, 10000000000000000L, 100000000000000000L, 1000000000000000000L};
    private final IRadixMathHelper<T> helper;
    private final int support;
    private final int thisRadix;
    private static EInteger valueMaxDigits = EInteger.FromInt64(0x155555552L);
    private static final int SafeMin32 = -1073741822;
    private static final int SafeMax32 = 0x3FFFFFFE;
    private static final long SafeMin64 = -4611686018427387902L;
    private static final long SafeMax64 = 0x3FFFFFFFFFFFFFFEL;
    private static final FastInteger ValueFastIntegerTwo = new FastInteger(2);
    private static final EContext DefaultUnlimited = EContext.UnlimitedHalfEven.WithRounding(ERounding.HalfEven);

    public RadixMath(IRadixMathHelper<T> helper) {
        this.helper = helper;
        this.support = helper.GetArithmeticSupport();
        this.thisRadix = helper.GetRadix();
    }

    @Override
    public T Abs(T value, EContext ctx) {
        int flags = this.helper.GetFlags(value);
        return (flags & 8) != 0 ? this.SignalingNaNInvalid(value, ctx) : ((flags & 4) != 0 ? this.ReturnQuietNaN(value, ctx) : ((flags & 1) != 0 ? this.RoundToPrecision(this.helper.CreateNewWithFlags(this.helper.GetMantissa(value), this.helper.GetExponent(value), flags & 0xFFFFFFFE), ctx) : this.RoundToPrecision(value, ctx)));
    }

    @Override
    public T Add(T thisValue, T other, EContext ctx) {
        if (thisValue == null) {
            throw new NullPointerException("thisValue");
        }
        if (other == null) {
            throw new NullPointerException("other");
        }
        return this.AddEx(thisValue, other, ctx, false);
    }

    private FastInteger MaxDigitLengthForBitLength(FastInteger prec) {
        FastInteger result;
        if (this.thisRadix == 2) {
            result = prec;
        } else if (this.thisRadix == 10 && prec.CompareToInt(2135) <= 0) {
            int value = 1 + ((prec.AsInt32() - 1) * 631305 >> 21);
            result = new FastInteger(value);
        } else {
            return this.helper.GetDigitLength(RadixMath.ShiftedMask(prec).Subtract(1));
        }
        return result;
    }

    private static EInteger ShiftedMask(FastInteger prec) {
        EInteger bthis = EInteger.FromInt32(1);
        prec = prec.Copy();
        while (prec.signum() > 0) {
            int num = prec.CompareToInt(1000000) >= 0 ? 1000000 : prec.AsInt32();
            bthis = bthis.ShiftLeft(num);
            prec.SubtractInt(num);
        }
        return bthis.Subtract(EInteger.FromInt32(1));
    }

    private boolean IsHigherThanBitLength(EInteger ei, FastInteger prec) {
        return prec.compareTo(FastInteger.FromBig(ei.GetUnsignedBitLengthAsEInteger())) < 0;
    }

    private T AddEx32Bit(int expcmp, FastIntegerFixed op1Exponent, FastIntegerFixed op1Mantissa, FastIntegerFixed op2Exponent, FastIntegerFixed op2Mantissa, FastIntegerFixed resultExponent, int thisFlags, int otherFlags, EContext ctx) {
        int maxoverflow;
        int power;
        int m2;
        int m1;
        int radix;
        int ediff;
        boolean haveRetval;
        T retval = null;
        if ((expcmp == 0 || op1Exponent.CanFitInInt32() && op2Exponent.CanFitInInt32()) && op1Mantissa.CanFitInInt32() && op2Mantissa.CanFitInInt32() && (thisFlags & 1) == (otherFlags & 1)) {
            int negflag = thisFlags & 1;
            int e1int = 0;
            int e2int = 0;
            if (expcmp != 0) {
                e1int = op1Exponent.AsInt32();
                e2int = op2Exponent.AsInt32();
            }
            haveRetval = false;
            if (expcmp == 0 || e1int >= -1073741822 && e1int <= 0x3FFFFFFE && e2int >= -1073741822 && e2int <= 0x3FFFFFFE) {
                ediff = expcmp == 0 ? 0 : (e1int > e2int ? e1int - e2int : e2int - e1int);
                radix = this.thisRadix;
                if (expcmp == 0) {
                    m1 = op1Mantissa.AsInt32();
                    m2 = op2Mantissa.AsInt32();
                    if (m2 <= Integer.MAX_VALUE - m1) {
                        retval = this.helper.CreateNewWithFlagsFastInt(new FastIntegerFixed(m1 += m2), resultExponent, negflag);
                        haveRetval = true;
                    }
                } else if (ediff <= 9 && radix == 10) {
                    power = ValueTenPowers[ediff];
                    maxoverflow = OverflowMaxes[ediff];
                    if (expcmp > 0) {
                        m1 = op1Mantissa.AsInt32();
                        m2 = op2Mantissa.AsInt32();
                        if (m1 == 0) {
                            retval = this.helper.CreateNewWithFlagsFastInt(op2Mantissa, op2Exponent, otherFlags);
                        } else if (m1 <= maxoverflow && m2 <= Integer.MAX_VALUE - (m1 *= power)) {
                            retval = this.helper.CreateNewWithFlagsFastInt(new FastIntegerFixed(m1 += m2), resultExponent, negflag);
                            haveRetval = true;
                        }
                    } else {
                        m1 = op1Mantissa.AsInt32();
                        m2 = op2Mantissa.AsInt32();
                        if (m2 == 0) {
                            retval = this.helper.CreateNewWithFlagsFastInt(op1Mantissa, op1Exponent, thisFlags);
                        }
                        if (m2 <= maxoverflow && m1 <= Integer.MAX_VALUE - (m2 *= power)) {
                            retval = this.helper.CreateNewWithFlagsFastInt(new FastIntegerFixed(m2 += m1), resultExponent, negflag);
                            haveRetval = true;
                        }
                    }
                } else if (ediff <= 30 && radix == 2) {
                    int mask = BitMasks[ediff];
                    if (expcmp > 0) {
                        m1 = op1Mantissa.AsInt32();
                        m2 = op2Mantissa.AsInt32();
                        if (m1 == 0) {
                            retval = this.helper.CreateNewWithFlagsFastInt(op2Mantissa, op2Exponent, otherFlags);
                        } else if ((m1 & mask) == m1 && m2 <= Integer.MAX_VALUE - (m1 <<= ediff)) {
                            retval = this.helper.CreateNewWithFlagsFastInt(new FastIntegerFixed(m1 += m2), resultExponent, negflag);
                            haveRetval = true;
                        }
                    } else {
                        m1 = op1Mantissa.AsInt32();
                        m2 = op2Mantissa.AsInt32();
                        if (m2 == 0) {
                            retval = this.helper.CreateNewWithFlagsFastInt(op1Mantissa, op1Exponent, thisFlags);
                        } else if ((m2 & mask) == m2 && m1 <= Integer.MAX_VALUE - (m2 <<= ediff)) {
                            retval = this.helper.CreateNewWithFlagsFastInt(new FastIntegerFixed(m2 += m1), resultExponent, negflag);
                            haveRetval = true;
                        }
                    }
                }
            }
            if (haveRetval) {
                if (!RadixMath.IsNullOrSimpleContext(ctx)) {
                    if (resultExponent.isValueZero() && this.IsNullOrInt32FriendlyContext(ctx)) {
                        return retval;
                    }
                    retval = this.RoundToPrecision(retval, ctx);
                }
                return retval;
            }
        }
        if ((thisFlags & 1) != 0 && (otherFlags & 1) == 0) {
            FastIntegerFixed fftmp = op1Exponent;
            op1Exponent = op2Exponent;
            op2Exponent = fftmp;
            fftmp = op1Mantissa;
            op1Mantissa = op2Mantissa;
            op2Mantissa = fftmp;
            int tmp = thisFlags;
            thisFlags = otherFlags;
            otherFlags = tmp;
            FastIntegerFixed fastIntegerFixed = resultExponent = (expcmp = -expcmp) < 0 ? op1Exponent : op2Exponent;
        }
        if ((expcmp == 0 || op1Exponent.CanFitInInt32() && op2Exponent.CanFitInInt32()) && op1Mantissa.CanFitInInt32() && op2Mantissa.CanFitInInt32() && (thisFlags & 1) == 0 && (otherFlags & 1) != 0 && !op2Mantissa.isValueZero() && !op1Mantissa.isValueZero()) {
            int e1int = 0;
            int e2int = 0;
            int result = 0;
            if (expcmp != 0) {
                e1int = op1Exponent.AsInt32();
                e2int = op2Exponent.AsInt32();
            }
            haveRetval = false;
            if (expcmp == 0 || e1int >= -1073741822 && e1int <= 0x3FFFFFFE && e2int >= -1073741822 && e2int <= 0x3FFFFFFE) {
                ediff = expcmp == 0 ? 0 : (e1int > e2int ? e1int - e2int : e2int - e1int);
                radix = this.thisRadix;
                if (expcmp == 0) {
                    m1 = op1Mantissa.AsInt32();
                    m2 = op2Mantissa.AsInt32();
                    if (Integer.MIN_VALUE + m2 <= m1 && m1 >= m2) {
                        result = m1 -= m2;
                        retval = this.helper.CreateNewWithFlagsFastInt(new FastIntegerFixed(m1), resultExponent, 0);
                        haveRetval = true;
                    }
                } else if (radix == 10 && ediff <= 9) {
                    power = ValueTenPowers[ediff];
                    maxoverflow = OverflowMaxes[ediff];
                    m1 = op1Mantissa.AsInt32();
                    m2 = op2Mantissa.AsInt32();
                    boolean negbit = false;
                    boolean multed = false;
                    if (expcmp < 0) {
                        if (m2 <= maxoverflow) {
                            m2 *= power;
                            multed = true;
                        }
                    } else if (m1 <= maxoverflow) {
                        m1 *= power;
                        multed = true;
                    }
                    if (multed && Integer.MIN_VALUE + m2 <= m1 && (m1 -= m2) != Integer.MIN_VALUE) {
                        negbit = m1 < 0;
                        result = Math.abs(m1);
                        retval = this.helper.CreateNewWithFlagsFastInt(new FastIntegerFixed(result), resultExponent, negbit ? 1 : 0);
                        haveRetval = true;
                    }
                }
            }
            if (haveRetval && result != 0) {
                if (!RadixMath.IsNullOrSimpleContext(ctx)) {
                    if (resultExponent.isValueZero() && this.IsNullOrInt32FriendlyContext(ctx)) {
                        return retval;
                    }
                    retval = this.RoundToPrecision(retval, ctx);
                }
                return retval;
            }
            if (haveRetval && result == 0 && resultExponent.isValueZero() && this.IsNullOrInt32FriendlyContext(ctx)) {
                return retval;
            }
        }
        return null;
    }

    private T AddEx64Bit(long expcmp, FastIntegerFixed op1Exponent, FastIntegerFixed op1Mantissa, FastIntegerFixed op2Exponent, FastIntegerFixed op2Mantissa, FastIntegerFixed resultExponent, int thisFlags, int otherFlags, EContext ctx) {
        Object retval = null;
        if ((expcmp == 0L || op1Exponent.CanFitInInt64() && op2Exponent.CanFitInInt64()) && op1Mantissa.CanFitInInt64() && op2Mantissa.CanFitInInt64() && (thisFlags & 1) == (otherFlags & 1)) {
            int negflag = thisFlags & 1;
            long e1long = 0L;
            long e2long = 0L;
            if (expcmp != 0L) {
                e1long = op1Exponent.AsInt64();
                e2long = op2Exponent.AsInt64();
            }
            boolean haveRetval = false;
            if (expcmp == 0L || e1long >= -4611686018427387902L && e1long <= 0x3FFFFFFFFFFFFFFEL && e2long >= -4611686018427387902L && e2long <= 0x3FFFFFFFFFFFFFFEL) {
                long ediffLong = expcmp == 0L ? 0L : (e1long > e2long ? e1long - e2long : e2long - e1long);
                int radix = this.thisRadix;
                if (expcmp == 0L) {
                    long m1 = op1Mantissa.AsInt64();
                    long m2 = op2Mantissa.AsInt64();
                    if (m2 <= Long.MAX_VALUE - m1) {
                        retval = this.helper.CreateNewWithFlagsFastInt(FastIntegerFixed.FromLong(m1 += m2), resultExponent, negflag);
                        haveRetval = true;
                    }
                } else if (ediffLong < (long)ValueTenPowers64.length && radix == 10) {
                    long power = ValueTenPowers64[(int)ediffLong];
                    long maxoverflow = OverflowMaxes64[(int)ediffLong];
                    if (expcmp > 0L) {
                        long m1 = op1Mantissa.AsInt64();
                        long m2 = op2Mantissa.AsInt64();
                        if (m1 == 0L) {
                            retval = this.helper.CreateNewWithFlagsFastInt(op2Mantissa, op2Exponent, otherFlags);
                        } else if (m1 <= maxoverflow && m2 <= Long.MAX_VALUE - (m1 *= power)) {
                            retval = this.helper.CreateNewWithFlagsFastInt(FastIntegerFixed.FromLong(m1 += m2), resultExponent, negflag);
                            haveRetval = true;
                        }
                    } else {
                        long m1 = op1Mantissa.AsInt64();
                        long m2 = op2Mantissa.AsInt64();
                        if (m2 == 0L) {
                            retval = this.helper.CreateNewWithFlagsFastInt(op1Mantissa, op1Exponent, thisFlags);
                        }
                        if (m2 <= maxoverflow && m1 <= Long.MAX_VALUE - (m2 *= power)) {
                            retval = this.helper.CreateNewWithFlagsFastInt(FastIntegerFixed.FromLong(m2 += m1), resultExponent, negflag);
                            haveRetval = true;
                        }
                    }
                } else if (ediffLong < (long)BitMasks64.length && radix == 2) {
                    long mask = BitMasks64[(int)ediffLong];
                    if (expcmp > 0L) {
                        long m1 = op1Mantissa.AsInt64();
                        long m2 = op2Mantissa.AsInt64();
                        if (m1 == 0L) {
                            retval = this.helper.CreateNewWithFlagsFastInt(op2Mantissa, op2Exponent, otherFlags);
                        } else if ((m1 & mask) == m1 && m2 <= Long.MAX_VALUE - (m1 <<= (int)ediffLong)) {
                            retval = this.helper.CreateNewWithFlagsFastInt(FastIntegerFixed.FromLong(m1 += m2), resultExponent, negflag);
                            haveRetval = true;
                        }
                    } else {
                        long m1 = op1Mantissa.AsInt64();
                        long m2 = op2Mantissa.AsInt64();
                        if (m2 == 0L) {
                            retval = this.helper.CreateNewWithFlagsFastInt(op1Mantissa, op1Exponent, thisFlags);
                        } else if ((m2 & mask) == m2 && m1 <= Long.MAX_VALUE - (m2 <<= (int)ediffLong)) {
                            retval = this.helper.CreateNewWithFlagsFastInt(FastIntegerFixed.FromLong(m2 += m1), resultExponent, negflag);
                            haveRetval = true;
                        }
                    }
                }
            }
            if (haveRetval) {
                if (!RadixMath.IsNullOrSimpleContext(ctx)) {
                    retval = this.RoundToPrecision(retval, ctx);
                }
                return retval;
            }
        }
        if ((thisFlags & 1) != 0 && (otherFlags & 1) == 0) {
            FastIntegerFixed fftmp = op1Exponent;
            op1Exponent = op2Exponent;
            op2Exponent = fftmp;
            fftmp = op1Mantissa;
            op1Mantissa = op2Mantissa;
            op2Mantissa = fftmp;
            int tmp = thisFlags;
            thisFlags = otherFlags;
            otherFlags = tmp;
            FastIntegerFixed fastIntegerFixed = resultExponent = (expcmp = -expcmp) < 0L ? op1Exponent : op2Exponent;
        }
        if ((expcmp == 0L || op1Exponent.CanFitInInt64() && op2Exponent.CanFitInInt64()) && op1Mantissa.CanFitInInt64() && op2Mantissa.CanFitInInt64() && (thisFlags & 1) == 0 && (otherFlags & 1) != 0 && !op2Mantissa.isValueZero() && !op1Mantissa.isValueZero()) {
            long e1long = 0L;
            long e2long = 0L;
            long result = 0L;
            if (expcmp != 0L) {
                e1long = op1Exponent.AsInt64();
                e2long = op2Exponent.AsInt64();
            }
            boolean haveRetval = false;
            if (expcmp == 0L || e1long >= -4611686018427387902L && e1long <= 0x3FFFFFFFFFFFFFFEL && e2long >= -4611686018427387902L && e2long <= 0x3FFFFFFFFFFFFFFEL) {
                long ediffLong = expcmp == 0L ? 0L : (e1long > e2long ? e1long - e2long : e2long - e1long);
                int radix = this.thisRadix;
                if (expcmp == 0L) {
                    long m1 = op1Mantissa.AsInt64();
                    long m2 = op2Mantissa.AsInt64();
                    if (Long.MIN_VALUE + m2 <= m1 && m1 >= m2) {
                        result = m1 -= m2;
                        retval = this.helper.CreateNewWithFlagsFastInt(FastIntegerFixed.FromLong(m1), resultExponent, 0);
                        haveRetval = true;
                    }
                } else if (radix == 10 && ediffLong < (long)ValueTenPowers64.length) {
                    long power = ValueTenPowers64[(int)ediffLong];
                    long maxoverflow = OverflowMaxes64[(int)ediffLong];
                    long m1 = op1Mantissa.AsInt64();
                    long m2 = op2Mantissa.AsInt64();
                    boolean negbit = false;
                    boolean multed = false;
                    if (expcmp < 0L) {
                        if (m2 <= maxoverflow) {
                            m2 *= power;
                            multed = true;
                        }
                    } else if (m1 <= maxoverflow) {
                        m1 *= power;
                        multed = true;
                    }
                    if (multed && Long.MIN_VALUE + m2 <= m1 && (m1 -= m2) != Long.MIN_VALUE) {
                        negbit = m1 < 0L;
                        result = Math.abs(m1);
                        retval = this.helper.CreateNewWithFlagsFastInt(FastIntegerFixed.FromLong(result), resultExponent, negbit ? 1 : 0);
                        haveRetval = true;
                    }
                }
            }
            if (haveRetval && result != 0L) {
                if (!RadixMath.IsNullOrSimpleContext(ctx)) {
                    retval = this.RoundToPrecision(retval, ctx);
                }
                return retval;
            }
        }
        return null;
    }

    @Override
    public T AddEx(T thisValue, T other, EContext ctx, boolean roundToOperandPrecision) {
        int otherFlags;
        int thisFlags = this.helper.GetFlags(thisValue);
        if (((thisFlags | (otherFlags = this.helper.GetFlags(other))) & 0xE) != 0) {
            T result = this.HandleNotANumber(thisValue, other, ctx);
            if (result != null) {
                return result;
            }
            if ((thisFlags & 2) != 0) {
                if ((otherFlags & 2) != 0 && (thisFlags & 1) != (otherFlags & 1)) {
                    return this.SignalInvalid(ctx);
                }
                return thisValue;
            }
            if ((otherFlags & 2) != 0) {
                return other;
            }
        }
        FastIntegerFixed op1Exponent = this.helper.GetExponentFastInt(thisValue);
        FastIntegerFixed op2Exponent = this.helper.GetExponentFastInt(other);
        FastIntegerFixed op1Mantissa = this.helper.GetMantissaFastInt(thisValue);
        FastIntegerFixed op2Mantissa = this.helper.GetMantissaFastInt(other);
        int expcmp = op1Exponent.compareTo(op2Exponent);
        FastIntegerFixed resultExponent = expcmp < 0 ? op1Exponent : op2Exponent;
        T retval = null;
        if ((thisFlags & 1) == 0 && (otherFlags & 1) == 0) {
            if (expcmp < 0 && op2Mantissa.isValueZero()) {
                return RadixMath.IsNullOrSimpleContext(ctx) ? thisValue : this.RoundToPrecision(thisValue, ctx);
            }
            if (expcmp >= 0 && op1Mantissa.isValueZero()) {
                return RadixMath.IsNullOrSimpleContext(ctx) ? other : this.RoundToPrecision(other, ctx);
            }
        }
        if (!roundToOperandPrecision) {
            retval = this.AddEx32Bit(expcmp, op1Exponent, op1Mantissa, op2Exponent, op2Mantissa, resultExponent, thisFlags, otherFlags, ctx);
            if (retval != null) {
                return retval;
            }
            retval = this.AddEx64Bit(expcmp, op1Exponent, op1Mantissa, op2Exponent, op2Mantissa, resultExponent, thisFlags, otherFlags, ctx);
            if (retval != null) {
                return retval;
            }
        }
        if (expcmp == 0) {
            retval = this.AddCore2(op1Mantissa, op2Mantissa, op1Exponent, thisFlags, otherFlags, ctx);
            if (!RadixMath.IsNullOrSimpleContext(ctx)) {
                retval = this.RoundToPrecision(retval, ctx);
            }
        } else {
            retval = this.AddExDiffExp(thisValue, other, thisFlags, otherFlags, ctx, expcmp, roundToOperandPrecision);
        }
        return retval;
    }

    @Override
    public int compareTo(T thisValue, T otherValue) {
        int otherFlags;
        if (otherValue == null) {
            return 1;
        }
        int thisFlags = this.helper.GetFlags(thisValue);
        if (((thisFlags | (otherFlags = this.helper.GetFlags(otherValue))) & 0xE) != 0) {
            return RadixMath.CompareToHandleSpecial2(thisValue, otherValue, thisFlags, otherFlags);
        }
        return RadixMath.CompareToInternal(thisValue, otherValue, true, this.helper);
    }

    @Override
    public T CompareToWithContext(T thisValue, T otherValue, boolean treatQuietNansAsSignaling, EContext ctx) {
        if (otherValue == null) {
            return this.SignalInvalid(ctx);
        }
        T result = this.CompareToHandleSpecial(thisValue, otherValue, treatQuietNansAsSignaling, ctx);
        if (result != null) {
            return result;
        }
        int cmp = RadixMath.CompareToInternal(thisValue, otherValue, false, this.helper);
        return cmp == -2 ? this.SignalInvalidWithMessage(ctx, "Out of memory ") : this.ValueOf(this.compareTo(thisValue, otherValue), null);
    }

    @Override
    public T Divide(T thisValue, T divisor, EContext ctx) {
        return this.DivideInternal(thisValue, divisor, ctx, 0, EInteger.FromInt32(0));
    }

    @Override
    public T DivideToExponent(T thisValue, T divisor, EInteger desiredExponent, EContext ctx) {
        if (ctx != null && !ctx.ExponentWithinRange(desiredExponent)) {
            return this.SignalInvalidWithMessage(ctx, "Exponent not within exponent range: " + desiredExponent);
        }
        EContext ctx2 = ctx == null ? EContext.ForRounding(ERounding.HalfDown) : ctx.WithUnlimitedExponents().WithPrecision(0);
        T ret = this.DivideInternal(thisValue, divisor, ctx2, 1, desiredExponent);
        if (!ctx2.getHasMaxPrecision() && this.IsFinite(ret)) {
            ret = this.Quantize(ret, ret, ctx2);
            if ((ctx2.getFlags() & 0x40) != 0) {
                ctx2.setFlags(64);
            }
        }
        if (ctx != null && ctx.getHasFlags()) {
            ctx.setFlags(ctx.getFlags() | ctx2.getFlags());
        }
        return ret;
    }

    @Override
    public T DivideToIntegerNaturalScale(T thisValue, T divisor, EContext ctx) {
        FastInteger desiredScale = FastInteger.FromBig(this.helper.GetExponent(thisValue)).SubtractBig(this.helper.GetExponent(divisor));
        EContext ctx2 = EContext.ForRounding(ERounding.Down).WithBigPrecision(ctx == null ? EInteger.FromInt32(0) : ctx.getPrecision()).WithBlankFlags();
        T ret = this.DivideInternal(thisValue, divisor, ctx2, 1, EInteger.FromInt32(0));
        if ((ctx2.getFlags() & 0xC0) != 0) {
            if (ctx != null && ctx.getHasFlags()) {
                ctx.setFlags(ctx.getFlags() | 0xC0);
            }
            return ret;
        }
        boolean neg = this.helper.GetSign(thisValue) < 0 ^ this.helper.GetSign(divisor) < 0;
        if (this.helper.GetMantissa(ret).isZero()) {
            EInteger dividendExp = this.helper.GetExponent(thisValue);
            EInteger divisorExp = this.helper.GetExponent(divisor);
            ret = this.helper.CreateNewWithFlags(EInteger.FromInt32(0), dividendExp.Subtract(divisorExp), this.helper.GetFlags(ret));
        } else if (desiredScale.signum() < 0) {
            desiredScale.Negate();
            EInteger bigmantissa = this.helper.GetMantissa(ret);
            bigmantissa = this.TryMultiplyByRadixPower(bigmantissa, desiredScale);
            if (bigmantissa == null) {
                return this.SignalInvalidWithMessage(ctx, "Result requires too much memory");
            }
            EInteger exponentDivisor = this.helper.GetExponent(divisor);
            ret = this.helper.CreateNewWithFlags(bigmantissa, this.helper.GetExponent(thisValue).Subtract(exponentDivisor), this.helper.GetFlags(ret));
        } else if (desiredScale.signum() > 0) {
            EInteger bigmantissa = this.helper.GetMantissa(ret);
            FastInteger fastexponent = FastInteger.FromBig(this.helper.GetExponent(ret));
            EInteger bigradix = EInteger.FromInt32(this.thisRadix);
            while (desiredScale.compareTo(fastexponent) != 0) {
                EInteger[] divrem = bigmantissa.DivRem(bigradix);
                EInteger bigquo = divrem[0];
                EInteger bigrem = divrem[1];
                if (!bigrem.isZero()) break;
                bigmantissa = bigquo;
                fastexponent.Increment();
            }
            ret = this.helper.CreateNewWithFlags(bigmantissa, fastexponent.AsEInteger(), this.helper.GetFlags(ret));
        }
        if (ctx != null) {
            ret = this.RoundToPrecision(ret, ctx);
        }
        ret = this.EnsureSign(ret, neg);
        return ret;
    }

    @Override
    public T DivideToIntegerZeroScale(T thisValue, T divisor, EContext ctx) {
        EContext ctx2 = EContext.ForRounding(ERounding.Down).WithBigPrecision(ctx == null ? EInteger.FromInt32(0) : ctx.getPrecision()).WithBlankFlags();
        T ret = this.DivideInternal(thisValue, divisor, ctx2, 1, EInteger.FromInt32(0));
        if ((ctx2.getFlags() & 0xC0) != 0) {
            if (ctx.getHasFlags()) {
                ctx.setFlags(ctx.getFlags() | ctx2.getFlags() & 0xC0);
            }
            return ret;
        }
        if (ctx != null) {
            ctx2 = ctx.WithBlankFlags().WithUnlimitedExponents();
            ret = this.RoundToPrecision(ret, ctx2);
            if ((ctx2.getFlags() & 2) != 0) {
                return this.SignalInvalid(ctx);
            }
        }
        return ret;
    }

    @Override
    public T Exp(T thisValue, EContext ctx) {
        if (ctx == null) {
            return this.SignalInvalidWithMessage(ctx, "ctx is null");
        }
        if (!ctx.getHasMaxPrecision()) {
            return this.SignalInvalidWithMessage(ctx, "ctx has unlimited precision");
        }
        int flags = this.helper.GetFlags(thisValue);
        if ((flags & 8) != 0) {
            return this.SignalingNaNInvalid(thisValue, ctx);
        }
        if ((flags & 4) != 0) {
            return this.ReturnQuietNaN(thisValue, ctx);
        }
        EContext ctxCopy = ctx.WithBlankFlags();
        if ((flags & 2) != 0) {
            if ((flags & 1) != 0) {
                T retval = this.helper.CreateNewWithFlags(EInteger.FromInt32(0), EInteger.FromInt32(0), 0);
                retval = this.RoundToPrecision(retval, ctxCopy);
                if (ctx.getHasFlags()) {
                    ctx.setFlags(ctx.getFlags() | ctxCopy.getFlags());
                }
                return retval;
            }
            return thisValue;
        }
        int sign = this.helper.GetSign(thisValue);
        T one = this.helper.ValueOf(1);
        EInteger guardDigits = this.thisRadix == 2 ? ctx.getPrecision().Add(10) : EInteger.FromInt32(10);
        EContext ctxdiv = RadixMath.SetPrecisionIfLimited(ctx, ctx.getPrecision().Add(guardDigits)).WithRounding(ERounding.OddOrZeroFiveUp).WithBlankFlags();
        if (sign == 0) {
            thisValue = this.RoundToPrecision(one, ctxCopy);
        } else if (sign > 0 && this.compareTo(thisValue, one) <= 0) {
            thisValue = this.ExpInternal(thisValue, ctxdiv.getPrecision(), ctxCopy);
            if (ctx.getHasFlags()) {
                ctx.setFlags(ctx.getFlags() | 3);
            }
        } else if (sign < 0) {
            T val = this.Exp(this.NegateRaw(thisValue), ctxdiv);
            if ((ctxdiv.getFlags() & 0x10) != 0 || !this.IsFinite(val)) {
                ctxdiv.setFlags(0);
                EInteger newMax = ctx.getEMax();
                EInteger expdiff = ctx.getEMin();
                expdiff = newMax.Subtract(expdiff);
                newMax = newMax.Add(expdiff);
                ctxdiv = ctxdiv.WithBigExponentRange(ctxdiv.getEMin(), newMax);
                thisValue = this.Exp(this.NegateRaw(thisValue), ctxdiv);
                if ((ctxdiv.getFlags() & 0x10) != 0) {
                    if (ctx.getHasFlags()) {
                        ctx.setFlags(ctx.getFlags() | 0xF);
                    }
                    EInteger ctxdivPrec = ctxdiv.getPrecision();
                    newMax = ctx.getEMin();
                    if (ctx.getAdjustExponent()) {
                        newMax = newMax.Subtract(ctxdivPrec);
                        newMax = newMax.Add(EInteger.FromInt32(1));
                    }
                    thisValue = this.helper.CreateNewWithFlags(EInteger.FromInt32(0), newMax, 0);
                    return this.RoundToPrecisionInternal(thisValue, 0, 1, null, false, ctx);
                }
            } else {
                thisValue = val;
            }
            thisValue = this.Divide(one, thisValue, ctxCopy);
            if (ctx.getHasFlags()) {
                ctx.setFlags(ctx.getFlags() | 3);
            }
        } else {
            Object intpart = null;
            boolean haveIntPart = false;
            if (this.compareTo(thisValue, this.helper.ValueOf(50000)) > 0 && ctx.getHasExponentRange()) {
                this.PowerIntegral(this.helper.ValueOf(2), EInteger.FromInt64(50000L), ctxCopy);
                if ((ctxCopy.getFlags() & 0x10) != 0) {
                    return this.SignalOverflow(ctx, false);
                }
                intpart = this.Quantize(thisValue, one, EContext.ForRounding(ERounding.Down));
                if (!this.GetHelper().GetExponent(intpart).isZero()) {
                    throw new IllegalArgumentException("integer part not zero, as expected");
                }
                haveIntPart = true;
                ctxCopy.setFlags(0);
                this.PowerIntegral(this.helper.ValueOf(2), this.helper.GetMantissa(intpart), ctxCopy);
                if ((ctxCopy.getFlags() & 0x10) != 0) {
                    return this.SignalOverflow(ctx, false);
                }
                ctxCopy.setFlags(0);
            }
            if (!haveIntPart) {
                intpart = this.Quantize(thisValue, one, EContext.ForRounding(ERounding.Down));
                if (!this.GetHelper().GetExponent(intpart).isZero()) {
                    throw new IllegalArgumentException("integer part not zero, as expected");
                }
            }
            T fracpart = this.Add(thisValue, this.NegateRaw(intpart), null);
            ctxdiv = RadixMath.SetPrecisionIfLimited(ctxdiv, ctxdiv.getPrecision().Add(guardDigits)).WithBlankFlags();
            fracpart = this.Add(one, this.Divide(fracpart, intpart, ctxdiv), null);
            ctxdiv.setFlags(0);
            EInteger workingPrec = ctxdiv.getPrecision();
            workingPrec = workingPrec.Add(EInteger.FromInt64(17L));
            thisValue = this.ExpInternal(fracpart, workingPrec, ctxdiv);
            if ((ctxdiv.getFlags() & 8) != 0 && ctx.getHasFlags()) {
                ctx.setFlags(ctx.getFlags() | ctxdiv.getFlags());
            }
            if (ctx.getHasFlags()) {
                ctx.setFlags(ctx.getFlags() | 3);
            }
            thisValue = this.PowerIntegral(thisValue, this.helper.GetMantissa(intpart), ctxCopy);
        }
        if (ctx.getHasFlags()) {
            ctx.setFlags(ctx.getFlags() | ctxCopy.getFlags());
        }
        return thisValue;
    }

    @Override
    public IRadixMathHelper<T> GetHelper() {
        return this.helper;
    }

    @Override
    public T Ln(T thisValue, EContext ctx) {
        if (ctx == null) {
            return this.SignalInvalidWithMessage(ctx, "ctx is null");
        }
        if (!ctx.getHasMaxPrecision()) {
            return this.SignalInvalidWithMessage(ctx, "ctx has unlimited precision");
        }
        int flags = this.helper.GetFlags(thisValue);
        if ((flags & 8) != 0) {
            return this.SignalingNaNInvalid(thisValue, ctx);
        }
        if ((flags & 4) != 0) {
            return this.ReturnQuietNaN(thisValue, ctx);
        }
        int sign = this.helper.GetSign(thisValue);
        if (sign < 0) {
            return this.SignalInvalid(ctx);
        }
        if ((flags & 2) != 0) {
            return thisValue;
        }
        EContext ctxCopy = ctx.WithBlankFlags();
        T one = this.helper.ValueOf(1);
        if (sign == 0) {
            return this.helper.CreateNewWithFlags(EInteger.FromInt32(0), EInteger.FromInt32(0), 3);
        }
        int cmpOne = this.compareTo(thisValue, one);
        EContext ctxdiv = null;
        if (cmpOne == 0) {
            thisValue = this.RoundToPrecision(this.helper.CreateNewWithFlags(EInteger.FromInt32(0), EInteger.FromInt32(0), 0), ctxCopy);
        } else if (cmpOne < 0) {
            FastInteger error = new FastInteger(10);
            EInteger bigError = error.AsEInteger();
            ctxdiv = RadixMath.SetPrecisionIfLimited(ctx, ctx.getPrecision().Add(bigError)).WithRounding(ERounding.OddOrZeroFiveUp).WithBlankFlags();
            T quarter = this.Divide(one, this.helper.ValueOf(4), ctxCopy);
            if (this.compareTo(thisValue, quarter) <= 0) {
                T half = this.Multiply(quarter, this.helper.ValueOf(2), null);
                FastInteger roots = new FastInteger(0);
                while (this.compareTo(thisValue, half) < 0) {
                    thisValue = this.SquareRoot(thisValue, ctxdiv.WithUnlimitedExponents());
                    roots.Increment();
                }
                thisValue = this.LnInternal(thisValue, ctxdiv.getPrecision(), ctxdiv);
                EInteger bigintRoots = RadixMath.PowerOfTwo(roots);
                thisValue = this.Multiply(thisValue, this.helper.CreateNewWithFlags(bigintRoots, EInteger.FromInt32(0), 0), ctxCopy);
            } else {
                T smallfrac = this.Divide(one, this.helper.ValueOf(16), ctxdiv);
                T closeToOne = this.Add(one, this.NegateRaw(smallfrac), null);
                if (this.compareTo(thisValue, closeToOne) >= 0) {
                    error = this.helper.GetDigitLength(this.helper.GetMantissa(thisValue));
                    error = error.Copy();
                    error.AddInt(6);
                    error.AddBig(ctx.getPrecision());
                    bigError = error.AsEInteger();
                    thisValue = this.LnInternalCloseToOne(thisValue, error.AsEInteger(), ctxCopy);
                } else {
                    thisValue = this.LnInternal(thisValue, ctxdiv.getPrecision(), ctxCopy);
                }
            }
            if (ctx.getHasFlags()) {
                ctxCopy.setFlags(ctxCopy.getFlags() | 1);
                ctxCopy.setFlags(ctxCopy.getFlags() | 2);
            }
        } else {
            T two = this.helper.ValueOf(2);
            if (this.compareTo(thisValue, two) >= 0) {
                FastInteger roots = new FastInteger(0);
                FastInteger error = new FastInteger(10);
                EInteger bigError = error.AsEInteger();
                ctxdiv = RadixMath.SetPrecisionIfLimited(ctx, ctx.getPrecision().Add(bigError)).WithRounding(ERounding.OddOrZeroFiveUp).WithBlankFlags();
                T smallfrac = ctxdiv.getPrecision().compareTo(400) > 0 ? this.Divide(one, this.helper.ValueOf(1000000), ctxdiv) : this.Divide(one, this.helper.ValueOf(20), ctxdiv);
                T closeToOne = this.Add(one, smallfrac, null);
                while (this.compareTo(thisValue, closeToOne) >= 0) {
                    thisValue = this.SquareRoot(thisValue, ctxdiv.WithUnlimitedExponents());
                    roots.Increment();
                }
                thisValue = this.Divide(one, thisValue, ctxdiv);
                thisValue = this.LnInternalCloseToOne(thisValue, ctxdiv.getPrecision(), ctxdiv);
                thisValue = this.NegateRaw(thisValue);
                EInteger bigintRoots = RadixMath.PowerOfTwo(roots);
                T ei2 = this.Multiply(thisValue, this.helper.CreateNewWithFlags(bigintRoots, EInteger.FromInt32(0), 0), ctxdiv);
                T ei3 = this.Multiply(thisValue, this.helper.CreateNewWithFlags(bigintRoots, EInteger.FromInt32(0), 0), ctxCopy.WithRounding(ERounding.HalfEven));
                thisValue = this.Multiply(thisValue, this.helper.CreateNewWithFlags(bigintRoots, EInteger.FromInt32(0), 0), ctxCopy);
            } else {
                FastInteger error = new FastInteger(10);
                EInteger bigError = error.AsEInteger();
                ctxdiv = RadixMath.SetPrecisionIfLimited(ctx, ctx.getPrecision().Add(bigError)).WithRounding(ERounding.OddOrZeroFiveUp).WithBlankFlags();
                T smallfrac = this.Divide(one, this.helper.ValueOf(16), ctxdiv);
                T closeToOne = this.Add(one, smallfrac, null);
                if (this.compareTo(thisValue, closeToOne) < 0) {
                    error = this.helper.GetDigitLength(this.helper.GetMantissa(thisValue));
                    error = error.Copy();
                    error.AddInt(6);
                    error.AddBig(ctx.getPrecision());
                    bigError = error.AsEInteger();
                    thisValue = this.LnInternalCloseToOne(thisValue, error.AsEInteger(), ctxCopy);
                } else {
                    thisValue = this.Divide(one, thisValue, ctxdiv);
                    thisValue = this.LnInternal(thisValue, ctxdiv.getPrecision(), ctxCopy);
                    thisValue = this.NegateRaw(thisValue);
                }
            }
            if (ctx.getHasFlags()) {
                ctxCopy.setFlags(ctxCopy.getFlags() | 1);
                ctxCopy.setFlags(ctxCopy.getFlags() | 2);
            }
        }
        if (ctx.getHasFlags()) {
            ctx.setFlags(ctx.getFlags() | ctxCopy.getFlags());
        }
        return thisValue;
    }

    @Override
    public T Log10(T thisValue, EContext ctx) {
        if (ctx == null) {
            return this.SignalInvalidWithMessage(ctx, "ctx is null");
        }
        if (!ctx.getHasMaxPrecision()) {
            return this.SignalInvalidWithMessage(ctx, "ctx has unlimited precision");
        }
        int flags = this.helper.GetFlags(thisValue);
        if ((flags & 8) != 0) {
            return this.SignalingNaNInvalid(thisValue, ctx);
        }
        if ((flags & 4) != 0) {
            return this.ReturnQuietNaN(thisValue, ctx);
        }
        int sign = this.helper.GetSign(thisValue);
        if (sign < 0) {
            return this.SignalInvalid(ctx);
        }
        if ((flags & 2) != 0) {
            return thisValue;
        }
        EContext ctxCopy = ctx.WithBlankFlags();
        T one = this.helper.ValueOf(1);
        if (sign == 0) {
            thisValue = this.RoundToPrecision(this.helper.CreateNewWithFlags(EInteger.FromInt32(0), EInteger.FromInt32(0), 3), ctxCopy);
        } else if (this.compareTo(thisValue, one) == 0) {
            thisValue = this.RoundToPrecision(this.helper.CreateNewWithFlags(EInteger.FromInt32(0), EInteger.FromInt32(0), 0), ctxCopy);
        } else {
            EInteger exp = this.helper.GetExponent(thisValue);
            EInteger mant = this.helper.GetMantissa(thisValue);
            if (mant.equals(EInteger.FromInt32(1)) && this.thisRadix == 10) {
                thisValue = this.helper.CreateNewWithFlags(exp.Abs(), EInteger.FromInt32(0), exp.signum() < 0 ? 1 : 0);
                thisValue = this.RoundToPrecision(thisValue, ctxCopy);
            } else {
                EInteger mantissa = this.helper.GetMantissa(thisValue);
                FastInteger expTmp = FastInteger.FromBig(exp);
                EInteger tenBig = EInteger.FromInt32(10);
                while (true) {
                    EInteger[] divrem = mantissa.DivRem(tenBig);
                    EInteger bigquo = divrem[0];
                    EInteger bigrem = divrem[1];
                    if (!bigrem.isZero()) break;
                    mantissa = bigquo;
                    expTmp.Increment();
                }
                if (mantissa.compareTo(EInteger.FromInt32(1)) == 0 && (this.thisRadix == 10 || expTmp.signum() == 0 || exp.isZero())) {
                    thisValue = this.helper.CreateNewWithFlags(expTmp.AsEInteger().Abs(), EInteger.FromInt32(0), expTmp.signum() < 0 ? 1 : 0);
                    thisValue = this.RoundToPrecision(thisValue, ctxCopy);
                } else {
                    EContext ctxdiv = RadixMath.SetPrecisionIfLimited(ctx, ctx.getPrecision().Add(EInteger.FromInt32(10))).WithRounding(ERounding.OddOrZeroFiveUp).WithBlankFlags().WithUnlimitedExponents();
                    T logNatural = this.Ln(thisValue, ctxdiv);
                    T logTen = this.LnTenConstant(ctxdiv);
                    thisValue = this.Divide(logNatural, logTen, ctx);
                    if (ctx.getHasFlags()) {
                        ctx.setFlags(ctx.getFlags() | 3);
                    }
                }
            }
        }
        if (ctx.getHasFlags()) {
            ctx.setFlags(ctx.getFlags() | ctxCopy.getFlags());
        }
        return thisValue;
    }

    @Override
    public T Max(T a, T b, EContext ctx) {
        if (a == null) {
            throw new NullPointerException("a");
        }
        if (b == null) {
            throw new NullPointerException("b");
        }
        T result = this.MinMaxHandleSpecial(a, b, ctx, false, false);
        if (result != null) {
            return result;
        }
        int cmp = this.compareTo(a, b);
        if (cmp != 0) {
            return cmp < 0 ? this.RoundToPrecision(b, ctx) : this.RoundToPrecision(a, ctx);
        }
        int flagNegA = this.helper.GetFlags(a) & 1;
        return flagNegA != (this.helper.GetFlags(b) & 1) ? (flagNegA != 0 ? this.RoundToPrecision(b, ctx) : this.RoundToPrecision(a, ctx)) : (flagNegA == 0 ? (this.helper.GetExponent(a).compareTo(this.helper.GetExponent(b)) > 0 ? this.RoundToPrecision(a, ctx) : this.RoundToPrecision(b, ctx)) : (this.helper.GetExponent(a).compareTo(this.helper.GetExponent(b)) > 0 ? this.RoundToPrecision(b, ctx) : this.RoundToPrecision(a, ctx)));
    }

    @Override
    public T MaxMagnitude(T a, T b, EContext ctx) {
        if (a == null) {
            throw new NullPointerException("a");
        }
        if (b == null) {
            throw new NullPointerException("b");
        }
        T result = this.MinMaxHandleSpecial(a, b, ctx, false, true);
        if (result != null) {
            return result;
        }
        int cmp = this.compareTo(this.AbsRaw(a), this.AbsRaw(b));
        return cmp == 0 ? this.Max(a, b, ctx) : (cmp > 0 ? this.RoundToPrecision(a, ctx) : this.RoundToPrecision(b, ctx));
    }

    @Override
    public T Min(T a, T b, EContext ctx) {
        if (a == null) {
            throw new NullPointerException("a");
        }
        if (b == null) {
            throw new NullPointerException("b");
        }
        T result = this.MinMaxHandleSpecial(a, b, ctx, true, false);
        if (result != null) {
            return result;
        }
        int cmp = this.compareTo(a, b);
        if (cmp != 0) {
            return cmp > 0 ? this.RoundToPrecision(b, ctx) : this.RoundToPrecision(a, ctx);
        }
        int signANeg = this.helper.GetFlags(a) & 1;
        return signANeg != (this.helper.GetFlags(b) & 1) ? (signANeg != 0 ? this.RoundToPrecision(a, ctx) : this.RoundToPrecision(b, ctx)) : (signANeg == 0 ? (this.helper.GetExponent(a).compareTo(this.helper.GetExponent(b)) > 0 ? this.RoundToPrecision(b, ctx) : this.RoundToPrecision(a, ctx)) : (this.helper.GetExponent(a).compareTo(this.helper.GetExponent(b)) > 0 ? this.RoundToPrecision(a, ctx) : this.RoundToPrecision(b, ctx)));
    }

    @Override
    public T MinMagnitude(T a, T b, EContext ctx) {
        if (a == null) {
            throw new NullPointerException("a");
        }
        if (b == null) {
            throw new NullPointerException("b");
        }
        T result = this.MinMaxHandleSpecial(a, b, ctx, true, true);
        if (result != null) {
            return result;
        }
        int cmp = this.compareTo(this.AbsRaw(a), this.AbsRaw(b));
        return cmp == 0 ? this.Min(a, b, ctx) : (cmp < 0 ? this.RoundToPrecision(a, ctx) : this.RoundToPrecision(b, ctx));
    }

    @Override
    public T Multiply(T thisValue, T other, EContext ctx) {
        int otherFlags;
        int thisFlags = this.helper.GetFlags(thisValue);
        if (((thisFlags | (otherFlags = this.helper.GetFlags(other))) & 0xE) != 0) {
            T result = this.HandleNotANumber(thisValue, other, ctx);
            if (result != null) {
                return result;
            }
            if ((thisFlags & 2) != 0) {
                boolean negflag = (thisFlags & 1) != 0 ^ (otherFlags & 1) != 0;
                return (otherFlags & 0xE) == 0 && this.helper.GetMantissa(other).isZero() ? this.SignalInvalid(ctx) : this.EnsureSign(thisValue, negflag);
            }
            if ((otherFlags & 2) != 0) {
                boolean negflag = (thisFlags & 1) != 0 ^ (otherFlags & 1) != 0;
                return (thisFlags & 0xE) == 0 && this.helper.GetMantissa(thisValue).isZero() ? this.SignalInvalid(ctx) : this.EnsureSign(other, negflag);
            }
        }
        EInteger bigintOp2 = this.helper.GetExponent(other);
        EInteger newexp = this.helper.GetExponent(thisValue).Add(bigintOp2);
        EInteger mantissaOp2 = this.helper.GetMantissa(other);
        thisFlags = thisFlags & 1 ^ otherFlags & 1;
        T ret = this.helper.CreateNewWithFlags(this.helper.GetMantissa(thisValue).Multiply(mantissaOp2), newexp, thisFlags);
        if (ctx != null && ctx != EContext.UnlimitedHalfEven) {
            ret = this.RoundToPrecision(ret, ctx);
        }
        return ret;
    }

    private T RoundIfPossible(T thisValue, EContext ctx) {
        if (this.helper.GetRadix() == 10 && ctx.getHasMaxPrecision()) {
            FastInteger precision;
            int flags = this.helper.GetFlags(thisValue);
            if ((flags & 0xE) != 0) {
                return thisValue;
            }
            EInteger ei = this.helper.GetMantissa(thisValue);
            if (!ei.isEven()) {
                return thisValue;
            }
            FastInteger approxDigitLength = FastInteger.FromBig(ei.GetUnsignedBitLengthAsEInteger().Divide(4));
            if (approxDigitLength.compareTo(precision = FastInteger.FromBig(ctx.getPrecision())) <= 0) {
                return thisValue;
            }
            EContext ctxCopy = ctx.WithBlankFlags();
            T newValue = this.RoundToPrecision(thisValue, ctxCopy);
            if ((ctxCopy.getFlags() & 1) == 0) {
                return newValue;
            }
        }
        return thisValue;
    }

    @Override
    public T MultiplyAndAdd(T thisValue, T multiplicand, T augend, EContext ctx) {
        if (multiplicand == null) {
            throw new NullPointerException("multiplicand");
        }
        if (augend == null) {
            throw new NullPointerException("augend");
        }
        EContext ctx2 = EContext.UnlimitedHalfEven.WithBlankFlags();
        T ret = this.MultiplyAddHandleSpecial(thisValue, multiplicand, augend, ctx);
        if (ret != null) {
            return ret;
        }
        T product = this.Multiply(thisValue, multiplicand, ctx2);
        ret = this.Add(product, augend, ctx);
        if (ctx != null && ctx.getHasFlags()) {
            ctx.setFlags(ctx.getFlags() | ctx2.getFlags());
        }
        return ret;
    }

    @Override
    public T Negate(T value, EContext ctx) {
        int flags = this.helper.GetFlags(value);
        if ((flags & 8) != 0) {
            return this.SignalingNaNInvalid(value, ctx);
        }
        if ((flags & 4) != 0) {
            return this.ReturnQuietNaN(value, ctx);
        }
        EInteger mant = this.helper.GetMantissa(value);
        if ((flags & 2) == 0 && mant.isZero()) {
            boolean nonnegative = (flags & 1) == 0;
            boolean floor = ctx != null && ctx.getRounding() == ERounding.Floor;
            T zero = floor && nonnegative ? this.helper.CreateNewWithFlags(mant, this.helper.GetExponent(value), flags | 1) : this.helper.CreateNewWithFlags(mant, this.helper.GetExponent(value), flags & 0xFFFFFFFE);
            return this.RoundToPrecision(zero, ctx);
        }
        return this.RoundToPrecision(this.helper.CreateNewWithFlags(mant, this.helper.GetExponent(value), flags ^= 1), ctx);
    }

    @Override
    public T NextMinus(T thisValue, EContext ctx) {
        FastInteger bigexp;
        if (ctx == null) {
            return this.SignalInvalidWithMessage(ctx, "ctx is null");
        }
        if (!ctx.getHasMaxPrecision()) {
            return this.SignalInvalidWithMessage(ctx, "ctx has unlimited precision");
        }
        if (!ctx.getHasExponentRange()) {
            return this.SignalInvalidWithMessage(ctx, "doesn't satisfy ctx.getHasExponentRange()");
        }
        int flags = this.helper.GetFlags(thisValue);
        if ((flags & 8) != 0) {
            return this.SignalingNaNInvalid(thisValue, ctx);
        }
        if ((flags & 4) != 0) {
            return this.ReturnQuietNaN(thisValue, ctx);
        }
        if ((flags & 2) != 0) {
            EInteger overflowMant;
            if ((flags & 1) != 0) {
                return thisValue;
            }
            EInteger bigexp2 = ctx.getEMax();
            EInteger bigprec = ctx.getPrecision();
            if (ctx.getAdjustExponent()) {
                bigexp2 = bigexp2.Add(EInteger.FromInt32(1));
                bigexp2 = bigexp2.Subtract(bigprec);
            }
            if ((overflowMant = this.TryMultiplyByRadixPower(EInteger.FromInt32(1), FastInteger.FromBig(ctx.getPrecision()))) == null) {
                return this.SignalInvalidWithMessage(ctx, "Result requires too much memory");
            }
            overflowMant = overflowMant.Subtract(EInteger.FromInt32(1));
            return this.helper.CreateNewWithFlags(overflowMant, bigexp2, 0);
        }
        FastInteger minexp = FastInteger.FromBig(ctx.getEMin());
        if (ctx.getAdjustExponent()) {
            minexp.SubtractBig(ctx.getPrecision()).Increment();
        }
        if ((bigexp = FastInteger.FromBig(this.helper.GetExponent(thisValue))).compareTo(minexp) <= 0) {
            minexp = bigexp.Copy().SubtractInt(2);
        }
        T quantum = this.helper.CreateNewWithFlags(EInteger.FromInt32(1), minexp.AsEInteger(), 1);
        EContext ctx2 = ctx.WithRounding(ERounding.Floor);
        return this.Add(thisValue, quantum, ctx2);
    }

    @Override
    public T NextPlus(T thisValue, EContext ctx) {
        FastInteger bigexp;
        if (ctx == null) {
            return this.SignalInvalidWithMessage(ctx, "ctx is null");
        }
        if (!ctx.getHasMaxPrecision()) {
            return this.SignalInvalidWithMessage(ctx, "ctx has unlimited precision");
        }
        if (!ctx.getHasExponentRange()) {
            return this.SignalInvalidWithMessage(ctx, "doesn't satisfy ctx.getHasExponentRange()");
        }
        int flags = this.helper.GetFlags(thisValue);
        if ((flags & 8) != 0) {
            return this.SignalingNaNInvalid(thisValue, ctx);
        }
        if ((flags & 4) != 0) {
            return this.ReturnQuietNaN(thisValue, ctx);
        }
        if ((flags & 2) != 0) {
            if ((flags & 1) != 0) {
                EInteger overflowMant;
                EInteger bigexp2 = ctx.getEMax();
                EInteger bigprec = ctx.getPrecision();
                if (ctx.getAdjustExponent()) {
                    bigexp2 = bigexp2.Add(EInteger.FromInt32(1));
                    bigexp2 = bigexp2.Subtract(bigprec);
                }
                if ((overflowMant = this.TryMultiplyByRadixPower(EInteger.FromInt32(1), FastInteger.FromBig(ctx.getPrecision()))) == null) {
                    return this.SignalInvalidWithMessage(ctx, "Result requires too much memory");
                }
                overflowMant = overflowMant.Subtract(EInteger.FromInt32(1));
                return this.helper.CreateNewWithFlags(overflowMant, bigexp2, 1);
            }
            return thisValue;
        }
        FastInteger minexp = FastInteger.FromBig(ctx.getEMin());
        if (ctx.getAdjustExponent()) {
            minexp.SubtractBig(ctx.getPrecision()).Increment();
        }
        if ((bigexp = FastInteger.FromBig(this.helper.GetExponent(thisValue))).compareTo(minexp) <= 0) {
            minexp = bigexp.Copy().SubtractInt(2);
        }
        T quantum = this.helper.CreateNewWithFlags(EInteger.FromInt32(1), minexp.AsEInteger(), 0);
        T val = thisValue;
        EContext ctx2 = ctx.WithRounding(ERounding.Ceiling);
        return this.Add(val, quantum, ctx2);
    }

    @Override
    public T NextToward(T thisValue, T otherValue, EContext ctx) {
        FastInteger bigexp;
        T result;
        int otherFlags;
        if (ctx == null) {
            return this.SignalInvalidWithMessage(ctx, "ctx is null");
        }
        if (!ctx.getHasMaxPrecision()) {
            return this.SignalInvalidWithMessage(ctx, "ctx has unlimited precision");
        }
        if (!ctx.getHasExponentRange()) {
            return this.SignalInvalidWithMessage(ctx, "doesn't satisfy ctx.getHasExponentRange()");
        }
        int thisFlags = this.helper.GetFlags(thisValue);
        if (((thisFlags | (otherFlags = this.helper.GetFlags(otherValue))) & 0xE) != 0 && (result = this.HandleNotANumber(thisValue, otherValue, ctx)) != null) {
            return result;
        }
        int cmp = this.compareTo(thisValue, otherValue);
        if (cmp == 0) {
            return this.RoundToPrecision(this.EnsureSign(thisValue, (otherFlags & 1) != 0), ctx.WithNoFlags());
        }
        if ((thisFlags & 2) != 0) {
            EInteger overflowMant;
            if ((thisFlags & 3) == (otherFlags & 3)) {
                return thisValue;
            }
            EInteger bigexp2 = ctx.getEMax();
            EInteger bigprec = ctx.getPrecision();
            if (ctx.getAdjustExponent()) {
                bigexp2 = bigexp2.Add(EInteger.FromInt32(1));
                bigexp2 = bigexp2.Subtract(bigprec);
            }
            if ((overflowMant = this.TryMultiplyByRadixPower(EInteger.FromInt32(1), FastInteger.FromBig(ctx.getPrecision()))) == null) {
                return this.SignalInvalidWithMessage(ctx, "Result requires too much memory");
            }
            overflowMant = overflowMant.Subtract(EInteger.FromInt32(1));
            return this.helper.CreateNewWithFlags(overflowMant, bigexp2, thisFlags & 1);
        }
        FastInteger minexp = FastInteger.FromBig(ctx.getEMin());
        if (ctx.getAdjustExponent()) {
            minexp.SubtractBig(ctx.getPrecision()).Increment();
        }
        if ((bigexp = FastInteger.FromBig(this.helper.GetExponent(thisValue))).compareTo(minexp) < 0) {
            minexp = bigexp.Copy().SubtractInt(2);
        } else {
            minexp.SubtractInt(2);
        }
        T quantum = this.helper.CreateNewWithFlags(EInteger.FromInt32(1), minexp.AsEInteger(), cmp > 0 ? 1 : 0);
        T val = thisValue;
        EContext ctx2 = ctx.WithRounding(cmp > 0 ? ERounding.Floor : ERounding.Ceiling).WithBlankFlags();
        val = this.Add(val, quantum, ctx2);
        if ((ctx2.getFlags() & 0x18) == 0) {
            ctx2.setFlags(0);
        }
        if ((ctx2.getFlags() & 8) != 0) {
            EInteger bigmant = this.helper.GetMantissa(val);
            EInteger maxmant = this.TryMultiplyByRadixPower(EInteger.FromInt32(1), FastInteger.FromBig(ctx.getPrecision()).Decrement());
            if (maxmant == null) {
                return this.SignalInvalidWithMessage(ctx, "Result requires too much memory");
            }
            if (bigmant.compareTo(maxmant) >= 0 || ctx.getPrecision().compareTo(EInteger.FromInt32(1)) == 0) {
                ctx2.setFlags(0);
            }
        }
        if (ctx.getHasFlags()) {
            ctx.setFlags(ctx.getFlags() | ctx2.getFlags());
        }
        return val;
    }

    @Override
    public T Pi(EContext ctx) {
        if (ctx == null) {
            return this.SignalInvalidWithMessage(ctx, "ctx is null");
        }
        if (!ctx.getHasMaxPrecision()) {
            return this.SignalInvalidWithMessage(ctx, "ctx has unlimited precision");
        }
        T a = this.helper.ValueOf(1);
        EContext ctxdiv = RadixMath.SetPrecisionIfLimited(ctx, ctx.getPrecision().Add(EInteger.FromInt32(10))).WithRounding(ERounding.OddOrZeroFiveUp);
        T two = this.helper.ValueOf(2);
        T b = this.Divide(a, this.SquareRoot(two, ctxdiv), ctxdiv);
        T four = this.helper.ValueOf(4);
        T half = (this.thisRadix & 1) == 0 ? (T)this.helper.CreateNewWithFlags(EInteger.FromInt64(this.thisRadix / 2), ValueMinusOne, 0) : null;
        T t = this.Divide(a, four, ctxdiv);
        boolean more = true;
        int lastCompare = 0;
        int vacillations = 0;
        T lastGuess = null;
        T guess = null;
        EInteger powerTwo = EInteger.FromInt32(1);
        while (more) {
            lastGuess = guess;
            T aplusB = this.Add(a, b, null);
            T newA = half == null ? this.Divide(aplusB, two, ctxdiv) : this.Multiply(aplusB, half, null);
            T valueAMinusNewA = this.Add(a, this.NegateRaw(newA), null);
            if (!a.equals(b)) {
                T atimesB = this.Multiply(a, b, ctxdiv);
                b = this.SquareRoot(atimesB, ctxdiv);
            }
            a = newA;
            guess = this.Multiply(aplusB, aplusB, null);
            T newGuess = guess = this.Divide(guess, this.Multiply(t, four, null), ctxdiv);
            if (lastGuess != null) {
                int guessCmp = this.compareTo(lastGuess, newGuess);
                if (guessCmp == 0) {
                    more = false;
                } else if (guessCmp > 0 && lastCompare < 0 || lastCompare > 0 && guessCmp < 0) {
                    more &= ++vacillations <= 3;
                }
                lastCompare = guessCmp;
            }
            if (more) {
                T tmpT = this.Multiply(valueAMinusNewA, valueAMinusNewA, null);
                tmpT = this.Multiply(tmpT, this.helper.CreateNewWithFlags(powerTwo, EInteger.FromInt32(0), 0), null);
                t = this.Add(t, this.NegateRaw(tmpT), ctxdiv);
                powerTwo = powerTwo.ShiftLeft(1);
            }
            guess = newGuess;
        }
        return this.RoundToPrecision(guess, ctx);
    }

    @Override
    public T Plus(T thisValue, EContext context) {
        return this.RoundToPrecisionInternal(thisValue, 0, 0, null, true, context);
    }

    @Override
    public T Power(T thisValue, T pow, EContext ctx) {
        boolean isResultNegative;
        T ret = this.HandleNotANumber(thisValue, pow, ctx);
        if (ret != null) {
            return ret;
        }
        int thisSign = this.helper.GetSign(thisValue);
        int powSign = this.helper.GetSign(pow);
        int thisFlags = this.helper.GetFlags(thisValue);
        int powFlags = this.helper.GetFlags(pow);
        if (thisSign == 0 && powSign == 0) {
            return this.SignalInvalid(ctx);
        }
        if (thisSign < 0 && (powFlags & 2) != 0) {
            return this.SignalInvalid(ctx);
        }
        if (thisSign > 0 && (thisFlags & 2) == 0 && (powFlags & 2) != 0) {
            int cmp = this.compareTo(thisValue, this.helper.ValueOf(1));
            if (cmp < 0) {
                if (powSign < 0) {
                    return this.helper.CreateNewWithFlags(EInteger.FromInt32(0), EInteger.FromInt32(0), 2);
                }
                return this.RoundToPrecision(this.helper.CreateNewWithFlags(EInteger.FromInt32(0), EInteger.FromInt32(0), 0), ctx);
            }
            if (cmp == 0) {
                return this.ExtendPrecision(this.helper.ValueOf(1), ctx);
            }
            if (powSign > 0) {
                return pow;
            }
            return this.RoundToPrecision(this.helper.CreateNewWithFlags(EInteger.FromInt32(0), EInteger.FromInt32(0), 0), ctx);
        }
        EInteger powExponent = this.helper.GetExponent(pow);
        boolean isPowIntegral = powExponent.signum() > 0;
        boolean isPowOdd = false;
        Object powInt = null;
        if (!isPowIntegral) {
            powInt = this.Quantize(pow, this.helper.CreateNewWithFlags(EInteger.FromInt32(0), EInteger.FromInt32(0), 0), EContext.ForRounding(ERounding.Down));
            isPowIntegral = this.compareTo(powInt, pow) == 0;
            isPowOdd = !this.helper.GetMantissa(powInt).isEven();
        } else {
            isPowOdd = powExponent.equals(EInteger.FromInt32(0)) ? !this.helper.GetMantissa(powInt).isEven() : (this.thisRadix % 2 == 0 ? false : !this.helper.GetMantissa(powInt = (Object)this.Quantize(pow, this.helper.CreateNewWithFlags(EInteger.FromInt32(0), EInteger.FromInt32(0), 0), EContext.ForRounding(ERounding.Down))).isEven());
        }
        boolean bl = isResultNegative = (thisFlags & 1) != 0 && (powFlags & 2) == 0 && isPowIntegral && isPowOdd;
        if (thisSign == 0 && powSign != 0) {
            int infinityFlags;
            int n = infinityFlags = powSign < 0 ? 2 : 0;
            if (isResultNegative) {
                infinityFlags |= 1;
            }
            thisValue = this.helper.CreateNewWithFlags(EInteger.FromInt32(0), EInteger.FromInt32(0), infinityFlags);
            if ((infinityFlags & 2) == 0) {
                thisValue = this.RoundToPrecision(thisValue, ctx);
            }
            return thisValue;
        }
        if (!(isPowIntegral && powSign >= 0 || ctx != null && ctx.getHasMaxPrecision())) {
            String ValueOutputMessage = "ctx is null or has unlimited precision, and pow's exponent is not an integer or is negative";
            return this.SignalInvalidWithMessage(ctx, ValueOutputMessage);
        }
        if (thisSign < 0 && !isPowIntegral) {
            return this.SignalInvalid(ctx);
        }
        if ((thisFlags & 2) != 0) {
            int negflag;
            int n = negflag = isResultNegative ? 1 : 0;
            return powSign > 0 ? this.RoundToPrecision(this.helper.CreateNewWithFlags(EInteger.FromInt32(0), EInteger.FromInt32(0), negflag | 2), ctx) : (powSign < 0 ? this.RoundToPrecision(this.helper.CreateNewWithFlags(EInteger.FromInt32(0), EInteger.FromInt32(0), negflag), ctx) : this.RoundToPrecision(this.helper.CreateNewWithFlags(EInteger.FromInt32(1), EInteger.FromInt32(0), 0), ctx));
        }
        if (powSign == 0) {
            return this.RoundToPrecision(this.helper.CreateNewWithFlags(EInteger.FromInt32(1), EInteger.FromInt32(0), 0), ctx);
        }
        if (isPowIntegral) {
            if (this.compareTo(thisValue, this.helper.ValueOf(1)) == 0) {
                EInteger thisExponent = this.helper.GetExponent(thisValue);
                if (thisExponent.signum() == 0) {
                    return !this.IsWithinExponentRangeForPow(pow, ctx) ? this.SignalInvalid(ctx) : this.helper.ValueOf(1);
                }
                if (powExponent.signum() == 0) {
                    if (!this.IsWithinExponentRangeForPow(pow, ctx)) {
                        return this.SignalInvalid(ctx);
                    }
                    EInteger signedMant = this.helper.GetMantissa(powInt).Abs();
                    return this.PowerIntegral(thisValue, signedMant, ctx);
                }
            }
            if (powExponent.compareTo(10) > 0 && this.compareTo(pow, this.helper.ValueOf(99999999)) > 0) {
                EContext ctxCopy = ctx.WithBlankFlags().WithTraps(0);
                T result = this.Power(thisValue, this.helper.ValueOf(isPowOdd ? 99999999 : 99999998), ctxCopy);
                if ((ctxCopy.getFlags() & 0x10) != 0) {
                    if (ctx.getHasFlags()) {
                        ctx.setFlags(ctx.getFlags() | ctxCopy.getFlags());
                    }
                    return result;
                }
            }
            if (powInt == null) {
                powInt = this.Quantize(pow, this.helper.CreateNewWithFlags(EInteger.FromInt32(0), EInteger.FromInt32(0), 0), EContext.ForRounding(ERounding.Down));
            }
            EInteger signedMant = this.helper.GetMantissa(powInt);
            if (powSign < 0) {
                signedMant = signedMant.Negate();
            }
            return this.PowerIntegral(thisValue, signedMant, ctx);
        }
        if (this.compareTo(thisValue, this.helper.ValueOf(1)) == 0 && powSign > 0) {
            return !this.IsWithinExponentRangeForPow(pow, ctx) ? this.SignalInvalid(ctx) : this.ExtendPrecision(this.helper.ValueOf(1), ctx);
        }
        if (this.thisRadix == 10 || this.thisRadix == 2) {
            T half;
            T t = half = this.thisRadix == 10 ? this.helper.CreateNewWithFlags(EInteger.FromInt64(5L), ValueMinusOne, 0) : this.helper.CreateNewWithFlags(EInteger.FromInt32(1), ValueMinusOne, 0);
            if (this.compareTo(pow, half) == 0 && this.IsWithinExponentRangeForPow(pow, ctx) && this.IsWithinExponentRangeForPow(thisValue, ctx)) {
                EContext ctxCopy = ctx.WithBlankFlags();
                thisValue = this.SquareRoot(thisValue, ctxCopy);
                ctxCopy.setFlags(ctxCopy.getFlags() | 1);
                ctxCopy.setFlags(ctxCopy.getFlags() | 2);
                if ((ctxCopy.getFlags() & 4) != 0) {
                    ctxCopy.setFlags(ctxCopy.getFlags() | 8);
                }
                thisValue = this.ExtendPrecision(thisValue, ctxCopy);
                if (ctx.getHasFlags()) {
                    ctx.setFlags(ctx.getFlags() | ctxCopy.getFlags());
                }
                return thisValue;
            }
        }
        int guardDigitCount = this.thisRadix == 2 ? 32 : 10;
        EInteger guardDigits = EInteger.FromInt32(guardDigitCount);
        EContext ctxdiv = RadixMath.SetPrecisionIfLimited(ctx, ctx.getPrecision().Add(guardDigits));
        ctxdiv = ctxdiv.WithRounding(ERounding.OddOrZeroFiveUp).WithBlankFlags();
        T lnresult = this.Ln(thisValue, ctxdiv);
        lnresult = this.Multiply(lnresult, pow, ctxdiv);
        ctxdiv = ctx.WithBlankFlags();
        lnresult = this.Exp(lnresult, ctxdiv);
        if ((ctxdiv.getFlags() & 0x30) != 0) {
            if (!this.IsWithinExponentRangeForPow(thisValue, ctx)) {
                return this.SignalInvalid(ctx);
            }
            if (!this.IsWithinExponentRangeForPow(pow, ctx)) {
                return this.SignalInvalid(ctx);
            }
        }
        if (ctx.getHasFlags()) {
            ctx.setFlags(ctx.getFlags() | ctxdiv.getFlags());
        }
        return lnresult;
    }

    private boolean IsSubnormal(T value, EContext ctx) {
        boolean result;
        boolean flag;
        boolean bl = flag = ctx == null || !ctx.getHasMaxPrecision();
        if (flag) {
            result = false;
        } else {
            FastInteger fastInteger = FastInteger.FromBig(this.helper.GetExponent(value));
            FastInteger val = FastInteger.FromBig(ctx.getEMin());
            boolean adjustExponent = ctx.getAdjustExponent();
            if (adjustExponent) {
                FastInteger digitLength = this.helper.GetDigitLength(this.helper.GetMantissa(value));
                fastInteger.Add(digitLength).SubtractInt(1);
            }
            result = fastInteger.compareTo(val) < 0;
        }
        return result;
    }

    @Override
    public T Quantize(T thisValue, T otherValue, EContext ctx) {
        int otherFlags;
        int thisFlags = this.helper.GetFlags(thisValue);
        if (((thisFlags | (otherFlags = this.helper.GetFlags(otherValue))) & 0xE) != 0) {
            T result = this.HandleNotANumber(thisValue, otherValue, ctx);
            if (result != null) {
                return result;
            }
            if ((thisFlags & otherFlags & 2) != 0) {
                return this.RoundToPrecision(thisValue, ctx);
            }
            return this.SignalInvalid(ctx);
        }
        EInteger expOther = this.helper.GetExponent(otherValue);
        if (ctx != null && !ctx.ExponentWithinRange(expOther)) {
            return this.SignalInvalidWithMessage(ctx, "Exponent not within exponent range: " + expOther);
        }
        EContext tmpctx = (ctx == null ? EContext.ForRounding(ERounding.HalfEven) : ctx.Copy()).WithBlankFlags();
        EInteger mantThis = this.helper.GetMantissa(thisValue);
        EInteger expThis = this.helper.GetExponent(thisValue);
        int expcmp = expThis.compareTo(expOther);
        int negativeFlag = this.helper.GetFlags(thisValue) & 1;
        T ret = null;
        if (expcmp == 0) {
            ret = this.RoundToPrecision(thisValue, tmpctx);
        } else if (mantThis.isZero()) {
            ret = this.helper.CreateNewWithFlags(EInteger.FromInt32(0), expOther, negativeFlag);
            ret = this.RoundToPrecision(ret, tmpctx);
        } else if (expcmp > 0) {
            FastInteger radixPower = FastInteger.FromBig(expThis).SubtractBig(expOther);
            if (tmpctx.getPrecision().signum() > 0 && radixPower.compareTo(FastInteger.FromBig(tmpctx.getPrecision()).AddInt(10)) > 0) {
                return this.SignalInvalidWithMessage(ctx, "Result too high for current precision");
            }
            if ((mantThis = this.TryMultiplyByRadixPower(mantThis, radixPower)) == null) {
                return this.SignalInvalidWithMessage(ctx, "Result requires too much memory");
            }
            ret = this.helper.CreateNewWithFlags(mantThis, expOther, negativeFlag);
            ret = this.RoundToPrecision(ret, tmpctx);
        } else {
            FastInteger shift = FastInteger.FromBig(expOther).SubtractBig(expThis);
            ret = this.RoundToPrecisionInternal(thisValue, 0, 0, shift, false, tmpctx);
        }
        if ((tmpctx.getFlags() & 0x10) != 0) {
            return this.SignalInvalid(ctx);
        }
        if (ret == null || !this.helper.GetExponent(ret).equals(expOther)) {
            return this.SignalInvalid(ctx);
        }
        ret = this.EnsureSign(ret, negativeFlag != 0);
        if (ctx != null && ctx.getHasFlags()) {
            boolean flag12;
            int flags = tmpctx.getFlags();
            flags &= 0xFFFFFFF7;
            boolean bl = flag12 = expcmp < 0 && !this.helper.GetMantissa(ret).isZero() && this.IsSubnormal(ret, ctx);
            if (flag12) {
                flags |= 4;
            }
            ctx.setFlags(ctx.getFlags() | flags);
        }
        return ret;
    }

    @Override
    public T Reduce(T thisValue, EContext ctx) {
        return this.ReduceToPrecisionAndIdealExponent(thisValue, ctx, null, null);
    }

    @Override
    public T Remainder(T thisValue, T divisor, EContext ctx, boolean roundAfterDivide) {
        EContext ctx2 = ctx == null ? null : ctx.WithBlankFlags();
        T ret = this.RemainderHandleSpecial(thisValue, divisor, ctx2);
        if (ret != null) {
            RadixMath.TransferFlags(ctx, ctx2);
            return ret;
        }
        ret = this.DivideToIntegerZeroScale(thisValue, divisor, roundAfterDivide ? ctx2 : null);
        if ((ctx2.getFlags() & 0x40) != 0) {
            return this.SignalInvalid(ctx);
        }
        ret = this.Add(thisValue, this.NegateRaw(this.Multiply(ret, divisor, null)), ctx2);
        ret = this.EnsureSign(ret, (this.helper.GetFlags(thisValue) & 1) != 0);
        RadixMath.TransferFlags(ctx, ctx2);
        return ret;
    }

    @Override
    public T RemainderNear(T thisValue, T divisor, EContext ctx) {
        EContext ctx2 = ctx == null ? EContext.ForRounding(ERounding.HalfEven).WithBlankFlags() : ctx.WithRounding(ERounding.HalfEven).WithBlankFlags();
        T ret = this.RemainderHandleSpecial(thisValue, divisor, ctx2);
        if (ret != null) {
            RadixMath.TransferFlags(ctx, ctx2);
            return ret;
        }
        ret = this.DivideInternal(thisValue, divisor, ctx2, 1, EInteger.FromInt32(0));
        if ((ctx2.getFlags() & 0x40) != 0) {
            return this.SignalInvalid(ctx);
        }
        ctx2 = ctx2.WithBlankFlags();
        ret = this.RoundToPrecision(ret, ctx2);
        if ((ctx2.getFlags() & 0x42) != 0) {
            return this.SignalInvalid(ctx);
        }
        ctx2 = ctx == null ? EContext.UnlimitedHalfEven.WithBlankFlags() : ctx.WithBlankFlags();
        T ret2 = this.Add(thisValue, this.NegateRaw(this.Multiply(ret, divisor, null)), ctx2);
        if ((ctx2.getFlags() & 0x40) != 0) {
            return this.SignalInvalid(ctx);
        }
        if (this.helper.GetFlags(ret2) == 0 && this.helper.GetMantissa(ret2).isZero()) {
            ret2 = this.EnsureSign(ret2, (this.helper.GetFlags(thisValue) & 1) != 0);
        }
        RadixMath.TransferFlags(ctx, ctx2);
        return ret2;
    }

    @Override
    public T RoundAfterConversion(T thisValue, EContext ctx) {
        return this.RoundToPrecision(thisValue, ctx);
    }

    @Override
    public T RoundToExponentExact(T thisValue, EInteger expOther, EContext ctx) {
        if (this.helper.GetExponent(thisValue).compareTo(expOther) >= 0) {
            return this.RoundToPrecision(thisValue, ctx);
        }
        EContext pctx = ctx == null ? null : ctx.WithPrecision(0).WithBlankFlags();
        T ret = this.Quantize(thisValue, this.helper.CreateNewWithFlags(EInteger.FromInt32(1), expOther, 0), pctx);
        if (ctx != null && ctx.getHasFlags()) {
            ctx.setFlags(ctx.getFlags() | pctx.getFlags());
        }
        return ret;
    }

    @Override
    public T RoundToExponentNoRoundedFlag(T thisValue, EInteger exponent, EContext ctx) {
        EContext pctx = ctx == null ? null : ctx.WithBlankFlags();
        T ret = this.RoundToExponentExact(thisValue, exponent, pctx);
        if (ctx != null && ctx.getHasFlags()) {
            ctx.setFlags(ctx.getFlags() | pctx.getFlags() & 0xFFFFFFFC);
        }
        return ret;
    }

    @Override
    public T RoundToExponentSimple(T thisValue, EInteger expOther, EContext ctx) {
        int thisFlags = this.helper.GetFlags(thisValue);
        if ((thisFlags & 0xE) != 0) {
            T result = this.HandleNotANumber(thisValue, thisValue, ctx);
            if (result != null) {
                return result;
            }
            if ((thisFlags & 2) != 0) {
                return thisValue;
            }
        }
        if (this.helper.GetExponent(thisValue).compareTo(expOther) >= 0) {
            return this.RoundToPrecision(thisValue, ctx);
        }
        if (ctx != null && !ctx.ExponentWithinRange(expOther)) {
            return this.SignalInvalidWithMessage(ctx, "Exponent not within exponent range: " + expOther);
        }
        FastInteger shift = FastInteger.FromBig(expOther).SubtractBig(this.helper.GetExponent(thisValue));
        if (shift.signum() == 0 && RadixMath.IsSimpleContext(ctx)) {
            return thisValue;
        }
        EInteger bigmantissa = this.helper.GetMantissa(thisValue);
        if (RadixMath.IsSimpleContext(ctx) && ctx.getRounding() == ERounding.Down) {
            EInteger shiftedmant = shift.CanFitInInt32() ? bigmantissa.ShiftRight(shift.AsInt32()) : bigmantissa.ShiftRight(shift.AsEInteger());
            return this.helper.CreateNewWithFlags(shiftedmant, expOther, thisFlags);
        }
        IShiftAccumulator accum = this.helper.CreateShiftAccumulatorWithDigits(bigmantissa, 0, 0);
        accum.TruncateOrShiftRight(shift, false);
        bigmantissa = accum.getShiftedInt();
        thisValue = this.helper.CreateNewWithFlags(bigmantissa, expOther, thisFlags);
        return this.RoundToPrecisionInternal(thisValue, accum.getLastDiscardedDigit(), accum.getOlderDiscardedDigits(), null, false, ctx);
    }

    @Override
    public T RoundToPrecision(T thisValue, EContext context) {
        return this.RoundToPrecisionInternal(thisValue, 0, 0, null, false, context);
    }

    @Override
    public T SquareRoot(T thisValue, EContext ctx) {
        int expcmp;
        EInteger currentExp;
        if (ctx == null) {
            return this.SignalInvalidWithMessage(ctx, "ctx is null");
        }
        if (!ctx.getHasMaxPrecision()) {
            return this.SignalInvalidWithMessage(ctx, "ctx has unlimited precision");
        }
        T ret = this.SquareRootHandleSpecial(thisValue, ctx);
        if (ret != null) {
            return ret;
        }
        EContext ctxtmp = ctx.WithBlankFlags();
        EInteger origExp = currentExp = this.helper.GetExponent(thisValue);
        EInteger idealExp = currentExp;
        idealExp = idealExp.Divide(EInteger.FromInt64(2L));
        if (currentExp.signum() < 0 && !currentExp.isEven()) {
            idealExp = idealExp.Subtract(EInteger.FromInt32(1));
        }
        if (this.helper.GetSign(thisValue) == 0) {
            ret = this.RoundToPrecision(this.helper.CreateNewWithFlags(EInteger.FromInt32(0), idealExp, this.helper.GetFlags(thisValue)), ctxtmp);
            if (ctx.getHasFlags()) {
                ctx.setFlags(ctx.getFlags() | ctxtmp.getFlags());
            }
            return ret;
        }
        EInteger mantissa = this.helper.GetMantissa(thisValue);
        FastInteger digitCount = this.helper.GetDigitLength(mantissa);
        FastInteger targetPrecision = FastInteger.FromBig(ctx.getPrecision());
        FastInteger precision = targetPrecision.Copy().Multiply(2).AddInt(2);
        boolean rounded = false;
        boolean inexact = false;
        if (digitCount.compareTo(precision) < 0) {
            FastInteger diff = precision.Copy().Subtract(digitCount);
            if (!diff.isEvenNumber() ^ !origExp.isEven()) {
                diff.Increment();
            }
            EInteger bigdiff = diff.AsEInteger();
            currentExp = currentExp.Subtract(bigdiff);
            if ((mantissa = this.TryMultiplyByRadixPower(mantissa, diff)) == null) {
                return this.SignalInvalidWithMessage(ctx, "Result requires too much memory");
            }
        }
        EInteger[] sr = mantissa.SqrtRem();
        digitCount = this.helper.GetDigitLength(sr[0]);
        EInteger squareRootRemainder = sr[1];
        mantissa = sr[0];
        if (!squareRootRemainder.isZero()) {
            rounded = true;
            inexact = true;
        }
        EInteger oldexp = currentExp;
        currentExp = currentExp.Divide(EInteger.FromInt64(2L));
        if (oldexp.signum() < 0 && !oldexp.isEven()) {
            currentExp = currentExp.Subtract(EInteger.FromInt32(1));
        }
        T retval = this.helper.CreateNewWithFlags(mantissa, currentExp, 0);
        retval = this.RoundToPrecisionInternal(retval, 0, inexact ? 1 : 0, null, false, ctxtmp);
        currentExp = this.helper.GetExponent(retval);
        if (!((ctxtmp.getFlags() & 8) != 0 || (expcmp = currentExp.compareTo(idealExp)) > 0 && this.IsFinite(retval))) {
            retval = this.ReduceToPrecisionAndIdealExponent(retval, ctx.getHasExponentRange() ? ctxtmp : null, inexact ? targetPrecision : null, FastInteger.FromBig(idealExp));
        }
        if (ctx.getHasFlags()) {
            if (ctx.getClampNormalExponents() && !this.helper.GetExponent(retval).equals(idealExp) && (ctxtmp.getFlags() & 1) == 0) {
                ctx.setFlags(ctx.getFlags() | 0x20);
            }
            boolean bl = (ctxtmp.getFlags() & 0x10) != 0;
            currentExp = this.helper.GetExponent(retval);
            if (rounded |= bl) {
                ctxtmp.setFlags(ctxtmp.getFlags() | 2);
            } else if (currentExp.compareTo(idealExp) > 0) {
                ctxtmp.setFlags(ctxtmp.getFlags() | 2);
            } else {
                ctxtmp.setFlags(ctxtmp.getFlags() & 0xFFFFFFFD);
            }
            if (inexact) {
                ctxtmp.setFlags(ctxtmp.getFlags() | 2);
                ctxtmp.setFlags(ctxtmp.getFlags() | 1);
            }
            ctx.setFlags(ctx.getFlags() | ctxtmp.getFlags());
        }
        return retval;
    }

    private static int CompareToFast(int e1int, int e2int, int expcmp, int signA, FastIntegerFixed op1Mantissa, FastIntegerFixed op2Mantissa, int radix) {
        if (e1int >= -1073741822 && e1int <= 0x3FFFFFFE && e2int >= -1073741822 && e2int <= 0x3FFFFFFE) {
            int ediff;
            int n = ediff = e1int > e2int ? e1int - e2int : e2int - e1int;
            if (ediff <= 9 && radix == 10) {
                int power = ValueTenPowers[ediff];
                int maxoverflow = OverflowMaxes[ediff];
                if (expcmp > 0) {
                    int m1 = op1Mantissa.AsInt32();
                    int m2 = op2Mantissa.AsInt32();
                    if (m1 <= maxoverflow) {
                        return (m1 *= power) == m2 ? 0 : (m1 < m2 ? -signA : signA);
                    }
                } else {
                    int m1 = op1Mantissa.AsInt32();
                    int m2 = op2Mantissa.AsInt32();
                    if (m2 <= maxoverflow) {
                        return m1 == (m2 *= power) ? 0 : (m1 < m2 ? -signA : signA);
                    }
                }
            } else if (ediff <= 30 && radix == 2) {
                int mask = BitMasks[ediff];
                if (expcmp > 0) {
                    int m1 = op1Mantissa.AsInt32();
                    int m2 = op2Mantissa.AsInt32();
                    if ((m1 & mask) == m1) {
                        return (m1 <<= ediff) == m2 ? 0 : (m1 < m2 ? -signA : signA);
                    }
                } else {
                    int m1 = op1Mantissa.AsInt32();
                    int m2 = op2Mantissa.AsInt32();
                    if ((m2 & mask) == m2) {
                        return m1 == (m2 <<= ediff) ? 0 : (m1 < m2 ? -signA : signA);
                    }
                }
            }
        }
        return 2;
    }

    private static int CompareToFast64(int e1int, int e2int, int expcmp, int signA, FastIntegerFixed op1Mantissa, FastIntegerFixed op2Mantissa, int radix) {
        if (e1int >= -1073741822 && e1int <= 0x3FFFFFFE && e2int >= -1073741822 && e2int <= 0x3FFFFFFE) {
            long ediffLong;
            long l = ediffLong = e1int > e2int ? (long)(e1int - e2int) : (long)(e2int - e1int);
            if (ediffLong <= 18L && radix == 10) {
                long power = ValueTenPowers64[(int)ediffLong];
                long maxoverflow = OverflowMaxes64[(int)ediffLong];
                if (expcmp > 0) {
                    long m1 = op1Mantissa.AsInt64();
                    long m2 = op2Mantissa.AsInt64();
                    if (m1 <= maxoverflow) {
                        return (m1 *= power) == m2 ? 0 : (m1 < m2 ? -signA : signA);
                    }
                } else {
                    long m1 = op1Mantissa.AsInt64();
                    long m2 = op2Mantissa.AsInt64();
                    if (m2 <= maxoverflow) {
                        return m1 == (m2 *= power) ? 0 : (m1 < m2 ? -signA : signA);
                    }
                }
            } else if (ediffLong <= 62L && radix == 2) {
                long mask = BitMasks64[(int)ediffLong];
                if (expcmp > 0) {
                    long m1 = op1Mantissa.AsInt64();
                    long m2 = op2Mantissa.AsInt64();
                    if ((m1 & mask) == m1) {
                        return (m1 <<= (int)ediffLong) == m2 ? 0 : (m1 < m2 ? -signA : signA);
                    }
                } else {
                    long m1 = op1Mantissa.AsInt64();
                    long m2 = op2Mantissa.AsInt64();
                    if ((m2 & mask) == m2) {
                        return m1 == (m2 <<= (int)ediffLong) ? 0 : (m1 < m2 ? -signA : signA);
                    }
                }
            }
        }
        return 2;
    }

    private static <TMath> int CompareToSlow(EInteger op1Exponent, EInteger op2Exponent, int expcmp, int signA, EInteger op1Mantissa, EInteger op2Mantissa, IRadixMathHelper<TMath> helper, boolean reportOOM) {
        EInteger newmant;
        FastInteger fastOp1Exp = FastInteger.FromBig(op1Exponent);
        FastInteger fastOp2Exp = FastInteger.FromBig(op2Exponent);
        FastInteger expdiff = fastOp1Exp.Copy().Subtract(fastOp2Exp).Abs();
        if (expdiff.CompareToInt(100) >= 0) {
            FastInteger exp2;
            EInteger op1MantAbs = op1Mantissa;
            EInteger op2MantAbs = op2Mantissa;
            FastInteger precision1 = helper.GetDigitLength(op1MantAbs);
            FastInteger precision2 = helper.GetDigitLength(op2MantAbs);
            FastInteger exp1 = fastOp1Exp.Copy().Add(precision1).Decrement();
            int adjcmp = exp1.compareTo(exp2 = fastOp2Exp.Copy().Add(precision2).Decrement());
            if (adjcmp != 0) {
                return signA < 0 ? -adjcmp : adjcmp;
            }
            FastInteger maxPrecision = null;
            FastInteger fastInteger = maxPrecision = precision1.compareTo(precision2) > 0 ? precision1 : precision2;
            if (expdiff.Copy().compareTo(maxPrecision) > 0) {
                int expcmp2 = fastOp1Exp.compareTo(fastOp2Exp);
                if (expcmp2 < 0) {
                    if (!op2MantAbs.isZero()) {
                        FastInteger tmp;
                        FastInteger newDiff;
                        FastInteger digitLength1 = helper.GetDigitLength(op1MantAbs);
                        if (fastOp1Exp.Copy().Add(digitLength1).AddInt(2).compareTo(fastOp2Exp) < 0 && (newDiff = (tmp = fastOp2Exp.Copy().SubtractInt(8).Subtract(digitLength1).Subtract(maxPrecision)).Copy().Subtract(fastOp2Exp).Abs()).compareTo(expdiff) < 0) {
                            return signA < 0 ? 1 : -1;
                        }
                    }
                } else if (expcmp2 > 0 && !op1MantAbs.isZero()) {
                    FastInteger tmp;
                    FastInteger newDiff;
                    FastInteger digitLength2 = helper.GetDigitLength(op2MantAbs);
                    if (fastOp2Exp.Copy().Add(digitLength2).AddInt(2).compareTo(fastOp1Exp) < 0 && (newDiff = (tmp = fastOp1Exp.Copy().SubtractInt(8).Subtract(digitLength2).Subtract(maxPrecision)).Copy().Subtract(fastOp1Exp).Abs()).compareTo(expdiff) < 0) {
                        return signA < 0 ? -1 : 1;
                    }
                }
                expcmp = op1Exponent.compareTo(op2Exponent);
            }
        }
        if (expcmp > 0) {
            newmant = RadixMath.RescaleByExponentDiff(op1Mantissa, op1Exponent, op2Exponent, helper);
            if (newmant == null) {
                if (reportOOM) {
                    throw new OutOfMemoryError("Result requires too much memory");
                }
                return -2;
            }
            int mantcmp = newmant.compareTo(op2Mantissa);
            return signA < 0 ? -mantcmp : mantcmp;
        }
        newmant = RadixMath.RescaleByExponentDiff(op2Mantissa, op1Exponent, op2Exponent, helper);
        if (newmant == null) {
            if (reportOOM) {
                throw new OutOfMemoryError("Result requires too much memory");
            }
            return -2;
        }
        int mantcmp = op1Mantissa.compareTo(newmant);
        return signA < 0 ? -mantcmp : mantcmp;
    }

    private static boolean IsNullOrSimpleContext(EContext ctx) {
        return ctx == null || ctx == EContext.UnlimitedHalfEven || !ctx.getHasExponentRange() && !ctx.getHasMaxPrecision() && ctx.getTraps() == 0 && !ctx.getHasFlags();
    }

    private static boolean IsSimpleContext(EContext ctx) {
        return ctx != null && (ctx == EContext.UnlimitedHalfEven || !ctx.getHasExponentRange() && !ctx.getHasMaxPrecision() && ctx.getTraps() == 0 && !ctx.getHasFlags());
    }

    private static EInteger PowerOfTwo(FastInteger fi) {
        if (fi.signum() <= 0) {
            return EInteger.FromInt32(1);
        }
        if (fi.CanFitInInt32()) {
            return EInteger.FromInt32(1).ShiftLeft(fi.AsInt32());
        }
        return EInteger.FromInt32(1).ShiftLeft(fi.AsEInteger());
    }

    private static <TMath> EInteger RescaleByExponentDiff(EInteger mantissa, EInteger e1, EInteger e2, IRadixMathHelper<TMath> helper) {
        if (mantissa.signum() == 0) {
            return EInteger.FromInt32(0);
        }
        FastInteger diff = FastInteger.FromBig(e1).SubtractBig(e2).Abs();
        if (!diff.CanFitInInt32()) {
            FastInteger fastBI = FastInteger.FromBig(mantissa);
            if (helper.GetRadix() != 10 || diff.compareTo(fastBI) > 0) {
                return null;
            }
        }
        return helper.MultiplyByRadixPower(mantissa, diff);
    }

    private static EContext SetPrecisionIfLimited(EContext ctx, EInteger bigPrecision) {
        return ctx == null || !ctx.getHasMaxPrecision() ? ctx : ctx.WithBigPrecision(bigPrecision);
    }

    private static void TransferFlags(EContext ctxDst, EContext ctxSrc) {
        if (ctxDst != null && ctxDst.getHasFlags()) {
            if ((ctxSrc.getFlags() & 0xC0) != 0) {
                ctxDst.setFlags(ctxDst.getFlags() | ctxSrc.getFlags() & 0xC0);
            } else {
                ctxDst.setFlags(ctxDst.getFlags() | ctxSrc.getFlags());
            }
        }
    }

    private T AbsRaw(T value) {
        return this.EnsureSign(value, false);
    }

    private T AddCore2(FastIntegerFixed mant1, FastIntegerFixed mant2, FastIntegerFixed exponent, int flags1, int flags2, EContext ctx) {
        boolean neg1 = (flags1 & 1) != 0;
        boolean neg2 = (flags2 & 1) != 0;
        boolean negResult = false;
        if (neg1 != neg2) {
            int mant1Sign = (mant1 = FastIntegerFixed.Subtract(mant1, mant2)).signum();
            if (mant1Sign < 0) {
                negResult = !neg1;
                mant1 = mant1.Negate();
            } else if (mant1Sign == 0) {
                negResult = neg1 ^ neg2;
                if (negResult) {
                    negResult &= neg1 && neg2 || neg1 ^ neg2 && ctx != null && ctx.getRounding() == ERounding.Floor;
                }
            } else {
                negResult = neg1;
            }
        } else {
            mant1 = FastIntegerFixed.Add(mant1, mant2);
            negResult = neg1;
            if (negResult && mant1.isValueZero()) {
                negResult &= neg1 && neg2 || neg1 ^ neg2 && ctx != null && ctx.getRounding() == ERounding.Floor;
            }
        }
        return this.helper.CreateNewWithFlagsFastInt(mant1, exponent, negResult ? 1 : 0);
    }

    private T AddCore(EInteger mant1, EInteger mant2, EInteger exponent, int flags1, int flags2, EContext ctx) {
        boolean neg1 = (flags1 & 1) != 0;
        boolean neg2 = (flags2 & 1) != 0;
        boolean negResult = false;
        if (neg1 != neg2) {
            int mant1Sign = (mant1 = mant1.Subtract(mant2)).signum();
            negResult = neg1 ^ (mant1Sign == 0 ? neg2 : mant1Sign < 0);
            if (mant1Sign < 0) {
                mant1 = mant1.Negate();
            }
        } else {
            mant1 = mant1.Add(mant2);
            negResult = neg1;
        }
        if (negResult && mant1.isZero()) {
            negResult &= neg1 && neg2 || neg1 ^ neg2 && ctx != null && ctx.getRounding() == ERounding.Floor;
        }
        return this.helper.CreateNewWithFlags(mant1, exponent, negResult ? 1 : 0);
    }

    private FastInteger OverestimateDigitLength(EInteger ei) {
        if (this.thisRadix == 2) {
            return FastInteger.FromBig(ei.GetUnsignedBitLengthAsEInteger());
        }
        if (this.thisRadix == 10) {
            EInteger bigBitLength = ei.GetUnsignedBitLengthAsEInteger();
            if (bigBitLength.compareTo(2135) <= 0) {
                return new FastInteger(1 + (bigBitLength.ToInt32Checked() * 631305 >> 21));
            }
            return FastInteger.FromBig(bigBitLength.Divide(3));
        }
        return this.helper.GetDigitLength(ei);
    }

    private T AddExDiffExp(T thisValue, T other, int thisFlags, int otherFlags, EContext ctx, int expcmp, boolean roundToOperandPrecision) {
        EInteger resultExponent;
        T retval = null;
        T op1 = thisValue;
        T op2 = other;
        EInteger op1MantAbs = this.helper.GetMantissa(thisValue);
        EInteger op2MantAbs = this.helper.GetMantissa(other);
        EInteger op1Exponent = this.helper.GetExponent(op1);
        EInteger op2Exponent = this.helper.GetExponent(op2);
        EInteger eInteger = resultExponent = expcmp < 0 ? op1Exponent : op2Exponent;
        if (ctx != null && ctx.getHasMaxPrecision() && ctx.getPrecision().signum() > 0) {
            FastInteger fastPrecision;
            boolean moreDistantThanPrecision;
            FastInteger fastOp1Exp = FastInteger.FromBig(op1Exponent);
            FastInteger fastOp2Exp = FastInteger.FromBig(op2Exponent);
            FastInteger expdiff = fastOp1Exp.Copy().Subtract(fastOp2Exp).Abs();
            boolean bl = moreDistantThanPrecision = expdiff.compareTo(fastPrecision = FastInteger.FromBig(ctx.getPrecision())) > 0;
            if (moreDistantThanPrecision) {
                int expcmp2 = fastOp1Exp.compareTo(fastOp2Exp);
                if (expcmp2 < 0) {
                    if (!op2MantAbs.isZero()) {
                        FastInteger tmp;
                        FastInteger newDiff;
                        FastInteger digitLength1 = this.OverestimateDigitLength(op1MantAbs);
                        if (fastOp1Exp.Copy().Add(digitLength1).AddInt(2).compareTo(fastOp2Exp) < 0 && (newDiff = (tmp = fastOp2Exp.Copy().SubtractInt(4).Subtract(digitLength1).SubtractBig(ctx.getPrecision())).Copy().Subtract(fastOp2Exp).Abs()).compareTo(expdiff) < 0) {
                            boolean sameSign = this.helper.GetSign(thisValue) == this.helper.GetSign(other);
                            boolean oneOpIsZero = op1MantAbs.isZero();
                            FastInteger digitLength2 = this.helper.GetDigitLength(op2MantAbs);
                            if (digitLength2.compareTo(fastPrecision) < 0) {
                                FastInteger precisionDiff = fastPrecision.Copy().Subtract(digitLength2);
                                if (!oneOpIsZero && !sameSign) {
                                    precisionDiff.AddInt(2);
                                }
                                if ((op2MantAbs = this.TryMultiplyByRadixPower(op2MantAbs, precisionDiff)) == null) {
                                    return this.SignalInvalidWithMessage(ctx, "Result requires too much memory");
                                }
                                EInteger bigintTemp = precisionDiff.AsEInteger();
                                op2Exponent = op2Exponent.Subtract(bigintTemp);
                                if (!oneOpIsZero && !sameSign) {
                                    op2MantAbs = op2MantAbs.Subtract(EInteger.FromInt32(1));
                                }
                                other = this.helper.CreateNewWithFlags(op2MantAbs, op2Exponent, this.helper.GetFlags(other));
                                FastInteger shift = digitLength2.Copy().Subtract(fastPrecision);
                                if (oneOpIsZero && ctx != null && ctx.getHasFlags()) {
                                    ctx.setFlags(ctx.getFlags() | 2);
                                }
                                return this.RoundToPrecisionInternal(other, oneOpIsZero || sameSign ? 0 : 1, oneOpIsZero && !sameSign ? 0 : 1, shift, false, ctx);
                            }
                            if (!oneOpIsZero && !sameSign) {
                                if ((op2MantAbs = this.TryMultiplyByRadixPower(op2MantAbs, ValueFastIntegerTwo)) == null) {
                                    return this.SignalInvalidWithMessage(ctx, "Result requires too much memory");
                                }
                                op2Exponent = op2Exponent.Subtract(EInteger.FromInt64(2L));
                                op2MantAbs = op2MantAbs.Subtract(EInteger.FromInt32(1));
                                other = this.helper.CreateNewWithFlags(op2MantAbs, op2Exponent, this.helper.GetFlags(other));
                                FastInteger shift = digitLength2.Copy().Subtract(fastPrecision);
                                return this.RoundToPrecisionInternal(other, 0, 0, shift, false, ctx);
                            }
                            FastInteger shift2 = digitLength2.Copy().Subtract(fastPrecision);
                            if (!sameSign && ctx != null && ctx.getHasFlags()) {
                                ctx.setFlags(ctx.getFlags() | 2);
                            }
                            return this.RoundToPrecisionInternal(other, 0, sameSign ? 1 : 0, shift2, false, ctx);
                        }
                    }
                } else if (expcmp2 > 0 && !op1MantAbs.isZero()) {
                    FastInteger tmp;
                    FastInteger newDiff;
                    FastInteger digitLength2 = this.OverestimateDigitLength(op2MantAbs);
                    if (fastOp2Exp.Copy().Add(digitLength2).AddInt(2).compareTo(fastOp1Exp) < 0 && (newDiff = (tmp = fastOp1Exp.Copy().SubtractInt(4).Subtract(digitLength2).SubtractBig(ctx.getPrecision())).Copy().Subtract(fastOp1Exp).Abs()).compareTo(expdiff) < 0) {
                        boolean sameSign = this.helper.GetSign(thisValue) == this.helper.GetSign(other);
                        boolean oneOpIsZero = op2MantAbs.isZero();
                        digitLength2 = this.helper.GetDigitLength(op1MantAbs);
                        if (digitLength2.compareTo(fastPrecision) < 0) {
                            FastInteger precisionDiff = fastPrecision.Copy().Subtract(digitLength2);
                            if (!oneOpIsZero && !sameSign) {
                                precisionDiff.AddInt(2);
                            }
                            if ((op1MantAbs = this.TryMultiplyByRadixPower(op1MantAbs, precisionDiff)) == null) {
                                return this.SignalInvalidWithMessage(ctx, "Result requires too much memory");
                            }
                            EInteger bigintTemp = precisionDiff.AsEInteger();
                            op1Exponent = op1Exponent.Subtract(bigintTemp);
                            if (!oneOpIsZero && !sameSign) {
                                op1MantAbs = op1MantAbs.Subtract(EInteger.FromInt32(1));
                            }
                            thisValue = this.helper.CreateNewWithFlags(op1MantAbs, op1Exponent, this.helper.GetFlags(thisValue));
                            FastInteger shift = digitLength2.Copy().Subtract(fastPrecision);
                            if (oneOpIsZero && ctx != null && ctx.getHasFlags()) {
                                ctx.setFlags(ctx.getFlags() | 2);
                            }
                            return this.RoundToPrecisionInternal(thisValue, oneOpIsZero || sameSign ? 0 : 1, oneOpIsZero && !sameSign ? 0 : 1, shift, false, ctx);
                        }
                        if (!oneOpIsZero && !sameSign) {
                            if ((op1MantAbs = this.TryMultiplyByRadixPower(op1MantAbs, ValueFastIntegerTwo)) == null) {
                                return this.SignalInvalidWithMessage(ctx, "Result requires too much memory");
                            }
                            op1Exponent = op1Exponent.Subtract(EInteger.FromInt64(2L));
                            op1MantAbs = op1MantAbs.Subtract(EInteger.FromInt32(1));
                            thisValue = this.helper.CreateNewWithFlags(op1MantAbs, op1Exponent, this.helper.GetFlags(thisValue));
                            FastInteger shift = digitLength2.Copy().Subtract(fastPrecision);
                            return this.RoundToPrecisionInternal(thisValue, 0, 0, shift, false, ctx);
                        }
                        FastInteger shift2 = digitLength2.Copy().Subtract(fastPrecision);
                        if (!sameSign && ctx != null && ctx.getHasFlags()) {
                            ctx.setFlags(ctx.getFlags() | 2);
                        }
                        return this.RoundToPrecisionInternal(thisValue, 0, sameSign ? 1 : 0, shift2, false, ctx);
                    }
                }
                EInteger eInteger2 = resultExponent = (expcmp = op1Exponent.compareTo(op2Exponent)) < 0 ? op1Exponent : op2Exponent;
            }
        }
        if (expcmp > 0) {
            if ((op1MantAbs = RadixMath.RescaleByExponentDiff(op1MantAbs, op1Exponent, op2Exponent, this.helper)) == null) {
                return this.SignalInvalidWithMessage(ctx, "Result requires too much memory");
            }
            retval = this.AddCore(op1MantAbs, op2MantAbs, resultExponent, thisFlags, otherFlags, ctx);
        } else {
            if ((op2MantAbs = RadixMath.RescaleByExponentDiff(op2MantAbs, op1Exponent, op2Exponent, this.helper)) == null) {
                return this.SignalInvalidWithMessage(ctx, "Result requires too much memory");
            }
            retval = this.AddCore(op1MantAbs, op2MantAbs, resultExponent, thisFlags, otherFlags, ctx);
        }
        if (roundToOperandPrecision && ctx != null && ctx.getHasMaxPrecision()) {
            FastInteger digitLength2;
            FastInteger digitLength1 = this.helper.GetDigitLength(op1MantAbs);
            FastInteger maxDigitLength = digitLength1.compareTo(digitLength2 = this.helper.GetDigitLength(op2MantAbs)) > 0 ? digitLength1 : digitLength2;
            maxDigitLength.SubtractBig(ctx.getPrecision());
            return maxDigitLength.signum() > 0 ? this.RoundToPrecisionInternal(retval, 0, 0, maxDigitLength, false, ctx) : this.RoundToPrecision(retval, ctx);
        }
        return (T)(RadixMath.IsNullOrSimpleContext(ctx) ? retval : this.RoundToPrecision(retval, ctx));
    }

    private T CompareToHandleSpecial(T thisValue, T other, boolean treatQuietNansAsSignaling, EContext ctx) {
        int otherFlags;
        int thisFlags = this.helper.GetFlags(thisValue);
        if (((thisFlags | (otherFlags = this.helper.GetFlags(other))) & 0xE) != 0) {
            if ((thisFlags & 8) != 0) {
                return this.SignalingNaNInvalid(thisValue, ctx);
            }
            if ((otherFlags & 8) != 0) {
                return this.SignalingNaNInvalid(other, ctx);
            }
            if (treatQuietNansAsSignaling) {
                if ((thisFlags & 4) != 0) {
                    return this.SignalingNaNInvalid(thisValue, ctx);
                }
                if ((otherFlags & 4) != 0) {
                    return this.SignalingNaNInvalid(other, ctx);
                }
            } else {
                if ((thisFlags & 4) != 0) {
                    return this.ReturnQuietNaN(thisValue, ctx);
                }
                if ((otherFlags & 4) != 0) {
                    return this.ReturnQuietNaN(other, ctx);
                }
            }
            if ((thisFlags & 2) != 0) {
                return (thisFlags & 3) == (otherFlags & 3) ? this.ValueOf(0, null) : ((thisFlags & 1) == 0 ? this.ValueOf(1, null) : this.ValueOf(-1, null));
            }
            if ((otherFlags & 2) != 0) {
                return (thisFlags & 3) == (otherFlags & 3) ? this.ValueOf(0, null) : ((otherFlags & 1) == 0 ? this.ValueOf(-1, null) : this.ValueOf(1, null));
            }
        }
        return null;
    }

    private static <TMath> int CompareToHandleSpecial2(TMath thisValue, TMath other, int thisFlags, int otherFlags) {
        if ((thisFlags & 0xC) != 0) {
            if ((otherFlags & 0xC) != 0) {
                return 0;
            }
            return 1;
        }
        if ((otherFlags & 0xC) != 0) {
            return -1;
        }
        if ((thisFlags & 2) != 0) {
            return (thisFlags & 3) == (otherFlags & 3) ? 0 : ((thisFlags & 1) == 0 ? 1 : -1);
        }
        if ((otherFlags & 2) != 0) {
            return (thisFlags & 3) == (otherFlags & 3) ? 0 : ((otherFlags & 1) == 0 ? -1 : 1);
        }
        return 2;
    }

    private static <TMath> int CompareToInternal(TMath thisValue, TMath otherValue, boolean reportOOM, IRadixMathHelper<TMath> helper) {
        int signB;
        int signA = helper.GetSign(thisValue);
        if (signA != (signB = helper.GetSign(otherValue))) {
            return signA < signB ? -1 : 1;
        }
        if (signB == 0 || signA == 0) {
            return 0;
        }
        FastIntegerFixed op1Exponent = helper.GetExponentFastInt(thisValue);
        FastIntegerFixed op2Exponent = helper.GetExponentFastInt(otherValue);
        FastIntegerFixed op1Mantissa = helper.GetMantissaFastInt(thisValue);
        FastIntegerFixed op2Mantissa = helper.GetMantissaFastInt(otherValue);
        int expcmp = op1Exponent.compareTo(op2Exponent);
        int mantcmp = op1Mantissa.compareTo(op2Mantissa);
        if (mantcmp == 0) {
            return signA < 0 ? -expcmp : expcmp;
        }
        if (expcmp == 0) {
            return signA < 0 ? -mantcmp : mantcmp;
        }
        if (op1Exponent.CanFitInInt32() && op2Exponent.CanFitInInt32()) {
            int e2int;
            int e1int;
            int c;
            if (op1Mantissa.CanFitInInt32() && op2Mantissa.CanFitInInt32()) {
                int e2int2;
                int e1int2 = op1Exponent.AsInt32();
                int c2 = RadixMath.CompareToFast(e1int2, e2int2 = op2Exponent.AsInt32(), expcmp, signA, op1Mantissa, op2Mantissa, helper.GetRadix());
                if (c2 <= 1) {
                    return c2;
                }
            } else if (op1Mantissa.CanFitInInt64() && op2Mantissa.CanFitInInt64() && (c = RadixMath.CompareToFast64(e1int = op1Exponent.AsInt32(), e2int = op2Exponent.AsInt32(), expcmp, signA, op1Mantissa, op2Mantissa, helper.GetRadix())) <= 1) {
                return c;
            }
        }
        return RadixMath.CompareToSlow(op1Exponent.ToEInteger(), op2Exponent.ToEInteger(), expcmp, signA, op1Mantissa.ToEInteger(), op2Mantissa.ToEInteger(), helper, reportOOM);
    }

    private T DivideInternal(T thisValue, T divisor, EContext ctx, int integerMode, EInteger desiredExponent) {
        int mantcmp;
        T ret = this.DivisionHandleSpecial(thisValue, divisor, ctx);
        if (ret != null) {
            return ret;
        }
        int signA = this.helper.GetSign(thisValue);
        int signB = this.helper.GetSign(divisor);
        if (signB == 0) {
            if (signA == 0) {
                return this.SignalInvalid(ctx);
            }
            boolean flagsNeg = (this.helper.GetFlags(thisValue) & 1) != 0 ^ (this.helper.GetFlags(divisor) & 1) != 0;
            return this.SignalDivideByZero(ctx, flagsNeg);
        }
        int radix = this.thisRadix;
        if (signA == 0) {
            T retval = null;
            if (integerMode == 1) {
                int newflags = this.helper.GetFlags(thisValue) & 1 ^ this.helper.GetFlags(divisor) & 1;
                retval = this.helper.CreateNewWithFlags(EInteger.FromInt32(0), desiredExponent, newflags);
            } else {
                EInteger dividendExp = this.helper.GetExponent(thisValue);
                EInteger divisorExp = this.helper.GetExponent(divisor);
                int newflags = this.helper.GetFlags(thisValue) & 1 ^ this.helper.GetFlags(divisor) & 1;
                retval = this.RoundToPrecision(this.helper.CreateNewWithFlags(EInteger.FromInt32(0), dividendExp.Subtract(divisorExp), newflags), ctx);
            }
            return retval;
        }
        EInteger mantissaDividend = this.helper.GetMantissa(thisValue);
        EInteger mantissaDivisor = this.helper.GetMantissa(divisor);
        FastInteger expDividend = this.helper.GetExponentFastInt(thisValue).ToFastInteger();
        FastInteger expDivisor = this.helper.GetExponentFastInt(divisor).ToFastInteger();
        FastInteger expdiff = expDividend.Copy().Subtract(expDivisor);
        FastInteger adjust = new FastInteger(0);
        FastInteger result = new FastInteger(0);
        FastInteger naturalExponent = expdiff.Copy();
        boolean hasPrecision = ctx != null && ctx.getPrecision().signum() != 0;
        boolean resultNeg = (this.helper.GetFlags(thisValue) & 1) != (this.helper.GetFlags(divisor) & 1);
        FastInteger fastPrecision = !hasPrecision ? new FastInteger(0) : FastInteger.FromBig(ctx.getPrecision());
        FastInteger dividendPrecision = null;
        FastInteger divisorPrecision = null;
        if (integerMode == 1) {
            FastInteger fastDesiredExponent = FastInteger.FromBig(desiredExponent);
            if (ctx != null && ctx.getHasFlags() && fastDesiredExponent.compareTo(expdiff) > 0) {
                ctx.setFlags(ctx.getFlags() | 2);
            }
            if (expdiff.compareTo(fastDesiredExponent) <= 0) {
                FastInteger shift = fastDesiredExponent.Copy().Subtract(expdiff);
                EInteger[] divrem = mantissaDividend.DivRem(mantissaDivisor);
                EInteger quo = divrem[0];
                EInteger rem = divrem[1];
                return this.RoundToScale(quo, rem, mantissaDivisor, desiredExponent, shift, resultNeg, ctx);
            }
            if (ctx != null && ctx.getPrecision().signum() != 0 && expdiff.Copy().SubtractInt(8).compareTo(fastPrecision) > 0) {
                return this.SignalInvalidWithMessage(ctx, "Result can't fit the precision");
            }
            FastInteger shift = expdiff.Copy().Subtract(fastDesiredExponent);
            if ((mantissaDividend = this.TryMultiplyByRadixPower(mantissaDividend, shift)) == null) {
                return this.SignalInvalidWithMessage(ctx, "Result requires too much memory");
            }
            EInteger[] divrem = mantissaDividend.DivRem(mantissaDivisor);
            EInteger quo = divrem[0];
            EInteger rem = divrem[1];
            return this.RoundToScale(quo, rem, mantissaDivisor, desiredExponent, new FastInteger(0), resultNeg, ctx);
        }
        if (integerMode == 0) {
            EInteger rem = null;
            EInteger quo = null;
            EInteger[] divrem = mantissaDividend.DivRem(mantissaDivisor);
            quo = divrem[0];
            rem = divrem[1];
            if (rem.isZero()) {
                quo = quo.Abs();
                T fi = this.helper.CreateNewWithFlagsFastInt(FastIntegerFixed.FromBig(quo), FastIntegerFixed.FromFastInteger(expdiff), resultNeg ? 1 : 0);
                return this.RoundToPrecision(fi, ctx);
            }
            rem = null;
            quo = null;
            if (hasPrecision) {
                int[] digitStatus;
                EInteger divid = mantissaDividend;
                FastInteger shift = FastInteger.FromBig(ctx.getPrecision());
                dividendPrecision = this.helper.GetDigitLength(mantissaDividend);
                divisorPrecision = this.helper.GetDigitLength(mantissaDivisor);
                FastInteger dividPrecision = dividendPrecision.Copy();
                FastInteger divisPrecision = divisorPrecision.Copy();
                if (dividendPrecision.compareTo(divisorPrecision) <= 0) {
                    divisorPrecision = divisorPrecision.Copy().Subtract(dividendPrecision);
                    divisorPrecision.Increment();
                    shift.Add(divisorPrecision);
                    divid = this.TryMultiplyByRadixPower(divid, shift);
                    dividPrecision.Add(shift);
                    if (divid == null) {
                        return this.SignalInvalidWithMessage(ctx, "Result requires too much memory");
                    }
                } else if ((dividendPrecision = dividendPrecision.Copy().Subtract(divisorPrecision)).compareTo(shift) <= 0) {
                    shift.Subtract(dividendPrecision);
                    shift.Increment();
                    divid = this.TryMultiplyByRadixPower(divid, shift);
                    dividPrecision.Add(shift);
                    if (divid == null) {
                        return this.SignalInvalidWithMessage(ctx, "Result requires too much memory");
                    }
                } else {
                    shift.SetInt(0);
                }
                dividendPrecision = dividPrecision;
                divisorPrecision = divisPrecision;
                if (shift.signum() != 0 || quo == null) {
                    EInteger[] divrem2 = divid.DivRem(mantissaDivisor);
                    quo = divrem2[0];
                    rem = divrem2[1];
                }
                if ((digitStatus = this.RoundToScaleStatus(rem, mantissaDivisor, ctx)) == null) {
                    return this.SignalInvalidWithMessage(ctx, "Rounding was required");
                }
                FastInteger natexp = naturalExponent.Copy().Subtract(shift);
                EContext ctxcopy = ctx.WithBlankFlags();
                T retval2 = this.helper.CreateNewWithFlags(quo, natexp.AsEInteger(), resultNeg ? 1 : 0);
                retval2 = this.RoundToPrecisionInternal(retval2, digitStatus[0], digitStatus[1], null, false, ctxcopy);
                if ((ctxcopy.getFlags() & 1) != 0) {
                    if (ctx.getHasFlags()) {
                        ctx.setFlags(ctx.getFlags() | ctxcopy.getFlags());
                    }
                    return retval2;
                }
                if (ctx.getHasFlags()) {
                    ctx.setFlags(ctx.getFlags() | ctxcopy.getFlags() & 0xFFFFFFFD);
                }
                return this.ReduceToPrecisionAndIdealExponent(retval2, ctx, rem.isZero() ? null : fastPrecision, expdiff);
            }
        }
        if ((mantcmp = mantissaDividend.compareTo(mantissaDivisor)) == 0) {
            result = new FastInteger(1);
            mantissaDividend = EInteger.FromInt32(0);
        } else {
            FastInteger divShift;
            EInteger gcd = mantissaDividend.Gcd(mantissaDivisor);
            if (gcd.compareTo(EInteger.FromInt32(1)) != 0) {
                mantissaDividend = mantissaDividend.Divide(gcd);
                mantissaDivisor = mantissaDivisor.Divide(gcd);
            }
            if ((divShift = this.helper.DivisionShift(mantissaDividend, mantissaDivisor)) == null) {
                return this.SignalInvalidWithMessage(ctx, "Result would have a nonterminating expansion");
            }
            mantissaDividend = this.helper.MultiplyByRadixPower(mantissaDividend, divShift);
            adjust = divShift.Copy();
            EInteger[] quorem = mantissaDividend.DivRem(mantissaDivisor);
            mantissaDividend = quorem[1];
            result = FastInteger.FromBig(quorem[0]);
        }
        FastInteger exp = expdiff.Copy().Subtract(adjust);
        ERounding rounding = ctx == null ? ERounding.HalfEven : ctx.getRounding();
        int lastDiscarded = 0;
        int olderDiscarded = 0;
        if (!mantissaDividend.isZero()) {
            if (rounding == ERounding.HalfDown || rounding == ERounding.HalfEven || rounding == ERounding.HalfUp) {
                EInteger halfDivisor = mantissaDivisor.ShiftRight(1);
                int cmpHalf = mantissaDividend.compareTo(halfDivisor);
                if (cmpHalf == 0 && mantissaDivisor.isEven()) {
                    lastDiscarded = radix / 2;
                    olderDiscarded = 0;
                } else if (cmpHalf > 0) {
                    lastDiscarded = radix / 2;
                    olderDiscarded = 1;
                } else {
                    lastDiscarded = 0;
                    olderDiscarded = 1;
                }
            } else {
                if (rounding == ERounding.None) {
                    return this.SignalInvalidWithMessage(ctx, "Rounding was required");
                }
                lastDiscarded = 1;
                olderDiscarded = 1;
            }
        }
        EInteger bigResult = result.AsEInteger();
        if (ctx != null && ctx.getHasFlags() && exp.compareTo(expdiff) > 0) {
            ctx.setFlags(ctx.getFlags() | 2);
        }
        EInteger bigexp = exp.AsEInteger();
        T retval = this.helper.CreateNewWithFlags(bigResult, bigexp, resultNeg ? 1 : 0);
        return this.RoundToPrecisionInternal(retval, lastDiscarded, olderDiscarded, null, false, ctx);
    }

    private T DivisionHandleSpecial(T thisValue, T other, EContext ctx) {
        int otherFlags;
        int thisFlags = this.helper.GetFlags(thisValue);
        if (((thisFlags | (otherFlags = this.helper.GetFlags(other))) & 0xE) != 0) {
            T result = this.HandleNotANumber(thisValue, other, ctx);
            if (result != null) {
                return result;
            }
            if ((thisFlags & 2) != 0 && (otherFlags & 2) != 0) {
                return this.SignalInvalid(ctx);
            }
            if ((thisFlags & 2) != 0) {
                return this.EnsureSign(thisValue, ((thisFlags ^ otherFlags) & 1) != 0);
            }
            if ((otherFlags & 2) != 0) {
                if (ctx != null && ctx.getHasExponentRange() && ctx.getPrecision().signum() > 0) {
                    if (ctx.getHasFlags()) {
                        ctx.setFlags(ctx.getFlags() | 0x20);
                    }
                    EInteger bigexp = ctx.getEMin();
                    EInteger bigprec = ctx.getPrecision();
                    if (ctx.getAdjustExponent()) {
                        bigexp = bigexp.Subtract(bigprec);
                        bigexp = bigexp.Add(EInteger.FromInt32(1));
                    }
                    thisFlags = (thisFlags ^ otherFlags) & 1;
                    return this.helper.CreateNewWithFlags(EInteger.FromInt32(0), bigexp, thisFlags);
                }
                thisFlags = (thisFlags ^ otherFlags) & 1;
                return this.RoundToPrecision(this.helper.CreateNewWithFlags(EInteger.FromInt32(0), EInteger.FromInt32(0), thisFlags), ctx);
            }
        }
        return null;
    }

    private T EnsureSign(T val, boolean negative) {
        if (val == null) {
            return val;
        }
        int flags = this.helper.GetFlags(val);
        if (negative && (flags & 1) == 0 || !negative && (flags & 1) != 0) {
            flags &= 0xFFFFFFFE;
            return this.helper.CreateNewWithFlags(this.helper.GetMantissa(val), this.helper.GetExponent(val), flags |= negative ? 1 : 0);
        }
        return val;
    }

    private T ExpInternal(T thisValue, EInteger workingPrecision, EContext ctx) {
        T guess;
        T one = this.helper.ValueOf(1);
        int precisionAdd = this.thisRadix == 2 ? 18 : 12;
        EContext ctxdiv = RadixMath.SetPrecisionIfLimited(ctx, workingPrecision.Add(EInteger.FromInt32(precisionAdd))).WithRounding(ERounding.OddOrZeroFiveUp);
        EInteger bigintN = EInteger.FromInt64(2L);
        EInteger facto = EInteger.FromInt32(1);
        T lastGuess = guess = this.Add(one, thisValue, ctxdiv);
        T pow = thisValue;
        boolean more = true;
        int lastCompare = 0;
        int vacillations = 0;
        while (more) {
            lastGuess = guess;
            T tmp = this.Divide(pow = this.Multiply(pow, thisValue, ctxdiv), this.helper.CreateNewWithFlags(facto = facto.Multiply(bigintN), EInteger.FromInt32(0), 0), ctxdiv);
            T newGuess = this.Add(guess, tmp, ctxdiv);
            int guessCmp = this.compareTo(lastGuess, newGuess);
            if (guessCmp == 0) {
                more = false;
            } else if (guessCmp > 0 && lastCompare < 0 || lastCompare > 0 && guessCmp < 0) {
                more &= ++vacillations <= 3 || guessCmp <= 0;
            }
            lastCompare = guessCmp;
            guess = newGuess;
            if (!more) continue;
            bigintN = bigintN.Add(EInteger.FromInt32(1));
        }
        return this.RoundToPrecision(guess, ctx);
    }

    private T ExtendPrecision(T thisValue, EContext ctx) {
        if (ctx == null || !ctx.getHasMaxPrecision()) {
            return this.RoundToPrecision(thisValue, ctx);
        }
        EInteger mant = this.helper.GetMantissa(thisValue);
        FastInteger digits = this.helper.GetDigitLength(mant);
        FastInteger fastPrecision = FastInteger.FromBig(ctx.getPrecision());
        EInteger exponent = this.helper.GetExponent(thisValue);
        if (digits.compareTo(fastPrecision) < 0) {
            fastPrecision.Subtract(digits);
            mant = this.TryMultiplyByRadixPower(mant, fastPrecision);
            if (mant == null) {
                return this.SignalInvalidWithMessage(ctx, "Result requires too much memory");
            }
            EInteger bigPrec = fastPrecision.AsEInteger();
            exponent = exponent.Subtract(bigPrec);
        }
        if (ctx != null && ctx.getHasFlags()) {
            ctx.setFlags(ctx.getFlags() | 2);
            ctx.setFlags(ctx.getFlags() | 1);
        }
        return this.RoundToPrecision(this.helper.CreateNewWithFlags(mant, exponent, 0), ctx);
    }

    private T HandleNotANumber(T thisValue, T other, EContext ctx) {
        int thisFlags = this.helper.GetFlags(thisValue);
        int otherFlags = this.helper.GetFlags(other);
        if ((thisFlags & 8) != 0) {
            return this.SignalingNaNInvalid(thisValue, ctx);
        }
        if ((otherFlags & 8) != 0) {
            return this.SignalingNaNInvalid(other, ctx);
        }
        return (T)((thisFlags & 4) != 0 ? this.ReturnQuietNaN(thisValue, ctx) : ((otherFlags & 4) != 0 ? this.ReturnQuietNaN(other, ctx) : null));
    }

    private boolean IsFinite(T val) {
        return (this.helper.GetFlags(val) & 0xE) == 0;
    }

    private boolean IsNegative(T val) {
        return (this.helper.GetFlags(val) & 1) != 0;
    }

    private boolean IsWithinExponentRangeForPow(T thisValue, EContext ctx) {
        if (ctx == null || !ctx.getHasExponentRange()) {
            return true;
        }
        FastInteger digits = this.helper.GetDigitLength(this.helper.GetMantissa(thisValue));
        EInteger exp = this.helper.GetExponent(thisValue);
        FastInteger fi = FastInteger.FromBig(exp);
        if (ctx.getAdjustExponent()) {
            fi.Add(digits);
            fi.Decrement();
        }
        if (fi.signum() < 0) {
            fi.Negate().Divide(2).Negate();
        }
        return (exp = fi.AsEInteger()).compareTo(ctx.getEMin()) >= 0 && exp.compareTo(ctx.getEMax()) <= 0;
    }

    private T LnInternalCloseToOne(T thisValue, EInteger workingPrecision, EContext ctx) {
        T rz;
        boolean more = true;
        int lastCompare = 0;
        int vacillations = 0;
        EContext ctxdiv = RadixMath.SetPrecisionIfLimited(ctx, workingPrecision.Add(EInteger.FromInt64(6L))).WithRounding(ERounding.OddOrZeroFiveUp);
        T rzz = rz = this.Add(thisValue, this.helper.ValueOf(-1), null);
        T guess = rz;
        T lastGuess = null;
        T lastDiff = null;
        boolean haveLastDiff = false;
        EInteger iterations = EInteger.FromInt32(0);
        boolean sub = true;
        EInteger denom = EInteger.FromInt64(2L);
        while (more) {
            lastGuess = guess;
            rzz = this.Multiply(rzz, rz, ctxdiv);
            T rd = this.Divide(rzz, this.helper.CreateNewWithFlags(denom, EInteger.FromInt32(0), 0), ctxdiv);
            if (haveLastDiff && this.compareTo(lastDiff, rd) == 0) break;
            T newGuess = sub ? this.Add(guess, this.NegateRaw(rd), ctxdiv) : this.Add(guess, rd, ctxdiv);
            int guessCmp = this.compareTo(lastGuess, newGuess);
            if (guessCmp == 0) {
                more = false;
            } else if (guessCmp > 0 && lastCompare < 0 || lastCompare > 0 && guessCmp < 0) {
                more &= ++vacillations <= 3 || guessCmp <= 0;
            }
            lastCompare = guessCmp;
            lastDiff = this.AbsRaw(rd);
            haveLastDiff = true;
            guess = newGuess;
            if (!more) continue;
            sub = !sub;
            denom = denom.Add(EInteger.FromInt32(1));
            iterations = iterations.Add(EInteger.FromInt32(1));
        }
        return this.RoundToPrecision(guess, ctx);
    }

    private T LnInternal(T thisValue, EInteger workingPrecision, EContext ctx) {
        boolean more = true;
        int lastCompare = 0;
        int vacillations = 0;
        EContext ctxdiv = RadixMath.SetPrecisionIfLimited(ctx, workingPrecision.Add(EInteger.FromInt64(6L))).WithRounding(ERounding.OddOrZeroFiveUp);
        T z = this.Add(this.NegateRaw(thisValue), this.helper.ValueOf(1), null);
        T zpow = this.Multiply(z, z, ctxdiv);
        T guess = this.NegateRaw(z);
        T lastGuess = null;
        EInteger denom = EInteger.FromInt64(2L);
        while (more) {
            lastGuess = guess;
            T tmp = this.Divide(zpow, this.helper.CreateNewWithFlags(denom, EInteger.FromInt32(0), 0), ctxdiv);
            T newGuess = this.Add(guess, this.NegateRaw(tmp), ctxdiv);
            int guessCmp = this.compareTo(lastGuess, newGuess);
            if (guessCmp == 0) {
                more = false;
            } else if (guessCmp > 0 && lastCompare < 0 || lastCompare > 0 && guessCmp < 0) {
                more &= ++vacillations <= 3 || guessCmp <= 0;
            }
            lastCompare = guessCmp;
            guess = newGuess;
            if (!more) continue;
            zpow = this.Multiply(zpow, z, ctxdiv);
            denom = denom.Add(EInteger.FromInt32(1));
        }
        return this.RoundToPrecision(guess, ctx);
    }

    private T LnTenConstant(EContext ctx) {
        T thisValue = this.helper.ValueOf(10);
        FastInteger error = new FastInteger(14);
        EInteger bigError = error.AsEInteger();
        EContext ctxdiv = RadixMath.SetPrecisionIfLimited(ctx, ctx.getPrecision().Add(bigError)).WithRounding(ERounding.OddOrZeroFiveUp).WithBlankFlags();
        for (int i = 0; i < 13; ++i) {
            thisValue = this.SquareRoot(thisValue, ctxdiv.WithUnlimitedExponents());
        }
        thisValue = this.Divide(this.helper.ValueOf(1), thisValue, ctxdiv);
        thisValue = this.LnInternalCloseToOne(thisValue, ctxdiv.getPrecision(), ctxdiv);
        thisValue = this.NegateRaw(thisValue);
        thisValue = this.Multiply(thisValue, this.helper.ValueOf(8192), ctx);
        if (ctx.getHasFlags()) {
            ctx.setFlags(ctx.getFlags() | 1);
            ctx.setFlags(ctx.getFlags() | 2);
        }
        return thisValue;
    }

    private T MinMaxHandleSpecial(T thisValue, T otherValue, EContext ctx, boolean isMinOp, boolean compareAbs) {
        int otherFlags;
        int thisFlags = this.helper.GetFlags(thisValue);
        if (((thisFlags | (otherFlags = this.helper.GetFlags(otherValue))) & 0xE) != 0) {
            if ((thisFlags & 8) != 0) {
                return this.SignalingNaNInvalid(thisValue, ctx);
            }
            if ((otherFlags & 8) != 0) {
                return this.SignalingNaNInvalid(otherValue, ctx);
            }
            if ((thisFlags & 4) != 0) {
                if ((otherFlags & 4) != 0) {
                    return this.ReturnQuietNaN(thisValue, ctx);
                }
                return this.RoundToPrecision(otherValue, ctx);
            }
            if ((otherFlags & 4) != 0) {
                return this.RoundToPrecision(thisValue, ctx);
            }
            if ((thisFlags & 2) != 0) {
                if (compareAbs && (otherFlags & 2) == 0) {
                    return isMinOp ? this.RoundToPrecision(otherValue, ctx) : thisValue;
                }
                if (isMinOp) {
                    return (thisFlags & 1) != 0 ? thisValue : this.RoundToPrecision(otherValue, ctx);
                }
                return (thisFlags & 1) == 0 ? thisValue : this.RoundToPrecision(otherValue, ctx);
            }
            if ((otherFlags & 2) != 0) {
                if (compareAbs) {
                    return isMinOp ? this.RoundToPrecision(thisValue, ctx) : otherValue;
                }
                return isMinOp ? ((otherFlags & 1) == 0 ? this.RoundToPrecision(thisValue, ctx) : otherValue) : ((otherFlags & 1) != 0 ? this.RoundToPrecision(thisValue, ctx) : otherValue);
            }
        }
        return null;
    }

    private T MultiplyAddHandleSpecial(T op1, T op2, T op3, EContext ctx) {
        int op1Flags = this.helper.GetFlags(op1);
        if ((op1Flags & 8) != 0) {
            return this.SignalingNaNInvalid(op1, ctx);
        }
        int op2Flags = this.helper.GetFlags(op2);
        if ((op2Flags & 8) != 0) {
            return this.SignalingNaNInvalid(op2, ctx);
        }
        int op3Flags = this.helper.GetFlags(op3);
        if ((op1Flags & 4) != 0) {
            if ((op3Flags & 8) != 0) {
                return this.SignalingNaNInvalid(op3, ctx);
            }
            return this.ReturnQuietNaN(op1, ctx);
        }
        if ((op2Flags & 4) != 0) {
            if ((op3Flags & 8) != 0) {
                return this.SignalingNaNInvalid(op3, ctx);
            }
            return this.ReturnQuietNaN(op2, ctx);
        }
        if ((op1Flags & 2) != 0 && (op2Flags & 0xE) == 0 && this.helper.GetMantissa(op2).isZero()) {
            return this.SignalInvalid(ctx);
        }
        if ((op2Flags & 2) != 0 && (op1Flags & 0xE) == 0 && this.helper.GetMantissa(op1).isZero()) {
            return this.SignalInvalid(ctx);
        }
        if ((op3Flags & 8) != 0) {
            return this.SignalingNaNInvalid(op3, ctx);
        }
        return (op3Flags & 4) != 0 ? (T)this.ReturnQuietNaN(op3, ctx) : null;
    }

    private T NegateRaw(T val) {
        if (val == null) {
            return val;
        }
        int sign = this.helper.GetFlags(val) & 1;
        return this.helper.CreateNewWithFlags(this.helper.GetMantissa(val), this.helper.GetExponent(val), sign == 0 ? 1 : 0);
    }

    private T PowerIntegral(T thisValue, EInteger powIntBig, EContext ctx) {
        int sign = powIntBig.signum();
        T one = this.helper.ValueOf(1);
        if (sign == 0) {
            return this.RoundToPrecision(one, ctx);
        }
        if (powIntBig.equals(EInteger.FromInt32(1))) {
            return this.RoundToPrecision(thisValue, ctx);
        }
        if (powIntBig.equals(EInteger.FromInt64(2L))) {
            return this.Multiply(thisValue, thisValue, ctx);
        }
        if (powIntBig.equals(EInteger.FromInt64(3L))) {
            return this.Multiply(thisValue, this.Multiply(thisValue, thisValue, null), ctx);
        }
        boolean retvalNeg = this.IsNegative(thisValue) && !powIntBig.isEven();
        FastInteger error = this.helper.GetDigitLength(powIntBig.Abs());
        error = error.Copy();
        error.AddInt(18);
        EInteger bigError = error.AsEInteger();
        EContext ctxdiv = RadixMath.SetPrecisionIfLimited(ctx, ctx.getPrecision().Add(bigError)).WithRounding(ERounding.OddOrZeroFiveUp).WithBlankFlags();
        if (sign < 0) {
            thisValue = this.Divide(one, thisValue, ctxdiv);
            if ((ctxdiv.getFlags() & 0x10) != 0) {
                return this.SignalOverflow(ctx, retvalNeg);
            }
            powIntBig = powIntBig.Negate();
        }
        T r = one;
        while (!powIntBig.isZero()) {
            if (!powIntBig.isEven()) {
                r = this.Multiply(r, thisValue, ctxdiv);
                if ((ctxdiv.getFlags() & 0x10) != 0) {
                    return this.SignalOverflow(ctx, retvalNeg);
                }
            }
            if ((powIntBig = powIntBig.ShiftRight(1)).isZero()) continue;
            ctxdiv.setFlags(0);
            T tmp = this.Multiply(thisValue, thisValue, ctxdiv);
            if ((ctxdiv.getFlags() & 0x10) != 0) {
                return this.SignalOverflow(ctx, retvalNeg);
            }
            thisValue = tmp;
        }
        return this.RoundToPrecision(r, ctx);
    }

    private T ReduceToPrecisionAndIdealExponent(T thisValue, EContext ctx, FastInteger precision, FastInteger idealExp) {
        T ret = this.RoundToPrecision(thisValue, ctx);
        if (ret != null && (this.helper.GetFlags(ret) & 0xE) == 0) {
            EInteger bigmant = this.helper.GetMantissa(ret);
            FastInteger exp = FastInteger.FromBig(this.helper.GetExponent(ret));
            int radix = this.thisRadix;
            if (bigmant.isZero()) {
                exp = new FastInteger(0);
            } else {
                FastInteger digits = precision == null ? null : this.helper.GetDigitLength(bigmant);
                bigmant = NumberUtility.ReduceTrailingZeros(bigmant, exp, radix, digits, precision, idealExp);
            }
            int flags = this.helper.GetFlags(thisValue);
            ret = this.helper.CreateNewWithFlags(bigmant, exp.AsEInteger(), flags);
            if (ctx != null && ctx.getClampNormalExponents()) {
                EContext ctxtmp = ctx.WithBlankFlags();
                ret = this.RoundToPrecision(ret, ctxtmp);
                if (ctx.getHasFlags()) {
                    ctx.setFlags(ctx.getFlags() | ctxtmp.getFlags() & 0xFFFFFFDF);
                }
            }
            ret = this.EnsureSign(ret, (flags & 1) != 0);
        }
        return ret;
    }

    private T RemainderHandleSpecial(T thisValue, T other, EContext ctx) {
        int otherFlags;
        int thisFlags = this.helper.GetFlags(thisValue);
        if (((thisFlags | (otherFlags = this.helper.GetFlags(other))) & 0xE) != 0) {
            T result = this.HandleNotANumber(thisValue, other, ctx);
            if (result != null) {
                return result;
            }
            if ((thisFlags & 2) != 0) {
                return this.SignalInvalid(ctx);
            }
            if ((otherFlags & 2) != 0) {
                return this.RoundToPrecision(thisValue, ctx);
            }
        }
        return this.helper.GetMantissa(other).isZero() ? (T)this.SignalInvalid(ctx) : null;
    }

    private T ReturnQuietNaN(T thisValue, EContext ctx) {
        EInteger mant = this.helper.GetMantissa(thisValue);
        boolean mantChanged = false;
        if (!mant.isZero() && ctx != null && ctx.getHasMaxPrecision()) {
            FastInteger compPrecision = FastInteger.FromBig(ctx.getPrecision());
            if (this.helper.GetDigitLength(mant).compareTo(compPrecision) >= 0) {
                EInteger limit = this.TryMultiplyByRadixPower(EInteger.FromInt32(1), compPrecision);
                if (limit == null) {
                    return this.SignalInvalidWithMessage(ctx, "Result requires too much memory");
                }
                if (mant.compareTo(limit) >= 0) {
                    mant = mant.Remainder(limit);
                    mantChanged = true;
                }
            }
        }
        int flags = this.helper.GetFlags(thisValue);
        if (!mantChanged && (flags & 4) != 0) {
            return thisValue;
        }
        flags &= 1;
        return this.helper.CreateNewWithFlags(mant, EInteger.FromInt32(0), flags |= 4);
    }

    private boolean IsNullOrInt32FriendlyContext(EContext ctx) {
        return ctx == null || !ctx.getHasFlags() && ctx.getTraps() == 0 && (!ctx.getHasExponentRange() || ctx.getEMin().compareTo(-10) < 0 && ctx.getEMax().compareTo(0) >= 0) && ctx.getRounding() != ERounding.Floor && (!ctx.getHasMaxPrecision() || this.thisRadix >= 10 && !ctx.isPrecisionInBits() && ctx.getPrecision().compareTo(10) >= 0 || (this.thisRadix >= 2 || ctx.isPrecisionInBits()) && ctx.getPrecision().compareTo(32) >= 0);
    }

    private boolean RoundGivenAccum(IShiftAccumulator accum, ERounding rounding, boolean neg) {
        return this.RoundGivenDigits(accum.getLastDiscardedDigit(), accum.getOlderDiscardedDigits(), rounding, neg, accum.getShiftedIntFast());
    }

    private boolean RoundGivenDigits(int lastDiscarded, int olderDiscarded, ERounding rounding, boolean neg, FastInteger fastNumber) {
        boolean incremented = false;
        int radix = this.thisRadix;
        if (rounding == ERounding.HalfUp) {
            incremented |= lastDiscarded >= radix / 2;
        } else if (rounding == ERounding.HalfEven) {
            if (lastDiscarded >= radix / 2) {
                incremented = lastDiscarded > radix / 2 || olderDiscarded != 0 ? true : (incremented |= !fastNumber.isEvenNumber());
            }
        } else if (rounding == ERounding.HalfDown) {
            incremented |= lastDiscarded > radix / 2 || lastDiscarded == radix / 2 && olderDiscarded != 0;
        } else if (rounding == ERounding.Ceiling) {
            incremented |= !neg && (lastDiscarded | olderDiscarded) != 0;
        } else if (rounding == ERounding.Floor) {
            incremented |= neg && (lastDiscarded | olderDiscarded) != 0;
        } else if (rounding == ERounding.Up) {
            incremented |= (lastDiscarded | olderDiscarded) != 0;
        } else if (rounding == ERounding.Odd || rounding == ERounding.OddOrZeroFiveUp && radix == 2) {
            incremented |= (lastDiscarded | olderDiscarded) != 0 && fastNumber.isEvenNumber();
        } else if ((rounding == ERounding.ZeroFiveUp || rounding == ERounding.OddOrZeroFiveUp && radix != 2) && (lastDiscarded | olderDiscarded) != 0) {
            if (radix == 2) {
                incremented = true;
            } else {
                int lastDigit = FastIntegerFixed.FromFastInteger(fastNumber).Mod(radix);
                if (lastDigit == 0 || lastDigit == radix / 2) {
                    incremented = true;
                }
            }
        }
        return incremented;
    }

    private T RoundToPrecisionInternal(T thisValue, int lastDiscarded, int olderDiscarded, FastInteger shift, boolean adjustNegativeZero, EContext ctx) {
        boolean doRounding;
        FastInteger expdiff;
        FastInteger adjExponent;
        boolean nonHalfRounding;
        boolean unlimitedPrec;
        FastIntegerFixed expabs;
        boolean unlimitedPrecisionExp = ctx == null || !ctx.getHasMaxPrecision() && !ctx.getHasExponentRange();
        int thisFlags = this.helper.GetFlags(thisValue);
        if ((thisFlags & 0xE) != 0) {
            if ((thisFlags & 8) != 0) {
                if (ctx != null && ctx.getHasFlags()) {
                    ctx.setFlags(ctx.getFlags() | 0x40);
                }
                return this.ReturnQuietNaN(thisValue, ctx);
            }
            if ((thisFlags & 4) != 0) {
                return this.ReturnQuietNaN(thisValue, ctx);
            }
            if ((thisFlags & 2) != 0) {
                return thisValue;
            }
        }
        if (!(!unlimitedPrecisionExp || (lastDiscarded | olderDiscarded) != 0 || shift != null && !shift.isValueZero() || adjustNegativeZero && (thisFlags & 1) != 0 && this.helper.GetMantissa(thisValue).isZero())) {
            return thisValue;
        }
        if (unlimitedPrecisionExp && (ctx == null || !ctx.getHasFlags() && ctx.getTraps() == 0) && (shift == null || shift.isValueZero())) {
            boolean negzero;
            ERounding er = ctx == null ? ERounding.HalfDown : ctx.getRounding();
            boolean negative = (thisFlags & 1) != 0;
            boolean bl = negzero = adjustNegativeZero && negative && this.helper.GetMantissa(thisValue).isZero() && er != ERounding.Floor;
            if (!negzero) {
                if (er == ERounding.Down) {
                    return thisValue;
                }
                if (this.thisRadix == 10 && er == ERounding.HalfEven) {
                    if (lastDiscarded < 5) {
                        return thisValue;
                    }
                    if (lastDiscarded > 5 || olderDiscarded != 0) {
                        FastIntegerFixed bm = this.helper.GetMantissaFastInt(thisValue);
                        return this.helper.CreateNewWithFlagsFastInt(FastIntegerFixed.Add(bm, FastIntegerFixed.One), this.helper.GetExponentFastInt(thisValue), thisFlags);
                    }
                }
                if (this.thisRadix == 2 && er == ERounding.HalfEven && lastDiscarded == 0) {
                    return thisValue;
                }
                if (!this.RoundGivenDigits(lastDiscarded, olderDiscarded, er, negative, FastInteger.FromBig(this.helper.GetMantissa(thisValue)))) {
                    return thisValue;
                }
                FastIntegerFixed bm = this.helper.GetMantissaFastInt(thisValue);
                return this.helper.CreateNewWithFlagsFastInt(FastIntegerFixed.Add(bm, FastIntegerFixed.One), this.helper.GetExponentFastInt(thisValue), thisFlags);
            }
        }
        if (this.IsNullOrInt32FriendlyContext(ctx) && (lastDiscarded | olderDiscarded) == 0 && (shift == null || shift.isValueZero()) && (expabs = this.helper.GetExponentFastInt(thisValue)).isValueZero()) {
            FastIntegerFixed mantabs = this.helper.GetMantissaFastInt(thisValue);
            if (mantabs.isValueZero() && adjustNegativeZero && (thisFlags & 1) != 0) {
                return this.helper.ValueOf(0);
            }
            if (mantabs.CanFitInInt32()) {
                return thisValue;
            }
        }
        ctx = ctx == null ? DefaultUnlimited : ctx;
        boolean binaryPrec = ctx.isPrecisionInBits();
        FastInteger fastPrecision = ctx.getPrecision().CanFitInInt32() ? new FastInteger(ctx.getPrecision().ToInt32Checked()) : FastInteger.FromBig(ctx.getPrecision());
        binaryPrec &= this.thisRadix != 2 && !ctx.getPrecision().isZero();
        IShiftAccumulator accum = null;
        FastInteger fastEMin = null;
        FastInteger fastEMax = null;
        if (ctx != null && ctx.getHasExponentRange()) {
            fastEMax = ctx.getEMax().CanFitInInt32() ? new FastInteger(ctx.getEMax().ToInt32Checked()) : FastInteger.FromBig(ctx.getEMax());
            fastEMin = ctx.getEMin().CanFitInInt32() ? new FastInteger(ctx.getEMin().ToInt32Checked()) : FastInteger.FromBig(ctx.getEMin());
        }
        ERounding rounding = ctx.getRounding();
        boolean bl = unlimitedPrec = !ctx.getHasMaxPrecision();
        if (!binaryPrec && fastPrecision.signum() > 0 && (shift == null || shift.isValueZero())) {
            FastInteger digitCount;
            FastIntegerFixed mantabs = this.helper.GetMantissaFastInt(thisValue);
            if (adjustNegativeZero && (thisFlags & 1) != 0 && mantabs.isValueZero() && ctx.getRounding() != ERounding.Floor) {
                thisValue = this.EnsureSign(thisValue, false);
                thisFlags = 0;
            }
            if ((digitCount = (accum = this.helper.CreateShiftAccumulatorWithDigitsFastInt(mantabs, lastDiscarded, olderDiscarded)).GetDigitLength()).compareTo(fastPrecision) <= 0) {
                FastInteger fastNormalMin;
                FastInteger fastAdjustedExp;
                if (!this.RoundGivenAccum(accum, ctx.getRounding(), (thisFlags & 1) != 0)) {
                    if (ctx.getHasFlags() && (lastDiscarded | olderDiscarded) != 0) {
                        ctx.setFlags(ctx.getFlags() | 3);
                    }
                    if (!ctx.getHasExponentRange()) {
                        return thisValue;
                    }
                    FastIntegerFixed bigexp = this.helper.GetExponentFastInt(thisValue);
                    if (ctx == null || ctx.getAdjustExponent()) {
                        fastAdjustedExp = bigexp.ToFastInteger().Add(fastPrecision).Decrement();
                        fastNormalMin = fastEMin.Copy().Add(fastPrecision).Decrement();
                    } else {
                        fastAdjustedExp = bigexp.ToFastInteger();
                        fastNormalMin = fastEMin;
                    }
                    if (fastAdjustedExp.compareTo(fastEMax) <= 0 && fastAdjustedExp.compareTo(fastNormalMin) >= 0) {
                        return thisValue;
                    }
                } else {
                    if (ctx.getHasFlags() && (lastDiscarded | olderDiscarded) != 0) {
                        ctx.setFlags(ctx.getFlags() | 3);
                    }
                    boolean stillWithinPrecision = false;
                    mantabs = mantabs.Increment();
                    int precisionCmp = digitCount.compareTo(fastPrecision);
                    if (precisionCmp < 0 || precisionCmp == 0 && (this.thisRadix & 1) == 0 && !mantabs.isEvenNumber()) {
                        stillWithinPrecision = true;
                    } else {
                        EInteger radixPower = this.TryMultiplyByRadixPower(EInteger.FromInt32(1), fastPrecision);
                        if (radixPower == null) {
                            return this.SignalInvalidWithMessage(ctx, "Result requires too much memory");
                        }
                        boolean bl2 = stillWithinPrecision = mantabs.ToEInteger().compareTo(radixPower) < 0;
                    }
                    if (stillWithinPrecision) {
                        if (!ctx.getHasExponentRange()) {
                            return this.helper.CreateNewWithFlagsFastInt(mantabs, this.helper.GetExponentFastInt(thisValue), thisFlags);
                        }
                        FastIntegerFixed bigexp = this.helper.GetExponentFastInt(thisValue);
                        if (ctx == null || ctx.getAdjustExponent()) {
                            fastAdjustedExp = bigexp.ToFastInteger().Add(fastPrecision).Decrement();
                            fastNormalMin = fastEMin.Copy().Add(fastPrecision).Decrement();
                        } else {
                            fastAdjustedExp = bigexp.ToFastInteger();
                            fastNormalMin = fastEMin;
                        }
                        if (fastAdjustedExp.compareTo(fastEMax) <= 0 && fastAdjustedExp.compareTo(fastNormalMin) >= 0) {
                            return this.helper.CreateNewWithFlagsFastInt(mantabs, bigexp, thisFlags);
                        }
                    }
                }
            }
        }
        if (adjustNegativeZero && (thisFlags & 1) != 0 && rounding != ERounding.Floor && this.helper.GetMantissa(thisValue).isZero()) {
            thisValue = this.EnsureSign(thisValue, false);
            thisFlags = 0;
        }
        boolean neg = (thisFlags & 1) != 0;
        FastIntegerFixed bigmantissa = this.helper.GetMantissaFastInt(thisValue);
        boolean mantissaWasZero = bigmantissa.isValueZero() && (lastDiscarded | olderDiscarded) == 0;
        FastInteger exp = this.helper.GetExponentFastInt(thisValue).ToFastInteger();
        int flags = 0;
        if (accum == null) {
            accum = this.helper.CreateShiftAccumulatorWithDigitsFastInt(bigmantissa, lastDiscarded, olderDiscarded);
        }
        FastInteger bitLength = fastPrecision;
        if (binaryPrec) {
            fastPrecision = this.MaxDigitLengthForBitLength(fastPrecision);
        }
        boolean bl3 = nonHalfRounding = rounding != ERounding.HalfEven && rounding != ERounding.HalfUp && rounding != ERounding.HalfDown;
        if (!unlimitedPrec) {
            accum.ShiftToDigits(fastPrecision, shift, nonHalfRounding);
        } else {
            if (shift != null && shift.signum() != 0) {
                accum.TruncateOrShiftRight(shift, nonHalfRounding);
            }
            fastPrecision = accum.GetDigitLength();
        }
        if (binaryPrec) {
            while (this.IsHigherThanBitLength(accum.getShiftedInt(), bitLength)) {
                accum.ShiftRightInt(1);
            }
        }
        FastInteger discardedBits = accum.getDiscardedDigitCount().Copy();
        exp.Add(discardedBits);
        FastInteger fastInteger = adjExponent = ctx.getAdjustExponent() ? exp.Copy().Add(accum.GetDigitLength()).Decrement() : exp.Copy();
        if (binaryPrec && fastEMax != null && adjExponent.compareTo(fastEMax) == 0) {
            FastInteger expdiff2 = fastPrecision.Copy().Subtract(accum.GetDigitLength());
            EInteger currMantissa = accum.getShiftedInt();
            if ((currMantissa = this.TryMultiplyByRadixPower(currMantissa, expdiff2)) == null) {
                return this.SignalInvalidWithMessage(ctx, "Result requires too much memory");
            }
            if (this.IsHigherThanBitLength(currMantissa, bitLength)) {
                adjExponent.Increment();
            }
        }
        if (fastEMax != null && adjExponent.compareTo(fastEMax) > 0) {
            if (mantissaWasZero) {
                if (ctx.getHasFlags()) {
                    ctx.setFlags(ctx.getFlags() | (flags | 0x20));
                }
                if (ctx.getClampNormalExponents() && ctx.getAdjustExponent()) {
                    FastInteger clampExp = fastEMax.Copy();
                    clampExp.Increment().Subtract(fastPrecision);
                    if (fastEMax.compareTo(clampExp) > 0) {
                        fastEMax = clampExp;
                    }
                }
                return this.helper.CreateNewWithFlagsFastInt(bigmantissa, FastIntegerFixed.FromFastInteger(fastEMax), thisFlags);
            }
            return this.SignalOverflow(ctx, neg);
        }
        if (fastEMin != null && adjExponent.compareTo(fastEMin) < 0) {
            FastInteger subExp;
            FastInteger fastETiny = fastEMin;
            if (ctx.getAdjustExponent()) {
                fastETiny = fastETiny.Copy().Subtract(fastPrecision).Increment();
            }
            if (ctx.getHasFlags() && !accum.getShiftedInt().isZero()) {
                FastInteger newAdjExponent = adjExponent;
                if (this.RoundGivenAccum(accum, rounding, neg)) {
                    EInteger earlyRounded = accum.getShiftedInt().Add(EInteger.FromInt32(1));
                    if (!unlimitedPrec && (earlyRounded.isEven() || (this.thisRadix & 1) != 0)) {
                        FastInteger newDigitLength = this.helper.GetDigitLength(earlyRounded);
                        if (binaryPrec || newDigitLength.compareTo(fastPrecision) > 0) {
                            newDigitLength = fastPrecision.Copy();
                        }
                        FastInteger fastInteger2 = newAdjExponent = ctx.getAdjustExponent() ? exp.Copy().Add(newDigitLength).Decrement() : exp;
                    }
                }
                if (newAdjExponent.compareTo(fastEMin) < 0) {
                    flags |= 4;
                }
            }
            if ((subExp = exp.Copy()).compareTo(fastETiny) < 0) {
                boolean nonZeroDiscardedDigits;
                expdiff = fastETiny.Copy().Subtract(exp);
                accum.TruncateOrShiftRight(expdiff, nonHalfRounding);
                FastInteger newmantissa = accum.getShiftedIntFast();
                boolean bl4 = nonZeroDiscardedDigits = (accum.getLastDiscardedDigit() | accum.getOlderDiscardedDigits()) != 0;
                if (nonZeroDiscardedDigits && rounding == ERounding.None) {
                    return this.SignalInvalidWithMessage(ctx, "Rounding was required");
                }
                if (accum.getDiscardedDigitCount().signum() != 0 || nonZeroDiscardedDigits) {
                    if (ctx.getHasFlags()) {
                        if (!mantissaWasZero) {
                            flags |= 2;
                        }
                        if (nonZeroDiscardedDigits) {
                            flags |= 3;
                        }
                    }
                    if (this.RoundGivenAccum(accum, rounding, neg)) {
                        newmantissa.Increment();
                    }
                }
                if (ctx.getHasFlags()) {
                    if (newmantissa.isValueZero()) {
                        flags |= 0x20;
                    }
                    if ((flags & 5) == 5) {
                        flags |= 0xA;
                    }
                    ctx.setFlags(ctx.getFlags() | flags);
                }
                if (ctx.getClampNormalExponents()) {
                    FastInteger clampExp = fastEMax.Copy();
                    if (ctx.getAdjustExponent()) {
                        clampExp.Increment().Subtract(fastPrecision);
                    }
                    if (fastETiny.compareTo(clampExp) > 0) {
                        if (!newmantissa.isValueZero()) {
                            expdiff = fastETiny.Copy().Subtract(clampExp);
                            bigmantissa = this.TryMultiplyByRadixPowerFastInt(FastIntegerFixed.FromFastInteger(newmantissa), expdiff);
                            if (bigmantissa == null) {
                                return this.SignalInvalidWithMessage(ctx, "Result requires too much memory");
                            }
                            if (ctx.getHasFlags()) {
                                ctx.setFlags(ctx.getFlags() | 0x20);
                            }
                            return this.helper.CreateNewWithFlagsFastInt(bigmantissa, FastIntegerFixed.FromFastInteger(clampExp), neg ? 1 : 0);
                        }
                        if (ctx.getHasFlags()) {
                            ctx.setFlags(ctx.getFlags() | 0x20);
                        }
                        fastETiny = clampExp;
                    }
                }
                if (ctx.getHasFlags()) {
                    ctx.setFlags(ctx.getFlags() | flags);
                }
                return this.helper.CreateNewWithFlagsFastInt(FastIntegerFixed.FromFastInteger(newmantissa), FastIntegerFixed.FromFastInteger(fastETiny), neg ? 1 : 0);
            }
        }
        boolean recheckOverflow = false;
        boolean bl5 = doRounding = accum.getDiscardedDigitCount().signum() != 0 || (accum.getLastDiscardedDigit() | accum.getOlderDiscardedDigits()) != 0;
        if (doRounding) {
            if (!bigmantissa.isValueZero()) {
                flags |= 2;
                if (rounding == ERounding.None) {
                    return this.SignalInvalidWithMessage(ctx, "Rounding was required");
                }
            }
            bigmantissa = FastIntegerFixed.FromFastInteger(accum.getShiftedIntFast());
            if ((accum.getLastDiscardedDigit() | accum.getOlderDiscardedDigits()) != 0) {
                flags |= 3;
                if (rounding == ERounding.None) {
                    return this.SignalInvalidWithMessage(ctx, "Rounding was required");
                }
            }
            if (this.RoundGivenAccum(accum, rounding, neg)) {
                bigmantissa = bigmantissa.Increment();
                recheckOverflow |= binaryPrec;
                if (!(unlimitedPrec || !bigmantissa.isEvenNumber() && (this.thisRadix & 1) == 0 || !binaryPrec && accum.GetDigitLength().compareTo(fastPrecision) < 0)) {
                    accum = this.helper.CreateShiftAccumulatorWithDigitsFastInt(bigmantissa, 0, 0);
                    FastInteger newDigitLength = accum.GetDigitLength();
                    if (binaryPrec || newDigitLength.compareTo(fastPrecision) > 0) {
                        FastInteger neededShift = newDigitLength.Copy().Subtract(fastPrecision);
                        accum.TruncateOrShiftRight(neededShift, nonHalfRounding);
                        if (binaryPrec) {
                            while (this.IsHigherThanBitLength(accum.getShiftedInt(), bitLength)) {
                                accum.ShiftRightInt(1);
                            }
                        }
                        if (accum.getDiscardedDigitCount().signum() != 0) {
                            exp.Add(accum.getDiscardedDigitCount());
                            discardedBits.Add(accum.getDiscardedDigitCount());
                            bigmantissa = FastIntegerFixed.FromFastInteger(accum.getShiftedIntFast());
                            recheckOverflow |= !binaryPrec;
                        }
                    }
                }
            }
        }
        if (fastEMax != null && recheckOverflow) {
            adjExponent = exp.Copy();
            if (ctx.getAdjustExponent()) {
                adjExponent.Add(accum.GetDigitLength()).Decrement();
            }
            if (binaryPrec && fastEMax != null && adjExponent.compareTo(fastEMax) == 0) {
                expdiff = fastPrecision.Copy().Subtract(accum.GetDigitLength());
                EInteger currMantissa = accum.getShiftedInt();
                if ((currMantissa = this.TryMultiplyByRadixPower(currMantissa, expdiff)) == null) {
                    return this.SignalInvalidWithMessage(ctx, "Result requires too much memory");
                }
                if (this.IsHigherThanBitLength(currMantissa, bitLength)) {
                    adjExponent.Increment();
                }
            }
            if (adjExponent.compareTo(fastEMax) > 0) {
                return this.SignalOverflow(ctx, neg);
            }
        }
        if (ctx.getHasFlags()) {
            ctx.setFlags(ctx.getFlags() | flags);
        }
        if (ctx.getClampNormalExponents()) {
            FastInteger clampExp = fastEMax.Copy();
            if (ctx.getAdjustExponent()) {
                clampExp.Increment().Subtract(fastPrecision);
            }
            if (exp.compareTo(clampExp) > 0) {
                FastInteger expdiff3;
                if (!bigmantissa.isValueZero() && (bigmantissa = this.TryMultiplyByRadixPowerFastInt(bigmantissa, expdiff3 = exp.Copy().Subtract(clampExp))) == null) {
                    return this.SignalInvalidWithMessage(ctx, "Result requires too much memory");
                }
                if (ctx.getHasFlags()) {
                    ctx.setFlags(ctx.getFlags() | 0x20);
                }
                exp = clampExp;
            }
        }
        return this.helper.CreateNewWithFlagsFastInt(bigmantissa, FastIntegerFixed.FromFastInteger(exp), neg ? 1 : 0);
    }

    private T RoundToScale(EInteger mantissa, EInteger remainder, EInteger divisor, EInteger desiredExponent, FastInteger shift, boolean neg, EContext ctx) {
        ERounding rounding = ctx == null ? ERounding.HalfEven : ctx.getRounding();
        int lastDiscarded = 0;
        int olderDiscarded = 0;
        if (!remainder.isZero()) {
            if (rounding == ERounding.HalfDown || rounding == ERounding.HalfUp || rounding == ERounding.HalfEven) {
                EInteger halfDivisor = divisor.ShiftRight(1);
                int cmpHalf = remainder.compareTo(halfDivisor);
                if (cmpHalf == 0 && divisor.isEven()) {
                    lastDiscarded = this.thisRadix / 2;
                    olderDiscarded = 0;
                } else if (cmpHalf > 0) {
                    lastDiscarded = this.thisRadix / 2;
                    olderDiscarded = 1;
                } else {
                    lastDiscarded = 0;
                    olderDiscarded = 1;
                }
            } else {
                if (rounding == ERounding.None) {
                    return this.SignalInvalidWithMessage(ctx, "Rounding was required");
                }
                lastDiscarded = 1;
                olderDiscarded = 1;
            }
        }
        int flags = 0;
        EInteger newmantissa = mantissa;
        if (shift.isValueZero()) {
            if (lastDiscarded | olderDiscarded) {
                flags |= 3;
                if (rounding == ERounding.None) {
                    return this.SignalInvalidWithMessage(ctx, "Rounding was required");
                }
                FastInteger fastNewMantissa = FastInteger.FromBig(newmantissa);
                if (this.RoundGivenDigits(lastDiscarded, olderDiscarded, rounding, neg, fastNewMantissa)) {
                    newmantissa = newmantissa.Add(EInteger.FromInt32(1));
                }
            }
        } else {
            IShiftAccumulator accum = this.helper.CreateShiftAccumulatorWithDigits(mantissa, lastDiscarded, olderDiscarded);
            accum.TruncateOrShiftRight(shift, false);
            newmantissa = accum.getShiftedInt();
            if (accum.getDiscardedDigitCount().signum() != 0 || (accum.getLastDiscardedDigit() | accum.getOlderDiscardedDigits()) != 0) {
                if (!mantissa.isZero()) {
                    flags |= 2;
                }
                if ((accum.getLastDiscardedDigit() | accum.getOlderDiscardedDigits()) != 0) {
                    flags |= 3;
                    if (rounding == ERounding.None) {
                        return this.SignalInvalidWithMessage(ctx, "Rounding was required");
                    }
                }
                if (this.RoundGivenAccum(accum, rounding, neg)) {
                    newmantissa = newmantissa.Add(EInteger.FromInt32(1));
                }
            }
        }
        if (ctx != null && ctx.getHasFlags()) {
            ctx.setFlags(ctx.getFlags() | flags);
        }
        return this.helper.CreateNewWithFlags(newmantissa, desiredExponent, neg ? 1 : 0);
    }

    private int[] RoundToScaleStatus(EInteger remainder, EInteger divisor, EContext ctx) {
        ERounding rounding = ctx == null ? ERounding.HalfEven : ctx.getRounding();
        int lastDiscarded = 0;
        int olderDiscarded = 0;
        if (!remainder.isZero()) {
            if (rounding == ERounding.HalfDown || rounding == ERounding.HalfUp || rounding == ERounding.HalfEven) {
                EInteger halfDivisor = divisor.ShiftRight(1);
                int cmpHalf = remainder.compareTo(halfDivisor);
                if (cmpHalf == 0 && divisor.isEven()) {
                    lastDiscarded = this.thisRadix / 2;
                    olderDiscarded = 0;
                } else if (cmpHalf > 0) {
                    lastDiscarded = this.thisRadix / 2;
                    olderDiscarded = 1;
                } else {
                    lastDiscarded = 0;
                    olderDiscarded = 1;
                }
            } else {
                if (rounding == ERounding.None) {
                    return null;
                }
                lastDiscarded = 1;
                olderDiscarded = 1;
            }
        }
        return new int[]{lastDiscarded, olderDiscarded};
    }

    private T SignalDivideByZero(EContext ctx, boolean neg) {
        if (ctx != null && ctx.getHasFlags()) {
            ctx.setFlags(ctx.getFlags() | 0x80);
        }
        if (this.support == 0) {
            throw new ArithmeticException("Division by zero");
        }
        return this.helper.CreateNewWithFlags(EInteger.FromInt32(0), EInteger.FromInt32(0), 2 | (neg ? 1 : 0));
    }

    private T SignalingNaNInvalid(T value, EContext ctx) {
        if (ctx != null && ctx.getHasFlags()) {
            ctx.setFlags(ctx.getFlags() | 0x40);
        }
        return this.ReturnQuietNaN(value, ctx);
    }

    private T SignalInvalid(EContext ctx) {
        if (ctx != null && ctx.getHasFlags()) {
            ctx.setFlags(ctx.getFlags() | 0x40);
        }
        if (this.support == 0) {
            throw new ArithmeticException("Invalid operation");
        }
        return this.helper.CreateNewWithFlags(EInteger.FromInt32(0), EInteger.FromInt32(0), 4);
    }

    private T SignalInvalidWithMessage(EContext ctx, String str) {
        if (ctx != null && ctx.getHasFlags()) {
            ctx.setFlags(ctx.getFlags() | 0x40);
        }
        if (this.support == 0) {
            throw new ArithmeticException(str);
        }
        return this.helper.CreateNewWithFlags(EInteger.FromInt32(0), EInteger.FromInt32(0), 4);
    }

    private T SignalOverflow(EContext ctx, boolean neg) {
        if (ctx != null) {
            ERounding roundingOnOverflow = ctx.getRounding();
            if (ctx.getHasFlags()) {
                ctx.setFlags(ctx.getFlags() | 0x13);
            }
            if (roundingOnOverflow == ERounding.None) {
                return this.SignalInvalidWithMessage(ctx, "Rounding was required");
            }
            if (ctx.getHasMaxPrecision() && ctx.getHasExponentRange() && (roundingOnOverflow == ERounding.Down || roundingOnOverflow == ERounding.ZeroFiveUp || roundingOnOverflow == ERounding.OddOrZeroFiveUp || roundingOnOverflow == ERounding.Odd || roundingOnOverflow == ERounding.Ceiling && neg || roundingOnOverflow == ERounding.Floor && !neg)) {
                EInteger overflowMant = EInteger.FromInt32(0);
                FastInteger fastPrecision = FastInteger.FromBig(ctx.getPrecision());
                overflowMant = this.TryMultiplyByRadixPower(EInteger.FromInt32(1), fastPrecision);
                if (overflowMant == null) {
                    return this.SignalInvalidWithMessage(ctx, "Result requires too much memory");
                }
                overflowMant = overflowMant.Subtract(EInteger.FromInt32(1));
                FastInteger clamp = FastInteger.FromBig(ctx.getEMax());
                if (ctx.getAdjustExponent()) {
                    clamp.Increment().Subtract(fastPrecision);
                }
                return this.helper.CreateNewWithFlags(overflowMant, clamp.AsEInteger(), neg ? 1 : 0);
            }
        }
        return this.support == 0 ? null : (T)this.helper.CreateNewWithFlags(EInteger.FromInt32(0), EInteger.FromInt32(0), (neg ? 1 : 0) | 2);
    }

    private T SquareRootHandleSpecial(T thisValue, EContext ctx) {
        int sign;
        int thisFlags = this.helper.GetFlags(thisValue);
        if ((thisFlags & 0xE) != 0) {
            if ((thisFlags & 8) != 0) {
                return this.SignalingNaNInvalid(thisValue, ctx);
            }
            if ((thisFlags & 4) != 0) {
                return this.ReturnQuietNaN(thisValue, ctx);
            }
            if ((thisFlags & 2) != 0) {
                return (thisFlags & 1) != 0 ? this.SignalInvalid(ctx) : thisValue;
            }
        }
        return (sign = this.helper.GetSign(thisValue)) < 0 ? (T)this.SignalInvalid(ctx) : null;
    }

    private EInteger TryMultiplyByRadixPower(EInteger bi, FastInteger radixPower) {
        if (bi.isZero()) {
            return bi;
        }
        if (!radixPower.CanFitInInt32()) {
            FastInteger fastBI = FastInteger.FromBig(valueMaxDigits);
            if (this.thisRadix != 10 || radixPower.compareTo(fastBI) > 0) {
                return null;
            }
        }
        return this.helper.MultiplyByRadixPower(bi, radixPower);
    }

    private FastIntegerFixed TryMultiplyByRadixPowerFastInt(FastIntegerFixed bi, FastInteger radixPower) {
        if (bi.isValueZero()) {
            return bi;
        }
        if (!radixPower.CanFitInInt32()) {
            FastInteger fastBI = FastInteger.FromBig(valueMaxDigits);
            if (this.thisRadix != 10 || radixPower.compareTo(fastBI) > 0) {
                return null;
            }
        }
        return FastIntegerFixed.FromBig(this.helper.MultiplyByRadixPower(bi.ToEInteger(), radixPower));
    }

    private T ValueOf(int value, EContext ctx) {
        return ctx == null || !ctx.getHasExponentRange() || ctx.ExponentWithinRange(EInteger.FromInt32(0)) ? this.helper.ValueOf(value) : this.RoundToPrecision(this.helper.ValueOf(value), ctx);
    }
}

