/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.numbers;

import com.upokecenter.numbers.EInteger;
import com.upokecenter.numbers.ERounding;

public final class EContext {
    public static final int FlagClamped = 32;
    public static final int FlagDivideByZero = 128;
    public static final int FlagInexact = 1;
    public static final int FlagInvalid = 64;
    public static final int FlagLostDigits = 256;
    public static final int FlagOverflow = 16;
    public static final int FlagRounded = 2;
    public static final int FlagSubnormal = 4;
    public static final int FlagUnderflow = 8;
    public static final EContext Basic = EContext.ForPrecisionAndRounding(9, ERounding.HalfUp);
    public static final EContext BigDecimalJava = new EContext(0, ERounding.HalfUp, 0, 0, true).WithExponentClamp(true).WithAdjustExponent(false).WithBigExponentRange(EInteger.FromInt32(0).Subtract(EInteger.FromInt64(Integer.MAX_VALUE)), EInteger.FromInt32(1).Add(EInteger.FromInt64(Integer.MAX_VALUE)));
    public static final EContext Binary128 = EContext.ForPrecisionAndRounding(113, ERounding.HalfEven).WithExponentClamp(true).WithExponentRange(-16382, 16383);
    public static final EContext Binary16 = EContext.ForPrecisionAndRounding(11, ERounding.HalfEven).WithExponentClamp(true).WithExponentRange(-14, 15);
    public static final EContext Binary32 = EContext.ForPrecisionAndRounding(24, ERounding.HalfEven).WithExponentClamp(true).WithExponentRange(-126, 127);
    public static final EContext Binary64 = EContext.ForPrecisionAndRounding(53, ERounding.HalfEven).WithExponentClamp(true).WithExponentRange(-1022, 1023);
    public static final EContext CliDecimal = new EContext(96, ERounding.HalfEven, 0, 28, true).WithPrecisionInBits(true);
    public static final EContext Decimal128 = new EContext(34, ERounding.HalfEven, -6143, 6144, true);
    public static final EContext Decimal32 = new EContext(7, ERounding.HalfEven, -95, 96, true);
    public static final EContext Decimal64 = new EContext(16, ERounding.HalfEven, -383, 384, true);
    public static final EContext Unlimited = EContext.ForPrecision(0);
    public static final EContext UnlimitedHalfEven = EContext.ForPrecision(0).WithRounding(ERounding.HalfEven);
    private boolean adjustExponent;
    private EInteger bigintPrecision;
    private boolean clampNormalExponents;
    private EInteger exponentMax;
    private EInteger exponentMin;
    private int flags;
    private boolean hasExponentRange;
    private boolean hasFlags;
    private boolean precisionInBits;
    private ERounding rounding;
    private boolean simplified;
    private int traps;
    private static final EContext ForRoundingHalfEven = new EContext(0, ERounding.HalfEven, 0, 0, false).WithUnlimitedExponents();
    private static final EContext ForRoundingDown = new EContext(0, ERounding.Down, 0, 0, false).WithUnlimitedExponents();

    public EContext(int precision, ERounding rounding, int exponentMinSmall, int exponentMaxSmall, boolean clampNormalExponents) {
        if (precision < 0) {
            throw new IllegalArgumentException("precision (" + precision + ") is less than 0");
        }
        if (exponentMinSmall > exponentMaxSmall) {
            throw new IllegalArgumentException("exponentMinSmall (" + exponentMinSmall + ") is more than " + exponentMaxSmall);
        }
        this.bigintPrecision = precision == 0 ? EInteger.FromInt32(0) : EInteger.FromInt32(precision);
        this.rounding = rounding;
        this.clampNormalExponents = clampNormalExponents;
        this.hasExponentRange = true;
        this.adjustExponent = true;
        this.exponentMax = exponentMaxSmall == 0 ? EInteger.FromInt32(0) : EInteger.FromInt32(exponentMaxSmall);
        this.exponentMin = exponentMinSmall == 0 ? EInteger.FromInt32(0) : EInteger.FromInt32(exponentMinSmall);
    }

    public final boolean getAdjustExponent() {
        return this.adjustExponent;
    }

    public final boolean getClampNormalExponents() {
        return this.hasExponentRange && this.clampNormalExponents;
    }

    public final EInteger getEMax() {
        return this.hasExponentRange ? this.exponentMax : EInteger.FromInt32(0);
    }

    public final EInteger getEMin() {
        return this.hasExponentRange ? this.exponentMin : EInteger.FromInt32(0);
    }

    public final int getFlags() {
        return this.flags;
    }

    public final void setFlags(int value) {
        if (!this.getHasFlags()) {
            throw new IllegalStateException("Can't set flags");
        }
        this.flags = value;
    }

    public final boolean getHasExponentRange() {
        return this.hasExponentRange;
    }

    public final boolean getHasFlags() {
        return this.hasFlags;
    }

    public final boolean getHasMaxPrecision() {
        return !this.bigintPrecision.isZero();
    }

    public final boolean isPrecisionInBits() {
        return this.precisionInBits;
    }

    public final boolean isSimplified() {
        return this.simplified;
    }

    public final EInteger getPrecision() {
        return this.bigintPrecision;
    }

    public final ERounding getRounding() {
        return this.rounding;
    }

    public final int getTraps() {
        return this.traps;
    }

    public static EContext ForPrecision(int precision) {
        return new EContext(precision, ERounding.HalfUp, 0, 0, false).WithUnlimitedExponents();
    }

    public static EContext ForPrecisionAndRounding(int precision, ERounding rounding) {
        return new EContext(precision, rounding, 0, 0, false).WithUnlimitedExponents();
    }

    public static EContext ForRounding(ERounding rounding) {
        if (rounding == ERounding.HalfEven) {
            return ForRoundingHalfEven;
        }
        if (rounding == ERounding.Down) {
            return ForRoundingDown;
        }
        return new EContext(0, rounding, 0, 0, false).WithUnlimitedExponents();
    }

    public EContext Copy() {
        EContext pcnew = new EContext(0, this.rounding, 0, 0, this.clampNormalExponents);
        pcnew.hasFlags = this.hasFlags;
        pcnew.precisionInBits = this.precisionInBits;
        pcnew.adjustExponent = this.adjustExponent;
        pcnew.simplified = this.simplified;
        pcnew.flags = this.flags;
        pcnew.exponentMax = this.exponentMax;
        pcnew.exponentMin = this.exponentMin;
        pcnew.hasExponentRange = this.hasExponentRange;
        pcnew.bigintPrecision = this.bigintPrecision;
        pcnew.rounding = this.rounding;
        pcnew.clampNormalExponents = this.clampNormalExponents;
        return pcnew;
    }

    public boolean ExponentWithinRange(EInteger exponent) {
        if (exponent == null) {
            throw new NullPointerException("exponent");
        }
        if (!this.getHasExponentRange()) {
            return true;
        }
        if (this.bigintPrecision.isZero()) {
            return exponent.compareTo(this.getEMax()) <= 0;
        }
        EInteger bigint = exponent;
        if (this.adjustExponent) {
            bigint = bigint.Add(this.bigintPrecision);
            bigint = bigint.Subtract(EInteger.FromInt32(1));
        }
        return bigint.compareTo(this.getEMin()) >= 0 && exponent.compareTo(this.getEMax()) <= 0;
    }

    public String toString() {
        return "[PrecisionContext ExponentMax=" + this.exponentMax + ", Traps=" + this.traps + ", ExponentMin=" + this.exponentMin + ", HasExponentRange=" + this.hasExponentRange + ", BigintPrecision=" + this.bigintPrecision + ", Rounding=" + (Object)((Object)this.rounding) + ", ClampNormalExponents=" + this.clampNormalExponents + ", Flags=" + this.flags + ", HasFlags=" + this.hasFlags + "]";
    }

    public EContext WithAdjustExponent(boolean adjustExponent) {
        EContext pc = this.Copy();
        pc.adjustExponent = adjustExponent;
        return pc;
    }

    public EContext WithBigExponentRange(EInteger exponentMin, EInteger exponentMax) {
        if (exponentMin == null) {
            throw new NullPointerException("exponentMin");
        }
        if (exponentMax == null) {
            throw new NullPointerException("exponentMax");
        }
        if (exponentMin.compareTo(exponentMax) > 0) {
            throw new IllegalArgumentException("exponentMin greater than exponentMax");
        }
        EContext pc = this.Copy();
        pc.hasExponentRange = true;
        pc.exponentMin = exponentMin;
        pc.exponentMax = exponentMax;
        return pc;
    }

    public EContext WithBigPrecision(EInteger bigintPrecision) {
        if (bigintPrecision == null) {
            throw new NullPointerException("bigintPrecision");
        }
        if (bigintPrecision.signum() < 0) {
            throw new IllegalArgumentException("bigintPrecision's sign (" + bigintPrecision.signum() + ") is less than 0");
        }
        EContext pc = this.Copy();
        pc.bigintPrecision = bigintPrecision;
        return pc;
    }

    public EContext WithBlankFlags() {
        EContext pc = this.Copy();
        pc.hasFlags = true;
        pc.flags = 0;
        return pc;
    }

    public EContext WithExponentClamp(boolean clamp) {
        EContext pc = this.Copy();
        pc.clampNormalExponents = clamp;
        return pc;
    }

    public EContext WithExponentRange(int exponentMinSmall, int exponentMaxSmall) {
        if (exponentMinSmall > exponentMaxSmall) {
            throw new IllegalArgumentException("exponentMinSmall (" + exponentMinSmall + ") is more than " + exponentMaxSmall);
        }
        EContext pc = this.Copy();
        pc.hasExponentRange = true;
        pc.exponentMin = EInteger.FromInt32(exponentMinSmall);
        pc.exponentMax = EInteger.FromInt32(exponentMaxSmall);
        return pc;
    }

    public EContext WithNoFlags() {
        EContext pc = this.Copy();
        pc.hasFlags = false;
        pc.flags = 0;
        return pc;
    }

    public EContext WithPrecision(int precision) {
        if (precision < 0) {
            throw new IllegalArgumentException("precision (" + precision + ") is less than 0");
        }
        EContext pc = this.Copy();
        pc.bigintPrecision = EInteger.FromInt32(precision);
        return pc;
    }

    public EContext WithPrecisionInBits(boolean isPrecisionBits) {
        EContext pc = this.Copy();
        pc.precisionInBits = isPrecisionBits;
        return pc;
    }

    public EContext WithRounding(ERounding rounding) {
        EContext pc = this.Copy();
        pc.rounding = rounding;
        return pc;
    }

    public EContext WithSimplified(boolean simplified) {
        EContext pc = this.Copy();
        pc.simplified = simplified;
        return pc;
    }

    public EContext WithTraps(int traps) {
        EContext pc = this.Copy();
        pc.hasFlags = true;
        pc.traps = traps;
        return pc;
    }

    public EContext WithUnlimitedExponents() {
        EContext pc = this.Copy();
        pc.hasExponentRange = false;
        return pc;
    }
}

