/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.numbers;

import com.upokecenter.numbers.DecimalUtility;
import com.upokecenter.numbers.DigitShiftAccumulator;
import com.upokecenter.numbers.EContext;
import com.upokecenter.numbers.EFloat;
import com.upokecenter.numbers.EInteger;
import com.upokecenter.numbers.ERounding;
import com.upokecenter.numbers.ExtendedOrSimpleRadixMath;
import com.upokecenter.numbers.Extras;
import com.upokecenter.numbers.FastInteger;
import com.upokecenter.numbers.IRadixMath;
import com.upokecenter.numbers.IRadixMathHelper;
import com.upokecenter.numbers.IShiftAccumulator;
import com.upokecenter.numbers.RadixMath;
import com.upokecenter.numbers.TrappableRadixMath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EDecimal
implements Comparable<EDecimal> {
    private static final int MaxSafeInt = 0xCCCCCCB;
    private final EInteger exponent;
    private final EInteger unsignedMantissa;
    private final int flags;
    private static final EInteger ValueOneShift62 = EInteger.FromInt64(1L).ShiftLeft(62);
    public static final EDecimal One = EDecimal.Create(EInteger.FromInt64(1L), EInteger.FromInt64(0L));
    public static final EDecimal Zero = EDecimal.Create(EInteger.FromInt64(0L), EInteger.FromInt64(0L));
    public static final EDecimal NegativeZero = EDecimal.CreateWithFlags(EInteger.FromInt64(0L), EInteger.FromInt64(0L), 1);
    public static final EDecimal Ten = EDecimal.Create(EInteger.FromInt64(10L), EInteger.FromInt64(0L));
    public static final EDecimal NaN = EDecimal.CreateWithFlags(EInteger.FromInt64(0L), EInteger.FromInt64(0L), 4);
    public static final EDecimal SignalingNaN = EDecimal.CreateWithFlags(EInteger.FromInt64(0L), EInteger.FromInt64(0L), 8);
    public static final EDecimal PositiveInfinity = EDecimal.CreateWithFlags(EInteger.FromInt64(0L), EInteger.FromInt64(0L), 2);
    public static final EDecimal NegativeInfinity = EDecimal.CreateWithFlags(EInteger.FromInt64(0L), EInteger.FromInt64(0L), 3);
    private static final IRadixMath<EDecimal> MathValue = new TrappableRadixMath<EDecimal>(new ExtendedOrSimpleRadixMath<EDecimal>(new DecimalMathHelper()));
    private static final IRadixMath<EDecimal> ExtendedMathValue = new RadixMath<EDecimal>(new DecimalMathHelper());
    private static final int[] ValueTenPowers = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000, 1000000000};

    public final EInteger getExponent() {
        return this.exponent;
    }

    public final EInteger getUnsignedMantissa() {
        return this.unsignedMantissa;
    }

    public final EInteger getMantissa() {
        return this.isNegative() ? this.unsignedMantissa.Negate() : this.unsignedMantissa;
    }

    private boolean EqualsInternal(EDecimal otherValue) {
        return otherValue != null && this.flags == otherValue.flags && this.unsignedMantissa.equals(otherValue.unsignedMantissa) && this.exponent.equals(otherValue.exponent);
    }

    public boolean equals(EDecimal other) {
        return this.EqualsInternal(other);
    }

    public boolean equals(Object obj) {
        return this.EqualsInternal(obj instanceof EDecimal ? (EDecimal)obj : null);
    }

    public int hashCode() {
        int valueHashCode = 964453631;
        valueHashCode += 964453723 * this.exponent.hashCode();
        valueHashCode += 964453939 * this.unsignedMantissa.hashCode();
        return valueHashCode += 964453967 * this.flags;
    }

    public static EDecimal Create(int mantissaSmall, int exponentSmall) {
        return EDecimal.Create(EInteger.FromInt64(mantissaSmall), EInteger.FromInt64(exponentSmall));
    }

    public static EDecimal Create(EInteger mantissa, EInteger exponent) {
        if (mantissa == null) {
            throw new NullPointerException("mantissa");
        }
        if (exponent == null) {
            throw new NullPointerException("exponent");
        }
        int sign = mantissa.signum();
        return new EDecimal(sign < 0 ? mantissa.Negate() : mantissa, exponent, sign < 0 ? 1 : 0);
    }

    private EDecimal(EInteger unsignedMantissa, EInteger exponent, int flags) {
        this.unsignedMantissa = unsignedMantissa;
        this.exponent = exponent;
        this.flags = flags;
    }

    static EDecimal CreateWithFlags(EInteger mantissa, EInteger exponent, int flags) {
        if (mantissa == null) {
            throw new NullPointerException("mantissa");
        }
        if (exponent == null) {
            throw new NullPointerException("exponent");
        }
        int sign = mantissa == null ? 0 : mantissa.signum();
        return new EDecimal(sign < 0 ? mantissa.Negate() : mantissa, exponent, flags);
    }

    public static EDecimal CreateNaN(EInteger diag) {
        return EDecimal.CreateNaN(diag, false, false, null);
    }

    public static EDecimal CreateNaN(EInteger diag, boolean signaling, boolean negative, EContext ctx) {
        if (diag == null) {
            throw new NullPointerException("diag");
        }
        if (diag.signum() < 0) {
            throw new IllegalArgumentException("Diagnostic information must be 0 or greater, was: " + diag);
        }
        if (diag.isZero() && !negative) {
            return signaling ? SignalingNaN : NaN;
        }
        int flags = 0;
        if (negative) {
            flags |= 1;
        }
        if (ctx != null && ctx.getHasMaxPrecision()) {
            EDecimal ef = EDecimal.CreateWithFlags(diag, EInteger.FromInt64(0L), flags |= 4).RoundToPrecision(ctx);
            int newFlags = ef.flags;
            newFlags &= 0xFFFFFFFB;
            return new EDecimal(ef.unsignedMantissa, ef.exponent, newFlags |= signaling ? 8 : 4);
        }
        return EDecimal.CreateWithFlags(diag, EInteger.FromInt64(0L), flags |= signaling ? 8 : 4);
    }

    public static EDecimal FromString(String str) {
        return EDecimal.FromString(str, 0, str == null ? 0 : str.length(), null);
    }

    public static EDecimal FromString(String str, EContext ctx) {
        return EDecimal.FromString(str, 0, str == null ? 0 : str.length(), ctx);
    }

    public static EDecimal FromString(String str, int offset, int length) {
        return EDecimal.FromString(str, offset, length, null);
    }

    public static EDecimal FromString(String str, int offset, int length, EContext ctx) {
        int tmpoffset = offset;
        if (str == null) {
            throw new NullPointerException("str");
        }
        if (tmpoffset < 0) {
            throw new NumberFormatException("offset (" + tmpoffset + ") is less than " + "0");
        }
        if (tmpoffset > str.length()) {
            throw new NumberFormatException("offset (" + tmpoffset + ") is more than " + str.length());
        }
        if (length < 0) {
            throw new NumberFormatException("length (" + length + ") is less than " + "0");
        }
        if (length > str.length()) {
            throw new NumberFormatException("length (" + length + ") is more than " + str.length());
        }
        if (str.length() - tmpoffset < length) {
            throw new NumberFormatException("str's length minus " + tmpoffset + " (" + (str.length() - tmpoffset) + ") is less than " + length);
        }
        if (length == 0) {
            throw new NumberFormatException();
        }
        boolean negative = false;
        int endStr = tmpoffset + length;
        if (str.charAt(0) == '+' || str.charAt(0) == '-') {
            negative = str.charAt(0) == '-';
            ++tmpoffset;
        }
        int mantInt = 0;
        FastInteger mant = null;
        int mantBuffer = 0;
        int mantBufferMult = 1;
        int expBuffer = 0;
        int expBufferMult = 1;
        boolean haveDecimalPoint = false;
        boolean haveDigits = false;
        boolean haveExponent = false;
        int newScaleInt = 0;
        FastInteger newScale = null;
        int i = tmpoffset;
        if (!(i + 8 != endStr || str.charAt(i) != 'I' && str.charAt(i) != 'i' || str.charAt(i + 1) != 'N' && str.charAt(i + 1) != 'n' || str.charAt(i + 2) != 'F' && str.charAt(i + 2) != 'f' || str.charAt(i + 3) != 'I' && str.charAt(i + 3) != 'i' || str.charAt(i + 4) != 'N' && str.charAt(i + 4) != 'n' || str.charAt(i + 5) != 'I' && str.charAt(i + 5) != 'i' || str.charAt(i + 6) != 'T' && str.charAt(i + 6) != 't' || str.charAt(i + 7) != 'Y' && str.charAt(i + 7) != 'y')) {
            if (ctx != null && ctx.isSimplified() && i < endStr) {
                throw new NumberFormatException("Infinity not allowed");
            }
            return negative ? NegativeInfinity : PositiveInfinity;
        }
        if (!(i + 3 != endStr || str.charAt(i) != 'I' && str.charAt(i) != 'i' || str.charAt(i + 1) != 'N' && str.charAt(i + 1) != 'n' || str.charAt(i + 2) != 'F' && str.charAt(i + 2) != 'f')) {
            if (ctx != null && ctx.isSimplified() && i < endStr) {
                throw new NumberFormatException("Infinity not allowed");
            }
            return negative ? NegativeInfinity : PositiveInfinity;
        }
        if (!(i + 3 > endStr || str.charAt(i) != 'N' && str.charAt(i) != 'n' || str.charAt(i + 1) != 'A' && str.charAt(i + 1) != 'a' || str.charAt(i + 2) != 'N' && str.charAt(i + 2) != 'n')) {
            if (ctx != null && ctx.isSimplified() && i < endStr) {
                throw new NumberFormatException("NaN not allowed");
            }
            int flags2 = (negative ? 1 : 0) | 4;
            if (i + 3 == endStr) {
                return !negative ? NaN : EDecimal.CreateWithFlags(EInteger.FromInt64(0L), EInteger.FromInt64(0L), flags2);
            }
            i += 3;
            FastInteger digitCount = new FastInteger(0);
            FastInteger maxDigits = null;
            haveDigits = false;
            if (ctx != null && ctx.getHasMaxPrecision()) {
                maxDigits = FastInteger.FromBig(ctx.getPrecision());
                if (ctx.getClampNormalExponents()) {
                    maxDigits.Decrement();
                }
            }
            while (i < endStr) {
                if (str.charAt(i) >= '0' && str.charAt(i) <= '9') {
                    int thisdigit = str.charAt(i) - 48;
                    boolean bl = haveDigits = haveDigits || thisdigit != 0;
                    if (mantInt > 0xCCCCCCB) {
                        if (mant == null) {
                            mant = new FastInteger(mantInt);
                            mantBuffer = thisdigit;
                            mantBufferMult = 10;
                        } else if (mantBufferMult >= 1000000000) {
                            mant.Multiply(mantBufferMult).AddInt(mantBuffer);
                            mantBuffer = thisdigit;
                            mantBufferMult = 10;
                        } else {
                            mantBufferMult *= 10;
                            mantBuffer = (mantBuffer << 3) + (mantBuffer << 1);
                            mantBuffer += thisdigit;
                        }
                    } else {
                        mantInt *= 10;
                        mantInt += thisdigit;
                    }
                    if (haveDigits && maxDigits != null) {
                        digitCount.Increment();
                        if (digitCount.compareTo(maxDigits) > 0) {
                            throw new NumberFormatException();
                        }
                    }
                } else {
                    throw new NumberFormatException();
                }
                ++i;
            }
            if (mant != null && (mantBufferMult != 1 || mantBuffer != 0)) {
                mant.Multiply(mantBufferMult).AddInt(mantBuffer);
            }
            EInteger bigmant = mant == null ? EInteger.FromInt64(mantInt) : mant.AsBigInteger();
            flags2 = (negative ? 1 : 0) | 4;
            return EDecimal.CreateWithFlags(bigmant, EInteger.FromInt64(0L), flags2);
        }
        if (!(i + 4 > endStr || str.charAt(i) != 'S' && str.charAt(i) != 's' || str.charAt(i + 1) != 'N' && str.charAt(i + 1) != 'n' || str.charAt(i + 2) != 'A' && str.charAt(i + 2) != 'a' || str.charAt(i + 3) != 'N' && str.charAt(i + 3) != 'n')) {
            if (ctx != null && ctx.isSimplified() && i < endStr) {
                throw new NumberFormatException("NaN not allowed");
            }
            if (i + 4 == endStr) {
                int flags2 = (negative ? 1 : 0) | 8;
                return !negative ? SignalingNaN : EDecimal.CreateWithFlags(EInteger.FromInt64(0L), EInteger.FromInt64(0L), flags2);
            }
            i += 4;
            FastInteger digitCount = new FastInteger(0);
            FastInteger maxDigits = null;
            haveDigits = false;
            if (ctx != null && ctx.getHasMaxPrecision()) {
                maxDigits = FastInteger.FromBig(ctx.getPrecision());
                if (ctx.getClampNormalExponents()) {
                    maxDigits.Decrement();
                }
            }
            while (i < endStr) {
                if (str.charAt(i) >= '0' && str.charAt(i) <= '9') {
                    int thisdigit = str.charAt(i) - 48;
                    boolean bl = haveDigits = haveDigits || thisdigit != 0;
                    if (mantInt > 0xCCCCCCB) {
                        if (mant == null) {
                            mant = new FastInteger(mantInt);
                            mantBuffer = thisdigit;
                            mantBufferMult = 10;
                        } else if (mantBufferMult >= 1000000000) {
                            mant.Multiply(mantBufferMult).AddInt(mantBuffer);
                            mantBuffer = thisdigit;
                            mantBufferMult = 10;
                        } else {
                            mantBufferMult *= 10;
                            mantBuffer = (mantBuffer << 3) + (mantBuffer << 1);
                            mantBuffer += thisdigit;
                        }
                    } else {
                        mantInt *= 10;
                        mantInt += thisdigit;
                    }
                    if (haveDigits && maxDigits != null) {
                        digitCount.Increment();
                        if (digitCount.compareTo(maxDigits) > 0) {
                            throw new NumberFormatException();
                        }
                    }
                } else {
                    throw new NumberFormatException();
                }
                ++i;
            }
            if (mant != null && (mantBufferMult != 1 || mantBuffer != 0)) {
                mant.Multiply(mantBufferMult).AddInt(mantBuffer);
            }
            int flags3 = (negative ? 1 : 0) | 8;
            EInteger bigmant = mant == null ? EInteger.FromInt64(mantInt) : mant.AsBigInteger();
            return EDecimal.CreateWithFlags(bigmant, EInteger.FromInt64(0L), flags3);
        }
        while (i < endStr) {
            if (str.charAt(i) >= '0' && str.charAt(i) <= '9') {
                int thisdigit = str.charAt(i) - 48;
                if (mantInt > 0xCCCCCCB) {
                    if (mant == null) {
                        mant = new FastInteger(mantInt);
                        mantBuffer = thisdigit;
                        mantBufferMult = 10;
                    } else if (mantBufferMult >= 1000000000) {
                        mant.Multiply(mantBufferMult).AddInt(mantBuffer);
                        mantBuffer = thisdigit;
                        mantBufferMult = 10;
                    } else {
                        mantBufferMult *= 10;
                        mantBuffer = (mantBuffer << 3) + (mantBuffer << 1);
                        mantBuffer += thisdigit;
                    }
                } else {
                    mantInt *= 10;
                    mantInt += thisdigit;
                }
                haveDigits = true;
                if (haveDecimalPoint) {
                    if (newScaleInt == Integer.MIN_VALUE) {
                        newScale = newScale == null ? new FastInteger(newScaleInt) : newScale;
                        newScale.Decrement();
                    } else {
                        --newScaleInt;
                    }
                }
            } else if (str.charAt(i) == '.') {
                if (haveDecimalPoint) {
                    throw new NumberFormatException();
                }
                haveDecimalPoint = true;
            } else {
                if (str.charAt(i) == 'E' || str.charAt(i) == 'e') {
                    haveExponent = true;
                    ++i;
                    break;
                }
                throw new NumberFormatException();
            }
            ++i;
        }
        if (!haveDigits) {
            throw new NumberFormatException();
        }
        if (mant != null && (mantBufferMult != 1 || mantBuffer != 0)) {
            mant.Multiply(mantBufferMult).AddInt(mantBuffer);
        }
        if (haveExponent) {
            FastInteger exp = null;
            int expInt = 0;
            tmpoffset = 1;
            haveDigits = false;
            if (i == endStr) {
                throw new NumberFormatException();
            }
            if (str.charAt(i) == '+' || str.charAt(i) == '-') {
                if (str.charAt(i) == '-') {
                    tmpoffset = -1;
                }
                ++i;
            }
            while (i < endStr) {
                if (str.charAt(i) >= '0' && str.charAt(i) <= '9') {
                    haveDigits = true;
                    int thisdigit = str.charAt(i) - 48;
                    if (expInt > 0xCCCCCCB) {
                        if (exp == null) {
                            exp = new FastInteger(expInt);
                            expBuffer = thisdigit;
                            expBufferMult = 10;
                        } else if (expBufferMult >= 1000000000) {
                            exp.Multiply(expBufferMult).AddInt(expBuffer);
                            expBuffer = thisdigit;
                            expBufferMult = 10;
                        } else {
                            expBufferMult = (expBufferMult << 3) + (expBufferMult << 1);
                            expBuffer = (expBuffer << 3) + (expBuffer << 1);
                            expBuffer += thisdigit;
                        }
                    } else {
                        expInt *= 10;
                        expInt += thisdigit;
                    }
                } else {
                    throw new NumberFormatException();
                }
                ++i;
            }
            if (!haveDigits) {
                throw new NumberFormatException();
            }
            if (exp != null && (expBufferMult != 1 || expBuffer != 0)) {
                exp.Multiply(expBufferMult).AddInt(expBuffer);
            }
            if (tmpoffset >= 0 && newScaleInt == 0 && newScale == null && exp == null) {
                newScaleInt = expInt;
            } else if (exp == null) {
                FastInteger fastInteger = newScale = newScale == null ? new FastInteger(newScaleInt) : newScale;
                if (tmpoffset < 0) {
                    newScale.SubtractInt(expInt);
                } else if (expInt != 0) {
                    newScale.AddInt(expInt);
                }
            } else {
                FastInteger fastInteger = newScale = newScale == null ? new FastInteger(newScaleInt) : newScale;
                if (tmpoffset < 0) {
                    newScale.Subtract(exp);
                } else {
                    newScale.Add(exp);
                }
            }
        }
        if (i != endStr) {
            throw new NumberFormatException();
        }
        EInteger bigNewScale = newScale == null ? EInteger.FromInt64(newScaleInt) : newScale.AsBigInteger();
        EDecimal ret = new EDecimal(mant == null ? EInteger.FromInt64(mantInt) : mant.AsBigInteger(), bigNewScale, negative ? 1 : 0);
        if (ctx != null) {
            ret = EDecimal.GetMathValue(ctx).RoundAfterConversion(ret, ctx);
        }
        return ret;
    }

    private static boolean AppendString(StringBuilder builder, char c, FastInteger count) {
        if (count.CompareToInt(Integer.MAX_VALUE) > 0 || count.signum() < 0) {
            throw new UnsupportedOperationException();
        }
        int icount = count.AsInt32();
        for (int i = icount - 1; i >= 0; --i) {
            builder.append(c);
        }
        return true;
    }

    private String ToStringInternal(int mode) {
        int tmpInt;
        int cmp;
        int intExp;
        boolean negative;
        boolean bl = negative = (this.flags & 1) != 0;
        if (!this.isFinite()) {
            if ((this.flags & 2) != 0) {
                return negative ? "-Infinity" : "Infinity";
            }
            if ((this.flags & 8) != 0) {
                return this.unsignedMantissa.isZero() ? (negative ? "-sNaN" : "sNaN") : (negative ? "-sNaN" + this.unsignedMantissa : "sNaN" + this.unsignedMantissa);
            }
            if ((this.flags & 4) != 0) {
                return this.unsignedMantissa.isZero() ? (negative ? "-NaN" : "NaN") : (negative ? "-NaN" + this.unsignedMantissa : "NaN" + this.unsignedMantissa);
            }
        }
        int scaleSign = -this.exponent.signum();
        String mantissaString = this.unsignedMantissa.toString();
        if (scaleSign == 0) {
            return negative ? "-" + mantissaString : mantissaString;
        }
        boolean iszero = this.unsignedMantissa.isZero();
        if (mode == 2 && iszero && scaleSign < 0) {
            return negative ? "-" + mantissaString : mantissaString;
        }
        StringBuilder builder = null;
        if (mode == 0 && mantissaString.length() < 100 && this.exponent.CanFitInInt32() && (intExp = this.exponent.AsInt32Unchecked()) > -100 && intExp < 100) {
            int adj = intExp + mantissaString.length() - 1;
            if (scaleSign >= 0 && adj >= -6 && scaleSign > 0) {
                int dp = intExp + mantissaString.length();
                if (dp < 0) {
                    builder = new StringBuilder(mantissaString.length() + 6);
                    if (negative) {
                        builder.append("-0.");
                    } else {
                        builder.append("0.");
                    }
                    dp = -dp;
                    for (int j = 0; j < dp; ++j) {
                        builder.append('0');
                    }
                    builder.append(mantissaString);
                    return builder.toString();
                }
                if (dp == 0) {
                    builder = new StringBuilder(mantissaString.length() + 6);
                    if (negative) {
                        builder.append("-0.");
                    } else {
                        builder.append("0.");
                    }
                    builder.append(mantissaString);
                    return builder.toString();
                }
                if (dp > 0 && dp <= mantissaString.length()) {
                    builder = new StringBuilder(mantissaString.length() + 6);
                    if (negative) {
                        builder.append('-');
                    }
                    builder.append(mantissaString, 0, 0 + dp);
                    builder.append('.');
                    builder.append(mantissaString, dp, dp + (mantissaString.length() - dp));
                    return builder.toString();
                }
            }
        }
        FastInteger adjustedExponent = FastInteger.FromBig(this.exponent);
        FastInteger builderLength = new FastInteger(mantissaString.length());
        FastInteger thisExponent = FastInteger.Copy(adjustedExponent);
        adjustedExponent.Add(builderLength).Decrement();
        FastInteger decimalPointAdjust = new FastInteger(1);
        FastInteger threshold = new FastInteger(-6);
        if (mode == 1) {
            FastInteger newExponent = FastInteger.Copy(adjustedExponent);
            boolean adjExponentNegative = adjustedExponent.signum() < 0;
            int intphase = FastInteger.Copy(adjustedExponent).Abs().Remainder(3).AsInt32();
            if (iszero && (adjustedExponent.compareTo(threshold) < 0 || scaleSign < 0)) {
                if (intphase == 1) {
                    if (adjExponentNegative) {
                        decimalPointAdjust.Increment();
                        newExponent.Increment();
                    } else {
                        decimalPointAdjust.AddInt(2);
                        newExponent.AddInt(2);
                    }
                } else if (intphase == 2) {
                    if (!adjExponentNegative) {
                        decimalPointAdjust.Increment();
                        newExponent.Increment();
                    } else {
                        decimalPointAdjust.AddInt(2);
                        newExponent.AddInt(2);
                    }
                }
                threshold.Increment();
            } else if (intphase == 1) {
                if (!adjExponentNegative) {
                    decimalPointAdjust.Increment();
                    newExponent.Decrement();
                } else {
                    decimalPointAdjust.AddInt(2);
                    newExponent.AddInt(-2);
                }
            } else if (intphase == 2) {
                if (adjExponentNegative) {
                    decimalPointAdjust.Increment();
                    newExponent.Decrement();
                } else {
                    decimalPointAdjust.AddInt(2);
                    newExponent.AddInt(-2);
                }
            }
            adjustedExponent = newExponent;
        }
        if (mode == 2 || adjustedExponent.compareTo(threshold) >= 0 && scaleSign >= 0) {
            if (scaleSign > 0) {
                FastInteger decimalPoint = FastInteger.Copy(thisExponent).Add(builderLength);
                cmp = decimalPoint.CompareToInt(0);
                builder = null;
                if (cmp < 0) {
                    FastInteger tmpFast = new FastInteger(mantissaString.length()).AddInt(6);
                    builder = new StringBuilder(tmpFast.CompareToInt(Integer.MAX_VALUE) > 0 ? Integer.MAX_VALUE : tmpFast.AsInt32());
                    if (negative) {
                        builder.append('-');
                    }
                    builder.append("0.");
                    EDecimal.AppendString(builder, '0', FastInteger.Copy(decimalPoint).Negate());
                    builder.append(mantissaString);
                } else if (cmp == 0) {
                    FastInteger tmpFast = new FastInteger(mantissaString.length()).AddInt(6);
                    builder = new StringBuilder(tmpFast.CompareToInt(Integer.MAX_VALUE) > 0 ? Integer.MAX_VALUE : tmpFast.AsInt32());
                    if (negative) {
                        builder.append('-');
                    }
                    builder.append("0.");
                    builder.append(mantissaString);
                } else if (decimalPoint.CompareToInt(mantissaString.length()) > 0) {
                    FastInteger tmpFast;
                    FastInteger insertionPoint = builderLength;
                    if (!insertionPoint.CanFitInInt32()) {
                        throw new UnsupportedOperationException();
                    }
                    int tmpInt2 = insertionPoint.AsInt32();
                    if (tmpInt2 < 0) {
                        tmpInt2 = 0;
                    }
                    builder = new StringBuilder((tmpFast = new FastInteger(mantissaString.length()).AddInt(6)).CompareToInt(Integer.MAX_VALUE) > 0 ? Integer.MAX_VALUE : tmpFast.AsInt32());
                    if (negative) {
                        builder.append('-');
                    }
                    builder.append(mantissaString, 0, 0 + tmpInt2);
                    EDecimal.AppendString(builder, '0', FastInteger.Copy(decimalPoint).SubtractInt(builder.length()));
                    builder.append('.');
                    builder.append(mantissaString, tmpInt2, tmpInt2 + (mantissaString.length() - tmpInt2));
                } else {
                    FastInteger tmpFast;
                    if (!decimalPoint.CanFitInInt32()) {
                        throw new UnsupportedOperationException();
                    }
                    tmpInt = decimalPoint.AsInt32();
                    if (tmpInt < 0) {
                        tmpInt = 0;
                    }
                    builder = new StringBuilder((tmpFast = new FastInteger(mantissaString.length()).AddInt(6)).CompareToInt(Integer.MAX_VALUE) > 0 ? Integer.MAX_VALUE : tmpFast.AsInt32());
                    if (negative) {
                        builder.append('-');
                    }
                    builder.append(mantissaString, 0, 0 + tmpInt);
                    builder.append('.');
                    builder.append(mantissaString, tmpInt, tmpInt + (mantissaString.length() - tmpInt));
                }
                return builder.toString();
            }
            if (mode == 2 && scaleSign < 0) {
                FastInteger negscale = FastInteger.Copy(thisExponent);
                builder = new StringBuilder();
                if (negative) {
                    builder.append('-');
                }
                builder.append(mantissaString);
                EDecimal.AppendString(builder, '0', negscale);
                return builder.toString();
            }
            return !negative ? mantissaString : "-" + mantissaString;
        }
        if (mode == 1 && iszero && decimalPointAdjust.CompareToInt(1) > 0) {
            builder = new StringBuilder();
            if (negative) {
                builder.append('-');
            }
            builder.append(mantissaString);
            builder.append('.');
            EDecimal.AppendString(builder, '0', FastInteger.Copy(decimalPointAdjust).Decrement());
        } else {
            FastInteger tmp = FastInteger.Copy(decimalPointAdjust);
            cmp = tmp.CompareToInt(mantissaString.length());
            if (cmp > 0) {
                tmp.SubtractInt(mantissaString.length());
                builder = new StringBuilder();
                if (negative) {
                    builder.append('-');
                }
                builder.append(mantissaString);
                EDecimal.AppendString(builder, '0', tmp);
            } else if (cmp < 0) {
                FastInteger tmpFast;
                if (!tmp.CanFitInInt32()) {
                    throw new UnsupportedOperationException();
                }
                tmpInt = tmp.AsInt32();
                if (tmp.signum() < 0) {
                    tmpInt = 0;
                }
                builder = new StringBuilder((tmpFast = new FastInteger(mantissaString.length()).AddInt(6)).CompareToInt(Integer.MAX_VALUE) > 0 ? Integer.MAX_VALUE : tmpFast.AsInt32());
                if (negative) {
                    builder.append('-');
                }
                builder.append(mantissaString, 0, 0 + tmpInt);
                builder.append('.');
                builder.append(mantissaString, tmpInt, tmpInt + (mantissaString.length() - tmpInt));
            } else {
                if (adjustedExponent.signum() == 0 && !negative) {
                    return mantissaString;
                }
                if (adjustedExponent.signum() == 0 && negative) {
                    return "-" + mantissaString;
                }
                builder = new StringBuilder();
                if (negative) {
                    builder.append('-');
                }
                builder.append(mantissaString);
            }
        }
        if (adjustedExponent.signum() != 0) {
            builder.append(adjustedExponent.signum() < 0 ? "E-" : "E+");
            adjustedExponent.Abs();
            StringBuilder builderReversed = new StringBuilder();
            while (adjustedExponent.signum() != 0) {
                int digit = FastInteger.Copy(adjustedExponent).Remainder(10).AsInt32();
                builderReversed.append((char)(48 + digit));
                adjustedExponent.Divide(10);
            }
            int count = builderReversed.length();
            String builderReversedString = builderReversed.toString();
            for (int i = 0; i < count; ++i) {
                builder.append(builderReversedString.charAt(count - 1 - i));
            }
        }
        return builder.toString();
    }

    public int CompareToBinary(EFloat other) {
        int signB;
        if (other == null) {
            return 1;
        }
        if (this.IsNaN()) {
            return other.IsNaN() ? 0 : 1;
        }
        int signA = this.signum();
        if (signA != (signB = other.signum())) {
            return signA < signB ? -1 : 1;
        }
        if (signB == 0 || signA == 0) {
            return 0;
        }
        if (this.IsInfinity()) {
            if (other.IsInfinity()) {
                return 0;
            }
            return this.isNegative() ? -1 : 1;
        }
        if (other.IsInfinity()) {
            return other.isNegative() ? 1 : -1;
        }
        if (other.getExponent().compareTo(EInteger.FromInt64(-1000L)) < 0 && other.Abs(null).compareTo(EFloat.One) < 0 && this.Abs(null).compareTo(One) >= 0) {
            return signA > 0 ? 1 : -1;
        }
        if (other.getExponent().compareTo(EInteger.FromInt64(1000L)) > 0) {
            EInteger bignum = EInteger.FromInt64(1L).ShiftLeft(999);
            if (this.Abs(null).compareTo(EDecimal.FromEInteger(bignum)) <= 0) {
                return signA > 0 ? -1 : 1;
            }
            EInteger thisAdjExp = this.GetAdjustedExponent();
            EInteger otherAdjExp = EDecimal.GetAdjustedExponentBinary(other);
            if (thisAdjExp.signum() > 0 && thisAdjExp.compareTo(otherAdjExp) >= 0) {
                return signA > 0 ? 1 : -1;
            }
            if (thisAdjExp.signum() > 0 && thisAdjExp.compareTo(EInteger.FromInt64(1000L)) >= 0 && otherAdjExp.compareTo(EInteger.FromInt64(1000L)) >= 0) {
                thisAdjExp = thisAdjExp.Add(EInteger.FromInt64(1L));
                EInteger ratio = (otherAdjExp = otherAdjExp.Add(EInteger.FromInt64(1L))).Divide(thisAdjExp);
                if (ratio.compareTo(EInteger.FromInt64(3L)) < 0) {
                    return signA > 0 ? 1 : -1;
                }
                if (ratio.compareTo(EInteger.FromInt64(4L)) >= 0) {
                    return signA > 0 ? -1 : 1;
                }
            }
        }
        EDecimal otherDec = EDecimal.FromExtendedFloat(other);
        return this.compareTo(otherDec);
    }

    public EInteger ToEInteger() {
        return this.ToEIntegerInternal(false);
    }

    public EInteger ToEIntegerExact() {
        return this.ToEIntegerInternal(true);
    }

    private EInteger ToEIntegerInternal(boolean exact) {
        if (!this.isFinite()) {
            throw new ArithmeticException("Value is infinity or NaN");
        }
        int sign = this.getExponent().signum();
        if (this.isZero()) {
            return EInteger.FromInt64(0L);
        }
        if (sign == 0) {
            EInteger bigmantissa = this.getMantissa();
            return bigmantissa;
        }
        if (sign > 0) {
            EInteger bigmantissa = this.getMantissa();
            EInteger bigexponent = DecimalUtility.FindPowerOfTenFromBig(this.getExponent());
            bigmantissa = bigmantissa.Multiply(bigexponent);
            return bigmantissa;
        }
        EInteger bigmantissa = this.getMantissa();
        FastInteger bigexponent = FastInteger.FromBig(this.getExponent()).Negate();
        bigmantissa = bigmantissa.Abs();
        DigitShiftAccumulator acc = new DigitShiftAccumulator(bigmantissa, 0, 0);
        acc.ShiftRight(bigexponent);
        if (exact && (acc.getLastDiscardedDigit() != 0 || acc.getOlderDiscardedDigits() != 0)) {
            throw new ArithmeticException("Not an exact integer");
        }
        bigmantissa = acc.getShiftedInt();
        if (this.isNegative()) {
            bigmantissa = bigmantissa.Negate();
        }
        return bigmantissa;
    }

    public EFloat ToExtendedFloat() {
        return this.ToExtendedFloatInternal(false);
    }

    private EFloat ToExtendedFloatInternal(boolean oddRounding) {
        EInteger remainder;
        EInteger quotient;
        boolean neg;
        if (this.IsNaN() || this.IsInfinity()) {
            return EFloat.CreateWithFlags(this.unsignedMantissa, this.exponent, this.flags);
        }
        EInteger bigintExp = this.getExponent();
        EInteger bigintMant = this.getMantissa();
        if (bigintMant.isZero()) {
            return this.isNegative() ? EFloat.NegativeZero : EFloat.Zero;
        }
        if (bigintExp.isZero()) {
            return EFloat.FromEInteger(bigintMant);
        }
        if (bigintExp.signum() > 0) {
            EInteger bigmantissa = bigintMant;
            bigintExp = DecimalUtility.FindPowerOfTenFromBig(bigintExp);
            bigmantissa = bigmantissa.Multiply(bigintExp);
            return EFloat.FromEInteger(bigmantissa);
        }
        FastInteger scale = FastInteger.FromBig(bigintExp);
        EInteger bigmantissa = bigintMant;
        boolean bl = neg = bigmantissa.signum() < 0;
        if (neg) {
            bigmantissa = bigmantissa.Negate();
        }
        FastInteger negscale = FastInteger.Copy(scale).Negate();
        EInteger divisor = DecimalUtility.FindPowerOfFiveFromBig(negscale.AsBigInteger());
        while (true) {
            EInteger[] divrem = bigmantissa.DivRem(divisor);
            quotient = divrem[0];
            remainder = divrem[1];
            if (remainder.isZero() || quotient.compareTo(ValueOneShift62) >= 0) break;
            int[] bits = FastInteger.GetLastWords(quotient, 2);
            int shift = 0;
            if ((bits[0] | bits[1]) != 0) {
                int bitPrecision = DecimalUtility.BitPrecisionInt(bits[1]);
                bitPrecision = bitPrecision != 0 ? (bitPrecision += 32) : DecimalUtility.BitPrecisionInt(bits[0]);
                shift = 63 - bitPrecision;
                scale.SubtractInt(shift);
            } else {
                shift = 1;
                scale.SubtractInt(shift);
            }
            bigmantissa = bigmantissa.ShiftLeft(shift);
        }
        bigmantissa = quotient;
        if (oddRounding) {
            if (!remainder.isZero() && bigmantissa.isEven()) {
                bigmantissa = bigmantissa.Add(EInteger.FromInt64(1L));
            }
        } else {
            EInteger halfDivisor = divisor;
            int cmp = remainder.compareTo(halfDivisor = halfDivisor.ShiftRight(1));
            if (cmp > 0) {
                bigmantissa = bigmantissa.Add(EInteger.FromInt64(1L));
            }
        }
        if (neg) {
            bigmantissa = bigmantissa.Negate();
        }
        return EFloat.Create(bigmantissa, scale.AsBigInteger());
    }

    public float ToSingle() {
        if (this.IsPositiveInfinity()) {
            return Float.POSITIVE_INFINITY;
        }
        if (this.IsNegativeInfinity()) {
            return Float.NEGATIVE_INFINITY;
        }
        if (this.isNegative() && this.isZero()) {
            return Float.intBitsToFloat(Integer.MIN_VALUE);
        }
        if (this.isZero()) {
            return 0.0f;
        }
        EInteger adjExp = this.GetAdjustedExponent();
        if (adjExp.compareTo(EInteger.FromInt64(-47L)) < 0) {
            return this.isNegative() ? Float.intBitsToFloat(Integer.MIN_VALUE) : 0.0f;
        }
        if (adjExp.compareTo(EInteger.FromInt64(39L)) > 0) {
            return this.isNegative() ? Float.NEGATIVE_INFINITY : Float.POSITIVE_INFINITY;
        }
        return this.ToExtendedFloatInternal(true).ToSingle();
    }

    private EInteger GetAdjustedExponent() {
        if (!this.isFinite()) {
            return EInteger.FromInt64(0L);
        }
        if (this.isZero()) {
            return EInteger.FromInt64(0L);
        }
        EInteger ret = this.getExponent();
        int smallPrecision = this.getUnsignedMantissa().GetDigitCount();
        ret = ret.Add(EInteger.FromInt64(--smallPrecision));
        return ret;
    }

    private static EInteger GetAdjustedExponentBinary(EFloat ef) {
        if (!ef.isFinite()) {
            return EInteger.FromInt64(0L);
        }
        if (ef.isZero()) {
            return EInteger.FromInt64(0L);
        }
        EInteger ret = ef.getExponent();
        int smallPrecision = ef.getUnsignedMantissa().GetSignedBitLength();
        ret = ret.Add(EInteger.FromInt64(--smallPrecision));
        return ret;
    }

    public double ToDouble() {
        if (this.IsPositiveInfinity()) {
            return Double.POSITIVE_INFINITY;
        }
        if (this.IsNegativeInfinity()) {
            return Double.NEGATIVE_INFINITY;
        }
        if (this.isNegative() && this.isZero()) {
            return Extras.IntegersToDouble(new int[]{0, Integer.MIN_VALUE});
        }
        if (this.isZero()) {
            return 0.0;
        }
        EInteger adjExp = this.GetAdjustedExponent();
        if (adjExp.compareTo(EInteger.FromInt64(-326L)) < 0) {
            return this.isNegative() ? Extras.IntegersToDouble(new int[]{0, Integer.MIN_VALUE}) : 0.0;
        }
        if (adjExp.compareTo(EInteger.FromInt64(309L)) > 0) {
            return this.isNegative() ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
        }
        return this.ToExtendedFloatInternal(true).ToDouble();
    }

    public static EDecimal FromSingle(float flt) {
        int value = Float.floatToRawIntBits(flt);
        boolean neg = value >> 31 != 0;
        int floatExponent = value >> 23 & 0xFF;
        int valueFpMantissa = value & 0x7FFFFF;
        if (floatExponent == 255) {
            if (valueFpMantissa == 0) {
                return neg ? NegativeInfinity : PositiveInfinity;
            }
            boolean quiet = (valueFpMantissa & 0x400000) != 0;
            EInteger info = EInteger.FromInt64(valueFpMantissa &= 0x1FFFFF);
            value = (neg ? 1 : 0) | (quiet ? 4 : 8);
            return info.isZero() ? (quiet ? NaN : SignalingNaN) : EDecimal.CreateWithFlags(info, EInteger.FromInt64(0L), value);
        }
        if (floatExponent == 0) {
            ++floatExponent;
        } else {
            valueFpMantissa |= 0x800000;
        }
        if (valueFpMantissa == 0) {
            return neg ? NegativeZero : Zero;
        }
        floatExponent -= 150;
        while ((valueFpMantissa & 1) == 0) {
            ++floatExponent;
            valueFpMantissa >>= 1;
        }
        if (floatExponent == 0) {
            if (neg) {
                valueFpMantissa = -valueFpMantissa;
            }
            return EDecimal.FromInt64(valueFpMantissa);
        }
        if (floatExponent > 0) {
            EInteger bigmantissa = EInteger.FromInt64(valueFpMantissa);
            bigmantissa = bigmantissa.ShiftLeft(floatExponent);
            if (neg) {
                bigmantissa = bigmantissa.Negate();
            }
            return EDecimal.FromEInteger(bigmantissa);
        }
        EInteger bigmantissa = EInteger.FromInt64(valueFpMantissa);
        EInteger bigexponent = DecimalUtility.FindPowerOfFive(-floatExponent);
        bigmantissa = bigmantissa.Multiply(bigexponent);
        if (neg) {
            bigmantissa = bigmantissa.Negate();
        }
        return EDecimal.Create(bigmantissa, EInteger.FromInt64(floatExponent));
    }

    public static EDecimal FromEInteger(EInteger bigint) {
        return EDecimal.Create(bigint, EInteger.FromInt64(0L));
    }

    public static EDecimal FromInt64(long valueSmall) {
        EInteger bigint = EInteger.FromInt64(valueSmall);
        return EDecimal.Create(bigint, EInteger.FromInt64(0L));
    }

    public static EDecimal FromInt32(int valueSmaller) {
        EInteger bigint = EInteger.FromInt64(valueSmaller);
        return EDecimal.Create(bigint, EInteger.FromInt64(0L));
    }

    public static EDecimal FromDouble(double dbl) {
        boolean neg;
        int[] value = Extras.DoubleToIntegers(dbl);
        int floatExponent = value[1] >> 20 & 0x7FF;
        boolean bl = neg = value[1] >> 31 != 0;
        if (floatExponent == 2047) {
            if ((value[1] & 0xFFFFF) == 0 && value[0] == 0) {
                return neg ? NegativeInfinity : PositiveInfinity;
            }
            boolean quiet = (value[1] & 0x80000) != 0;
            value[1] = value[1] & 0x3FFFF;
            EInteger info = FastInteger.WordsToEInteger(value);
            value[0] = (neg ? 1 : 0) | (quiet ? 4 : 8);
            return info.isZero() ? (quiet ? NaN : SignalingNaN) : EDecimal.CreateWithFlags(info, EInteger.FromInt64(0L), value[0]);
        }
        value[1] = value[1] & 0xFFFFF;
        if (floatExponent == 0) {
            ++floatExponent;
        } else {
            value[1] = value[1] | 0x100000;
        }
        if ((value[1] | value[0]) != 0) {
            floatExponent += DecimalUtility.ShiftAwayTrailingZerosTwoElements(value);
        } else {
            return neg ? NegativeZero : Zero;
        }
        EInteger valueFpMantissaBig = FastInteger.WordsToEInteger(value);
        if ((floatExponent -= 1075) == 0) {
            if (neg) {
                valueFpMantissaBig = valueFpMantissaBig.Negate();
            }
            return EDecimal.FromEInteger(valueFpMantissaBig);
        }
        if (floatExponent > 0) {
            EInteger bigmantissa = valueFpMantissaBig;
            bigmantissa = bigmantissa.ShiftLeft(floatExponent);
            if (neg) {
                bigmantissa = bigmantissa.Negate();
            }
            return EDecimal.FromEInteger(bigmantissa);
        }
        EInteger bigmantissa = valueFpMantissaBig;
        EInteger exp = DecimalUtility.FindPowerOfFive(-floatExponent);
        bigmantissa = bigmantissa.Multiply(exp);
        if (neg) {
            bigmantissa = bigmantissa.Negate();
        }
        return EDecimal.Create(bigmantissa, EInteger.FromInt64(floatExponent));
    }

    public static EDecimal FromExtendedFloat(EFloat bigfloat) {
        if (bigfloat == null) {
            throw new NullPointerException("bigfloat");
        }
        if (bigfloat.IsNaN() || bigfloat.IsInfinity()) {
            int flags = (bigfloat.isNegative() ? 1 : 0) | (bigfloat.IsInfinity() ? 2 : 0) | (bigfloat.IsQuietNaN() ? 4 : 0) | (bigfloat.IsSignalingNaN() ? 8 : 0);
            return EDecimal.CreateWithFlags(bigfloat.getUnsignedMantissa(), bigfloat.getExponent(), flags);
        }
        EInteger bigintExp = bigfloat.getExponent();
        EInteger bigintMant = bigfloat.getMantissa();
        if (bigintMant.isZero()) {
            return bigfloat.isNegative() ? NegativeZero : Zero;
        }
        if (bigintExp.isZero()) {
            return EDecimal.FromEInteger(bigintMant);
        }
        if (bigintExp.signum() > 0) {
            boolean neg;
            FastInteger intcurexp = FastInteger.FromBig(bigintExp);
            EInteger bigmantissa = bigintMant;
            boolean bl = neg = bigmantissa.signum() < 0;
            if (neg) {
                bigmantissa = bigmantissa.Negate();
            }
            while (intcurexp.signum() > 0) {
                int shift = 1000000;
                if (intcurexp.CompareToInt(1000000) < 0) {
                    shift = intcurexp.AsInt32();
                }
                bigmantissa = bigmantissa.ShiftLeft(shift);
                intcurexp.AddInt(-shift);
            }
            if (neg) {
                bigmantissa = bigmantissa.Negate();
            }
            return EDecimal.FromEInteger(bigmantissa);
        }
        EInteger bigmantissa = bigintMant;
        EInteger negbigintExp = bigintExp.Negate();
        negbigintExp = DecimalUtility.FindPowerOfFiveFromBig(negbigintExp);
        bigmantissa = bigmantissa.Multiply(negbigintExp);
        return EDecimal.Create(bigmantissa, bigintExp);
    }

    public String toString() {
        return this.ToStringInternal(0);
    }

    public String ToEngineeringString() {
        return this.ToStringInternal(1);
    }

    public String ToPlainString() {
        return this.ToStringInternal(2);
    }

    public boolean IsNegativeInfinity() {
        return (this.flags & 3) == 3;
    }

    public boolean IsPositiveInfinity() {
        return (this.flags & 3) == 2;
    }

    public boolean IsNaN() {
        return (this.flags & 0xC) != 0;
    }

    public boolean IsInfinity() {
        return (this.flags & 2) != 0;
    }

    public final boolean isFinite() {
        return (this.flags & 0xE) == 0;
    }

    public final boolean isNegative() {
        return (this.flags & 1) != 0;
    }

    public boolean IsQuietNaN() {
        return (this.flags & 4) != 0;
    }

    public boolean IsSignalingNaN() {
        return (this.flags & 8) != 0;
    }

    public final int signum() {
        return (this.flags & 0xE) == 0 && this.unsignedMantissa.isZero() ? 0 : ((this.flags & 1) != 0 ? -1 : 1);
    }

    public final boolean isZero() {
        return (this.flags & 0xE) == 0 && this.unsignedMantissa.isZero();
    }

    public EDecimal Abs() {
        return this.Abs(null);
    }

    public EDecimal Negate() {
        return this.Negate(null);
    }

    public EDecimal Divide(EDecimal divisor) {
        return this.Divide(divisor, EContext.ForRounding(ERounding.None));
    }

    public EDecimal DivideToSameExponent(EDecimal divisor, ERounding rounding) {
        return this.DivideToExponent(divisor, this.exponent, EContext.ForRounding(rounding));
    }

    public EDecimal DivideToIntegerNaturalScale(EDecimal divisor) {
        return this.DivideToIntegerNaturalScale(divisor, EContext.ForRounding(ERounding.Down));
    }

    public EDecimal Reduce(EContext ctx) {
        return EDecimal.GetMathValue(ctx).Reduce(this, ctx);
    }

    public EDecimal RemainderNaturalScale(EDecimal divisor) {
        return this.RemainderNaturalScale(divisor, null);
    }

    public EDecimal RemainderNaturalScale(EDecimal divisor, EContext ctx) {
        return this.Subtract(this.DivideToIntegerNaturalScale(divisor, ctx).Multiply(divisor, null), null);
    }

    public EDecimal DivideToExponent(EDecimal divisor, long desiredExponentSmall, EContext ctx) {
        return this.DivideToExponent(divisor, EInteger.FromInt64(desiredExponentSmall), ctx);
    }

    public EDecimal Divide(EDecimal divisor, EContext ctx) {
        return EDecimal.GetMathValue(ctx).Divide(this, divisor, ctx);
    }

    public EDecimal DivideToExponent(EDecimal divisor, long desiredExponentSmall, ERounding rounding) {
        return this.DivideToExponent(divisor, EInteger.FromInt64(desiredExponentSmall), EContext.ForRounding(rounding));
    }

    public EDecimal DivideToExponent(EDecimal divisor, EInteger exponent, EContext ctx) {
        return EDecimal.GetMathValue(ctx).DivideToExponent(this, divisor, exponent, ctx);
    }

    public EDecimal DivideToExponent(EDecimal divisor, EInteger desiredExponent, ERounding rounding) {
        return this.DivideToExponent(divisor, desiredExponent, EContext.ForRounding(rounding));
    }

    public EDecimal Abs(EContext context) {
        return (context == null || context == EContext.Unlimited ? ExtendedMathValue : MathValue).Abs(this, context);
    }

    public EDecimal Negate(EContext context) {
        return (context == null || context == EContext.Unlimited ? ExtendedMathValue : MathValue).Negate(this, context);
    }

    public EDecimal Add(EDecimal otherValue) {
        return this.Add(otherValue, EContext.Unlimited);
    }

    public EDecimal Subtract(EDecimal otherValue) {
        return this.Subtract(otherValue, EContext.Unlimited);
    }

    public EDecimal Subtract(EDecimal otherValue, EContext ctx) {
        if (otherValue == null) {
            throw new NullPointerException("otherValue");
        }
        EDecimal negated = otherValue;
        if ((otherValue.flags & 0xC) == 0) {
            int newflags = otherValue.flags ^ 1;
            negated = EDecimal.CreateWithFlags(otherValue.unsignedMantissa, otherValue.exponent, newflags);
        }
        return this.Add(negated, ctx);
    }

    public EDecimal Multiply(EDecimal otherValue) {
        return this.Multiply(otherValue, EContext.Unlimited);
    }

    public EDecimal MultiplyAndAdd(EDecimal multiplicand, EDecimal augend) {
        return this.MultiplyAndAdd(multiplicand, augend, null);
    }

    private static IRadixMath<EDecimal> GetMathValue(EContext ctx) {
        if (ctx == null || ctx == EContext.Unlimited) {
            return ExtendedMathValue;
        }
        return !ctx.isSimplified() && ctx.getTraps() == 0 ? ExtendedMathValue : MathValue;
    }

    public EDecimal DivideToIntegerNaturalScale(EDecimal divisor, EContext ctx) {
        return EDecimal.GetMathValue(ctx).DivideToIntegerNaturalScale(this, divisor, ctx);
    }

    public EDecimal DivideToIntegerZeroScale(EDecimal divisor, EContext ctx) {
        return EDecimal.GetMathValue(ctx).DivideToIntegerZeroScale(this, divisor, ctx);
    }

    public EDecimal Remainder(EDecimal divisor, EContext ctx) {
        return EDecimal.GetMathValue(ctx).Remainder(this, divisor, ctx);
    }

    public EDecimal RemainderNear(EDecimal divisor, EContext ctx) {
        return EDecimal.GetMathValue(ctx).RemainderNear(this, divisor, ctx);
    }

    public EDecimal NextMinus(EContext ctx) {
        return EDecimal.GetMathValue(ctx).NextMinus(this, ctx);
    }

    public EDecimal NextPlus(EContext ctx) {
        return EDecimal.GetMathValue(ctx).NextPlus(this, ctx);
    }

    public EDecimal NextToward(EDecimal otherValue, EContext ctx) {
        return EDecimal.GetMathValue(ctx).NextToward(this, otherValue, ctx);
    }

    public static EDecimal Max(EDecimal first, EDecimal second, EContext ctx) {
        return EDecimal.GetMathValue(ctx).Max(first, second, ctx);
    }

    public static EDecimal Min(EDecimal first, EDecimal second, EContext ctx) {
        return EDecimal.GetMathValue(ctx).Min(first, second, ctx);
    }

    public static EDecimal MaxMagnitude(EDecimal first, EDecimal second, EContext ctx) {
        return EDecimal.GetMathValue(ctx).MaxMagnitude(first, second, ctx);
    }

    public static EDecimal MinMagnitude(EDecimal first, EDecimal second, EContext ctx) {
        return EDecimal.GetMathValue(ctx).MinMagnitude(first, second, ctx);
    }

    public static EDecimal Max(EDecimal first, EDecimal second) {
        return EDecimal.Max(first, second, null);
    }

    public static EDecimal Min(EDecimal first, EDecimal second) {
        return EDecimal.Min(first, second, null);
    }

    public static EDecimal MaxMagnitude(EDecimal first, EDecimal second) {
        return EDecimal.MaxMagnitude(first, second, null);
    }

    public static EDecimal MinMagnitude(EDecimal first, EDecimal second) {
        return EDecimal.MinMagnitude(first, second, null);
    }

    @Override
    public int compareTo(EDecimal other) {
        return ExtendedMathValue.compareTo(this, other);
    }

    public EDecimal CompareToWithContext(EDecimal other, EContext ctx) {
        return EDecimal.GetMathValue(ctx).CompareToWithContext(this, other, false, ctx);
    }

    public EDecimal CompareToSignal(EDecimal other, EContext ctx) {
        return EDecimal.GetMathValue(ctx).CompareToWithContext(this, other, true, ctx);
    }

    public EDecimal Add(EDecimal otherValue, EContext ctx) {
        return EDecimal.GetMathValue(ctx).Add(this, otherValue, ctx);
    }

    public EDecimal Quantize(EInteger desiredExponent, EContext ctx) {
        return this.Quantize(EDecimal.Create(EInteger.FromInt64(1L), desiredExponent), ctx);
    }

    public EDecimal Quantize(int desiredExponentSmall, ERounding rounding) {
        return this.Quantize(EDecimal.Create(EInteger.FromInt64(1L), EInteger.FromInt64(desiredExponentSmall)), EContext.ForRounding(rounding));
    }

    public EDecimal Quantize(int desiredExponentSmall, EContext ctx) {
        return this.Quantize(EDecimal.Create(EInteger.FromInt64(1L), EInteger.FromInt64(desiredExponentSmall)), ctx);
    }

    public EDecimal Quantize(EDecimal otherValue, EContext ctx) {
        return EDecimal.GetMathValue(ctx).Quantize(this, otherValue, ctx);
    }

    public EDecimal RoundToIntegralExact(EContext ctx) {
        return EDecimal.GetMathValue(ctx).RoundToExponentExact(this, EInteger.FromInt64(0L), ctx);
    }

    public EDecimal RoundToIntegralNoRoundedFlag(EContext ctx) {
        return EDecimal.GetMathValue(ctx).RoundToExponentNoRoundedFlag(this, EInteger.FromInt64(0L), ctx);
    }

    public EDecimal RoundToExponentExact(EInteger exponent, EContext ctx) {
        return EDecimal.GetMathValue(ctx).RoundToExponentExact(this, exponent, ctx);
    }

    public EDecimal RoundToExponent(EInteger exponent, EContext ctx) {
        return EDecimal.GetMathValue(ctx).RoundToExponentSimple(this, exponent, ctx);
    }

    public EDecimal RoundToExponentExact(int exponentSmall, EContext ctx) {
        return this.RoundToExponentExact(EInteger.FromInt64(exponentSmall), ctx);
    }

    public EDecimal RoundToExponent(int exponentSmall, EContext ctx) {
        if (this.isFinite() && (ctx == null || !ctx.getHasExponentRange() && !ctx.getHasFlags() && ctx.getTraps() == 0 && !ctx.getHasMaxPrecision() && !ctx.isSimplified()) && this.exponent.CanFitInInt32() && this.unsignedMantissa.CanFitInInt32()) {
            int thisExponentSmall = this.exponent.AsInt32Unchecked();
            if (thisExponentSmall == exponentSmall) {
                return this;
            }
            int thisMantissaSmall = this.unsignedMantissa.AsInt32Unchecked();
            ERounding rounding = ctx.getRounding();
            if (thisExponentSmall >= -100 && thisExponentSmall <= 100 && exponentSmall >= -100 && exponentSmall <= 100) {
                int diff;
                if (rounding == ERounding.Down) {
                    int diff2 = exponentSmall - thisExponentSmall;
                    if (diff2 >= 1 && diff2 <= 9) {
                        return EDecimal.CreateWithFlags(EInteger.FromInt32(thisMantissaSmall /= ValueTenPowers[diff2]), EInteger.FromInt32(exponentSmall), this.flags);
                    }
                } else if (rounding == ERounding.HalfEven && thisMantissaSmall != Integer.MAX_VALUE && (diff = exponentSmall - thisExponentSmall) >= 1 && diff <= 9) {
                    int pwr = ValueTenPowers[diff - 1];
                    int div = thisMantissaSmall / pwr;
                    int div2 = div / 10;
                    int rem = div - div2 * 10;
                    if (rem > 5) {
                        ++div2;
                    } else if (rem == 5 && thisMantissaSmall - div * pwr != 0) {
                        ++div2;
                    } else if (rem == 5 && (div2 & 1) == 1) {
                        ++div2;
                    }
                    return EDecimal.CreateWithFlags(EInteger.FromInt32(div2), EInteger.FromInt32(exponentSmall), this.flags);
                }
            }
        }
        return this.RoundToExponent(EInteger.FromInt64(exponentSmall), ctx);
    }

    public EDecimal RoundToExponentExact(int exponentSmall, ERounding rounding) {
        return this.RoundToExponentExact(exponentSmall, EContext.ForRounding(rounding));
    }

    public EDecimal RoundToExponent(int exponentSmall, ERounding rounding) {
        return this.RoundToExponent(exponentSmall, EContext.ForRounding(rounding));
    }

    public EDecimal Multiply(EDecimal op, EContext ctx) {
        return EDecimal.GetMathValue(ctx).Multiply(this, op, ctx);
    }

    public EDecimal MultiplyAndAdd(EDecimal op, EDecimal augend, EContext ctx) {
        return EDecimal.GetMathValue(ctx).MultiplyAndAdd(this, op, augend, ctx);
    }

    public EDecimal MultiplyAndSubtract(EDecimal op, EDecimal subtrahend, EContext ctx) {
        if (op == null) {
            throw new NullPointerException("op");
        }
        if (subtrahend == null) {
            throw new NullPointerException("subtrahend");
        }
        EDecimal negated = subtrahend;
        if ((subtrahend.flags & 0xC) == 0) {
            int newflags = subtrahend.flags ^ 1;
            negated = EDecimal.CreateWithFlags(subtrahend.unsignedMantissa, subtrahend.exponent, newflags);
        }
        return EDecimal.GetMathValue(ctx).MultiplyAndAdd(this, op, negated, ctx);
    }

    public EDecimal RoundToPrecision(EContext ctx) {
        return EDecimal.GetMathValue(ctx).RoundToPrecision(this, ctx);
    }

    public EDecimal Plus(EContext ctx) {
        return EDecimal.GetMathValue(ctx).Plus(this, ctx);
    }

    public EDecimal SquareRoot(EContext ctx) {
        return EDecimal.GetMathValue(ctx).SquareRoot(this, ctx);
    }

    public EDecimal Exp(EContext ctx) {
        return EDecimal.GetMathValue(ctx).Exp(this, ctx);
    }

    public EDecimal Log(EContext ctx) {
        return EDecimal.GetMathValue(ctx).Ln(this, ctx);
    }

    public EDecimal Log10(EContext ctx) {
        return EDecimal.GetMathValue(ctx).Log10(this, ctx);
    }

    public EDecimal Pow(EDecimal exponent, EContext ctx) {
        return EDecimal.GetMathValue(ctx).Power(this, exponent, ctx);
    }

    public EDecimal Pow(int exponentSmall, EContext ctx) {
        return this.Pow(EDecimal.FromInt64(exponentSmall), ctx);
    }

    public EDecimal Pow(int exponentSmall) {
        return this.Pow(EDecimal.FromInt64(exponentSmall), null);
    }

    public static EDecimal PI(EContext ctx) {
        return EDecimal.GetMathValue(ctx).Pi(ctx);
    }

    public EDecimal MovePointLeft(int places) {
        return this.MovePointLeft(EInteger.FromInt64(places), null);
    }

    public EDecimal MovePointLeft(int places, EContext ctx) {
        return this.MovePointLeft(EInteger.FromInt64(places), ctx);
    }

    public EDecimal MovePointLeft(EInteger bigPlaces) {
        return this.MovePointLeft(bigPlaces, null);
    }

    public EDecimal MovePointLeft(EInteger bigPlaces, EContext ctx) {
        if (bigPlaces.isZero()) {
            return this.RoundToPrecision(ctx);
        }
        return !this.isFinite() ? this.RoundToPrecision(ctx) : this.MovePointRight(bigPlaces.Negate(), ctx);
    }

    public EDecimal MovePointRight(int places) {
        return this.MovePointRight(EInteger.FromInt64(places), null);
    }

    public EDecimal MovePointRight(int places, EContext ctx) {
        return this.MovePointRight(EInteger.FromInt64(places), ctx);
    }

    public EDecimal MovePointRight(EInteger bigPlaces) {
        return this.MovePointRight(bigPlaces, null);
    }

    public EDecimal MovePointRight(EInteger bigPlaces, EContext ctx) {
        if (bigPlaces.isZero()) {
            return this.RoundToPrecision(ctx);
        }
        if (!this.isFinite()) {
            return this.RoundToPrecision(ctx);
        }
        EInteger bigExp = this.getExponent();
        if ((bigExp = bigExp.Add(bigPlaces)).signum() > 0) {
            EInteger mant = this.unsignedMantissa;
            EInteger bigPower = DecimalUtility.FindPowerOfTenFromBig(bigExp);
            mant = mant.Multiply(bigPower);
            return EDecimal.CreateWithFlags(mant, EInteger.FromInt64(0L), this.flags).RoundToPrecision(ctx);
        }
        return EDecimal.CreateWithFlags(this.unsignedMantissa, bigExp, this.flags).RoundToPrecision(ctx);
    }

    public EDecimal ScaleByPowerOfTen(int places) {
        return this.ScaleByPowerOfTen(EInteger.FromInt64(places), null);
    }

    public EDecimal ScaleByPowerOfTen(int places, EContext ctx) {
        return this.ScaleByPowerOfTen(EInteger.FromInt64(places), ctx);
    }

    public EDecimal ScaleByPowerOfTen(EInteger bigPlaces) {
        return this.ScaleByPowerOfTen(bigPlaces, null);
    }

    public EDecimal ScaleByPowerOfTen(EInteger bigPlaces, EContext ctx) {
        if (bigPlaces.isZero()) {
            return this.RoundToPrecision(ctx);
        }
        if (!this.isFinite()) {
            return this.RoundToPrecision(ctx);
        }
        EInteger bigExp = this.getExponent();
        bigExp = bigExp.Add(bigPlaces);
        return EDecimal.CreateWithFlags(this.unsignedMantissa, bigExp, this.flags).RoundToPrecision(ctx);
    }

    public EInteger Precision() {
        if (!this.isFinite()) {
            return EInteger.FromInt64(0L);
        }
        if (this.isZero()) {
            return EInteger.FromInt64(1L);
        }
        int digcount = this.unsignedMantissa.GetDigitCount();
        return EInteger.FromInt64(digcount);
    }

    public EDecimal Ulp() {
        return !this.isFinite() ? One : EDecimal.Create(EInteger.FromInt64(1L), this.exponent);
    }

    public EDecimal[] DivideAndRemainderNaturalScale(EDecimal divisor) {
        return this.DivideAndRemainderNaturalScale(divisor, null);
    }

    public EDecimal[] DivideAndRemainderNaturalScale(EDecimal divisor, EContext ctx) {
        EDecimal[] result;
        result = new EDecimal[]{this.DivideToIntegerNaturalScale(divisor, ctx), this.Subtract(result[0].Multiply(divisor, null), null)};
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DecimalMathHelper
    implements IRadixMathHelper<EDecimal> {
        private DecimalMathHelper() {
        }

        @Override
        public int GetRadix() {
            return 10;
        }

        @Override
        public int GetSign(EDecimal value) {
            return value.signum();
        }

        @Override
        public EInteger GetMantissa(EDecimal value) {
            return value.unsignedMantissa;
        }

        @Override
        public EInteger GetExponent(EDecimal value) {
            return value.exponent;
        }

        @Override
        public IShiftAccumulator CreateShiftAccumulatorWithDigits(EInteger bigint, int lastDigit, int olderDigits) {
            return new DigitShiftAccumulator(bigint, lastDigit, olderDigits);
        }

        @Override
        public IShiftAccumulator CreateShiftAccumulator(EInteger bigint) {
            return new DigitShiftAccumulator(bigint, 0, 0);
        }

        @Override
        public boolean HasTerminatingRadixExpansion(EInteger numerator, EInteger denominator) {
            EInteger gcd = numerator.Gcd(denominator);
            EInteger tmpden = denominator;
            if ((tmpden = tmpden.Divide(gcd)).isZero()) {
                return false;
            }
            int lowBit = tmpden.GetLowBit();
            tmpden = tmpden.ShiftRight(lowBit);
            while (true) {
                EInteger[] divrem = tmpden.DivRem(EInteger.FromInt64(5L));
                EInteger bigquo = divrem[0];
                EInteger bigrem = divrem[1];
                if (!bigrem.isZero()) break;
                tmpden = bigquo;
            }
            return tmpden.compareTo(EInteger.FromInt64(1L)) == 0;
        }

        @Override
        public EInteger MultiplyByRadixPower(EInteger bigint, FastInteger power) {
            int powerInt;
            EInteger tmpbigint = bigint;
            if (tmpbigint.isZero()) {
                return tmpbigint;
            }
            boolean fitsInInt32 = power.CanFitInInt32();
            int n = powerInt = fitsInInt32 ? power.AsInt32() : 0;
            if (fitsInInt32 && powerInt == 0) {
                return tmpbigint;
            }
            EInteger bigtmp = null;
            if (tmpbigint.compareTo(EInteger.FromInt64(1L)) != 0) {
                if (fitsInInt32) {
                    bigtmp = DecimalUtility.FindPowerOfTen(powerInt);
                    tmpbigint = tmpbigint.Multiply(bigtmp);
                } else {
                    bigtmp = DecimalUtility.FindPowerOfTenFromBig(power.AsBigInteger());
                    tmpbigint = tmpbigint.Multiply(bigtmp);
                }
                return tmpbigint;
            }
            return fitsInInt32 ? DecimalUtility.FindPowerOfTen(powerInt) : DecimalUtility.FindPowerOfTenFromBig(power.AsBigInteger());
        }

        @Override
        public int GetFlags(EDecimal value) {
            return value.flags;
        }

        @Override
        public EDecimal CreateNewWithFlags(EInteger mantissa, EInteger exponent, int flags) {
            return EDecimal.CreateWithFlags(mantissa, exponent, flags);
        }

        @Override
        public int GetArithmeticSupport() {
            return 1;
        }

        @Override
        public EDecimal ValueOf(int val) {
            return val == 0 ? Zero : (val == 1 ? One : EDecimal.FromInt64(val));
        }
    }
}

