/*
 * Decompiled with CFR 0.152.
 */
package permissions.dispatcher;

import android.app.Activity;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Process;
import android.support.v4.app.ActivityCompat;
import android.support.v4.app.AppOpsManagerCompat;
import android.support.v4.content.PermissionChecker;
import android.support.v4.util.SimpleArrayMap;

public final class PermissionUtils {
    private static final SimpleArrayMap<String, Integer> MIN_SDK_PERMISSIONS = new SimpleArrayMap(8);
    private static volatile int targetSdkVersion;

    private PermissionUtils() {
    }

    public static boolean verifyPermissions(int ... grantResults) {
        if (grantResults.length == 0) {
            return false;
        }
        for (int result : grantResults) {
            if (result == 0) continue;
            return false;
        }
        return true;
    }

    private static boolean permissionExists(String permission) {
        Integer minVersion = (Integer)MIN_SDK_PERMISSIONS.get((Object)permission);
        return minVersion == null || Build.VERSION.SDK_INT >= minVersion;
    }

    public static boolean hasSelfPermissions(Context context, String ... permissions) {
        for (String permission : permissions) {
            if (!PermissionUtils.permissionExists(permission) || PermissionUtils.hasSelfPermission(context, permission)) continue;
            return false;
        }
        return true;
    }

    private static boolean hasSelfPermission(Context context, String permission) {
        if (Build.VERSION.SDK_INT >= 23 && "Xiaomi".equalsIgnoreCase(Build.MANUFACTURER)) {
            return PermissionUtils.hasSelfPermissionForXiaomi(context, permission);
        }
        try {
            return PermissionChecker.checkSelfPermission((Context)context, (String)permission) == 0;
        }
        catch (RuntimeException t) {
            return false;
        }
    }

    private static boolean hasSelfPermissionForXiaomi(Context context, String permission) {
        String permissionToOp = AppOpsManagerCompat.permissionToOp((String)permission);
        if (permissionToOp == null) {
            return true;
        }
        int noteOp = AppOpsManagerCompat.noteOp((Context)context, (String)permissionToOp, (int)Process.myUid(), (String)context.getPackageName());
        return noteOp == 0 && PermissionChecker.checkSelfPermission((Context)context, (String)permission) == 0;
    }

    public static boolean shouldShowRequestPermissionRationale(Activity activity, String ... permissions) {
        for (String permission : permissions) {
            if (!ActivityCompat.shouldShowRequestPermissionRationale((Activity)activity, (String)permission)) continue;
            return true;
        }
        return false;
    }

    public static int getTargetSdkVersion(Context context) {
        if (targetSdkVersion != -1) {
            return targetSdkVersion;
        }
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            targetSdkVersion = packageInfo.applicationInfo.targetSdkVersion;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        return targetSdkVersion;
    }

    static {
        MIN_SDK_PERMISSIONS.put((Object)"com.android.voicemail.permission.ADD_VOICEMAIL", (Object)14);
        MIN_SDK_PERMISSIONS.put((Object)"android.permission.BODY_SENSORS", (Object)20);
        MIN_SDK_PERMISSIONS.put((Object)"android.permission.READ_CALL_LOG", (Object)16);
        MIN_SDK_PERMISSIONS.put((Object)"android.permission.READ_EXTERNAL_STORAGE", (Object)16);
        MIN_SDK_PERMISSIONS.put((Object)"android.permission.USE_SIP", (Object)9);
        MIN_SDK_PERMISSIONS.put((Object)"android.permission.WRITE_CALL_LOG", (Object)16);
        MIN_SDK_PERMISSIONS.put((Object)"android.permission.SYSTEM_ALERT_WINDOW", (Object)23);
        MIN_SDK_PERMISSIONS.put((Object)"android.permission.WRITE_SETTINGS", (Object)23);
        targetSdkVersion = -1;
    }
}

