/*
 * Decompiled with CFR 0.152.
 */
package com.pepperonas.materialdialog.adapter;

import android.content.Context;
import android.graphics.Typeface;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.pepperonas.materialdialog.MaterialDialog;
import com.pepperonas.materialdialog.R;

public class CustomArrayAdapter
extends ArrayAdapter<String> {
    private MaterialDialog mMaterialDialog;
    private boolean mDismissOnSelection = false;
    private LayoutInflater mInflater;
    private CharSequence[] mStrings;
    private MaterialDialog.ItemClickListener mItemClickListener;
    private MaterialDialog.ItemLongClickListener mItemLongClickListener;
    private Typeface mTypeface;

    public CustomArrayAdapter(@NonNull MaterialDialog materialDialog, @NonNull Context context, @NonNull String[] strings, @Nullable MaterialDialog.ItemClickListener itemClickListener, @Nullable MaterialDialog.ItemLongClickListener itemLongClickListener, boolean dismissOnSelection, Typeface typeface) {
        super(context, R.layout.custom_list_item, (Object[])strings);
        this.mMaterialDialog = materialDialog;
        this.mDismissOnSelection = dismissOnSelection;
        this.mInflater = (LayoutInflater)context.getSystemService("layout_inflater");
        this.mStrings = strings;
        this.mItemClickListener = itemClickListener;
        this.mItemLongClickListener = itemLongClickListener;
        this.mTypeface = typeface;
    }

    public View getView(final int position, View convertView, ViewGroup parent) {
        ViewHolder viewHolder;
        View row = convertView;
        if (row == null) {
            row = this.mInflater.inflate(R.layout.custom_list_item, parent, false);
            LinearLayout linearLayout = (LinearLayout)row.findViewById(R.id.ll_simple_list_item);
            TextView tv = (TextView)row.findViewById(R.id.tv_simple_list_item);
            if (this.mTypeface != null) {
                tv.setTypeface(this.mTypeface);
            }
            viewHolder = new ViewHolder();
            viewHolder.linearLayout = linearLayout;
            viewHolder.tv = tv;
            row.setTag((Object)viewHolder);
        } else {
            viewHolder = (ViewHolder)row.getTag();
        }
        final View finalRow = row;
        viewHolder.linearLayout.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (CustomArrayAdapter.this.mItemClickListener != null) {
                    CustomArrayAdapter.this.mItemClickListener.onClick(finalRow, position, finalRow.getId());
                    if (CustomArrayAdapter.this.mDismissOnSelection) {
                        CustomArrayAdapter.this.mMaterialDialog.dismiss();
                    }
                }
                if (CustomArrayAdapter.this.mItemLongClickListener != null) {
                    CustomArrayAdapter.this.mItemLongClickListener.onLongClick(finalRow, position, finalRow.getId());
                    if (CustomArrayAdapter.this.mDismissOnSelection) {
                        CustomArrayAdapter.this.mMaterialDialog.dismiss();
                    }
                }
            }
        });
        viewHolder.tv.setText(this.mStrings[position]);
        viewHolder.tv.setTag((Object)position);
        return row;
    }

    static class ViewHolder {
        LinearLayout linearLayout;
        TextView tv;

        ViewHolder() {
        }
    }
}

