/*
 * Decompiled with CFR 0.152.
 */
package com.github.penfeizhou.animation.glide;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import androidx.annotation.NonNull;
import com.bumptech.glide.Glide;
import com.bumptech.glide.Registry;
import com.bumptech.glide.annotation.GlideModule;
import com.bumptech.glide.load.ResourceDecoder;
import com.bumptech.glide.load.resource.transcode.ResourceTranscoder;
import com.bumptech.glide.module.LibraryGlideModule;
import com.github.penfeizhou.animation.decode.FrameSeqDecoder;
import com.github.penfeizhou.animation.glide.ByteBufferAnimationDecoder;
import com.github.penfeizhou.animation.glide.FrameBitmapTranscoder;
import com.github.penfeizhou.animation.glide.FrameDrawableTranscoder;
import com.github.penfeizhou.animation.glide.StreamAnimationDecoder;
import java.io.InputStream;
import java.nio.ByteBuffer;

@GlideModule
public class GlideAnimationModule
extends LibraryGlideModule {
    public void registerComponents(@NonNull Context context, @NonNull Glide glide, @NonNull Registry registry) {
        super.registerComponents(context, glide, registry);
        ByteBufferAnimationDecoder byteBufferAnimationDecoder = new ByteBufferAnimationDecoder();
        StreamAnimationDecoder streamAnimationDecoder = new StreamAnimationDecoder(byteBufferAnimationDecoder);
        registry.prepend(InputStream.class, FrameSeqDecoder.class, (ResourceDecoder)streamAnimationDecoder);
        registry.prepend(ByteBuffer.class, FrameSeqDecoder.class, (ResourceDecoder)byteBufferAnimationDecoder);
        registry.register(FrameSeqDecoder.class, Drawable.class, (ResourceTranscoder)new FrameDrawableTranscoder());
        registry.register(FrameSeqDecoder.class, Bitmap.class, (ResourceTranscoder)new FrameBitmapTranscoder(glide.getBitmapPool()));
    }
}

