/*
 * Decompiled with CFR 0.152.
 */
package com.github.penfeizhou.animation.glide;

import android.graphics.Bitmap;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.bumptech.glide.load.Options;
import com.bumptech.glide.load.engine.Resource;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.bumptech.glide.load.resource.bitmap.BitmapResource;
import com.bumptech.glide.load.resource.transcode.ResourceTranscoder;
import com.github.penfeizhou.animation.decode.FrameSeqDecoder;
import java.io.IOException;

class FrameBitmapTranscoder
implements ResourceTranscoder<FrameSeqDecoder, Bitmap> {
    private final BitmapPool bitmapPool;

    FrameBitmapTranscoder(BitmapPool bitmapPool) {
        this.bitmapPool = bitmapPool;
    }

    @Nullable
    public Resource<Bitmap> transcode(@NonNull Resource<FrameSeqDecoder> toTranscode, @NonNull Options options) {
        FrameSeqDecoder frameSeqDecoder = (FrameSeqDecoder)toTranscode.get();
        try {
            Bitmap bitmap = frameSeqDecoder.getFrameBitmap(0);
            return BitmapResource.obtain((Bitmap)bitmap, (BitmapPool)this.bitmapPool);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

