/*
 * Decompiled with CFR 0.152.
 */
package com.github.penfeizhou.animation.gif.decode;

import com.github.penfeizhou.animation.gif.decode.Block;
import com.github.penfeizhou.animation.gif.decode.ColorTable;
import com.github.penfeizhou.animation.gif.io.GifReader;
import java.io.IOException;

public class ImageDescriptor
implements Block {
    public int frameX;
    public int frameY;
    public int frameWidth;
    public int frameHeight;
    private byte flag;
    public ColorTable localColorTable;
    public int lzwMinimumCodeSize;
    public int imageDataOffset;

    @Override
    public void receive(GifReader reader) throws IOException {
        byte blockSize;
        this.frameX = reader.readUInt16();
        this.frameY = reader.readUInt16();
        this.frameWidth = reader.readUInt16();
        this.frameHeight = reader.readUInt16();
        this.flag = reader.peek();
        if (this.localColorTableFlag()) {
            this.localColorTable = new ColorTable(this.localColorTableSize());
            this.localColorTable.receive(reader);
        }
        this.lzwMinimumCodeSize = reader.peek() & 0xFF;
        this.imageDataOffset = reader.position();
        while ((blockSize = reader.peek()) != 0) {
            reader.skip(blockSize & 0xFF);
        }
    }

    public boolean localColorTableFlag() {
        return (this.flag & 0x80) == 128;
    }

    public boolean interlaceFlag() {
        return (this.flag & 0x40) == 64;
    }

    public boolean sortFlag() {
        return (this.flag & 0x20) == 32;
    }

    public int localColorTableSize() {
        return 2 << (this.flag & 0xF);
    }

    @Override
    public int size() {
        return 0;
    }
}

