/*
 * Decompiled with CFR 0.152.
 */
package com.github.penfeizhou.animation.gif.decode;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import androidx.annotation.Nullable;
import com.github.penfeizhou.animation.decode.Frame;
import com.github.penfeizhou.animation.gif.decode.ColorTable;
import com.github.penfeizhou.animation.gif.decode.GraphicControlExtension;
import com.github.penfeizhou.animation.gif.decode.ImageDescriptor;
import com.github.penfeizhou.animation.gif.io.GifReader;
import com.github.penfeizhou.animation.gif.io.GifWriter;
import com.github.penfeizhou.animation.io.Reader;
import java.io.IOException;

public class GifFrame
extends Frame<GifReader, GifWriter> {
    public final int disposalMethod;
    public final int transparentColorIndex;
    public final ColorTable colorTable;
    private final int imageDataOffset;
    private final int lzwMinCodeSize;
    private static final ThreadLocal<byte[]> sDataBlock;
    private static final int DEFAULT_DELAY = 10;
    private final boolean interlace;

    public GifFrame(GifReader reader, ColorTable globalColorTable, @Nullable GraphicControlExtension graphicControlExtension, ImageDescriptor imageDescriptor) {
        super((Reader)reader);
        if (graphicControlExtension != null) {
            this.disposalMethod = graphicControlExtension.disposalMethod();
            this.frameDuration = (graphicControlExtension.delayTime <= 0 ? 10 : graphicControlExtension.delayTime) * 10;
            this.transparentColorIndex = graphicControlExtension.transparencyFlag() ? graphicControlExtension.transparentColorIndex : -1;
        } else {
            this.disposalMethod = 0;
            this.transparentColorIndex = -1;
        }
        this.frameX = imageDescriptor.frameX;
        this.frameY = imageDescriptor.frameY;
        this.frameWidth = imageDescriptor.frameWidth;
        this.frameHeight = imageDescriptor.frameHeight;
        this.interlace = imageDescriptor.interlaceFlag();
        this.colorTable = imageDescriptor.localColorTableFlag() ? imageDescriptor.localColorTable : globalColorTable;
        this.lzwMinCodeSize = imageDescriptor.lzwMinimumCodeSize;
        this.imageDataOffset = imageDescriptor.imageDataOffset;
    }

    public boolean transparencyFlag() {
        return this.transparentColorIndex >= 0;
    }

    public Bitmap draw(Canvas canvas, Paint paint, int sampleSize, Bitmap reusedBitmap, GifWriter writer) {
        try {
            writer.reset(this.frameWidth * this.frameHeight / (sampleSize * sampleSize));
            int[] pixels = writer.asIntArray();
            this.encode(pixels, sampleSize);
            reusedBitmap.copyPixelsFromBuffer(writer.asBuffer().rewind());
            this.srcRect.left = 0;
            this.srcRect.top = 0;
            this.srcRect.right = reusedBitmap.getWidth();
            this.srcRect.bottom = reusedBitmap.getHeight();
            this.dstRect.left = (int)((float)this.frameX / (float)sampleSize);
            this.dstRect.top = (int)((float)this.frameY / (float)sampleSize);
            this.dstRect.right = (int)((float)this.frameX / (float)sampleSize + (float)reusedBitmap.getWidth());
            this.dstRect.bottom = (int)((float)this.frameY / (float)sampleSize + (float)reusedBitmap.getHeight());
            canvas.drawBitmap(reusedBitmap, this.srcRect, this.dstRect, paint);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return reusedBitmap;
    }

    public void encode(int[] pixels, int sampleSize) throws IOException {
        ((GifReader)this.reader).reset();
        ((GifReader)this.reader).skip(this.imageDataOffset);
        byte[] dataBlock = sDataBlock.get();
        if (dataBlock == null) {
            dataBlock = new byte[255];
            sDataBlock.set(dataBlock);
        }
        this.uncompressLZW((GifReader)this.reader, this.colorTable.getColorTable(), this.transparentColorIndex, pixels, this.frameWidth / sampleSize, this.frameHeight / sampleSize, this.lzwMinCodeSize, this.interlace, dataBlock);
    }

    private native void uncompressLZW(GifReader var1, int[] var2, int var3, int[] var4, int var5, int var6, int var7, boolean var8, byte[] var9);

    static {
        System.loadLibrary("animation-decoder-gif");
        sDataBlock = new ThreadLocal();
    }
}

