/*
 * Decompiled with CFR 0.152.
 */
package com.github.penfeizhou.animation.gif.decode;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.util.Log;
import com.github.penfeizhou.animation.decode.Frame;
import com.github.penfeizhou.animation.decode.FrameSeqDecoder;
import com.github.penfeizhou.animation.gif.decode.ApplicationExtension;
import com.github.penfeizhou.animation.gif.decode.Block;
import com.github.penfeizhou.animation.gif.decode.ColorTable;
import com.github.penfeizhou.animation.gif.decode.GifFrame;
import com.github.penfeizhou.animation.gif.decode.GifParser;
import com.github.penfeizhou.animation.gif.decode.GraphicControlExtension;
import com.github.penfeizhou.animation.gif.decode.ImageDescriptor;
import com.github.penfeizhou.animation.gif.decode.LogicalScreenDescriptor;
import com.github.penfeizhou.animation.gif.io.GifReader;
import com.github.penfeizhou.animation.gif.io.GifWriter;
import com.github.penfeizhou.animation.io.Reader;
import com.github.penfeizhou.animation.loader.Loader;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.List;

public class GifDecoder
extends FrameSeqDecoder<GifReader, GifWriter> {
    private static final String TAG = "GifDecoder";
    private GifWriter mGifWriter = new GifWriter();
    private final Paint paint = new Paint();
    private int bgColor = 0;
    private final SnapShot snapShot = new SnapShot();
    private int mLoopCount = 1;

    public GifDecoder(Loader loader, FrameSeqDecoder.RenderListener renderListener) {
        super(loader, renderListener);
        this.paint.setAntiAlias(true);
    }

    protected GifWriter getWriter() {
        if (this.mGifWriter == null) {
            this.mGifWriter = new GifWriter();
        }
        return this.mGifWriter;
    }

    protected GifReader getReader(Reader reader) {
        return new GifReader(reader);
    }

    protected int getLoopCount() {
        return this.mLoopCount;
    }

    protected void release() {
        this.snapShot.byteBuffer = null;
        this.mGifWriter = null;
    }

    protected Rect read(GifReader reader) throws IOException {
        List<Block> blocks = GifParser.parse(reader);
        int canvasWidth = 0;
        int canvasHeight = 0;
        ColorTable globalColorTable = null;
        GraphicControlExtension graphicControlExtension = null;
        int bgColorIndex = -1;
        for (Block block : blocks) {
            if (block instanceof LogicalScreenDescriptor) {
                canvasWidth = ((LogicalScreenDescriptor)block).screenWidth;
                canvasHeight = ((LogicalScreenDescriptor)block).screenHeight;
                if (!((LogicalScreenDescriptor)block).gColorTableFlag()) continue;
                bgColorIndex = ((LogicalScreenDescriptor)block).bgColorIndex & 0xFF;
                continue;
            }
            if (block instanceof ColorTable) {
                globalColorTable = (ColorTable)block;
                continue;
            }
            if (block instanceof GraphicControlExtension) {
                graphicControlExtension = (GraphicControlExtension)block;
                continue;
            }
            if (block instanceof ImageDescriptor) {
                GifFrame gifFrame = new GifFrame(reader, globalColorTable, graphicControlExtension, (ImageDescriptor)block);
                this.frames.add(gifFrame);
                continue;
            }
            if (!(block instanceof ApplicationExtension) || !"NETSCAPE2.0".equals(((ApplicationExtension)block).identifier)) continue;
            int loopCount = ((ApplicationExtension)block).loopCount;
            if (loopCount == 0) {
                this.mLoopCount = 0;
                continue;
            }
            if (loopCount <= 0) continue;
            this.mLoopCount = loopCount + 1;
        }
        long bufferSize = ((long)canvasWidth * (long)canvasHeight / ((long)this.sampleSize * (long)this.sampleSize) + 1L) * 4L;
        try {
            this.frameBuffer = ByteBuffer.allocate((int)bufferSize);
            this.snapShot.byteBuffer = ByteBuffer.allocate((int)bufferSize);
        }
        catch (OutOfMemoryError e) {
            Log.e((String)TAG, (String)String.format("OutOfMemoryError in GifDecoder: Buffer needed: %.2fMB (%,d bytes)", (double)bufferSize / 1048576.0, bufferSize));
            this.frameBuffer = null;
            this.snapShot.byteBuffer = null;
            throw e;
        }
        if (globalColorTable != null && bgColorIndex >= 0 && bgColorIndex < globalColorTable.getColorTable().length) {
            int abgr = globalColorTable.getColorTable()[bgColorIndex];
            this.bgColor = Color.rgb((int)(abgr & 0xFF), (int)(abgr >> 8 & 0xFF), (int)(abgr >> 16 & 0xFF));
        }
        return new Rect(0, 0, canvasWidth, canvasHeight);
    }

    protected int getDesiredSample(int desiredWidth, int desiredHeight) {
        return 1;
    }

    protected void renderFrame(Frame<GifReader, GifWriter> frame) {
        GifFrame gifFrame = (GifFrame)frame;
        Bitmap bitmap = this.obtainBitmap(this.fullRect.width() / this.sampleSize, this.fullRect.height() / this.sampleSize);
        Canvas canvas = (Canvas)this.cachedCanvas.get(bitmap);
        if (canvas == null) {
            canvas = new Canvas(bitmap);
            this.cachedCanvas.put(bitmap, canvas);
        }
        this.frameBuffer.rewind();
        bitmap.copyPixelsFromBuffer((Buffer)this.frameBuffer);
        int backgroundColor = 0;
        if (!gifFrame.transparencyFlag()) {
            backgroundColor = this.bgColor;
        }
        if (this.frameIndex == 0) {
            bitmap.eraseColor(backgroundColor);
        } else {
            GifFrame preFrame = (GifFrame)((Object)this.frames.get(this.frameIndex - 1));
            canvas.save();
            canvas.clipRect(preFrame.frameX / this.sampleSize, preFrame.frameY / this.sampleSize, (preFrame.frameX + preFrame.frameWidth) / this.sampleSize, (preFrame.frameY + preFrame.frameHeight) / this.sampleSize);
            switch (preFrame.disposalMethod) {
                case 0: {
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    canvas.drawColor(this.bgColor, PorterDuff.Mode.CLEAR);
                    break;
                }
                case 3: {
                    this.snapShot.byteBuffer.rewind();
                    canvas.drawColor(this.bgColor, PorterDuff.Mode.CLEAR);
                    Bitmap preBitmap = this.obtainBitmap(this.fullRect.width() / this.sampleSize, this.fullRect.height() / this.sampleSize);
                    preBitmap.copyPixelsFromBuffer((Buffer)this.snapShot.byteBuffer);
                    canvas.drawBitmap(preBitmap, 0.0f, 0.0f, this.paint);
                    this.recycleBitmap(preBitmap);
                }
            }
            canvas.restore();
            if (gifFrame.disposalMethod == 3 && preFrame.disposalMethod != 3) {
                this.frameBuffer.rewind();
                this.snapShot.byteBuffer.rewind();
                this.snapShot.byteBuffer.put(this.frameBuffer);
            }
        }
        Bitmap reused = this.obtainBitmap(frame.frameWidth / this.sampleSize, frame.frameHeight / this.sampleSize);
        gifFrame.draw(canvas, this.paint, this.sampleSize, reused, this.getWriter());
        canvas.drawColor(backgroundColor, PorterDuff.Mode.DST_OVER);
        this.recycleBitmap(reused);
        this.frameBuffer.rewind();
        bitmap.copyPixelsToBuffer((Buffer)this.frameBuffer);
        this.recycleBitmap(bitmap);
    }

    private static class SnapShot {
        ByteBuffer byteBuffer;

        private SnapShot() {
        }
    }
}

