/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtsp.rtsp.commands;

import android.util.Log;
import com.pedro.rtsp.rtsp.Protocol;
import com.pedro.rtsp.rtsp.commands.Command;
import com.pedro.rtsp.rtsp.commands.Method;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\n\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006H\u0002J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0006H\u0002J\u000e\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rJ6\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0013J\u000e\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0006J\u0016\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u0006\u00a8\u0006\u001d"}, d2={"Lcom/pedro/rtsp/rtsp/commands/CommandParser;", "", "()V", "getCSeq", "", "request", "", "getMethod", "Lcom/pedro/rtsp/rtsp/commands/Method;", "response", "getResponseStatus", "getSessionId", "command", "Lcom/pedro/rtsp/rtsp/commands/Command;", "loadServerPorts", "", "protocol", "Lcom/pedro/rtsp/rtsp/Protocol;", "audioClientPorts", "", "videoClientPorts", "audioServerPorts", "videoServerPorts", "parseCommand", "commandText", "parseResponse", "method", "responseText", "Companion", "rtsp_release"})
public final class CommandParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String TAG = "CommandParser";

    public final boolean loadServerPorts(@NotNull Command command, @NotNull Protocol protocol, @NotNull int[] audioClientPorts, @NotNull int[] videoClientPorts, @NotNull int[] audioServerPorts, @NotNull int[] videoServerPorts) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)((Object)protocol), (String)"protocol");
        Intrinsics.checkNotNullParameter((Object)audioClientPorts, (String)"audioClientPorts");
        Intrinsics.checkNotNullParameter((Object)videoClientPorts, (String)"videoClientPorts");
        Intrinsics.checkNotNullParameter((Object)audioServerPorts, (String)"audioServerPorts");
        Intrinsics.checkNotNullParameter((Object)videoServerPorts, (String)"videoServerPorts");
        boolean isAudio = true;
        if (command.getMethod() == Method.SETUP && protocol == Protocol.UDP) {
            Pattern rtspPattern;
            Matcher matcher;
            Pattern clientPattern = Pattern.compile("client_port=([0-9]+)-([0-9]+)");
            Matcher clientMatcher = clientPattern.matcher(command.getText());
            if (clientMatcher.find()) {
                int port;
                String string = clientMatcher.group(1);
                if (string == null) {
                    string = "-1";
                }
                boolean bl = isAudio = (port = Integer.parseInt(string)) == audioClientPorts[0];
            }
            if ((matcher = (rtspPattern = Pattern.compile("server_port=([0-9]+)-([0-9]+)")).matcher(command.getText())).find()) {
                if (isAudio) {
                    String string = matcher.group(1);
                    audioServerPorts[0] = string != null ? Integer.parseInt(string) : audioClientPorts[0];
                    String string2 = matcher.group(2);
                    audioServerPorts[1] = string2 != null ? Integer.parseInt(string2) : audioClientPorts[1];
                } else {
                    String string = matcher.group(1);
                    videoServerPorts[0] = string != null ? Integer.parseInt(string) : videoClientPorts[0];
                    String string3 = matcher.group(2);
                    videoServerPorts[1] = string3 != null ? Integer.parseInt(string3) : videoClientPorts[1];
                }
                return true;
            }
        }
        return false;
    }

    @NotNull
    public final String getSessionId(@NotNull Command command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        String sessionId = "";
        Pattern rtspPattern = Pattern.compile("Session:(\\s?[^;\\n]+)");
        Matcher matcher = rtspPattern.matcher(command.getText());
        if (matcher.find()) {
            String string = matcher.group(1);
            if (string == null) {
                string = "";
            }
            sessionId = string;
            String[] stringArray = new String[]{";"};
            String temp = (String)StringsKt.split$default((CharSequence)sessionId, (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(0);
            sessionId = ((Object)StringsKt.trim((CharSequence)temp)).toString();
        }
        return sessionId;
    }

    @NotNull
    public final Command parseResponse(@NotNull Method method, @NotNull String responseText) {
        Intrinsics.checkNotNullParameter((Object)((Object)method), (String)"method");
        Intrinsics.checkNotNullParameter((Object)responseText, (String)"responseText");
        int status = this.getResponseStatus(responseText);
        int cSeq = this.getCSeq(responseText);
        return new Command(method, cSeq, status, responseText);
    }

    @NotNull
    public final Command parseCommand(@NotNull String commandText) {
        Intrinsics.checkNotNullParameter((Object)commandText, (String)"commandText");
        Method method = this.getMethod(commandText);
        int cSeq = this.getCSeq(commandText);
        return new Command(method, cSeq, -1, commandText);
    }

    private final int getCSeq(String request) {
        int n;
        Matcher cSeqMatcher = Pattern.compile("CSeq\\s*:\\s*(\\d+)", 2).matcher(request);
        if (cSeqMatcher.find()) {
            String string = cSeqMatcher.group(1);
            n = string != null ? Integer.parseInt(string) : -1;
        } else {
            Log.e((String)TAG, (String)"cSeq not found");
            n = -1;
        }
        return n;
    }

    private final Method getMethod(String response) {
        block37: {
            Method method;
            block40: {
                block38: {
                    Matcher matcher = Pattern.compile("(\\w+) (\\S+) RTSP", 2).matcher(response);
                    if (!matcher.find()) break block37;
                    String method2 = matcher.group(1);
                    if (method2 == null) break block38;
                    String string = method2.toUpperCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
                    switch (string) {
                        case "OPTIONS": {
                            method = Method.OPTIONS;
                            break;
                        }
                        case "ANNOUNCE": {
                            method = Method.ANNOUNCE;
                            break;
                        }
                        case "RECORD": {
                            method = Method.RECORD;
                            break;
                        }
                        case "SETUP": {
                            method = Method.SETUP;
                            break;
                        }
                        case "DESCRIBE": {
                            method = Method.DESCRIBE;
                            break;
                        }
                        case "TEARDOWN": {
                            method = Method.TEARDOWN;
                            break;
                        }
                        case "PLAY": {
                            method = Method.PLAY;
                            break;
                        }
                        case "PAUSE": {
                            method = Method.PAUSE;
                            break;
                        }
                        case "SET_PARAMETERS": {
                            method = Method.SET_PARAMETERS;
                            break;
                        }
                        case "GET_PARAMETERS": {
                            method = Method.GET_PARAMETERS;
                            break;
                        }
                        case "REDIRECT": {
                            method = Method.REDIRECT;
                            break;
                        }
                        default: {
                            method = Method.UNKNOWN;
                            break;
                        }
                    }
                    break block40;
                }
                method = Method.UNKNOWN;
            }
            return method;
        }
        return Method.UNKNOWN;
    }

    private final int getResponseStatus(String response) {
        int n;
        Matcher matcher = Pattern.compile("RTSP/\\d.\\d (\\d+) (\\w+)", 2).matcher(response);
        if (matcher.find()) {
            String string = matcher.group(1);
            if (string == null) {
                string = "-1";
            }
            n = Integer.parseInt(string);
        } else {
            Log.e((String)TAG, (String)"status code not found");
            n = -1;
        }
        return n;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/pedro/rtsp/rtsp/commands/CommandParser$Companion;", "", "()V", "TAG", "", "rtsp_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

