/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtsp.rtp.packets;

import java.util.Random;

public class BasePacket {
    protected static final int maxPacketSize = 1272;
    protected byte channelIdentifier;
    protected int rtpPort;
    protected int rtcpPort;
    private final long clock;
    private int seq = 0;
    private int ssrc;

    public BasePacket(long clock) {
        this.clock = clock;
        this.ssrc = new Random().nextInt();
    }

    public void setPorts(int rtpPort, int rtcpPort) {
        this.rtpPort = rtpPort;
        this.rtcpPort = rtcpPort;
    }

    public void reset() {
        this.seq = 0;
        this.ssrc = new Random().nextInt();
    }

    protected byte[] getBuffer() {
        byte[] buffer = new byte[1300];
        buffer[0] = (byte)Integer.parseInt("10000000", 2);
        buffer[1] = 96;
        this.setLongSSRC(buffer, this.ssrc);
        this.requestBuffer(buffer);
        return buffer;
    }

    protected void updateTimeStamp(byte[] buffer, long timestamp) {
        long ts = timestamp * this.clock / 1000000000L;
        this.setLong(buffer, ts, 4, 8);
    }

    protected void setLong(byte[] buffer, long n, int begin, int end) {
        --end;
        while (end >= begin) {
            buffer[end] = (byte)(n % 256L);
            n >>= 8;
            --end;
        }
    }

    protected void updateSeq(byte[] buffer) {
        this.setLong(buffer, ++this.seq, 2, 4);
    }

    protected void markPacket(byte[] buffer) {
        buffer[1] = (byte)(buffer[1] | 0x80);
    }

    private void setLongSSRC(byte[] buffer, int ssrc) {
        this.setLong(buffer, ssrc, 8, 12);
    }

    private void requestBuffer(byte[] buffer) {
        buffer[1] = (byte)(buffer[1] & 0x7F);
    }
}

