/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtplibrary.view;

import android.content.Context;
import android.graphics.PointF;
import android.graphics.SurfaceTexture;
import android.support.annotation.RequiresApi;
import android.util.AttributeSet;
import android.util.Log;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import com.pedro.encoder.input.gl.SurfaceManager;
import com.pedro.encoder.input.gl.render.ManagerRender;
import com.pedro.encoder.input.gl.render.filters.BaseFilterRender;
import com.pedro.encoder.utils.gl.GifStreamObject;
import com.pedro.encoder.utils.gl.ImageStreamObject;
import com.pedro.encoder.utils.gl.TextStreamObject;
import com.pedro.encoder.utils.gl.TranslateTo;
import java.util.concurrent.Semaphore;

@RequiresApi(api=18)
public class OpenGlView
extends SurfaceView
implements Runnable,
SurfaceTexture.OnFrameAvailableListener,
SurfaceHolder.Callback {
    public static final String TAG = "OpenGlView";
    private Thread thread = null;
    private boolean frameAvailable = false;
    private boolean running = true;
    private boolean initialized = false;
    private SurfaceManager surfaceManager = null;
    private SurfaceManager surfaceManagerEncoder = null;
    private ManagerRender textureManager = null;
    private final Semaphore semaphore = new Semaphore(0);
    private final Object sync = new Object();
    private int previewWidth;
    private int previewHeight;
    private int encoderWidth;
    private int encoderHeight;
    private boolean loadStreamObject = false;
    private boolean loadAlpha = false;
    private boolean loadScale = false;
    private boolean loadPosition = false;
    private boolean loadFilter = false;
    private boolean loadAA = false;
    private boolean loadPositionTo = false;
    private TextStreamObject textStreamObject;
    private ImageStreamObject imageStreamObject;
    private GifStreamObject gifStreamObject;
    private BaseFilterRender baseFilterRender;
    private float alpha;
    private float scaleX;
    private float scaleY;
    private float positionX;
    private float positionY;
    private boolean AAEnabled = false;
    private TranslateTo positionTo;
    private Surface surface;
    private boolean isCamera2Landscape = false;
    private int waitTime = 10;

    public OpenGlView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.getHolder().addCallback((SurfaceHolder.Callback)this);
    }

    public void init() {
        if (!this.initialized) {
            this.textureManager = new ManagerRender();
        }
        this.initialized = true;
    }

    public SurfaceTexture getSurfaceTexture() {
        return this.textureManager.getSurfaceTexture();
    }

    public Surface getSurface() {
        return this.textureManager.getSurface();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMediaCodecSurface(Surface surface) {
        Object object = this.sync;
        synchronized (object) {
            this.surface = surface;
            this.surfaceManagerEncoder = new SurfaceManager(surface, this.surfaceManager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMediaCodecSurface() {
        Object object = this.sync;
        synchronized (object) {
            if (this.surfaceManagerEncoder != null) {
                this.surfaceManagerEncoder.release();
                this.surfaceManagerEncoder = null;
            }
        }
    }

    public void setEncoderSize(int width, int height) {
        this.encoderWidth = width;
        this.encoderHeight = height;
    }

    public void setFilter(BaseFilterRender baseFilterRender) {
        this.loadFilter = true;
        this.baseFilterRender = baseFilterRender;
    }

    public void setGif(GifStreamObject gifStreamObject) {
        this.gifStreamObject = gifStreamObject;
        this.imageStreamObject = null;
        this.textStreamObject = null;
        this.loadStreamObject = true;
    }

    public void setImage(ImageStreamObject imageStreamObject) {
        this.imageStreamObject = imageStreamObject;
        this.gifStreamObject = null;
        this.textStreamObject = null;
        this.loadStreamObject = true;
    }

    public void setText(TextStreamObject textStreamObject) {
        this.textStreamObject = textStreamObject;
        this.gifStreamObject = null;
        this.imageStreamObject = null;
        this.loadStreamObject = true;
    }

    public void clear() {
        this.textStreamObject = null;
        this.gifStreamObject = null;
        this.imageStreamObject = null;
        this.loadStreamObject = true;
    }

    public void setStreamObjectAlpha(float alpha) {
        this.alpha = alpha;
        this.loadAlpha = true;
    }

    public void setStreamObjectSize(float sizeX, float sizeY) {
        this.scaleX = sizeX;
        this.scaleY = sizeY;
        this.loadScale = true;
    }

    public void setStreamObjectPosition(float x, float y) {
        this.positionX = x;
        this.positionY = y;
        this.loadPosition = true;
    }

    public void setStreamObjectPosition(TranslateTo translateTo) {
        this.positionTo = translateTo;
        this.loadPositionTo = true;
    }

    public void enableAA(boolean AAEnabled) {
        this.AAEnabled = AAEnabled;
        this.loadAA = true;
    }

    public boolean isAAEnabled() {
        return this.textureManager != null && this.textureManager.isAAEnabled();
    }

    public void setWaitTime(int waitTime) {
        this.waitTime = waitTime;
    }

    public PointF getScale() {
        if (this.textureManager != null) {
            return this.textureManager.getScale();
        }
        return new PointF(0.0f, 0.0f);
    }

    public PointF getPosition() {
        if (this.textureManager != null) {
            return this.textureManager.getPosition();
        }
        return new PointF(0.0f, 0.0f);
    }

    public void startGLThread(boolean isCamera2Landscape) {
        this.isCamera2Landscape = isCamera2Landscape;
        Log.i((String)TAG, (String)"Thread started.");
        this.thread = new Thread(this);
        this.running = true;
        this.thread.start();
        this.semaphore.acquireUninterruptibly();
    }

    public void stopGlThread() {
        if (this.thread != null) {
            this.thread.interrupt();
            try {
                this.thread.join();
            }
            catch (InterruptedException e) {
                this.thread.interrupt();
            }
            this.thread = null;
        }
        this.running = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        this.surfaceManager = new SurfaceManager(this.getHolder().getSurface());
        this.surfaceManager.makeCurrent();
        this.textureManager.setStreamSize(this.encoderWidth, this.encoderHeight);
        this.textureManager.initGl(this.previewWidth, this.previewHeight, this.isCamera2Landscape, this.getContext());
        this.textureManager.getSurfaceTexture().setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)this);
        this.semaphore.release();
        try {
            while (this.running) {
                Object object = this.sync;
                synchronized (object) {
                    this.sync.wait(this.waitTime);
                    if (this.frameAvailable) {
                        this.frameAvailable = false;
                        this.surfaceManager.makeCurrent();
                        if (this.loadStreamObject) {
                            if (this.textStreamObject != null) {
                                this.textureManager.setText(this.textStreamObject);
                            } else if (this.imageStreamObject != null) {
                                this.textureManager.setImage(this.imageStreamObject);
                            } else if (this.gifStreamObject != null) {
                                this.textureManager.setGif(this.gifStreamObject);
                            } else {
                                this.textureManager.clear();
                            }
                        }
                        this.textureManager.updateFrame();
                        this.textureManager.drawOffScreen();
                        this.textureManager.drawScreen(this.previewWidth, this.previewHeight);
                        this.surfaceManager.swapBuffer();
                        if (this.loadStreamObject) {
                            this.surfaceManagerEncoder.release();
                            this.surfaceManagerEncoder = null;
                            this.addMediaCodecSurface(this.surface);
                            this.loadStreamObject = false;
                            continue;
                        }
                        Object object2 = this.sync;
                        synchronized (object2) {
                            if (this.surfaceManagerEncoder != null) {
                                this.surfaceManagerEncoder.makeCurrent();
                                this.textureManager.drawScreen(this.encoderWidth, this.encoderHeight);
                                long ts = this.textureManager.getSurfaceTexture().getTimestamp();
                                this.surfaceManagerEncoder.setPresentationTime(ts);
                                this.surfaceManagerEncoder.swapBuffer();
                            }
                        }
                    }
                    if (this.loadAlpha) {
                        this.textureManager.setAlpha(this.alpha);
                        this.loadAlpha = false;
                    } else if (this.loadScale) {
                        this.textureManager.setScale(this.scaleX, this.scaleY);
                        this.loadScale = false;
                    } else if (this.loadPosition) {
                        this.textureManager.setPosition(this.positionX, this.positionY);
                        this.loadPosition = false;
                    } else if (this.loadPositionTo) {
                        this.textureManager.setPosition(this.positionTo);
                        this.loadPositionTo = false;
                    } else if (this.loadFilter) {
                        this.textureManager.setFilter(this.baseFilterRender);
                        this.loadFilter = false;
                    } else if (this.loadAA) {
                        this.textureManager.enableAA(this.AAEnabled);
                        this.loadAA = false;
                    }
                }
            }
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        finally {
            this.surfaceManager.release();
            this.textureManager.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFrameAvailable(SurfaceTexture surfaceTexture) {
        Object object = this.sync;
        synchronized (object) {
            this.frameAvailable = true;
            this.sync.notifyAll();
        }
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
        Log.i((String)TAG, (String)("size: " + width + "x" + height));
        this.previewWidth = width;
        this.previewHeight = height;
    }

    public void surfaceCreated(SurfaceHolder holder) {
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        this.stopGlThread();
    }
}

