/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtplibrary.view;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.opengl.EGL14;
import android.opengl.EGLContext;
import android.opengl.EGLDisplay;
import android.opengl.EGLSurface;
import android.opengl.GLES20;
import android.opengl.GLSurfaceView;
import android.opengl.Matrix;
import android.support.annotation.RequiresApi;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.Surface;
import com.pedro.encoder.input.gl.SurfaceManager;
import com.pedro.encoder.utils.gl.GlUtil;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;

@RequiresApi(api=18)
public class CustomGlSurfaceView
extends GLSurfaceView {
    private CubeRenderer mRenderer;
    private float mPreviousX;
    private float mPreviousY;
    private float mPreviousDeg;
    private int previewWidth;
    private int previewHeight;
    private SurfaceTexture surfaceTexture;
    private SurfaceManager surfaceManager;
    private int encoderWidth;
    private int encoderHeight;
    private final Object sync = new Object();
    private EGLContext eglContext;
    private EGLDisplay savedEglDisplay;
    private EGLSurface savedEglDrawSurface;
    private EGLSurface savedEglReadSurface;
    private EGLContext savedEglContext;

    public CustomGlSurfaceView(Context context) {
        this(context, null);
    }

    public CustomGlSurfaceView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setEGLConfigChooser(new MyConfigChooser());
        this.setEGLContextClientVersion(2);
        this.mRenderer = new CubeRenderer();
        this.setRenderer(this.mRenderer);
        this.setRenderMode(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMediaCodecSurface(Surface surface) {
        Object object = this.sync;
        synchronized (object) {
            this.surfaceManager = new SurfaceManager(surface, this.eglContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMediaCodecSurface() {
        Object object = this.sync;
        synchronized (object) {
            if (this.surfaceManager != null) {
                this.surfaceManager.release();
                this.surfaceManager = null;
            }
        }
    }

    public void setEncoderSize(int width, int height) {
        this.encoderWidth = width;
        this.encoderHeight = height;
    }

    public void onPause() {
    }

    public void onResume() {
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (event != null) {
            System.out.println();
            if (event.getPointerCount() == 1) {
                float x = event.getX();
                float y = event.getY();
                if (event.getAction() == 2 && this.mRenderer != null) {
                    float deltaX = (x - this.mPreviousX) / (float)this.getWidth() * 360.0f;
                    float deltaY = (y - this.mPreviousY) / (float)this.getHeight() * 360.0f;
                    this.mRenderer.mDeltaX += deltaY;
                    this.mRenderer.mDeltaY += deltaX;
                }
                this.mPreviousX = x;
                this.mPreviousY = y;
            } else if (event.getPointerCount() == 2) {
                float dx = event.getX(1) - event.getX(0);
                float dy = event.getY(1) - event.getY(0);
                float deg = (float)Math.toDegrees(Math.atan2(dy, dx));
                if (event.getAction() != 2) {
                    this.mPreviousDeg = deg;
                    this.mPreviousX = event.getX();
                    this.mPreviousY = event.getY();
                    return true;
                }
                float ddeg = deg - this.mPreviousDeg;
                this.mRenderer.mDeltaZ -= ddeg;
                this.mPreviousDeg = deg;
            }
            this.requestRender();
        }
        return true;
    }

    private class CubeRenderer
    implements GLSurfaceView.Renderer {
        public volatile float mDeltaX;
        public volatile float mDeltaY;
        public volatile float mDeltaZ;
        int iProgId;
        int iPosition;
        int iVPMatrix;
        int iTexId;
        int iTexLoc;
        int iTexCoords;
        float[] m_fProjMatrix = new float[16];
        float[] m_fViewMatrix = new float[16];
        float[] m_fIdentity = new float[16];
        float[] m_fVPMatrix = new float[16];
        private float[] mAccumulatedRotation = new float[16];
        private float[] mCurrentRotation = new float[16];
        private float[] mTemporaryMatrix = new float[16];
        float[] cube = new float[]{2.0f, 2.0f, 2.0f, -2.0f, 2.0f, 2.0f, -2.0f, -2.0f, 2.0f, 2.0f, -2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, -2.0f, 2.0f, 2.0f, -2.0f, -2.0f, 2.0f, 2.0f, -2.0f, 2.0f, -2.0f, -2.0f, -2.0f, -2.0f, -2.0f, -2.0f, 2.0f, -2.0f, 2.0f, 2.0f, -2.0f, -2.0f, 2.0f, 2.0f, -2.0f, 2.0f, -2.0f, -2.0f, -2.0f, -2.0f, -2.0f, -2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, -2.0f, -2.0f, 2.0f, -2.0f, -2.0f, 2.0f, 2.0f, 2.0f, -2.0f, 2.0f, -2.0f, -2.0f, 2.0f, -2.0f, -2.0f, -2.0f, 2.0f, -2.0f, -2.0f};
        short[] indeces = new short[]{0, 1, 2, 0, 2, 3, 4, 5, 6, 4, 6, 7, 8, 9, 10, 8, 10, 11, 12, 13, 14, 12, 14, 15, 16, 17, 18, 16, 18, 19, 20, 21, 22, 20, 22, 23};
        float[] tex = new float[]{1.0f, 1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, -1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, -1.0f, 1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, -1.0f, 1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f};
        final String strVShader = "attribute vec4 a_position;attribute vec4 a_color;attribute vec3 a_normal;uniform mat4 u_VPMatrix;uniform vec3 u_LightPos;varying vec3 v_texCoords;attribute vec3 a_texCoords;void main(){v_texCoords = a_texCoords;gl_Position = u_VPMatrix * a_position;}";
        final String strFShader = "precision mediump float;uniform samplerCube u_texId;varying vec3 v_texCoords;void main(){gl_FragColor = textureCube(u_texId, v_texCoords);}";
        FloatBuffer cubeBuffer = ByteBuffer.allocateDirect(this.cube.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        ShortBuffer indexBuffer = null;
        FloatBuffer texBuffer = null;

        public CubeRenderer() {
            this.cubeBuffer.put(this.cube).position(0);
            this.indexBuffer = ByteBuffer.allocateDirect(this.indeces.length * 4).order(ByteOrder.nativeOrder()).asShortBuffer();
            this.indexBuffer.put(this.indeces).position(0);
            this.texBuffer = ByteBuffer.allocateDirect(this.tex.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
            this.texBuffer.put(this.tex).position(0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onDrawFrame(GL10 arg0) {
            Object object = CustomGlSurfaceView.this.sync;
            synchronized (object) {
                this.drawFrame(CustomGlSurfaceView.this.previewWidth, CustomGlSurfaceView.this.previewHeight);
                if (CustomGlSurfaceView.this.surfaceManager != null) {
                    this.saveRenderState();
                    CustomGlSurfaceView.this.surfaceManager.makeCurrent();
                    this.drawFrame(CustomGlSurfaceView.this.encoderWidth, CustomGlSurfaceView.this.encoderHeight);
                    CustomGlSurfaceView.this.surfaceManager.setPresentationTime(CustomGlSurfaceView.this.getDrawingTime());
                    CustomGlSurfaceView.this.surfaceManager.swapBuffer();
                    this.restoreRenderState();
                }
                CustomGlSurfaceView.this.surfaceTexture.updateTexImage();
            }
        }

        private void saveRenderState() {
            CustomGlSurfaceView.this.savedEglDisplay = EGL14.eglGetCurrentDisplay();
            CustomGlSurfaceView.this.savedEglDrawSurface = EGL14.eglGetCurrentSurface((int)12377);
            CustomGlSurfaceView.this.savedEglReadSurface = EGL14.eglGetCurrentSurface((int)12378);
            CustomGlSurfaceView.this.savedEglContext = EGL14.eglGetCurrentContext();
        }

        private void restoreRenderState() {
            if (!EGL14.eglMakeCurrent((EGLDisplay)CustomGlSurfaceView.this.savedEglDisplay, (EGLSurface)CustomGlSurfaceView.this.savedEglDrawSurface, (EGLSurface)CustomGlSurfaceView.this.savedEglReadSurface, (EGLContext)CustomGlSurfaceView.this.savedEglContext)) {
                throw new RuntimeException("eglMakeCurrent failed");
            }
        }

        private void drawFrame(int width, int height) {
            GLES20.glViewport((int)0, (int)0, (int)width, (int)height);
            Matrix.frustumM((float[])this.m_fProjMatrix, (int)0, (float)(-((float)width) / (float)height), (float)((float)width / (float)height), (float)-1.0f, (float)1.0f, (float)1.0f, (float)10.0f);
            GLES20.glClear((int)16640);
            GLES20.glUseProgram((int)this.iProgId);
            this.cubeBuffer.position(0);
            GLES20.glVertexAttribPointer((int)this.iPosition, (int)3, (int)5126, (boolean)false, (int)0, (Buffer)this.cubeBuffer);
            GLES20.glEnableVertexAttribArray((int)this.iPosition);
            this.texBuffer.position(0);
            GLES20.glVertexAttribPointer((int)this.iTexCoords, (int)3, (int)5126, (boolean)false, (int)0, (Buffer)this.texBuffer);
            GLES20.glEnableVertexAttribArray((int)this.iTexCoords);
            GLES20.glActiveTexture((int)33984);
            GLES20.glBindTexture((int)34067, (int)this.iTexId);
            GLES20.glUniform1i((int)this.iTexLoc, (int)0);
            Matrix.setIdentityM((float[])this.m_fIdentity, (int)0);
            Matrix.setIdentityM((float[])this.mCurrentRotation, (int)0);
            Matrix.rotateM((float[])this.mCurrentRotation, (int)0, (float)this.mDeltaX, (float)1.0f, (float)0.0f, (float)0.0f);
            Matrix.rotateM((float[])this.mCurrentRotation, (int)0, (float)this.mDeltaY, (float)0.0f, (float)1.0f, (float)0.0f);
            Matrix.rotateM((float[])this.mCurrentRotation, (int)0, (float)this.mDeltaZ, (float)0.0f, (float)0.0f, (float)1.0f);
            this.mDeltaX = 0.0f;
            this.mDeltaY = 0.0f;
            this.mDeltaZ = 0.0f;
            Matrix.multiplyMM((float[])this.mTemporaryMatrix, (int)0, (float[])this.mCurrentRotation, (int)0, (float[])this.mAccumulatedRotation, (int)0);
            System.arraycopy(this.mTemporaryMatrix, 0, this.mAccumulatedRotation, 0, 16);
            Matrix.multiplyMM((float[])this.mTemporaryMatrix, (int)0, (float[])this.m_fIdentity, (int)0, (float[])this.mAccumulatedRotation, (int)0);
            System.arraycopy(this.mTemporaryMatrix, 0, this.m_fIdentity, 0, 16);
            Matrix.multiplyMM((float[])this.m_fVPMatrix, (int)0, (float[])this.m_fViewMatrix, (int)0, (float[])this.m_fIdentity, (int)0);
            Matrix.multiplyMM((float[])this.m_fVPMatrix, (int)0, (float[])this.m_fProjMatrix, (int)0, (float[])this.m_fVPMatrix, (int)0);
            GLES20.glUniformMatrix4fv((int)this.iVPMatrix, (int)1, (boolean)false, (float[])this.m_fVPMatrix, (int)0);
            GLES20.glDrawElements((int)4, (int)36, (int)5123, (Buffer)this.indexBuffer);
        }

        public void onSurfaceCreated(GL10 gl10, EGLConfig eglConfig) {
            GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            GLES20.glEnable((int)2929);
            GLES20.glDepthFunc((int)515);
            GLES20.glFrontFace((int)2305);
            GLES20.glEnable((int)2884);
            GLES20.glCullFace((int)1029);
            GLES20.glEnable((int)3042);
            GLES20.glBlendFunc((int)770, (int)771);
            Matrix.setLookAtM((float[])this.m_fViewMatrix, (int)0, (float)0.0f, (float)0.0f, (float)6.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            Matrix.setIdentityM((float[])this.mAccumulatedRotation, (int)0);
            this.iProgId = GlUtil.createProgram((String)"attribute vec4 a_position;attribute vec4 a_color;attribute vec3 a_normal;uniform mat4 u_VPMatrix;uniform vec3 u_LightPos;varying vec3 v_texCoords;attribute vec3 a_texCoords;void main(){v_texCoords = a_texCoords;gl_Position = u_VPMatrix * a_position;}", (String)"precision mediump float;uniform samplerCube u_texId;varying vec3 v_texCoords;void main(){gl_FragColor = textureCube(u_texId, v_texCoords);}");
            this.iPosition = GLES20.glGetAttribLocation((int)this.iProgId, (String)"a_position");
            this.iVPMatrix = GLES20.glGetUniformLocation((int)this.iProgId, (String)"u_VPMatrix");
            this.iTexLoc = GLES20.glGetUniformLocation((int)this.iProgId, (String)"u_texId");
            this.iTexCoords = GLES20.glGetAttribLocation((int)this.iProgId, (String)"a_texCoords");
            this.iTexId = this.createCubeTexture();
            CustomGlSurfaceView.this.surfaceTexture = new SurfaceTexture(this.iTexId);
            CustomGlSurfaceView.this.surfaceTexture.setOnFrameAvailableListener(new SurfaceTexture.OnFrameAvailableListener(){

                public void onFrameAvailable(SurfaceTexture surfaceTexture) {
                    CustomGlSurfaceView.this.requestRender();
                }
            });
            CustomGlSurfaceView.this.eglContext = EGL14.eglGetCurrentContext();
        }

        public void onSurfaceChanged(GL10 arg0, int width, int height) {
            CustomGlSurfaceView.this.previewWidth = width;
            CustomGlSurfaceView.this.previewHeight = height;
        }

        public int createCubeTexture() {
            int[] textureId = new int[1];
            byte[] cubePixels0 = new byte[]{127, 0, 0};
            byte[] cubePixels1 = new byte[]{0, 127, 0};
            byte[] cubePixels2 = new byte[]{0, 0, 127};
            byte[] cubePixels3 = new byte[]{127, 127, 0};
            byte[] cubePixels4 = new byte[]{127, 0, 127};
            byte[] cubePixels5 = new byte[]{127, 127, 127};
            ByteBuffer cubePixels = ByteBuffer.allocateDirect(3);
            GLES20.glGenTextures((int)1, (int[])textureId, (int)0);
            GLES20.glBindTexture((int)34067, (int)textureId[0]);
            cubePixels.put(cubePixels0).position(0);
            GLES20.glTexImage2D((int)34069, (int)0, (int)6407, (int)1, (int)1, (int)0, (int)6407, (int)5121, (Buffer)cubePixels);
            cubePixels.put(cubePixels1).position(0);
            GLES20.glTexImage2D((int)34070, (int)0, (int)6407, (int)1, (int)1, (int)0, (int)6407, (int)5121, (Buffer)cubePixels);
            cubePixels.put(cubePixels2).position(0);
            GLES20.glTexImage2D((int)34071, (int)0, (int)6407, (int)1, (int)1, (int)0, (int)6407, (int)5121, (Buffer)cubePixels);
            cubePixels.put(cubePixels3).position(0);
            GLES20.glTexImage2D((int)34072, (int)0, (int)6407, (int)1, (int)1, (int)0, (int)6407, (int)5121, (Buffer)cubePixels);
            cubePixels.put(cubePixels4).position(0);
            GLES20.glTexImage2D((int)34073, (int)0, (int)6407, (int)1, (int)1, (int)0, (int)6407, (int)5121, (Buffer)cubePixels);
            cubePixels.put(cubePixels5).position(0);
            GLES20.glTexImage2D((int)34074, (int)0, (int)6407, (int)1, (int)1, (int)0, (int)6407, (int)5121, (Buffer)cubePixels);
            GLES20.glTexParameterf((int)34067, (int)10241, (float)9729.0f);
            GLES20.glTexParameterf((int)34067, (int)10240, (float)9729.0f);
            GLES20.glTexParameteri((int)34067, (int)10242, (int)33071);
            GLES20.glTexParameteri((int)34067, (int)10243, (int)33071);
            return textureId[0];
        }
    }

    private class MyConfigChooser
    implements GLSurfaceView.EGLConfigChooser {
        private MyConfigChooser() {
        }

        public EGLConfig chooseConfig(EGL10 egl10, javax.microedition.khronos.egl.EGLDisplay eglDisplay) {
            int[] attribs = new int[]{12324, 8, 12323, 8, 12322, 8, 12352, 4, 12344};
            EGLConfig[] configs = new EGLConfig[1];
            int[] configCounts = new int[1];
            egl10.eglChooseConfig(eglDisplay, attribs, configs, 1, configCounts);
            if (configCounts[0] == 0) {
                Log.e((String)"GlConfig", (String)"failed config");
                return null;
            }
            return configs[0];
        }
    }
}

