/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtmp.utils.socket;

import android.util.Log;
import com.pedro.common.ExtensionsKt;
import com.pedro.common.TimeUtils;
import com.pedro.rtmp.utils.socket.RtmpSocket;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.ssl.HttpsURLConnection;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u001a\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0005H\u0002J \u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010 \u001a\u00020!H\u0002J\u0018\u0010\"\u001a\u00020!2\u0006\u0010\u001f\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010#\u001a\u00020$2\u0006\u0010\u001f\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0016\u0010%\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020\u0007H\u0096@\u00a2\u0006\u0002\u0010'J\u000e\u0010(\u001a\u00020\u001eH\u0096@\u00a2\u0006\u0002\u0010)J\u000e\u0010*\u001a\u00020\u001eH\u0096@\u00a2\u0006\u0002\u0010)J\b\u0010+\u001a\u00020\u0007H\u0016J\b\u0010,\u001a\u00020\u0007H\u0016J\u0016\u0010-\u001a\u00020\u001e2\u0006\u0010.\u001a\u00020\u0005H\u0096@\u00a2\u0006\u0002\u0010/J\u0016\u0010-\u001a\u00020\u001e2\u0006\u0010.\u001a\u00020!H\u0096@\u00a2\u0006\u0002\u00100J&\u0010-\u001a\u00020\u001e2\u0006\u0010.\u001a\u00020!2\u0006\u00101\u001a\u00020\u00052\u0006\u00102\u001a\u00020\u0005H\u0096@\u00a2\u0006\u0002\u00103J\u0016\u00104\u001a\u00020\u001e2\u0006\u0010.\u001a\u00020\u0005H\u0096@\u00a2\u0006\u0002\u0010/J\u0016\u00105\u001a\u00020\u001e2\u0006\u0010.\u001a\u00020\u0005H\u0096@\u00a2\u0006\u0002\u0010/J\u0016\u00106\u001a\u00020\u001e2\u0006\u0010.\u001a\u00020\u0005H\u0096@\u00a2\u0006\u0002\u0010/J\u0016\u00107\u001a\u00020\u001e2\u0006\u0010.\u001a\u00020\u0005H\u0096@\u00a2\u0006\u0002\u0010/J\u000e\u00108\u001a\u00020\u0005H\u0096@\u00a2\u0006\u0002\u0010)J\u000e\u00109\u001a\u00020\u0005H\u0096@\u00a2\u0006\u0002\u0010)J\u000e\u0010:\u001a\u00020\u0005H\u0096@\u00a2\u0006\u0002\u0010)J\u000e\u0010;\u001a\u00020\u0005H\u0096@\u00a2\u0006\u0002\u0010)J\u000e\u0010<\u001a\u00020\u0005H\u0096@\u00a2\u0006\u0002\u0010)J\u0016\u0010=\u001a\u00020\u001e2\u0006\u0010.\u001a\u00020!H\u0096@\u00a2\u0006\u0002\u00100R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lcom/pedro/rtmp/utils/socket/TcpTunneledSocket;", "Lcom/pedro/rtmp/utils/socket/RtmpSocket;", "host", "", "port", "", "secured", "", "<init>", "(Ljava/lang/String;IZ)V", "TAG", "headers", "", "timeout", "connectionId", "connected", "index", "Ljava/util/concurrent/atomic/AtomicLong;", "output", "Ljava/io/ByteArrayOutputStream;", "input", "Ljava/io/ByteArrayInputStream;", "sync", "", "storedPackets", "maxStoredPackets", "getInputStream", "Ljava/io/InputStream;", "requiredBytes", "requestWrite", "", "path", "data", "", "requestRead", "configureSocket", "Ljava/net/HttpURLConnection;", "flush", "isPacket", "(ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "connect", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "close", "isConnected", "isReachable", "write", "b", "(ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "([BLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "offset", "size", "([BIILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "writeUInt16", "writeUInt24", "writeUInt32", "writeUInt32LittleEndian", "read", "readUInt16", "readUInt24", "readUInt32", "readUInt32LittleEndian", "readUntil", "rtmp_release"})
@SourceDebugExtension(value={"SMAP\nTcpTunneledSocket.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TcpTunneledSocket.kt\ncom/pedro/rtmp/utils/socket/TcpTunneledSocket\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,232:1\n216#2,2:233\n*S KotlinDebug\n*F\n+ 1 TcpTunneledSocket.kt\ncom/pedro/rtmp/utils/socket/TcpTunneledSocket\n*L\n116#1:233,2\n*E\n"})
public final class TcpTunneledSocket
extends RtmpSocket {
    @NotNull
    private final String host;
    private final int port;
    private final boolean secured;
    @NotNull
    private final String TAG;
    @NotNull
    private final Map<String, String> headers;
    private final int timeout;
    @NotNull
    private String connectionId;
    private boolean connected;
    @NotNull
    private AtomicLong index;
    @NotNull
    private ByteArrayOutputStream output;
    @NotNull
    private ByteArrayInputStream input;
    @NotNull
    private final Object sync;
    private int storedPackets;
    private final int maxStoredPackets;

    public TcpTunneledSocket(@NotNull String host, int port, boolean secured) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        this.host = host;
        this.port = port;
        this.secured = secured;
        this.TAG = "TcpTunneledSocket";
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"Content-Type", (Object)"application/x-fcs"), TuplesKt.to((Object)"User-Agent", (Object)"Shockwave Flash")};
        this.headers = MapsKt.mapOf((Pair[])pairArray);
        this.timeout = 5000;
        this.connectionId = "";
        this.index = new AtomicLong(0L);
        this.output = new ByteArrayOutputStream();
        this.input = new ByteArrayInputStream(new byte[0]);
        this.sync = new Object();
        this.maxStoredPackets = 10;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final InputStream getInputStream(int requiredBytes) {
        if (this.input.available() >= requiredBytes) {
            return this.input;
        }
        Object object = this.sync;
        synchronized (object) {
            boolean bl = false;
            long start = TimeUtils.getCurrentTimeMillis();
            while (this.input.available() <= 1 && this.connected) {
                long i = this.index.addAndGet(1L);
                byte[] bytes = this.requestRead("idle/" + this.connectionId + "/" + i, this.secured);
                this.input = new ByteArrayInputStream(bytes, 1, bytes.length);
                if (TimeUtils.getCurrentTimeMillis() - start < (long)this.timeout) continue;
                throw new SocketTimeoutException("couldn't receive a valid packet");
            }
            Unit unit = Unit.INSTANCE;
        }
        return this.input;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void requestWrite(String path, boolean secured, byte[] data) throws IOException {
        HttpURLConnection socket = this.configureSocket(path, secured);
        try {
            boolean success;
            socket.connect();
            socket.getOutputStream().write(data);
            InputStream inputStream = socket.getInputStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
            byte[] bytes = ByteStreamsKt.readBytes((InputStream)inputStream);
            if (bytes.length > 1) {
                this.input = new ByteArrayInputStream(bytes, 1, bytes.length);
            }
            boolean bl = success = socket.getResponseCode() == 200;
            if (!success) {
                throw new IOException("send packet failed: " + socket.getResponseMessage() + ", broken pipe");
            }
        }
        finally {
            socket.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final byte[] requestRead(String path, boolean secured) throws IOException {
        HttpURLConnection socket = this.configureSocket(path, secured);
        try {
            boolean success;
            socket.connect();
            InputStream inputStream = socket.getInputStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
            byte[] data = ByteStreamsKt.readBytes((InputStream)inputStream);
            boolean bl = success = socket.getResponseCode() == 200;
            if (!success) {
                throw new IOException("receive packet failed: " + socket.getResponseMessage() + ", broken pipe");
            }
            byte[] byArray = data;
            return byArray;
        }
        finally {
            socket.disconnect();
        }
    }

    private final HttpURLConnection configureSocket(String path, boolean secured) {
        HttpURLConnection httpURLConnection;
        String schema = secured ? "https" : "http";
        URL url = new URL(schema + "://" + this.host + ":" + this.port + "/" + path);
        if (secured) {
            URLConnection uRLConnection = url.openConnection();
            Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type javax.net.ssl.HttpsURLConnection");
            httpURLConnection = (HttpsURLConnection)uRLConnection;
        } else {
            URLConnection uRLConnection = url.openConnection();
            Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
            httpURLConnection = (HttpURLConnection)uRLConnection;
        }
        HttpURLConnection socket = httpURLConnection;
        Log.i((String)this.TAG, (String)("open: " + url));
        socket.setRequestMethod("POST");
        Map<String, String> $this$forEach$iv = this.headers;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> element$iv;
            Map.Entry<String, String> entry = element$iv = iterator.next();
            boolean bl = false;
            String key = entry.getKey();
            String value = entry.getValue();
            socket.addRequestProperty(key, value);
        }
        socket.setDoOutput(true);
        socket.setConnectTimeout(this.timeout);
        socket.setReadTimeout(this.timeout);
        return socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Object flush(boolean isPacket, @NotNull Continuation<? super Unit> $completion) {
        Object object = this.sync;
        synchronized (object) {
            block6: {
                block5: {
                    boolean bl = false;
                    if (!isPacket || this.storedPackets >= this.maxStoredPackets) break block5;
                    int n = this.storedPackets;
                    this.storedPackets = n + 1;
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                if (this.connected) break block6;
                Unit unit = Unit.INSTANCE;
                return unit;
            }
            long i = this.index.addAndGet(1L);
            byte[] bytes = this.output.toByteArray();
            this.output.reset();
            String string = "send/" + this.connectionId + "/" + i;
            Intrinsics.checkNotNull((Object)bytes);
            this.requestWrite(string, this.secured, bytes);
            this.storedPackets = 0;
            Unit unit = Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Object connect(@NotNull Continuation<? super Unit> $completion) {
        Object object = this.sync;
        synchronized (object) {
            Object object2;
            boolean bl = false;
            try {
                object2 = new byte[]{0};
                this.requestWrite("fcs/ident2", this.secured, (byte[])object2);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                byte[] openResult = this.requestRead("open/1", this.secured);
                this.connectionId = StringsKt.trimIndent((String)new String(openResult, Charsets.UTF_8));
                byte[] byArray = new byte[]{0};
                this.requestWrite("idle/" + this.connectionId + "/" + this.index.get(), this.secured, byArray);
                this.connected = true;
                object2 = Boxing.boxInt((int)Log.i((String)this.TAG, (String)"Connection success"));
            }
            catch (IOException e) {
                Log.e((String)this.TAG, (String)("Connection failed: " + e.getMessage()));
                this.connected = false;
                object2 = Unit.INSTANCE;
            }
            Object object3 = object2;
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Object close(@NotNull Continuation<? super Unit> $completion) {
        Log.i((String)this.TAG, (String)"closing tunneled socket...");
        this.connected = false;
        Object object = this.sync;
        synchronized (object) {
            boolean bl = false;
            new Thread(() -> TcpTunneledSocket.close$lambda$5$lambda$4(this)).start();
            Unit unit = Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public boolean isReachable() {
        return this.connected;
    }

    @Override
    @Nullable
    public Object write(int b, @NotNull Continuation<? super Unit> $completion) {
        Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, b, null){
            int label;
            final /* synthetic */ TcpTunneledSocket this$0;
            final /* synthetic */ int $b;
            {
                this.this$0 = $receiver;
                this.$b = $b;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        TcpTunneledSocket.access$getOutput$p(this.this$0).write(this.$b);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object write(@NotNull byte[] b, @NotNull Continuation<? super Unit> $completion) {
        Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, b, null){
            int label;
            final /* synthetic */ TcpTunneledSocket this$0;
            final /* synthetic */ byte[] $b;
            {
                this.this$0 = $receiver;
                this.$b = $b;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        TcpTunneledSocket.access$getOutput$p(this.this$0).write(this.$b);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object write(@NotNull byte[] b, int offset, int size, @NotNull Continuation<? super Unit> $completion) {
        this.output.write(b, offset, size);
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object writeUInt16(int b, @NotNull Continuation<? super Unit> $completion) {
        ExtensionsKt.writeUInt16((OutputStream)this.output, (int)b);
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object writeUInt24(int b, @NotNull Continuation<? super Unit> $completion) {
        ExtensionsKt.writeUInt24((OutputStream)this.output, (int)b);
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object writeUInt32(int b, @NotNull Continuation<? super Unit> $completion) {
        ExtensionsKt.writeUInt32((OutputStream)this.output, (int)b);
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object writeUInt32LittleEndian(int b, @NotNull Continuation<? super Unit> $completion) {
        ExtensionsKt.writeUInt32LittleEndian((OutputStream)this.output, (int)b);
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object read(@NotNull Continuation<? super Integer> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Integer>, Object>(this, null){
            int label;
            final /* synthetic */ TcpTunneledSocket this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        return Boxing.boxInt((int)TcpTunneledSocket.access$getInputStream(this.this$0, 1).read());
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Integer> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    @Override
    @Nullable
    public Object readUInt16(@NotNull Continuation<? super Integer> $completion) {
        return Boxing.boxInt((int)ExtensionsKt.readUInt16((InputStream)this.getInputStream(1)));
    }

    @Override
    @Nullable
    public Object readUInt24(@NotNull Continuation<? super Integer> $completion) {
        return Boxing.boxInt((int)ExtensionsKt.readUInt24((InputStream)this.getInputStream(1)));
    }

    @Override
    @Nullable
    public Object readUInt32(@NotNull Continuation<? super Integer> $completion) {
        return Boxing.boxInt((int)ExtensionsKt.readUInt32((InputStream)this.getInputStream(1)));
    }

    @Override
    @Nullable
    public Object readUInt32LittleEndian(@NotNull Continuation<? super Integer> $completion) {
        return Boxing.boxInt((int)ExtensionsKt.readUInt32LittleEndian((InputStream)this.getInputStream(1)));
    }

    @Override
    @Nullable
    public Object readUntil(@NotNull byte[] b, @NotNull Continuation<? super Unit> $completion) {
        ExtensionsKt.readUntil((InputStream)this.getInputStream(b.length), (byte[])b);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void close$lambda$5$lambda$4(TcpTunneledSocket this$0) {
        try {
            byte[] byArray = new byte[]{0};
            this$0.requestWrite("close/" + this$0.connectionId, this$0.secured, byArray);
            Log.i((String)this$0.TAG, (String)"Close success");
        }
        catch (IOException e) {
            Log.e((String)this$0.TAG, (String)("Close request failed: " + e.getMessage()));
        }
        finally {
            this$0.index.set(0L);
            this$0.connectionId = "";
        }
    }

    public static final /* synthetic */ ByteArrayOutputStream access$getOutput$p(TcpTunneledSocket $this) {
        return $this.output;
    }

    public static final /* synthetic */ InputStream access$getInputStream(TcpTunneledSocket $this, int requiredBytes) {
        return $this.getInputStream(requiredBytes);
    }
}

