/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtmp.utils;

import com.pedro.common.ExtensionsKt;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Collection;
import java.util.Random;
import kotlin.Metadata;
import kotlin.io.encoding.Base64;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0012\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0002J.\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004J\u000e\u0010\r\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004J&\u0010\u000e\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004J\u000e\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004J\u000e\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004J\u000e\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004J\u000e\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0004\u00a8\u0006\u0016"}, d2={"Lcom/pedro/rtmp/utils/AuthUtil;", "", "()V", "findDescriptionValue", "", "value", "description", "getAdobeAuthUserResult", "user", "password", "salt", "challenge", "opaque", "getChallenge", "getLlnwAuthUserResult", "nonce", "app", "getNonce", "getOpaque", "getSalt", "stringToMd5Base64", "s", "rtmp_release"})
@SourceDebugExtension(value={"SMAP\nAuthUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AuthUtil.kt\ncom/pedro/rtmp/utils/AuthUtil\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,102:1\n37#2,2:103\n*S KotlinDebug\n*F\n+ 1 AuthUtil.kt\ncom/pedro/rtmp/utils/AuthUtil\n*L\n94#1:103,2\n*E\n"})
public final class AuthUtil {
    @NotNull
    public static final AuthUtil INSTANCE = new AuthUtil();

    private AuthUtil() {
    }

    @NotNull
    public final String getAdobeAuthUserResult(@NotNull String user, @NotNull String password, @NotNull String salt, @NotNull String challenge, @NotNull String opaque) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        Intrinsics.checkNotNullParameter((Object)salt, (String)"salt");
        Intrinsics.checkNotNullParameter((Object)challenge, (String)"challenge");
        Intrinsics.checkNotNullParameter((Object)opaque, (String)"opaque");
        String string = "%08x";
        Object[] objectArray = new Object[]{new Random().nextInt()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        String challenge2 = string2;
        Object response = this.stringToMd5Base64(user + salt + password);
        if (((CharSequence)opaque).length() > 0) {
            response = (String)response + opaque;
        } else if (((CharSequence)challenge).length() > 0) {
            response = (String)response + challenge;
        }
        response = this.stringToMd5Base64((String)response + challenge2);
        String result = "?authmod=adobe&user=" + user + "&challenge=" + challenge2 + "&response=" + (String)response;
        if (((CharSequence)opaque).length() > 0) {
            result = result + "&opaque=" + opaque;
        }
        return result;
    }

    @NotNull
    public final String getLlnwAuthUserResult(@NotNull String user, @NotNull String password, @NotNull String nonce, @NotNull String app) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        Intrinsics.checkNotNullParameter((Object)nonce, (String)"nonce");
        Intrinsics.checkNotNullParameter((Object)app, (String)"app");
        String authMod = "llnw";
        String realm = "live";
        String method = "publish";
        String qop = "auth";
        String string = "%08x";
        Object object = new Object[]{1};
        String string2 = String.format(string, Arrays.copyOf(object, ((Object[])object).length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        String ncHex = string2;
        object = "%08x";
        Object[] objectArray = new Object[]{new Random().nextInt()};
        String string3 = String.format((String)object, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        String cNonce = string3;
        Object path = app;
        int queryPos = StringsKt.indexOf$default((CharSequence)((CharSequence)path), (String)"?", (int)0, (boolean)false, (int)6, null);
        if (queryPos >= 0) {
            String string4 = ((String)path).substring(0, queryPos);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
            path = string4;
        }
        if (!StringsKt.contains$default((CharSequence)((CharSequence)path), (CharSequence)"/", (boolean)false, (int)2, null)) {
            path = (String)path + "/_definst_";
        }
        String hash1 = ExtensionsKt.getMd5Hash((String)(user + ":" + realm + ":" + password));
        String hash2 = ExtensionsKt.getMd5Hash((String)(method + ":/" + (String)path));
        String hash3 = ExtensionsKt.getMd5Hash((String)(hash1 + ":" + nonce + ":" + ncHex + ":" + cNonce + ":" + qop + ":" + hash2));
        return "?authmod=" + authMod + "&user=" + user + "&nonce=" + nonce + "&cnonce=" + cNonce + "&nc=" + ncHex + "&response=" + hash3;
    }

    @NotNull
    public final String getSalt(@NotNull String description) {
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        return this.findDescriptionValue("salt=", description);
    }

    @NotNull
    public final String getChallenge(@NotNull String description) {
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        return this.findDescriptionValue("challenge=", description);
    }

    @NotNull
    public final String getOpaque(@NotNull String description) {
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        return this.findDescriptionValue("opaque=", description);
    }

    @NotNull
    public final String stringToMd5Base64(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            String string = s;
            byte[] byArray = string.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            md.update(byArray);
            byte[] md5hash = md.digest();
            Base64 base64 = (Base64)Base64.Default;
            Intrinsics.checkNotNullExpressionValue((Object)md5hash, (String)"md5hash");
            return Base64.encode$default((Base64)base64, (byte[])md5hash, (int)0, (int)0, (int)6, null);
        }
        catch (Exception exception) {
            return "";
        }
    }

    @NotNull
    public final String getNonce(@NotNull String description) {
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        return this.findDescriptionValue("nonce=", description);
    }

    private final String findDescriptionValue(String value, String description) {
        String[] stringArray = new String[]{"&"};
        Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)description, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        for (String s : thisCollection$iv.toArray(new String[0])) {
            if (!StringsKt.contains$default((CharSequence)s, (CharSequence)value, (boolean)false, (int)2, null)) continue;
            String string = s.substring(value.length());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            return string;
        }
        return "";
    }
}

