/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.extrasources;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.net.Uri;
import android.view.Surface;
import androidx.annotation.OptIn;
import androidx.media3.common.MediaItem;
import androidx.media3.common.PlaybackParameters;
import androidx.media3.common.Player;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.exoplayer.ExoPlayer;
import androidx.media3.exoplayer.RenderersFactory;
import com.pedro.common.frame.MediaFrame;
import com.pedro.encoder.input.sources.OrientationConfig;
import com.pedro.encoder.input.sources.OrientationForced;
import com.pedro.encoder.input.sources.video.VideoSource;
import com.pedro.extrasources.TracksRenderersFactory;
import com.pedro.extrasources.extractor.Media3Extractor;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001BP\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012#\b\u0002\u0010\n\u001a\u001d\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u00020\u000f0\u000b\u00a2\u0006\u0004\b\u0010\u0010\u0011J(\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u0018H\u0014J\u0010\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u000fH\u0016J\b\u0010 \u001a\u00020\u000fH\u0016J\b\u0010!\u001a\u00020\tH\u0016J\b\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u0004\u0018\u00010\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\n\u001a\u001d\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u00020\u000f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/pedro/extrasources/Media3VideoSource;", "Lcom/pedro/encoder/input/sources/video/VideoSource;", "context", "Landroid/content/Context;", "path", "Landroid/net/Uri;", "speed", "", "loopMode", "", "onFinish", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "isLoop", "", "<init>", "(Landroid/content/Context;Landroid/net/Uri;FZLkotlin/jvm/functions/Function1;)V", "player", "Landroidx/media3/exoplayer/ExoPlayer;", "surface", "Landroid/view/Surface;", "create", "width", "", "height", "fps", "rotation", "start", "surfaceTexture", "Landroid/graphics/SurfaceTexture;", "stop", "release", "isRunning", "getOrientationConfig", "Lcom/pedro/encoder/input/sources/OrientationConfig;", "getPlayer", "extra-sources_release"})
@OptIn(markerClass={UnstableApi.class})
public final class Media3VideoSource
extends VideoSource {
    @NotNull
    private final Context context;
    @NotNull
    private final Uri path;
    private final float speed;
    private final boolean loopMode;
    @NotNull
    private final Function1<Boolean, Unit> onFinish;
    @Nullable
    private ExoPlayer player;
    @Nullable
    private Surface surface;

    public Media3VideoSource(@NotNull Context context, @NotNull Uri path, float speed, boolean loopMode, @NotNull Function1<? super Boolean, Unit> onFinish) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(onFinish, (String)"onFinish");
        this.context = context;
        this.path = path;
        this.speed = speed;
        this.loopMode = loopMode;
        this.onFinish = onFinish;
    }

    public /* synthetic */ Media3VideoSource(Context context, Uri uri, float f, boolean bl, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            f = 1.0f;
        }
        if ((n & 8) != 0) {
            bl = true;
        }
        if ((n & 0x10) != 0) {
            function1 = Media3VideoSource::_init_$lambda$0;
        }
        this(context, uri, f, bl, (Function1<? super Boolean, Unit>)function1);
    }

    /*
     * WARNING - void declaration
     */
    protected boolean create(int width, int height, int fps, int rotation) {
        block3: {
            void exoPlayer;
            ExoPlayer exoPlayer2;
            Media3Extractor mediaExtractor = new Media3Extractor(this.context);
            try {
                mediaExtractor.initialize(this.context, this.path);
                mediaExtractor.selectTrack(MediaFrame.Type.VIDEO);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Video file track not found");
            }
            mediaExtractor.release();
            ExoPlayer exception = exoPlayer2 = new ExoPlayer.Builder(this.context, (RenderersFactory)new TracksRenderersFactory(this.context, MediaFrame.Type.VIDEO, null, 4, null)).build();
            Media3VideoSource media3VideoSource = this;
            boolean bl = false;
            exoPlayer.setVideoSurface(this.surface);
            MediaItem mediaItem = MediaItem.fromUri((Uri)this.path);
            Intrinsics.checkNotNullExpressionValue((Object)mediaItem, (String)"fromUri(...)");
            MediaItem mediaItem2 = mediaItem;
            exoPlayer.setMediaItem(mediaItem2);
            exoPlayer.setPlaybackParameters(new PlaybackParameters(this.speed));
            exoPlayer.prepare();
            if (this.loopMode) {
                exoPlayer.setRepeatMode(2);
            }
            media3VideoSource.player = exoPlayer2;
            ExoPlayer exoPlayer3 = this.player;
            if (exoPlayer3 == null) break block3;
            exoPlayer3.addListener(new Player.Listener(this){
                final /* synthetic */ Media3VideoSource this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onPlaybackStateChanged(int state) {
                    if (state == 4) {
                        Media3VideoSource.access$getOnFinish$p(this.this$0).invoke((Object)Media3VideoSource.access$getLoopMode$p(this.this$0));
                    }
                }
            });
        }
        return true;
    }

    public void start(@NotNull SurfaceTexture surfaceTexture) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)surfaceTexture, (String)"surfaceTexture");
            this.surface = new Surface(surfaceTexture);
            ExoPlayer exoPlayer = this.player;
            if (exoPlayer == null) break block0;
            exoPlayer.play();
        }
    }

    public void stop() {
        ExoPlayer exoPlayer = this.player;
        if (exoPlayer != null) {
            exoPlayer.release();
        }
        this.player = null;
        Surface surface = this.surface;
        if (surface != null) {
            surface.release();
        }
        this.surface = null;
    }

    public void release() {
    }

    public boolean isRunning() {
        ExoPlayer exoPlayer = this.player;
        return exoPlayer != null ? exoPlayer.isPlaying() : false;
    }

    @NotNull
    public OrientationConfig getOrientationConfig() {
        return new OrientationConfig(null, null, OrientationForced.LANDSCAPE, 3, null);
    }

    @Nullable
    public final ExoPlayer getPlayer() {
        return this.player;
    }

    private static final Unit _init_$lambda$0(boolean it) {
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Function1 access$getOnFinish$p(Media3VideoSource $this) {
        return $this.onFinish;
    }

    public static final /* synthetic */ boolean access$getLoopMode$p(Media3VideoSource $this) {
        return $this.loopMode;
    }
}

