/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.input.gl;

import android.graphics.PointF;
import com.pedro.encoder.utils.gl.TranslateTo;

public class Sprite {
    private final float[] squareVertexDataSprite = new float[]{0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f};
    private PointF scale;
    private PointF position;
    private int rotation;

    public Sprite() {
        this.reset();
    }

    public void translate(float deltaX, float deltaY) {
        this.position.x = deltaX;
        this.position.y = deltaY;
    }

    public void translate(TranslateTo translation) {
        switch (translation) {
            case CENTER: {
                this.position.x = 50.0f - this.scale.x / 2.0f;
                this.position.y = 50.0f - this.scale.x / 2.0f;
                break;
            }
            case BOTTOM: {
                this.position.x = 50.0f - this.scale.x / 2.0f;
                this.position.y = 100.0f - this.scale.y;
                break;
            }
            case TOP: {
                this.position.x = 50.0f - this.scale.x / 2.0f;
                this.position.y = 0.0f;
                break;
            }
            case LEFT: {
                this.position.x = 0.0f;
                this.position.y = 50.0f - this.scale.y / 2.0f;
                break;
            }
            case RIGHT: {
                this.position.x = 100.0f - this.scale.x;
                this.position.y = 50.0f - this.scale.y / 2.0f;
                break;
            }
            case TOP_LEFT: {
                this.position.x = 0.0f;
                this.position.y = 0.0f;
                break;
            }
            case TOP_RIGHT: {
                this.position.x = 100.0f - this.scale.x;
                this.position.y = 0.0f;
                break;
            }
            case BOTTOM_LEFT: {
                this.position.x = 0.0f;
                this.position.y = 100.0f - this.scale.y;
                break;
            }
            case BOTTOM_RIGHT: {
                this.position.x = 100.0f - this.scale.x;
                this.position.y = 100.0f - this.scale.y;
                break;
            }
        }
    }

    public void scale(float deltaX, float deltaY) {
        this.position.x /= deltaX / this.scale.x;
        this.position.y /= deltaY / this.scale.y;
        this.scale = new PointF(deltaX, deltaY);
    }

    public void setRotation(int angle) {
        this.rotation = angle;
    }

    public PointF getScale() {
        return this.scale;
    }

    public PointF getTranslation() {
        return this.position;
    }

    public int getRotation() {
        return this.rotation;
    }

    public void reset() {
        this.scale = new PointF(100.0f, 100.0f);
        this.position = new PointF(0.0f, 0.0f);
        this.rotation = 0;
    }

    public float[] getTransformedVertices() {
        PointF bottomRight = new PointF(this.squareVertexDataSprite[0], this.squareVertexDataSprite[1]);
        PointF bottomLeft = new PointF(this.squareVertexDataSprite[2], this.squareVertexDataSprite[3]);
        PointF topRight = new PointF(this.squareVertexDataSprite[4], this.squareVertexDataSprite[5]);
        PointF topLeft = new PointF(this.squareVertexDataSprite[6], this.squareVertexDataSprite[7]);
        float scaleX = this.scale.x / 100.0f;
        float scaleY = this.scale.y / 100.0f;
        bottomRight.x /= scaleX;
        bottomRight.y /= scaleY;
        bottomLeft.x /= scaleX;
        bottomLeft.y /= scaleY;
        topRight.x /= scaleX;
        topRight.y /= scaleY;
        topLeft.x /= scaleX;
        topLeft.y /= scaleY;
        float positionX = -this.position.x / this.scale.x;
        float positionY = -this.position.y / this.scale.y;
        bottomRight.x += positionX;
        bottomRight.y += positionY;
        bottomLeft.x += positionX;
        bottomLeft.y += positionY;
        topRight.x += positionX;
        topRight.y += positionY;
        topLeft.x += positionX;
        topLeft.y += positionY;
        PointF center = new PointF(0.5f, 0.5f);
        bottomLeft = this.rotatePoint(bottomLeft, center, this.rotation);
        bottomRight = this.rotatePoint(bottomRight, center, this.rotation);
        topLeft = this.rotatePoint(topLeft, center, this.rotation);
        topRight = this.rotatePoint(topRight, center, this.rotation);
        return new float[]{bottomRight.x, bottomRight.y, bottomLeft.x, bottomLeft.y, topRight.x, topRight.y, topLeft.x, topLeft.y};
    }

    private PointF rotatePoint(PointF point, PointF center, int rotation) {
        float angle = rotation % 360;
        if (angle > 180.0f) {
            angle -= 360.0f;
        }
        double A = (double)angle * Math.PI / 180.0;
        float cosA = (float)Math.cos(A);
        float sinA = (float)Math.sin(A);
        float x = point.x - center.x;
        float y = point.y - center.y;
        float rotationX = x * cosA - y * sinA;
        float rotationY = y * cosA + x * sinA;
        return new PointF(center.x + rotationX, center.y + rotationY);
    }
}

