/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.input.decoder;

import com.pedro.common.frame.MediaFrame;
import com.pedro.encoder.Frame;
import com.pedro.encoder.input.audio.GetMicrophoneData;
import com.pedro.encoder.input.decoder.AudioDecoderInterface;
import com.pedro.encoder.input.decoder.AudioInfo;
import com.pedro.encoder.input.decoder.BaseDecoder;
import com.pedro.encoder.input.decoder.DecoderInterface;
import com.pedro.encoder.input.decoder.Extractor;
import com.pedro.encoder.utils.PCMUtil;
import java.nio.ByteBuffer;

public class AudioDecoder
extends BaseDecoder {
    private final AudioDecoderInterface audioDecoderInterface;
    private GetMicrophoneData getMicrophoneData;
    private int sampleRate;
    private boolean isStereo;
    private int channels = 1;
    private int size = 2048;
    private byte[] pcmBuffer = new byte[this.size];
    private byte[] pcmBufferMuted = new byte[11];
    private boolean muted = false;

    public AudioDecoder(GetMicrophoneData getMicrophoneData, AudioDecoderInterface audioDecoderInterface, DecoderInterface decoderInterface2) {
        super(decoderInterface2);
        this.TAG = "AudioDecoder";
        this.getMicrophoneData = getMicrophoneData;
        this.audioDecoderInterface = audioDecoderInterface;
    }

    @Override
    protected boolean extract(Extractor extractor) {
        try {
            this.size = 2048;
            this.mime = extractor.selectTrack(MediaFrame.Type.AUDIO);
            AudioInfo audioInfo = extractor.getAudioInfo();
            this.mediaFormat = extractor.getFormat();
            this.channels = audioInfo.getChannels();
            this.isStereo = this.channels >= 2;
            this.sampleRate = audioInfo.getSampleRate();
            this.duration = audioInfo.getSampleRate();
            this.fixBuffer();
            return true;
        }
        catch (Exception e) {
            this.mime = "";
            return false;
        }
    }

    private void fixBuffer() {
        if (this.channels >= 2) {
            this.size *= this.channels;
        }
        this.pcmBuffer = new byte[this.size];
    }

    public boolean prepareAudio() {
        return this.prepare(null);
    }

    @Override
    protected boolean decodeOutput(ByteBuffer outputBuffer, long timeStamp) {
        GetMicrophoneData getMicrophoneData = this.getMicrophoneData;
        if (getMicrophoneData == null) {
            return false;
        }
        if (this.muted) {
            outputBuffer.get(this.pcmBufferMuted, 0, Math.min(outputBuffer.remaining(), this.pcmBufferMuted.length));
            getMicrophoneData.inputPCMData(new Frame(this.pcmBufferMuted, 0, this.pcmBufferMuted.length, timeStamp));
        } else {
            if (this.pcmBuffer.length < outputBuffer.remaining()) {
                this.pcmBuffer = new byte[outputBuffer.remaining()];
            }
            outputBuffer.get(this.pcmBuffer, 0, Math.min(outputBuffer.remaining(), this.pcmBuffer.length));
            if (this.channels > 2) {
                byte[] bufferStereo = PCMUtil.pcmToStereo(this.pcmBuffer, this.channels);
                getMicrophoneData.inputPCMData(new Frame(bufferStereo, 0, bufferStereo.length, timeStamp));
            } else {
                getMicrophoneData.inputPCMData(new Frame(this.pcmBuffer, 0, this.pcmBuffer.length, timeStamp));
            }
        }
        return false;
    }

    @Override
    protected void finished() {
        this.audioDecoderInterface.onAudioDecoderFinished();
    }

    public void mute() {
        this.muted = true;
    }

    public void unMute() {
        this.muted = false;
    }

    public boolean isMuted() {
        return this.muted;
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public boolean isStereo() {
        return this.isStereo;
    }

    public int getSize() {
        return this.size;
    }

    public void setGetMicrophoneData(GetMicrophoneData getMicrophoneData) {
        if (this.running) {
            return;
        }
        this.getMicrophoneData = getMicrophoneData;
    }
}

