/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.input.gl;

import android.graphics.PointF;
import android.view.View;
import com.pedro.encoder.utils.gl.TranslateTo;

public class AndroidViewSprite {
    private PointF scale;
    private PointF position;
    private PointF rotationAxis;
    private int rotation;
    private View view;

    public AndroidViewSprite() {
        this.reset();
    }

    public void setView(View view) {
        this.view = view;
        this.rotationAxis = new PointF((float)view.getMeasuredWidth() / 2.0f, (float)view.getMeasuredHeight() / 2.0f);
    }

    public void translate(float deltaX, float deltaY) {
        this.position.x = deltaX;
        this.position.y = deltaY;
    }

    public void translate(TranslateTo translation) {
        switch (translation) {
            case CENTER: {
                this.position.x = 50.0f - this.scale.x / 2.0f;
                this.position.y = 50.0f - this.scale.x / 2.0f;
                break;
            }
            case BOTTOM: {
                this.position.x = 50.0f - this.scale.x / 2.0f;
                this.position.y = 100.0f - this.scale.y;
                break;
            }
            case TOP: {
                this.position.x = 50.0f - this.scale.x / 2.0f;
                this.position.y = 0.0f;
                break;
            }
            case LEFT: {
                this.position.x = 0.0f;
                this.position.y = 50.0f - this.scale.y / 2.0f;
                break;
            }
            case RIGHT: {
                this.position.x = 100.0f - this.scale.x;
                this.position.y = 50.0f - this.scale.y / 2.0f;
                break;
            }
            case TOP_LEFT: {
                this.position.x = 0.0f;
                this.position.y = 0.0f;
                break;
            }
            case TOP_RIGHT: {
                this.position.x = 100.0f - this.scale.x;
                this.position.y = 0.0f;
                break;
            }
            case BOTTOM_LEFT: {
                this.position.x = 0.0f;
                this.position.y = 100.0f - this.scale.y;
                break;
            }
            case BOTTOM_RIGHT: {
                this.position.x = 100.0f - this.scale.x;
                this.position.y = 100.0f - this.scale.y;
                break;
            }
        }
    }

    public void scale(float deltaX, float deltaY) {
        this.position.x /= deltaX / this.scale.x;
        this.position.y /= deltaY / this.scale.y;
        this.scale = new PointF(deltaX, deltaY);
    }

    public PointF getScale() {
        return this.scale;
    }

    public PointF getTranslation() {
        return this.position;
    }

    public int getRotation() {
        return this.rotation;
    }

    public PointF getRotationAxis() {
        return this.rotationAxis;
    }

    public void setRotation(int rotation) {
        this.rotation = rotation < 0 ? 0 : (rotation > 360 ? 360 : rotation);
    }

    public void reset() {
        this.scale = new PointF(0.0f, 0.0f);
        this.position = new PointF(0.0f, 0.0f);
    }

    public PointF getCanvasPosition(float previewX, float previewY) {
        return new PointF(previewX * this.position.x / 100.0f, previewY * this.position.y / 100.0f);
    }

    public PointF getCanvasScale(float previewX, float previewY) {
        float scaleFactorX = 100.0f * (float)this.view.getWidth() / previewX;
        float scaleFactorY = 100.0f * (float)this.view.getHeight() / previewY;
        return new PointF(this.scale.x / scaleFactorX, this.scale.y / scaleFactorY);
    }

    public void calculateDefaultScale(float previewX, float previewY) {
        if (this.scale.x == 0.0f && this.scale.y == 0.0f) {
            this.scale.x = 100.0f * (float)this.view.getWidth() / previewX;
            this.scale.y = 100.0f * (float)this.view.getHeight() / previewY;
        }
    }
}

