/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.utils.gl;

import android.graphics.Point;
import android.graphics.PointF;
import android.opengl.GLES20;
import android.opengl.Matrix;
import android.util.Pair;
import com.pedro.encoder.utils.gl.AspectRatioMode;

public class SizeCalculator {
    public static void calculateViewPort(AspectRatioMode mode, int previewWidth, int previewHeight, int streamWidth, int streamHeight) {
        Pair<Point, Point> pair = SizeCalculator.getViewport(mode, previewWidth, previewHeight, streamWidth, streamHeight);
        GLES20.glViewport((int)((Point)pair.first).x, (int)((Point)pair.first).y, (int)((Point)pair.second).x, (int)((Point)pair.second).y);
    }

    public static void calculateViewPortEncoder(int streamWidth, int streamHeight, boolean isPortrait) {
        Pair pair;
        float factor = (float)streamWidth / (float)streamHeight;
        if (factor >= 1.0f) {
            if (isPortrait) {
                int width = (int)((float)streamHeight / factor);
                int oX = (streamWidth - width) / 2;
                pair = new Pair((Object)new Point(oX, 0), (Object)new Point(width, streamHeight));
            } else {
                pair = new Pair((Object)new Point(0, 0), (Object)new Point(streamWidth, streamHeight));
            }
        } else if (isPortrait) {
            pair = new Pair((Object)new Point(0, 0), (Object)new Point(streamWidth, streamHeight));
        } else {
            int height = (int)((float)streamWidth * factor);
            int oY = (streamHeight - height) / 2;
            pair = new Pair((Object)new Point(0, oY), (Object)new Point(streamWidth, height));
        }
        GLES20.glViewport((int)((Point)pair.first).x, (int)((Point)pair.first).y, (int)((Point)pair.second).x, (int)((Point)pair.second).y);
    }

    public static Pair<Point, Point> getViewport(AspectRatioMode mode, int previewWidth, int previewHeight, int streamWidth, int streamHeight) {
        if (mode != AspectRatioMode.NONE) {
            float streamAspectRatio = (float)streamWidth / (float)streamHeight;
            float previewAspectRatio = (float)previewWidth / (float)previewHeight;
            int xo = 0;
            int yo = 0;
            int xf = previewWidth;
            int yf = previewHeight;
            if (previewAspectRatio > 1.0f && streamAspectRatio > previewAspectRatio || streamAspectRatio < 1.0f && previewAspectRatio < 1.0f && streamAspectRatio > previewAspectRatio || streamAspectRatio > 1.0f && previewAspectRatio < 1.0f) {
                if (mode == AspectRatioMode.Adjust) {
                    yf = streamHeight * previewWidth / streamWidth;
                    yo = (yf - previewHeight) / -2;
                } else {
                    xf = streamWidth * previewHeight / streamHeight;
                    xo = (xf - previewWidth) / -2;
                }
            } else if (streamAspectRatio > 1.0f && previewAspectRatio > 1.0f && streamAspectRatio < previewAspectRatio || previewAspectRatio < 1.0f && streamAspectRatio < previewAspectRatio || streamAspectRatio < 1.0f && previewAspectRatio > 1.0f) {
                if (mode == AspectRatioMode.Adjust) {
                    xf = streamWidth * previewHeight / streamHeight;
                    xo = (xf - previewWidth) / -2;
                } else {
                    yf = streamHeight * previewWidth / streamWidth;
                    yo = (yf - previewHeight) / -2;
                }
            }
            return new Pair((Object)new Point(xo, yo), (Object)new Point(xf, yf));
        }
        return new Pair((Object)new Point(0, 0), (Object)new Point(previewWidth, previewHeight));
    }

    public static void processMatrix(int rotation, boolean flipStreamHorizontal, boolean flipStreamVertical, float[] MVPMatrix) {
        PointF scale = new PointF(1.0f, 1.0f);
        float xFlip = flipStreamHorizontal ? -1.0f : 1.0f;
        float yFlip = flipStreamVertical ? -1.0f : 1.0f;
        scale = new PointF(scale.x * xFlip, scale.y * yFlip);
        SizeCalculator.updateMatrix(rotation, scale, MVPMatrix);
    }

    private static void updateMatrix(int rotation, PointF scale, float[] MVPMatrix) {
        Matrix.setIdentityM((float[])MVPMatrix, (int)0);
        Matrix.scaleM((float[])MVPMatrix, (int)0, (float)scale.x, (float)scale.y, (float)1.0f);
        Matrix.rotateM((float[])MVPMatrix, (int)0, (float)rotation, (float)0.0f, (float)0.0f, (float)-1.0f);
    }

    private static PointF getScale(int rotation, int width, int height, boolean isPortrait, boolean isPreview) {
        float scaleX = 1.0f;
        float scaleY = 1.0f;
        if (!isPreview) {
            if (isPortrait && rotation != 0 && rotation != 180) {
                float adjustedWidth = (float)width * ((float)width / (float)height);
                scaleY = adjustedWidth / (float)height;
            } else if (!isPortrait && rotation != 90 && rotation != 270) {
                float adjustedWidth = (float)height * ((float)height / (float)width);
                scaleX = adjustedWidth / (float)width;
            }
        }
        return new PointF(scaleX, scaleY);
    }
}

