/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.utils.yuv;

public class NV21Utils {
    private static byte[] preAllocatedBufferRotate;
    private static byte[] preAllocatedBufferColor;

    public static void preAllocateBuffers(int length) {
        preAllocatedBufferRotate = new byte[length];
        preAllocatedBufferColor = new byte[length];
    }

    public static int[] toARGB(byte[] yuv, int width, int height) {
        int[] argb = new int[width * height];
        int frameSize = width * height;
        boolean ii = false;
        boolean ij = false;
        boolean di = true;
        boolean dj = true;
        int a = 0;
        int i = 0;
        int ci = 0;
        while (i < height) {
            int j = 0;
            int cj = 0;
            while (j < width) {
                int y = 0xFF & yuv[ci * width + cj];
                int v = 0xFF & yuv[frameSize + (ci >> 1) * width + (cj & 0xFFFFFFFE) + 0];
                int u = 0xFF & yuv[frameSize + (ci >> 1) * width + (cj & 0xFFFFFFFE) + 1];
                y = y < 16 ? 16 : y;
                int r = (int)(1.164f * (float)(y - 16) + 1.596f * (float)(v - 128));
                int g = (int)(1.164f * (float)(y - 16) - 0.813f * (float)(v - 128) - 0.391f * (float)(u - 128));
                int b = (int)(1.164f * (float)(y - 16) + 2.018f * (float)(u - 128));
                int n = r < 0 ? 0 : (r = r > 255 ? 255 : r);
                int n2 = g < 0 ? 0 : (g = g > 255 ? 255 : g);
                b = b < 0 ? 0 : (b > 255 ? 255 : b);
                argb[a++] = 0xFF000000 | r << 16 | g << 8 | b;
                ++j;
                ++cj;
            }
            ++i;
            ++ci;
        }
        return argb;
    }

    public static byte[] toYV12(byte[] input, int width, int height) {
        int frameSize = width * height;
        int qFrameSize = frameSize / 4;
        System.arraycopy(input, 0, preAllocatedBufferColor, 0, frameSize);
        for (int i = 0; i < qFrameSize; ++i) {
            NV21Utils.preAllocatedBufferColor[frameSize + i + qFrameSize] = input[frameSize + i * 2 + 1];
            NV21Utils.preAllocatedBufferColor[frameSize + i] = input[frameSize + i * 2];
        }
        return preAllocatedBufferColor;
    }

    public static byte[] toNV12(byte[] input, int width, int height) {
        int frameSize = width * height;
        int qFrameSize = frameSize / 4;
        System.arraycopy(input, 0, preAllocatedBufferColor, 0, frameSize);
        for (int i = 0; i < qFrameSize; ++i) {
            NV21Utils.preAllocatedBufferColor[frameSize + i * 2] = input[frameSize + i * 2 + 1];
            NV21Utils.preAllocatedBufferColor[frameSize + i * 2 + 1] = input[frameSize + i * 2];
        }
        return preAllocatedBufferColor;
    }

    public static byte[] toI420(byte[] input, int width, int height) {
        int frameSize = width * height;
        int qFrameSize = frameSize / 4;
        System.arraycopy(input, 0, preAllocatedBufferColor, 0, frameSize);
        for (int i = 0; i < qFrameSize; ++i) {
            NV21Utils.preAllocatedBufferColor[frameSize + i] = input[frameSize + i * 2 + 1];
            NV21Utils.preAllocatedBufferColor[frameSize + i + qFrameSize] = input[frameSize + i * 2];
        }
        return preAllocatedBufferColor;
    }

    public static byte[] rotate90(byte[] data, int imageWidth, int imageHeight) {
        int i = 0;
        for (int x = 0; x < imageWidth; ++x) {
            for (int y = imageHeight - 1; y >= 0; --y) {
                NV21Utils.preAllocatedBufferRotate[i++] = data[y * imageWidth + x];
            }
        }
        int size = imageWidth * imageHeight;
        i = size * 3 / 2 - 1;
        for (int x = imageWidth - 1; x > 0; x -= 2) {
            for (int y = 0; y < imageHeight / 2; ++y) {
                NV21Utils.preAllocatedBufferRotate[i--] = data[size + y * imageWidth + x];
                NV21Utils.preAllocatedBufferRotate[i--] = data[size + y * imageWidth + (x - 1)];
            }
        }
        return preAllocatedBufferRotate;
    }

    public static byte[] rotate180(byte[] data, int imageWidth, int imageHeight) {
        int i;
        int count = 0;
        for (i = imageWidth * imageHeight - 1; i >= 0; --i) {
            NV21Utils.preAllocatedBufferRotate[count] = data[i];
            ++count;
        }
        for (i = imageWidth * imageHeight * 3 / 2 - 1; i >= imageWidth * imageHeight; i -= 2) {
            NV21Utils.preAllocatedBufferRotate[count++] = data[i - 1];
            NV21Utils.preAllocatedBufferRotate[count++] = data[i];
        }
        return preAllocatedBufferRotate;
    }

    public static byte[] rotate270(byte[] data, int imageWidth, int imageHeight) {
        int i = 0;
        for (int x = imageWidth - 1; x >= 0; --x) {
            for (int y = 0; y < imageHeight; ++y) {
                NV21Utils.preAllocatedBufferRotate[i++] = data[y * imageWidth + x];
            }
        }
        i = imageWidth * imageHeight;
        int uvHeight = imageHeight / 2;
        for (int x = imageWidth - 1; x >= 0; x -= 2) {
            for (int y = imageHeight; y < uvHeight + imageHeight; ++y) {
                NV21Utils.preAllocatedBufferRotate[i++] = data[y * imageWidth + x - 1];
                NV21Utils.preAllocatedBufferRotate[i++] = data[y * imageWidth + x];
            }
        }
        return preAllocatedBufferRotate;
    }

    public static byte[] rotatePixels(byte[] input, int width, int height, int rotation) {
        byte[] output = new byte[input.length];
        boolean swap = rotation == 90 || rotation == 270;
        boolean yflip = rotation == 90 || rotation == 180;
        boolean xflip = rotation == 270 || rotation == 180;
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int xo = x;
                int yo = y;
                int w = width;
                int h = height;
                int xi = xo;
                int yi = yo;
                if (swap) {
                    xi = w * yo / h;
                    yi = h * xo / w;
                }
                if (yflip) {
                    yi = h - yi - 1;
                }
                if (xflip) {
                    xi = w - xi - 1;
                }
                output[w * yo + xo] = input[w * yi + xi];
                int fs = w * h;
                int qs = fs >> 2;
                h >>= 1;
                int ui = fs + ((w >>= 1) * (yi >>= 1) + (xi >>= 1)) * 2;
                int uo = fs + (w * (yo >>= 1) + (xo >>= 1)) * 2;
                int vi = ui + 1;
                int vo = uo + 1;
                output[uo] = input[ui];
                output[vo] = input[vi];
            }
        }
        return output;
    }

    public static byte[] mirror(byte[] input, int width, int height) {
        byte[] output = new byte[input.length];
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int xo = x;
                int yo = y;
                int w = width;
                int h = height;
                int xi = xo;
                int yi = yo;
                yi = h - yi - 1;
                output[w * yo + xo] = input[w * yi + xi];
                int fs = w * h;
                int qs = fs >> 2;
                h >>= 1;
                int ui = fs + ((w >>= 1) * (yi >>= 1) + (xi >>= 1)) * 2;
                int uo = fs + (w * (yo >>= 1) + (xo >>= 1)) * 2;
                int vi = ui + 1;
                int vo = uo + 1;
                output[uo] = input[ui];
                output[vo] = input[vi];
            }
        }
        return output;
    }
}

