/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.utils.gl;

import android.graphics.Bitmap;
import android.util.Log;
import com.pedro.encoder.utils.gl.StreamObjectBase;
import com.pedro.encoder.utils.gl.gif.GifDecoder;
import java.io.IOException;
import java.io.InputStream;

public class GifStreamObject
extends StreamObjectBase {
    private static final String TAG = "GifStreamObject";
    private int numFrames;
    private Bitmap[] gifBitmaps;
    private int[] gifDelayFrames;
    private long startDelayFrame;
    private int currentGifFrame;

    @Override
    public int getWidth() {
        return this.gifBitmaps != null ? this.gifBitmaps[0].getWidth() : 0;
    }

    @Override
    public int getHeight() {
        return this.gifBitmaps != null ? this.gifBitmaps[0].getHeight() : 0;
    }

    public void load(InputStream inputStreamGif) throws IOException {
        GifDecoder gifDecoder = new GifDecoder();
        if (gifDecoder.read(inputStreamGif, inputStreamGif.available()) == 0) {
            Log.i((String)TAG, (String)"read gif ok");
            this.numFrames = gifDecoder.getFrameCount();
            this.gifDelayFrames = new int[this.numFrames];
            this.gifBitmaps = new Bitmap[this.numFrames];
            for (int i = 0; i < this.numFrames; ++i) {
                gifDecoder.advance();
                this.gifBitmaps[i] = gifDecoder.getNextFrame();
                this.gifDelayFrames[i] = gifDecoder.getNextDelay();
            }
        } else {
            throw new IOException("Read gif error");
        }
        Log.i((String)TAG, (String)"finish load gif frames");
    }

    @Override
    public void recycle() {
        if (this.gifBitmaps != null) {
            for (int i = 0; i < this.numFrames; ++i) {
                if (this.gifBitmaps[i] == null || this.gifBitmaps[i].isRecycled()) continue;
                this.gifBitmaps[i].recycle();
            }
        }
    }

    @Override
    public int getNumFrames() {
        return this.numFrames;
    }

    @Override
    public Bitmap[] getBitmaps() {
        return this.gifBitmaps;
    }

    public int[] getGifDelayFrames() {
        return this.gifDelayFrames;
    }

    public int updateFrame(int size) {
        return size <= 1 ? 0 : this.updateFrame();
    }

    @Override
    public int updateFrame() {
        if (this.startDelayFrame == 0L) {
            this.startDelayFrame = System.currentTimeMillis();
        }
        if (System.currentTimeMillis() - this.startDelayFrame >= (long)this.gifDelayFrames[this.currentGifFrame]) {
            this.currentGifFrame = this.currentGifFrame >= this.numFrames - 1 ? 0 : ++this.currentGifFrame;
            this.startDelayFrame = 0L;
        }
        return this.currentGifFrame;
    }
}

