/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.audio;

import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaFormat;
import android.util.Log;
import androidx.annotation.NonNull;
import com.pedro.encoder.BaseEncoder;
import com.pedro.encoder.Frame;
import com.pedro.encoder.GetFrame;
import com.pedro.encoder.audio.GetAacData;
import com.pedro.encoder.input.audio.GetMicrophoneData;
import com.pedro.encoder.utils.CodecUtil;
import java.nio.ByteBuffer;
import java.util.List;

public class AudioEncoder
extends BaseEncoder
implements GetMicrophoneData {
    private GetAacData getAacData;
    private int bitRate = 65536;
    private int sampleRate = 32000;
    private int maxInputSize = 0;
    private boolean isStereo = true;
    private GetFrame getFrame;

    public AudioEncoder(GetAacData getAacData) {
        this.getAacData = getAacData;
        this.TAG = "AudioEncoder";
    }

    public boolean prepareAudioEncoder(int bitRate, int sampleRate, boolean isStereo, int maxInputSize) {
        this.bitRate = bitRate;
        this.sampleRate = sampleRate;
        this.maxInputSize = maxInputSize;
        this.isStereo = isStereo;
        this.isBufferMode = true;
        try {
            MediaCodecInfo encoder = this.chooseEncoder("audio/mp4a-latm");
            if (encoder == null) {
                Log.e((String)this.TAG, (String)"Valid encoder not found");
                return false;
            }
            Log.i((String)this.TAG, (String)("Encoder selected " + encoder.getName()));
            this.codec = MediaCodec.createByCodecName((String)encoder.getName());
            int channelCount = isStereo ? 2 : 1;
            MediaFormat audioFormat = MediaFormat.createAudioFormat((String)"audio/mp4a-latm", (int)sampleRate, (int)channelCount);
            audioFormat.setInteger("bitrate", bitRate);
            audioFormat.setInteger("max-input-size", maxInputSize);
            audioFormat.setInteger("aac-profile", 2);
            this.codec.configure(audioFormat, null, null, 1);
            this.running = false;
            Log.i((String)this.TAG, (String)"prepared");
            return true;
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)"Create AudioEncoder failed.", (Throwable)e);
            this.stop();
            return false;
        }
    }

    public void setGetFrame(GetFrame getFrame) {
        this.getFrame = getFrame;
    }

    public boolean prepareAudioEncoder() {
        return this.prepareAudioEncoder(this.bitRate, this.sampleRate, this.isStereo, this.maxInputSize);
    }

    @Override
    public void start(boolean resetTs) {
        this.shouldReset = resetTs;
        Log.i((String)this.TAG, (String)"started");
    }

    @Override
    protected void stopImp() {
        Log.i((String)this.TAG, (String)"stopped");
    }

    @Override
    public void reset() {
        this.stop(false);
        this.prepareAudioEncoder(this.bitRate, this.sampleRate, this.isStereo, this.maxInputSize);
        this.restart();
    }

    @Override
    protected Frame getInputFrame() throws InterruptedException {
        return this.getFrame != null ? this.getFrame.getInputFrame() : (Frame)this.queue.take();
    }

    @Override
    protected void checkBuffer(@NonNull ByteBuffer byteBuffer, @NonNull MediaCodec.BufferInfo bufferInfo) {
        this.fixTimeStamp(bufferInfo);
    }

    @Override
    protected void sendBuffer(@NonNull ByteBuffer byteBuffer, @NonNull MediaCodec.BufferInfo bufferInfo) {
        this.getAacData.getAacData(byteBuffer, bufferInfo);
    }

    @Override
    public void inputPCMData(Frame frame) {
        if (this.running && !this.queue.offer(frame)) {
            Log.i((String)this.TAG, (String)"frame discarded");
        }
    }

    @Override
    protected MediaCodecInfo chooseEncoder(String mime) {
        List<MediaCodecInfo> mediaCodecInfoList = this.force == CodecUtil.Force.HARDWARE ? CodecUtil.getAllHardwareEncoders("audio/mp4a-latm") : (this.force == CodecUtil.Force.SOFTWARE ? CodecUtil.getAllSoftwareEncoders("audio/mp4a-latm") : CodecUtil.getAllEncoders("audio/mp4a-latm"));
        Log.i((String)this.TAG, (String)(mediaCodecInfoList.size() + " encoders found"));
        for (MediaCodecInfo mci : mediaCodecInfoList) {
            String name = mci.getName().toLowerCase();
            Log.i((String)this.TAG, (String)("Encoder " + mci.getName()));
            if (name.contains("omx.google") && mediaCodecInfoList.size() > 1) continue;
            return mci;
        }
        return null;
    }

    public void setSampleRate(int sampleRate) {
        this.sampleRate = sampleRate;
    }

    @Override
    public void formatChanged(@NonNull MediaCodec mediaCodec, @NonNull MediaFormat mediaFormat) {
        this.getAacData.onAudioFormat(mediaFormat);
    }
}

