/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.utils.yuv;

public class YV12Utils {
    private static byte[] preAllocatedBufferRotate;
    private static byte[] preAllocatedBufferColor;

    public static void preAllocateBuffers(int length) {
        preAllocatedBufferRotate = new byte[length];
        preAllocatedBufferColor = new byte[length];
    }

    public static byte[] toNV12(byte[] input, int width, int height) {
        int frameSize = width * height;
        int qFrameSize = frameSize / 4;
        System.arraycopy(input, 0, preAllocatedBufferColor, 0, frameSize);
        for (int i = 0; i < qFrameSize; ++i) {
            YV12Utils.preAllocatedBufferColor[frameSize + i * 2] = input[frameSize + i + qFrameSize];
            YV12Utils.preAllocatedBufferColor[frameSize + i * 2 + 1] = input[frameSize + i];
        }
        return preAllocatedBufferColor;
    }

    public static byte[] toI420(byte[] input, int width, int height) {
        int frameSize = width * height;
        int qFrameSize = frameSize / 4;
        System.arraycopy(input, 0, preAllocatedBufferColor, 0, frameSize);
        System.arraycopy(input, frameSize + qFrameSize, preAllocatedBufferColor, frameSize, qFrameSize);
        System.arraycopy(input, frameSize, preAllocatedBufferColor, frameSize + qFrameSize, qFrameSize);
        return preAllocatedBufferColor;
    }

    public static byte[] toNV21(byte[] input, int width, int height) {
        int frameSize = width * height;
        int qFrameSize = frameSize / 4;
        System.arraycopy(input, 0, preAllocatedBufferColor, 0, frameSize);
        for (int i = 0; i < qFrameSize; ++i) {
            YV12Utils.preAllocatedBufferColor[frameSize + i * 2 + 1] = input[frameSize + i + qFrameSize];
            YV12Utils.preAllocatedBufferColor[frameSize + i * 2] = input[frameSize + i];
        }
        return preAllocatedBufferColor;
    }

    public static byte[] rotate90(byte[] data, int imageWidth, int imageHeight) {
        int i = 0;
        for (int x = 0; x < imageWidth; ++x) {
            for (int y = imageHeight - 1; y >= 0; --y) {
                YV12Utils.preAllocatedBufferRotate[i++] = data[y * imageWidth + x];
            }
        }
        int size = imageWidth * imageHeight;
        int colorSize = size / 4;
        int colorHeight = colorSize / imageWidth;
        for (int x = 0; x < imageWidth / 2; ++x) {
            for (int y = colorHeight - 1; y >= 0; --y) {
                YV12Utils.preAllocatedBufferRotate[i + colorSize] = data[colorSize + size + imageWidth * y + x + imageWidth / 2];
                YV12Utils.preAllocatedBufferRotate[i + colorSize + 1] = data[colorSize + size + imageWidth * y + x];
                YV12Utils.preAllocatedBufferRotate[i++] = data[size + imageWidth * y + x + imageWidth / 2];
                YV12Utils.preAllocatedBufferRotate[i++] = data[size + imageWidth * y + x];
            }
        }
        return preAllocatedBufferRotate;
    }

    public static byte[] rotate180(byte[] data, int imageWidth, int imageHeight) {
        int i;
        int count = 0;
        int size = imageWidth * imageHeight;
        for (int i2 = size - 1; i2 >= 0; --i2) {
            YV12Utils.preAllocatedBufferRotate[count++] = data[i2];
        }
        int midColorSize = size / 4;
        for (i = size + midColorSize - 1; i >= size; --i) {
            YV12Utils.preAllocatedBufferRotate[count++] = data[i];
        }
        for (i = data.length - 1; i >= imageWidth * imageHeight + midColorSize; --i) {
            YV12Utils.preAllocatedBufferRotate[count++] = data[i];
        }
        return preAllocatedBufferRotate;
    }

    public static byte[] rotate270(byte[] data, int imageWidth, int imageHeight) {
        int i = 0;
        for (int x = imageWidth - 1; x >= 0; --x) {
            for (int y = 0; y < imageHeight; ++y) {
                YV12Utils.preAllocatedBufferRotate[i++] = data[y * imageWidth + x];
            }
        }
        int size = imageWidth * imageHeight;
        int colorSize = size / 4;
        int colorHeight = colorSize / imageWidth;
        for (int x = 0; x < imageWidth / 2; ++x) {
            for (int y = 0; y < colorHeight; ++y) {
                YV12Utils.preAllocatedBufferRotate[i + colorSize] = data[colorSize + size + imageWidth * y - x + imageWidth / 2 - 1];
                YV12Utils.preAllocatedBufferRotate[i + colorSize + 1] = data[colorSize + size + imageWidth * y - x + imageWidth - 1];
                YV12Utils.preAllocatedBufferRotate[i++] = data[size + imageWidth * y - x + imageWidth / 2 - 1];
                YV12Utils.preAllocatedBufferRotate[i++] = data[size + imageWidth * y - x + imageWidth - 1];
            }
        }
        return preAllocatedBufferRotate;
    }
}

