/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.input.decoder;

import android.media.MediaCodec;
import android.media.MediaExtractor;
import android.media.MediaFormat;
import android.util.Log;
import android.view.Surface;
import com.pedro.encoder.input.decoder.LoopFileInterface;
import com.pedro.encoder.input.decoder.VideoDecoderInterface;
import java.io.IOException;
import java.nio.ByteBuffer;

public class VideoDecoder {
    private final String TAG = "VideoDecoder";
    private VideoDecoderInterface videoDecoderInterface;
    private LoopFileInterface loopFileInterface;
    private MediaExtractor videoExtractor;
    private MediaCodec videoDecoder;
    private MediaCodec.BufferInfo videoInfo = new MediaCodec.BufferInfo();
    private boolean decoding;
    private Thread thread;
    private MediaFormat videoFormat;
    private String mime = "";
    private int width;
    private int height;
    private long duration;
    private static boolean loopMode = false;
    private volatile long seekTime = 0L;
    private volatile long startMs = 0L;

    public VideoDecoder(VideoDecoderInterface videoDecoderInterface, LoopFileInterface loopFileInterface) {
        this.videoDecoderInterface = videoDecoderInterface;
        this.loopFileInterface = loopFileInterface;
    }

    public boolean initExtractor(String filePath) throws IOException {
        this.decoding = false;
        this.videoExtractor = new MediaExtractor();
        this.videoExtractor.setDataSource(filePath);
        for (int i = 0; i < this.videoExtractor.getTrackCount() && !this.mime.startsWith("video/"); ++i) {
            this.videoFormat = this.videoExtractor.getTrackFormat(i);
            this.mime = this.videoFormat.getString("mime");
            if (this.mime.startsWith("video/")) {
                this.videoExtractor.selectTrack(i);
                continue;
            }
            this.videoFormat = null;
        }
        if (this.videoFormat != null) {
            this.width = this.videoFormat.getInteger("width");
            this.height = this.videoFormat.getInteger("height");
            this.duration = this.videoFormat.getLong("durationUs");
            return true;
        }
        this.mime = "";
        this.videoFormat = null;
        return false;
    }

    public boolean prepareVideo(Surface surface) {
        try {
            this.videoDecoder = MediaCodec.createDecoderByType((String)this.mime);
            this.videoDecoder.configure(this.videoFormat, surface, null, 0);
            return true;
        }
        catch (IOException e) {
            Log.e((String)"VideoDecoder", (String)"Prepare decoder error:", (Throwable)e);
            return false;
        }
    }

    public void start() {
        this.decoding = true;
        this.videoDecoder.start();
        this.thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    VideoDecoder.this.decodeVideo();
                }
                catch (IllegalStateException e) {
                    Log.i((String)"VideoDecoder", (String)"Decoding error", (Throwable)e);
                }
            }
        });
        this.thread.start();
    }

    public void stop() {
        this.decoding = false;
        this.seekTime = 0L;
        if (this.thread != null) {
            this.thread.interrupt();
            try {
                this.thread.join(100L);
            }
            catch (InterruptedException e) {
                this.thread.interrupt();
            }
            this.thread = null;
        }
        try {
            this.videoDecoder.stop();
            this.videoDecoder.release();
            this.videoDecoder = null;
        }
        catch (IllegalStateException | NullPointerException e) {
            this.videoDecoder = null;
        }
        if (this.videoExtractor != null) {
            this.videoExtractor.release();
            this.videoExtractor = null;
        }
    }

    private void decodeVideo() throws IllegalStateException {
        ByteBuffer[] inputBuffers = this.videoDecoder.getInputBuffers();
        this.startMs = System.currentTimeMillis();
        while (this.decoding) {
            int outIndex;
            int inIndex = this.videoDecoder.dequeueInputBuffer(10000L);
            if (inIndex >= 0) {
                ByteBuffer buffer = inputBuffers[inIndex];
                int sampleSize = this.videoExtractor.readSampleData(buffer, 0);
                if (sampleSize < 0) {
                    this.videoDecoder.queueInputBuffer(inIndex, 0, 0, 0L, 4);
                } else {
                    this.videoDecoder.queueInputBuffer(inIndex, 0, sampleSize, this.videoExtractor.getSampleTime(), 0);
                    this.videoExtractor.advance();
                }
            }
            if ((outIndex = this.videoDecoder.dequeueOutputBuffer(this.videoInfo, 10000L)) >= 0) {
                while (this.videoExtractor.getSampleTime() / 1000L > System.currentTimeMillis() - this.startMs + this.seekTime) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        if (this.thread != null) {
                            this.thread.interrupt();
                        }
                        return;
                    }
                }
                this.videoDecoder.releaseOutputBuffer(outIndex, this.videoInfo.size != 0);
            }
            if ((this.videoInfo.flags & 4) == 0) continue;
            this.seekTime = 0L;
            Log.i((String)"VideoDecoder", (String)"end of file out");
            if (loopMode) {
                this.loopFileInterface.onReset(true);
                continue;
            }
            this.videoDecoderInterface.onVideoDecoderFinished();
        }
    }

    public double getTime() {
        if (this.decoding) {
            return (double)this.videoExtractor.getSampleTime() / 1000000.0;
        }
        return 0.0;
    }

    public void moveTo(double time) {
        this.videoExtractor.seekTo((long)(time * 1000000.0), 2);
        this.seekTime = this.videoExtractor.getSampleTime() / 1000L;
        this.startMs = System.currentTimeMillis();
    }

    public void setLoopMode(boolean loopMode) {
        VideoDecoder.loopMode = loopMode;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public double getDuration() {
        return (double)this.duration / 1000000.0;
    }
}

