/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.input.gl.render;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.opengl.Matrix;
import android.support.annotation.RequiresApi;
import android.view.Surface;
import com.pedro.encoder.R;
import com.pedro.encoder.input.gl.render.BaseRenderOffScreen;
import com.pedro.encoder.input.video.CameraHelper;
import com.pedro.encoder.utils.gl.GlUtil;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

@RequiresApi(api=18)
public class CameraRender
extends BaseRenderOffScreen {
    private int[] textureID = new int[1];
    private float[] rotationMatrix = new float[16];
    private float[] scaleMatrix = new float[16];
    private int program = -1;
    private int uMVPMatrixHandle = -1;
    private int uSTMatrixHandle = -1;
    private int aPositionHandle = -1;
    private int aTextureCameraHandle = -1;
    private SurfaceTexture surfaceTexture;
    private Surface surface;

    public CameraRender() {
        Matrix.setIdentityM((float[])this.MVPMatrix, (int)0);
        Matrix.setIdentityM((float[])this.STMatrix, (int)0);
        float[] vertex = CameraHelper.getVerticesData();
        this.squareVertex = ByteBuffer.allocateDirect(vertex.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.squareVertex.put(vertex).position(0);
        this.setRotation(0);
        this.setFlip(false, false);
    }

    @Override
    public void initGl(int width, int height, Context context, int previewWidth, int previewHeight) {
        this.width = width;
        this.height = height;
        GlUtil.checkGlError("initGl start");
        String vertexShader = GlUtil.getStringFromRaw(context, R.raw.simple_vertex);
        String fragmentShader = GlUtil.getStringFromRaw(context, R.raw.camera_fragment);
        this.program = GlUtil.createProgram(vertexShader, fragmentShader);
        this.aPositionHandle = GLES20.glGetAttribLocation((int)this.program, (String)"aPosition");
        this.aTextureCameraHandle = GLES20.glGetAttribLocation((int)this.program, (String)"aTextureCoord");
        this.uMVPMatrixHandle = GLES20.glGetUniformLocation((int)this.program, (String)"uMVPMatrix");
        this.uSTMatrixHandle = GLES20.glGetUniformLocation((int)this.program, (String)"uSTMatrix");
        this.uSTMatrixHandle = GLES20.glGetUniformLocation((int)this.program, (String)"uSTMatrix");
        GlUtil.createExternalTextures(1, this.textureID, 0);
        this.surfaceTexture = new SurfaceTexture(this.textureID[0]);
        this.surfaceTexture.setDefaultBufferSize(width, height);
        this.surface = new Surface(this.surfaceTexture);
        this.initFBO(width, height);
        GlUtil.checkGlError("initGl end");
    }

    @Override
    public void draw() {
        GlUtil.checkGlError("drawCamera start");
        GLES20.glBindFramebuffer((int)36160, (int)this.renderHandler.getFboId()[0]);
        this.surfaceTexture.getTransformMatrix(this.STMatrix);
        GLES20.glViewport((int)0, (int)0, (int)this.width, (int)this.height);
        GLES20.glUseProgram((int)this.program);
        GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GLES20.glClear((int)16640);
        this.squareVertex.position(0);
        GLES20.glVertexAttribPointer((int)this.aPositionHandle, (int)3, (int)5126, (boolean)false, (int)20, (Buffer)this.squareVertex);
        GLES20.glEnableVertexAttribArray((int)this.aPositionHandle);
        this.squareVertex.position(3);
        GLES20.glVertexAttribPointer((int)this.aTextureCameraHandle, (int)2, (int)5126, (boolean)false, (int)20, (Buffer)this.squareVertex);
        GLES20.glEnableVertexAttribArray((int)this.aTextureCameraHandle);
        GLES20.glUniformMatrix4fv((int)this.uMVPMatrixHandle, (int)1, (boolean)false, (float[])this.MVPMatrix, (int)0);
        GLES20.glUniformMatrix4fv((int)this.uSTMatrixHandle, (int)1, (boolean)false, (float[])this.STMatrix, (int)0);
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)36197, (int)this.textureID[0]);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        GLES20.glBindFramebuffer((int)36160, (int)0);
        GlUtil.checkGlError("drawCamera end");
    }

    @Override
    public void release() {
        GLES20.glDeleteProgram((int)this.program);
        this.surfaceTexture = null;
        this.surface = null;
    }

    public void updateTexImage() {
        this.surfaceTexture.updateTexImage();
    }

    public SurfaceTexture getSurfaceTexture() {
        return this.surfaceTexture;
    }

    public Surface getSurface() {
        return this.surface;
    }

    public void setRotation(int rotation) {
        Matrix.setIdentityM((float[])this.rotationMatrix, (int)0);
        Matrix.rotateM((float[])this.rotationMatrix, (int)0, (float)rotation, (float)0.0f, (float)0.0f, (float)-1.0f);
        this.update();
    }

    public void setFlip(boolean isFlipHorizontal, boolean isFlipVertical) {
        Matrix.setIdentityM((float[])this.scaleMatrix, (int)0);
        Matrix.scaleM((float[])this.scaleMatrix, (int)0, (float)(isFlipHorizontal ? -1.0f : 1.0f), (float)(isFlipVertical ? -1.0f : 1.0f), (float)1.0f);
        this.update();
    }

    private void update() {
        Matrix.setIdentityM((float[])this.MVPMatrix, (int)0);
        Matrix.multiplyMM((float[])this.MVPMatrix, (int)0, (float[])this.scaleMatrix, (int)0, (float[])this.MVPMatrix, (int)0);
        Matrix.multiplyMM((float[])this.MVPMatrix, (int)0, (float[])this.rotationMatrix, (int)0, (float[])this.MVPMatrix, (int)0);
    }
}

