/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.utils.yuv;

import android.graphics.Bitmap;
import com.pedro.encoder.input.video.Frame;
import com.pedro.encoder.utils.yuv.NV21Utils;
import com.pedro.encoder.utils.yuv.YV12Utils;
import com.pedro.encoder.video.FormatVideoEncoder;

public class YUVUtil {
    public static void preAllocateBuffers(int length) {
        NV21Utils.preAllocateBuffers(length);
        YV12Utils.preAllocateBuffers(length);
    }

    public static byte[] NV21toYUV420byColor(byte[] input, int width, int height, FormatVideoEncoder formatVideoEncoder) {
        switch (formatVideoEncoder) {
            case YUV420PLANAR: {
                return NV21Utils.toI420(input, width, height);
            }
            case YUV420SEMIPLANAR: {
                return NV21Utils.toNV12(input, width, height);
            }
        }
        return null;
    }

    public static byte[] rotateNV21(byte[] data, int width, int height, int rotation) {
        switch (rotation) {
            case 0: {
                return data;
            }
            case 90: {
                return NV21Utils.rotate90(data, width, height);
            }
            case 180: {
                return NV21Utils.rotate180(data, width, height);
            }
            case 270: {
                return NV21Utils.rotate270(data, width, height);
            }
        }
        return null;
    }

    public static byte[] YV12toYUV420byColor(byte[] input, int width, int height, FormatVideoEncoder formatVideoEncoder) {
        switch (formatVideoEncoder) {
            case YUV420PLANAR: {
                return YV12Utils.toI420(input, width, height);
            }
            case YUV420SEMIPLANAR: {
                return YV12Utils.toNV12(input, width, height);
            }
        }
        return null;
    }

    public static byte[] rotateYV12(byte[] data, int width, int height, int rotation) {
        switch (rotation) {
            case 0: {
                return data;
            }
            case 90: {
                return YV12Utils.rotate90(data, width, height);
            }
            case 180: {
                return YV12Utils.rotate180(data, width, height);
            }
            case 270: {
                return YV12Utils.rotate270(data, width, height);
            }
        }
        return null;
    }

    public static Bitmap frameToBitmap(Frame frame, int width, int height, int orientation) {
        int w = orientation == 90 || orientation == 270 ? height : width;
        int h = orientation == 90 || orientation == 270 ? width : height;
        int[] argb = NV21Utils.toARGB(YUVUtil.rotateNV21(frame.getBuffer(), width, height, orientation), w, h);
        return Bitmap.createBitmap((int[])argb, (int)w, (int)h, (Bitmap.Config)Bitmap.Config.ARGB_8888);
    }

    public static byte[] ARGBtoYUV420SemiPlanar(int[] input, int width, int height) {
        int frameSize = width * height;
        byte[] yuv420sp = new byte[width * height * 3 / 2];
        int yIndex = 0;
        int uvIndex = frameSize;
        int index = 0;
        for (int j = 0; j < height; ++j) {
            for (int i = 0; i < width; ++i) {
                int a = (input[index] & 0xFF000000) >> 24;
                int R2 = (input[index] & 0xFF0000) >> 16;
                int G = (input[index] & 0xFF00) >> 8;
                int B = (input[index] & 0xFF) >> 0;
                int Y = (66 * R2 + 129 * G + 25 * B + 128 >> 8) + 16;
                int U = (-38 * R2 - 74 * G + 112 * B + 128 >> 8) + 128;
                int V = (112 * R2 - 94 * G - 18 * B + 128 >> 8) + 128;
                yuv420sp[yIndex++] = (byte)(Y < 0 ? 0 : (Y > 255 ? 255 : Y));
                if (j % 2 == 0 && index % 2 == 0) {
                    yuv420sp[uvIndex++] = (byte)(V < 0 ? 0 : (V > 255 ? 255 : V));
                    yuv420sp[uvIndex++] = (byte)(U < 0 ? 0 : (U > 255 ? 255 : U));
                }
                ++index;
            }
        }
        return yuv420sp;
    }

    public static byte[] CropYuv(int src_format, byte[] src_yuv, int src_width, int src_height, int dst_width, int dst_height) {
        byte[] dst_yuv;
        if (src_yuv == null) {
            return null;
        }
        if (src_width == dst_width && src_height == dst_height) {
            dst_yuv = src_yuv;
        } else {
            dst_yuv = new byte[(int)((double)(dst_width * dst_height) * 1.5)];
            switch (src_format) {
                case 19: 
                case 20: {
                    int src_yoffset = 0;
                    int dst_yoffset = 0;
                    for (int i = 0; i < dst_height; ++i) {
                        System.arraycopy(src_yuv, src_yoffset, dst_yuv, dst_yoffset, dst_width);
                        src_yoffset += src_width;
                        dst_yoffset += dst_width;
                    }
                    int src_uoffset = 0;
                    int dst_uoffset = 0;
                    src_yoffset = src_width * src_height;
                    dst_yoffset = dst_width * dst_height;
                    for (int i = 0; i < dst_height / 2; ++i) {
                        System.arraycopy(src_yuv, src_yoffset + src_uoffset, dst_yuv, dst_yoffset + dst_uoffset, dst_width / 2);
                        src_uoffset += src_width / 2;
                        dst_uoffset += dst_width / 2;
                    }
                    int src_voffset = 0;
                    int dst_voffset = 0;
                    src_uoffset = src_width * src_height + src_width * src_height / 4;
                    dst_uoffset = dst_width * dst_height + dst_width * dst_height / 4;
                    for (int i = 0; i < dst_height / 2; ++i) {
                        System.arraycopy(src_yuv, src_uoffset + src_voffset, dst_yuv, dst_uoffset + dst_voffset, dst_width / 2);
                        src_voffset += src_width / 2;
                        dst_voffset += dst_width / 2;
                    }
                    break;
                }
                case 21: 
                case 39: 
                case 2130706688: 
                case 2141391872: {
                    int src_yoffset = 0;
                    int dst_yoffset = 0;
                    for (int i = 0; i < dst_height; ++i) {
                        System.arraycopy(src_yuv, src_yoffset, dst_yuv, dst_yoffset, dst_width);
                        src_yoffset += src_width;
                        dst_yoffset += dst_width;
                    }
                    int src_uoffset = 0;
                    int dst_uoffset = 0;
                    src_yoffset = src_width * src_height;
                    dst_yoffset = dst_width * dst_height;
                    for (int i = 0; i < dst_height / 2; ++i) {
                        System.arraycopy(src_yuv, src_yoffset + src_uoffset, dst_yuv, dst_yoffset + dst_uoffset, dst_width);
                        src_uoffset += src_width;
                        dst_uoffset += dst_width;
                    }
                    break;
                }
                default: {
                    dst_yuv = null;
                }
            }
        }
        return dst_yuv;
    }
}

