/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.input.gl;

import android.graphics.PointF;
import android.graphics.RectF;
import com.pedro.encoder.utils.gl.TranslateTo;

public class Sprite {
    private float angle;
    private RectF base;
    private PointF translation;
    private PointF scale;

    public Sprite() {
        this.reset();
    }

    public void translate(float deltaX, float deltaY) {
        float rangeX = this.scale.x - 1.0f;
        float rangeY = this.scale.y - 1.0f;
        this.translation.x = -rangeX / (100.0f / deltaY);
        this.translation.y = -rangeY / (100.0f / deltaX);
    }

    public void translate(TranslateTo translation) {
        switch (translation) {
            case CENTER: {
                this.translation.x = -this.scale.x / 2.0f;
                this.translation.x += 0.5f;
                this.translation.y = -this.scale.y / 2.0f;
                this.translation.y += 0.5f;
                break;
            }
            case BOTTOM: {
                this.translation.x = 0.0f;
                this.translation.y = -this.scale.y / 2.0f;
                this.translation.y += 0.5f;
                break;
            }
            case TOP: {
                this.translation.x = -this.scale.x + 1.0f;
                this.translation.y = -this.scale.y / 2.0f;
                this.translation.y += 0.5f;
                break;
            }
            case LEFT: {
                this.translation.x = -this.scale.x / 2.0f;
                this.translation.x += 0.5f;
                this.translation.y = -this.scale.y + 1.0f;
                break;
            }
            case RIGHT: {
                this.translation.x = -this.scale.x / 2.0f;
                this.translation.x += 0.5f;
                this.translation.y = 0.0f;
                break;
            }
            case TOP_LEFT: {
                this.translation.x = -this.scale.x + 1.0f;
                this.translation.y = -this.scale.y + 1.0f;
                break;
            }
            case TOP_RIGHT: {
                this.translation.x = -this.scale.x + 1.0f;
                this.translation.y = 0.0f;
                break;
            }
            case BOTTOM_LEFT: {
                this.translation.x = 0.0f;
                this.translation.y = -this.scale.y + 1.0f;
                break;
            }
            case BOTTOM_RIGHT: {
                this.translation.x = 0.0f;
                this.translation.y = 0.0f;
                break;
            }
        }
    }

    public void scale(float deltaX, float deltaY) {
        PointF oldScale = this.scale;
        this.scale = new PointF(100.0f / deltaY, 100.0f / deltaX);
        this.translation.x = this.keepOldPosition(this.translation.x, oldScale.x, this.scale.x);
        this.translation.y = this.keepOldPosition(this.translation.y, oldScale.y, this.scale.y);
    }

    private float keepOldPosition(float position, float oldScale, float newScale) {
        float oldRange = oldScale - 1.0f;
        float percent = position * 100.0f / oldRange;
        float newRange = newScale - 1.0f;
        position = newRange / (100.0f / percent);
        return position;
    }

    public PointF getScale() {
        return new PointF(100.0f / this.scale.y, 100.0f / this.scale.x);
    }

    public PointF getTranslation() {
        return new PointF(-(this.translation.x * 100.0f / (this.scale.x - 1.0f)), -(this.translation.y * 100.0f / (this.scale.y - 1.0f)));
    }

    public void rotate(float delta) {
        this.angle = delta;
    }

    public void reset() {
        this.base = new RectF(0.0f, 0.0f, 1.0f, 1.0f);
        this.translation = new PointF(0.0f, 0.0f);
        this.scale = new PointF(100.0f, 100.0f);
        this.angle = 0.0f;
    }

    public float[] getTransformedVertices() {
        float x1 = this.base.left * this.scale.x;
        float x2 = this.base.right * this.scale.x;
        float y1 = this.base.bottom * this.scale.y;
        float y2 = this.base.top * this.scale.y;
        PointF one = new PointF(x1, y1);
        PointF two = new PointF(x1, y2);
        PointF three = new PointF(x2, y1);
        PointF four = new PointF(x2, y2);
        float s = (float)Math.sin(this.angle);
        float c = (float)Math.cos(this.angle);
        one.x = x1 * c - y1 * s;
        one.y = x1 * s + y1 * c;
        two.x = x1 * c - y2 * s;
        two.y = x1 * s + y2 * c;
        three.x = x2 * c - y1 * s;
        three.y = x2 * s + y1 * c;
        four.x = x2 * c - y2 * s;
        four.y = x2 * s + y2 * c;
        one.x += this.translation.x;
        one.y += this.translation.y;
        two.x += this.translation.x;
        two.y += this.translation.y;
        three.x += this.translation.x;
        three.y += this.translation.y;
        four.x += this.translation.x;
        four.y += this.translation.y;
        return new float[]{one.x, one.y, two.x, two.y, three.x, three.y, four.x, four.y};
    }
}

