/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.srt.mpeg2ts;

import com.pedro.srt.mpeg2ts.MpegTsPayload;
import com.pedro.srt.mpeg2ts.PesType;
import com.pedro.srt.utils.ExtensionsKt;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0005\n\u0000\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u000bJ \u0010 \u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\t2\u0006\u0010\"\u001a\u00020#H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0003X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/pedro/srt/mpeg2ts/Pes;", "Lcom/pedro/srt/mpeg2ts/MpegTsPayload;", "pid", "", "isKeyFrame", "", "streamId", "Lcom/pedro/srt/mpeg2ts/PesType;", "pts", "", "bufferData", "Ljava/nio/ByteBuffer;", "<init>", "(IZLcom/pedro/srt/mpeg2ts/PesType;JLjava/nio/ByteBuffer;)V", "getBufferData", "()Ljava/nio/ByteBuffer;", "headerLength", "getHeaderLength", "()I", "length", "markerBits", "scramblingControl", "priority", "dataAlignmentIndicator", "copyright", "originalOrCopy", "ptsdtsIndicator", "otherFlags", "pesHeaderLength", "writeHeader", "", "buffer", "addTimestamp", "timestamp", "fourBits", "", "srt_release"})
public final class Pes
extends MpegTsPayload {
    @NotNull
    private final PesType streamId;
    private final long pts;
    @NotNull
    private final ByteBuffer bufferData;
    private final int headerLength;
    private final int length;
    private final int markerBits;
    private final int scramblingControl;
    private final boolean priority;
    private final boolean dataAlignmentIndicator;
    private final boolean copyright;
    private final boolean originalOrCopy;
    private final int ptsdtsIndicator;
    private final int otherFlags;
    private final int pesHeaderLength;

    public Pes(int pid, boolean isKeyFrame, @NotNull PesType streamId, long pts, @NotNull ByteBuffer bufferData) {
        Intrinsics.checkNotNullParameter((Object)((Object)streamId), (String)"streamId");
        Intrinsics.checkNotNullParameter((Object)bufferData, (String)"bufferData");
        super(pid, isKeyFrame);
        this.streamId = streamId;
        this.pts = pts;
        this.bufferData = bufferData;
        this.headerLength = 14;
        this.length = this.headerLength + this.bufferData.remaining();
        this.markerBits = 2;
        this.originalOrCopy = true;
        this.ptsdtsIndicator = 2;
        this.pesHeaderLength = 5;
    }

    @NotNull
    public final ByteBuffer getBufferData() {
        return this.bufferData;
    }

    public final int getHeaderLength() {
        return this.headerLength;
    }

    public final void writeHeader(@NotNull ByteBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        buffer.putShort((short)0);
        buffer.put((byte)1);
        buffer.put(this.streamId.getValue());
        int l = this.length > 65535 ? 0 : this.length - 6;
        buffer.putShort((short)l);
        byte info = (byte)(this.markerBits << 6 | this.scramblingControl << 4 | ExtensionsKt.toInt(this.priority) << 3 | ExtensionsKt.toInt(this.dataAlignmentIndicator) << 3 | ExtensionsKt.toInt(this.copyright) << 3 | ExtensionsKt.toInt(this.originalOrCopy));
        buffer.put(info);
        byte flags = (byte)(this.ptsdtsIndicator << 6 | this.otherFlags);
        buffer.put(flags);
        buffer.put((byte)this.pesHeaderLength);
        this.addTimestamp(buffer, this.pts, (byte)2);
    }

    private final void addTimestamp(ByteBuffer buffer, long timestamp, byte fourBits) {
        long pts = (long)27000000 * timestamp / (long)1000000 / (long)300 % (long)Math.pow(2.0, 33);
        buffer.put((byte)((byte)(fourBits & 0xF) << 4 | (int)(pts >> 29 & 0xEL) | 1));
        buffer.putShort((short)(pts >> 14 & 0xFFFEL | 1L));
        buffer.putShort((short)(pts << 1 & 0xFFFEL | 1L));
    }
}

