/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.srt.utils;

import com.pedro.common.AudioCodec;
import com.pedro.common.VideoCodec;
import com.pedro.srt.mpeg2ts.Codec;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\n\u0010\u0005\u001a\u00020\u0006*\u00020\u0001\u001a\n\u0010\u0007\u001a\u00020\u0001*\u00020\u0006\u001a\n\u0010\b\u001a\u00020\u0006*\u00020\t\u001a\n\u0010\n\u001a\u00020\u0006*\u00020\t\u001a\u0012\u0010\u000b\u001a\u00020\f*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0006\u001a\u0012\u0010\u000f\u001a\u00020\f*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0006\u001a\u0012\u0010\u0010\u001a\u00020\f*\u00020\t2\u0006\u0010\u0003\u001a\u00020\u0004\u001a\n\u0010\u0011\u001a\u00020\u0004*\u00020\u0006\u001a\n\u0010\u0012\u001a\u00020\u0013*\u00020\u0014\u001a\n\u0010\u0012\u001a\u00020\u0013*\u00020\u0015\u00a8\u0006\u0016"}, d2={"startWith", "", "Ljava/nio/ByteBuffer;", "byteArray", "", "toInt", "", "toBoolean", "readUInt16", "Ljava/io/InputStream;", "readUInt32", "writeUInt32", "", "Ljava/io/OutputStream;", "value", "writeUInt16", "readUntil", "toByteArray", "toCodec", "Lcom/pedro/srt/mpeg2ts/Codec;", "Lcom/pedro/common/VideoCodec;", "Lcom/pedro/common/AudioCodec;", "srt_release"})
public final class ExtensionsKt {
    public static final boolean startWith(@NotNull ByteBuffer $this$startWith, @NotNull byte[] byteArray) {
        Intrinsics.checkNotNullParameter((Object)$this$startWith, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)byteArray, (String)"byteArray");
        byte[] startData = new byte[byteArray.length];
        $this$startWith.rewind();
        $this$startWith.get(startData);
        return Arrays.equals(startData, byteArray);
    }

    public static final int toInt(boolean $this$toInt) {
        return $this$toInt ? 1 : 0;
    }

    public static final boolean toBoolean(int $this$toBoolean) {
        return $this$toBoolean == 1;
    }

    public static final int readUInt16(@NotNull InputStream $this$readUInt16) {
        Intrinsics.checkNotNullParameter((Object)$this$readUInt16, (String)"<this>");
        return ($this$readUInt16.read() & 0xFF) << 8 | $this$readUInt16.read() & 0xFF;
    }

    public static final int readUInt32(@NotNull InputStream $this$readUInt32) {
        Intrinsics.checkNotNullParameter((Object)$this$readUInt32, (String)"<this>");
        return ($this$readUInt32.read() & 0xFF) << 24 | ($this$readUInt32.read() & 0xFF) << 16 | ($this$readUInt32.read() & 0xFF) << 8 | $this$readUInt32.read() & 0xFF;
    }

    public static final void writeUInt32(@NotNull OutputStream $this$writeUInt32, int value) {
        Intrinsics.checkNotNullParameter((Object)$this$writeUInt32, (String)"<this>");
        $this$writeUInt32.write(value >>> 24);
        $this$writeUInt32.write(value >>> 16);
        $this$writeUInt32.write(value >>> 8);
        $this$writeUInt32.write(value);
    }

    public static final void writeUInt16(@NotNull OutputStream $this$writeUInt16, int value) {
        Intrinsics.checkNotNullParameter((Object)$this$writeUInt16, (String)"<this>");
        $this$writeUInt16.write(value >>> 8);
        $this$writeUInt16.write(value);
    }

    public static final void readUntil(@NotNull InputStream $this$readUntil, @NotNull byte[] byteArray) {
        Intrinsics.checkNotNullParameter((Object)$this$readUntil, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)byteArray, (String)"byteArray");
        int bytesRead = 0;
        while (bytesRead < byteArray.length) {
            int result = $this$readUntil.read(byteArray, bytesRead, byteArray.length - bytesRead);
            if (result == -1) continue;
            bytesRead += result;
        }
    }

    @NotNull
    public static final byte[] toByteArray(int $this$toByteArray) {
        int remainingValue;
        List bytes = new ArrayList();
        for (remainingValue = $this$toByteArray; remainingValue >= 255; remainingValue -= 255) {
            bytes.add((byte)-1);
        }
        if (remainingValue > 0) {
            bytes.add((byte)remainingValue);
        }
        return CollectionsKt.toByteArray((Collection)bytes);
    }

    @NotNull
    public static final Codec toCodec(@NotNull VideoCodec $this$toCodec) {
        Intrinsics.checkNotNullParameter((Object)$this$toCodec, (String)"<this>");
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$toCodec.ordinal()]) {
            case 1 -> Codec.AVC;
            case 2 -> Codec.HEVC;
            default -> throw new IllegalArgumentException("Unsupported codec: " + $this$toCodec.name());
        };
    }

    @NotNull
    public static final Codec toCodec(@NotNull AudioCodec $this$toCodec) {
        Intrinsics.checkNotNullParameter((Object)$this$toCodec, (String)"<this>");
        return switch (WhenMappings.$EnumSwitchMapping$1[$this$toCodec.ordinal()]) {
            case 1 -> Codec.AAC;
            case 2 -> Codec.OPUS;
            default -> throw new IllegalArgumentException("Unsupported codec: " + $this$toCodec.name());
        };
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[VideoCodec.values().length];
            try {
                nArray[VideoCodec.H264.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VideoCodec.H265.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[AudioCodec.values().length];
            try {
                nArray[AudioCodec.AAC.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AudioCodec.OPUS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

