/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtsp.rtp.packets;

import android.util.Log;
import com.pedro.common.ExtensionsKt;
import com.pedro.common.frame.MediaFrame;
import com.pedro.rtsp.rtp.packets.BasePacket;
import com.pedro.rtsp.rtsp.RtpFrame;
import com.pedro.rtsp.utils.RtpConstants;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\fJ@\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2(\u0010\u0010\u001a$\b\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0011H\u0096@\u00a2\u0006\u0002\u0010\u0016J\u0018\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\fH\u0002J\b\u0010\u001b\u001a\u00020\u000bH\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/pedro/rtsp/rtp/packets/H264Packet;", "Lcom/pedro/rtsp/rtp/packets/BasePacket;", "<init>", "()V", "stapA", "", "sendKeyFrame", "", "sps", "pps", "sendVideoInfo", "", "Ljava/nio/ByteBuffer;", "createAndSendPacket", "mediaFrame", "Lcom/pedro/common/frame/MediaFrame;", "callback", "Lkotlin/Function2;", "", "Lcom/pedro/rtsp/rtsp/RtpFrame;", "Lkotlin/coroutines/Continuation;", "", "(Lcom/pedro/common/frame/MediaFrame;Lkotlin/jvm/functions/Function2;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "setSpsPps", "getHeaderSize", "", "byteBuffer", "reset", "rtsp_release"})
public final class H264Packet
extends BasePacket {
    @Nullable
    private byte[] stapA;
    private boolean sendKeyFrame;
    @Nullable
    private byte[] sps;
    @Nullable
    private byte[] pps;

    public H264Packet() {
        super(90000L, 96 + RtpConstants.INSTANCE.getTrackVideo());
        this.setChannelIdentifier(RtpConstants.INSTANCE.getTrackVideo());
    }

    public final void sendVideoInfo(@NotNull ByteBuffer sps, @NotNull ByteBuffer pps) {
        Intrinsics.checkNotNullParameter((Object)sps, (String)"sps");
        Intrinsics.checkNotNullParameter((Object)pps, (String)"pps");
        this.setSpsPps(ExtensionsKt.toByteArray((ByteBuffer)sps), ExtensionsKt.toByteArray((ByteBuffer)pps));
    }

    @Override
    @Nullable
    public Object createAndSendPacket(@NotNull MediaFrame mediaFrame, @NotNull Function2<? super List<RtpFrame>, ? super Continuation<? super Unit>, ? extends Object> callback, @NotNull Continuation<? super Unit> $completion) {
        ByteBuffer fixedBuffer = ExtensionsKt.removeInfo((ByteBuffer)mediaFrame.getData(), (MediaFrame.Info)mediaFrame.getInfo());
        byte[] header = new byte[this.getHeaderSize(fixedBuffer) + 1];
        if (header.length == 1) {
            return Unit.INSTANCE;
        }
        fixedBuffer.rewind();
        fixedBuffer.get(header, 0, header.length);
        long ts = mediaFrame.getInfo().getTimestamp() * 1000L;
        int naluLength = fixedBuffer.remaining();
        byte type = (byte)(header[header.length - 1] & 0x1F);
        List frames = new ArrayList();
        if (type == 5 || mediaFrame.getInfo().isKeyFrame()) {
            if (this.stapA != null) {
                byte[] it = this.stapA;
                boolean bl = false;
                byte[] buffer = this.getBuffer(it.length + 12);
                long rtpTs = this.updateTimeStamp(buffer, ts);
                this.markPacket(buffer);
                System.arraycopy(it, 0, buffer, 12, it.length);
                this.updateSeq(buffer);
                RtpFrame rtpFrame = new RtpFrame(buffer, rtpTs, it.length + 12, this.getChannelIdentifier());
                frames.add(rtpFrame);
                this.sendKeyFrame = true;
            } else {
                H264Packet $this$createAndSendPacket_u24lambda_u241 = this;
                boolean bl = false;
                Boxing.boxInt((int)Log.i((String)$this$createAndSendPacket_u24lambda_u241.getTAG(), (String)"can't create key frame because setSpsPps was not called"));
            }
        }
        if (this.sendKeyFrame) {
            if (naluLength <= this.getMaxPacketSize() - 12 - 1) {
                byte[] buffer = this.getBuffer(naluLength + 12 + 1);
                buffer[12] = header[header.length - 1];
                fixedBuffer.get(buffer, 13, naluLength);
                long rtpTs = this.updateTimeStamp(buffer, ts);
                this.markPacket(buffer);
                this.updateSeq(buffer);
                RtpFrame rtpFrame = new RtpFrame(buffer, rtpTs, buffer.length, this.getChannelIdentifier());
                v0 = Boxing.boxBoolean((boolean)frames.add(rtpFrame));
            } else {
                header[1] = (byte)(header[header.length - 1] & 0x1F);
                header[1] = (byte)(header[1] + 128);
                header[0] = (byte)((byte)(header[header.length - 1] & 0x60) & 0xFFFFFFFF);
                header[0] = (byte)(header[0] + 28);
                int sum = 0;
                while (sum < naluLength) {
                    int length = naluLength - sum > this.getMaxPacketSize() - 12 - 2 ? this.getMaxPacketSize() - 12 - 2 : fixedBuffer.remaining();
                    byte[] buffer = this.getBuffer(length + 12 + 2);
                    buffer[12] = header[0];
                    buffer[13] = header[1];
                    long rtpTs = this.updateTimeStamp(buffer, ts);
                    fixedBuffer.get(buffer, 14, length);
                    if ((sum += length) >= naluLength) {
                        buffer[13] = (byte)(buffer[13] + 64);
                        this.markPacket(buffer);
                    }
                    this.updateSeq(buffer);
                    RtpFrame rtpFrame = new RtpFrame(buffer, rtpTs, buffer.length, this.getChannelIdentifier());
                    frames.add(rtpFrame);
                    header[1] = (byte)(header[1] & 0x7F);
                }
                v0 = Unit.INSTANCE;
            }
        } else {
            v0 = Boxing.boxInt((int)Log.i((String)this.getTAG(), (String)"waiting for keyframe"));
        }
        if (!((Collection)frames).isEmpty()) {
            Object object = callback.invoke((Object)frames, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    private final void setSpsPps(byte[] sps, byte[] pps) {
        block0: {
            this.sps = sps;
            this.pps = pps;
            if (this.stapA == null) break block0;
            byte[] it = this.stapA = new byte[sps.length + pps.length + 5];
            boolean bl = false;
            it[0] = 24;
            it[1] = (byte)(sps.length >> 8);
            it[2] = (byte)(sps.length & 0xFF);
            it[sps.length + 3] = (byte)(pps.length >> 8);
            it[sps.length + 4] = (byte)(pps.length & 0xFF);
            System.arraycopy(sps, 0, it, 3, sps.length);
            System.arraycopy(pps, 0, it, 5 + sps.length, pps.length);
        }
    }

    private final int getHeaderSize(ByteBuffer byteBuffer) {
        if (byteBuffer.remaining() < 4) {
            return 0;
        }
        byte[] sps = this.sps;
        byte[] pps = this.pps;
        if (sps != null && pps != null) {
            int startCodeSize = com.pedro.rtsp.utils.ExtensionsKt.getVideoStartCodeSize(byteBuffer);
            if (startCodeSize == 0) {
                return 0;
            }
            int n = 0;
            byte[] byArray = new byte[startCodeSize];
            while (n < startCodeSize) {
                int n2 = n++;
                byArray[n2] = 0;
            }
            byte[] startCode = byArray;
            startCode[startCodeSize - 1] = 1;
            byte[] avcHeader = ArraysKt.plus((byte[])ArraysKt.plus((byte[])ArraysKt.plus((byte[])ArraysKt.plus((byte[])startCode, (byte[])sps), (byte[])startCode), (byte[])pps), (byte[])startCode);
            if (byteBuffer.remaining() < avcHeader.length) {
                return startCodeSize;
            }
            byte[] possibleAvcHeader = new byte[avcHeader.length];
            byteBuffer.get(possibleAvcHeader, 0, possibleAvcHeader.length);
            return Arrays.equals(avcHeader, possibleAvcHeader) ? avcHeader.length : startCodeSize;
        }
        return 0;
    }

    @Override
    public void reset() {
        super.reset();
        this.sendKeyFrame = false;
    }
}

