/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtsp.rtsp.commands;

import android.util.Log;
import com.pedro.common.AudioCodec;
import com.pedro.common.ExtensionsKt;
import com.pedro.common.TimeUtils;
import com.pedro.common.VideoCodec;
import com.pedro.rtsp.rtsp.Protocol;
import com.pedro.rtsp.rtsp.commands.Command;
import com.pedro.rtsp.rtsp.commands.CommandParser;
import com.pedro.rtsp.rtsp.commands.Method;
import com.pedro.rtsp.rtsp.commands.SdpBody;
import com.pedro.rtsp.utils.RtpConstants;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u0000 q2\u00020\u0001:\u0001qB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010L\u001a\u00020\u001eJ\"\u0010M\u001a\u00020N2\u0006\u0010\u0010\u001a\u00020O2\b\u0010\u0013\u001a\u0004\u0018\u00010O2\b\u0010F\u001a\u0004\u0018\u00010OJ\u0016\u0010P\u001a\u00020N2\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u001eJ\u001a\u0010Q\u001a\u00020N2\b\u0010H\u001a\u0004\u0018\u00010\u00052\b\u0010J\u001a\u0004\u0018\u00010\u0005J\"\u0010R\u001a\u00020N2\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\u0006\u0010\n\u001a\u00020\t2\b\u0010\r\u001a\u0004\u0018\u00010\u0005J\u0006\u0010S\u001a\u00020NJ\u0006\u0010T\u001a\u00020NJ\b\u0010[\u001a\u00020\u0005H\u0002J\b\u0010\\\u001a\u00020\u0005H\u0002J\u0010\u0010]\u001a\u00020\u00052\u0006\u0010^\u001a\u00020\u0005H\u0002J\u0006\u0010_\u001a\u00020\u0005J\u0010\u0010`\u001a\u00020\u00052\u0006\u0010a\u001a\u00020\tH\u0016J\u0006\u0010b\u001a\u00020\u0005J\u0006\u0010c\u001a\u00020\u0005J\u000e\u0010d\u001a\u00020\u00052\u0006\u0010^\u001a\u00020\u0005J\u0006\u0010e\u001a\u00020\u0005J\u0018\u0010f\u001a\u00020g2\u0006\u0010h\u001a\u00020i2\b\b\u0002\u0010j\u001a\u00020kJ\u0006\u0010l\u001a\u00020\u0005J\u0006\u0010m\u001a\u00020\u0005J\u0006\u0010n\u001a\u00020\u0005J\u0006\u0010o\u001a\u00020\u0005J\u0006\u0010p\u001a\u00020\u0005R\"\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001e\u0010\n\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\"\u0010\r\u001a\u0004\u0018\u00010\u00052\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\bR\"\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0004\u001a\u0004\u0018\u00010\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\"\u0010\u0013\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0004\u001a\u0004\u0018\u00010\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u000e\u0010\u0015\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\f\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010\"\u001a\u00020#X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u001a\u0010(\u001a\u00020\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010\u001f\"\u0004\b*\u0010!R\u001a\u0010+\u001a\u00020\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010\u001f\"\u0004\b-\u0010!R\u000e\u0010.\u001a\u00020/X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u00100\u001a\u000201X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105R\u001a\u00106\u001a\u000207X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u00109\"\u0004\b:\u0010;R\u0011\u0010<\u001a\u00020=\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010?R\u0011\u0010@\u001a\u00020=\u00a2\u0006\b\n\u0000\u001a\u0004\bA\u0010?R\u0011\u0010B\u001a\u00020=\u00a2\u0006\b\n\u0000\u001a\u0004\bC\u0010?R\u0011\u0010D\u001a\u00020=\u00a2\u0006\b\n\u0000\u001a\u0004\bE\u0010?R\"\u0010F\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0004\u001a\u0004\u0018\u00010\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bG\u0010\u0012R\"\u0010H\u001a\u0004\u0018\u00010\u00052\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bI\u0010\bR\"\u0010J\u001a\u0004\u0018\u00010\u00052\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bK\u0010\bR\u0014\u0010U\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bV\u0010\bR\u0014\u0010W\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bX\u0010\bR\u0014\u0010Y\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bZ\u0010\b\u00a8\u0006r"}, d2={"Lcom/pedro/rtsp/rtsp/commands/CommandsManager;", "", "<init>", "()V", "value", "", "host", "getHost", "()Ljava/lang/String;", "", "port", "getPort", "()I", "path", "getPath", "", "sps", "getSps", "()[B", "pps", "getPps", "cSeq", "sessionId", "timeStamp", "", "sampleRate", "getSampleRate", "setSampleRate", "(I)V", "isStereo", "", "()Z", "setStereo", "(Z)V", "protocol", "Lcom/pedro/rtsp/rtsp/Protocol;", "getProtocol", "()Lcom/pedro/rtsp/rtsp/Protocol;", "setProtocol", "(Lcom/pedro/rtsp/rtsp/Protocol;)V", "videoDisabled", "getVideoDisabled", "setVideoDisabled", "audioDisabled", "getAudioDisabled", "setAudioDisabled", "commandParser", "Lcom/pedro/rtsp/rtsp/commands/CommandParser;", "videoCodec", "Lcom/pedro/common/VideoCodec;", "getVideoCodec", "()Lcom/pedro/common/VideoCodec;", "setVideoCodec", "(Lcom/pedro/common/VideoCodec;)V", "audioCodec", "Lcom/pedro/common/AudioCodec;", "getAudioCodec", "()Lcom/pedro/common/AudioCodec;", "setAudioCodec", "(Lcom/pedro/common/AudioCodec;)V", "audioClientPorts", "", "getAudioClientPorts", "()[I", "videoClientPorts", "getVideoClientPorts", "audioServerPorts", "getAudioServerPorts", "videoServerPorts", "getVideoServerPorts", "vps", "getVps", "user", "getUser", "password", "getPassword", "videoInfoReady", "setVideoInfo", "", "Ljava/nio/ByteBuffer;", "setAudioInfo", "setAuth", "setUrl", "clear", "retryClear", "spsString", "getSpsString", "ppsString", "getPpsString", "vpsString", "getVpsString", "addHeaders", "createBody", "createAuth", "authResponse", "createOptions", "createSetup", "track", "createRecord", "createAnnounce", "createAnnounceWithAuth", "createTeardown", "getResponse", "Lcom/pedro/rtsp/rtsp/commands/Command;", "reader", "Ljava/io/BufferedReader;", "method", "Lcom/pedro/rtsp/rtsp/commands/Method;", "createPause", "createPlay", "createGetParameter", "createSetParameter", "createRedirect", "Companion", "rtsp_release"})
@SourceDebugExtension(value={"SMAP\nCommandsManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommandsManager.kt\ncom/pedro/rtsp/rtsp/commands/CommandsManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,297:1\n1#2:298\n*E\n"})
public class CommandsManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private String host;
    private int port;
    @Nullable
    private String path;
    @Nullable
    private byte[] sps;
    @Nullable
    private byte[] pps;
    private int cSeq;
    @Nullable
    private String sessionId;
    private final long timeStamp;
    private int sampleRate = 32000;
    private boolean isStereo = true;
    @NotNull
    private Protocol protocol = Protocol.TCP;
    private boolean videoDisabled;
    private boolean audioDisabled;
    @NotNull
    private final CommandParser commandParser = new CommandParser();
    @NotNull
    private VideoCodec videoCodec = VideoCodec.H264;
    @NotNull
    private AudioCodec audioCodec = AudioCodec.AAC;
    @NotNull
    private final int[] audioClientPorts;
    @NotNull
    private final int[] videoClientPorts;
    @NotNull
    private final int[] audioServerPorts;
    @NotNull
    private final int[] videoServerPorts;
    @Nullable
    private byte[] vps;
    @Nullable
    private String user;
    @Nullable
    private String password;
    @NotNull
    private static final String TAG = "CommandsManager";
    @Nullable
    private static String authorization;

    public CommandsManager() {
        int[] nArray = new int[]{5000, 5001};
        this.audioClientPorts = nArray;
        nArray = new int[]{5002, 5003};
        this.videoClientPorts = nArray;
        nArray = new int[]{5004, 5005};
        this.audioServerPorts = nArray;
        nArray = new int[]{5006, 5007};
        this.videoServerPorts = nArray;
        long uptime = TimeUtils.getCurrentTimeMillis();
        this.timeStamp = uptime / (long)1000 << 32 & (uptime - uptime / (long)1000 * (long)1000 >> 32) / (long)1000;
    }

    @Nullable
    public final String getHost() {
        return this.host;
    }

    public final int getPort() {
        return this.port;
    }

    @Nullable
    public final String getPath() {
        return this.path;
    }

    @Nullable
    public final byte[] getSps() {
        return this.sps;
    }

    @Nullable
    public final byte[] getPps() {
        return this.pps;
    }

    public final int getSampleRate() {
        return this.sampleRate;
    }

    public final void setSampleRate(int n) {
        this.sampleRate = n;
    }

    public final boolean isStereo() {
        return this.isStereo;
    }

    public final void setStereo(boolean bl) {
        this.isStereo = bl;
    }

    @NotNull
    public final Protocol getProtocol() {
        return this.protocol;
    }

    public final void setProtocol(@NotNull Protocol protocol) {
        Intrinsics.checkNotNullParameter((Object)((Object)protocol), (String)"<set-?>");
        this.protocol = protocol;
    }

    public final boolean getVideoDisabled() {
        return this.videoDisabled;
    }

    public final void setVideoDisabled(boolean bl) {
        this.videoDisabled = bl;
    }

    public final boolean getAudioDisabled() {
        return this.audioDisabled;
    }

    public final void setAudioDisabled(boolean bl) {
        this.audioDisabled = bl;
    }

    @NotNull
    public final VideoCodec getVideoCodec() {
        return this.videoCodec;
    }

    public final void setVideoCodec(@NotNull VideoCodec videoCodec) {
        Intrinsics.checkNotNullParameter((Object)videoCodec, (String)"<set-?>");
        this.videoCodec = videoCodec;
    }

    @NotNull
    public final AudioCodec getAudioCodec() {
        return this.audioCodec;
    }

    public final void setAudioCodec(@NotNull AudioCodec audioCodec) {
        Intrinsics.checkNotNullParameter((Object)audioCodec, (String)"<set-?>");
        this.audioCodec = audioCodec;
    }

    @NotNull
    public final int[] getAudioClientPorts() {
        return this.audioClientPorts;
    }

    @NotNull
    public final int[] getVideoClientPorts() {
        return this.videoClientPorts;
    }

    @NotNull
    public final int[] getAudioServerPorts() {
        return this.audioServerPorts;
    }

    @NotNull
    public final int[] getVideoServerPorts() {
        return this.videoServerPorts;
    }

    @Nullable
    public final byte[] getVps() {
        return this.vps;
    }

    @Nullable
    public final String getUser() {
        return this.user;
    }

    @Nullable
    public final String getPassword() {
        return this.password;
    }

    public final boolean videoInfoReady() {
        return switch (WhenMappings.$EnumSwitchMapping$0[this.videoCodec.ordinal()]) {
            case 1 -> {
                if (this.sps != null && this.pps != null) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                if (this.sps != null && this.pps != null && this.vps != null) {
                    yield true;
                }
                yield false;
            }
            case 3 -> {
                if (this.sps != null) {
                    yield true;
                }
                yield false;
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public final void setVideoInfo(@NotNull ByteBuffer sps, @Nullable ByteBuffer pps, @Nullable ByteBuffer vps) {
        Intrinsics.checkNotNullParameter((Object)sps, (String)"sps");
        this.sps = com.pedro.rtsp.utils.ExtensionsKt.getData(sps);
        ByteBuffer byteBuffer = pps;
        this.pps = (byte[])(byteBuffer != null ? com.pedro.rtsp.utils.ExtensionsKt.getData(byteBuffer) : null);
        ByteBuffer byteBuffer2 = vps;
        this.vps = (byte[])(byteBuffer2 != null ? com.pedro.rtsp.utils.ExtensionsKt.getData(byteBuffer2) : null);
    }

    public final void setAudioInfo(int sampleRate, boolean isStereo) {
        this.isStereo = isStereo;
        this.sampleRate = sampleRate;
    }

    public final void setAuth(@Nullable String user, @Nullable String password) {
        this.user = user;
        this.password = password;
    }

    public final void setUrl(@Nullable String host, int port, @Nullable String path) {
        this.host = host;
        this.port = port;
        this.path = path;
    }

    public final void clear() {
        this.sps = null;
        this.pps = null;
        this.vps = null;
        this.retryClear();
    }

    public final void retryClear() {
        this.cSeq = 0;
        this.sessionId = null;
    }

    private final String getSpsString() {
        Object object;
        block3: {
            block2: {
                object = this.sps;
                if (this.sps == null) break block2;
                String string = com.pedro.rtsp.utils.ExtensionsKt.encodeToString(object);
                object = string;
                if (string != null) break block3;
            }
            object = "";
        }
        return object;
    }

    private final String getPpsString() {
        Object object;
        block3: {
            block2: {
                object = this.pps;
                if (this.pps == null) break block2;
                String string = com.pedro.rtsp.utils.ExtensionsKt.encodeToString(object);
                object = string;
                if (string != null) break block3;
            }
            object = "";
        }
        return object;
    }

    private final String getVpsString() {
        Object object;
        block3: {
            block2: {
                object = this.vps;
                if (this.vps == null) break block2;
                String string = com.pedro.rtsp.utils.ExtensionsKt.encodeToString(object);
                object = string;
                if (string != null) break block3;
            }
            object = "";
        }
        return object;
    }

    private final String addHeaders() {
        ++this.cSeq;
        CharSequence charSequence = this.sessionId;
        Object object = charSequence == null || charSequence.length() == 0 ? "" : "Session: " + this.sessionId + "\r\n";
        charSequence = authorization;
        return "CSeq: " + this.cSeq + "\r\n" + (String)object + (String)(charSequence == null || charSequence.length() == 0 ? "" : "Authorization: " + authorization + "\r\n");
    }

    private final String createBody() {
        String videoBody = "";
        if (!this.videoDisabled) {
            videoBody = switch (WhenMappings.$EnumSwitchMapping$0[this.videoCodec.ordinal()]) {
                case 1 -> SdpBody.INSTANCE.createH264Body(RtpConstants.INSTANCE.getTrackVideo(), this.getSpsString(), this.getPpsString());
                case 2 -> SdpBody.INSTANCE.createH265Body(RtpConstants.INSTANCE.getTrackVideo(), this.getSpsString(), this.getPpsString(), this.getVpsString());
                case 3 -> SdpBody.INSTANCE.createAV1Body(RtpConstants.INSTANCE.getTrackVideo());
                default -> throw new NoWhenBranchMatchedException();
            };
        }
        String audioBody = "";
        if (!this.audioDisabled) {
            audioBody = switch (WhenMappings.$EnumSwitchMapping$1[this.audioCodec.ordinal()]) {
                case 1 -> SdpBody.INSTANCE.createG711Body(RtpConstants.INSTANCE.getTrackAudio(), this.sampleRate, this.isStereo);
                case 2 -> SdpBody.INSTANCE.createAacBody(RtpConstants.INSTANCE.getTrackAudio(), this.sampleRate, this.isStereo);
                case 3 -> SdpBody.INSTANCE.createOpusBody(RtpConstants.INSTANCE.getTrackAudio());
                default -> throw new NoWhenBranchMatchedException();
            };
        }
        return "v=0\r\no=- " + this.timeStamp + " " + this.timeStamp + " IN IP4 127.0.0.1\r\ns=Unnamed\r\ni=N/A\r\nc=IN IP4 " + this.host + "\r\nt=0 0\r\na=recvonly\r\n" + videoBody + audioBody;
    }

    private final String createAuth(String authResponse) {
        String string;
        Pattern authPattern = Pattern.compile("realm=\"(.+)\",\\s+nonce=\"(\\w+)\"", 2);
        Matcher matcher = authPattern.matcher(authResponse);
        if (matcher.find()) {
            Log.i((String)TAG, (String)"using digest auth");
            String realm = matcher.group(1);
            String nonce = matcher.group(2);
            String hash1 = ExtensionsKt.getMd5Hash((String)(this.user + ":" + realm + ":" + this.password));
            String hash2 = ExtensionsKt.getMd5Hash((String)("ANNOUNCE:rtsp://" + this.host + ":" + this.port + this.path));
            String hash3 = ExtensionsKt.getMd5Hash((String)(hash1 + ":" + nonce + ":" + hash2));
            string = "Digest username=\"" + this.user + "\", realm=\"" + realm + "\", nonce=\"" + nonce + "\", uri=\"rtsp://" + this.host + ":" + this.port + this.path + "\", response=\"" + hash3 + "\"";
        } else {
            String data;
            Log.i((String)TAG, (String)"using basic auth");
            String string2 = data = this.user + ":" + this.password;
            byte[] byArray = string2.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            String base64Data = com.pedro.rtsp.utils.ExtensionsKt.encodeToString(byArray);
            string = "Basic " + base64Data;
        }
        return string;
    }

    @NotNull
    public final String createOptions() {
        String options = "OPTIONS rtsp://" + this.host + ":" + this.port + this.path + " RTSP/1.0\r\n" + this.addHeaders() + "\r\n";
        Log.i((String)TAG, (String)options);
        return options;
    }

    @NotNull
    public String createSetup(int track) {
        int[] udpPorts = track == RtpConstants.INSTANCE.getTrackVideo() ? this.videoClientPorts : this.audioClientPorts;
        String params = this.protocol == Protocol.UDP ? "UDP;unicast;client_port=" + udpPorts[0] + "-" + udpPorts[1] + ";mode=record" : "TCP;unicast;interleaved=" + 2 * track + "-" + (2 * track + 1) + ";mode=record";
        String setup = "SETUP rtsp://" + this.host + ":" + this.port + this.path + "/streamid=" + track + " RTSP/1.0\r\nTransport: RTP/AVP/" + params + "\r\n" + this.addHeaders() + "\r\n";
        Log.i((String)TAG, (String)setup);
        return setup;
    }

    @NotNull
    public final String createRecord() {
        String record = "RECORD rtsp://" + this.host + ":" + this.port + this.path + " RTSP/1.0\r\nRange: npt=0.000-\r\n" + this.addHeaders() + "\r\n";
        Log.i((String)TAG, (String)record);
        return record;
    }

    @NotNull
    public final String createAnnounce() {
        String body = this.createBody();
        String announce = "ANNOUNCE rtsp://" + this.host + ":" + this.port + this.path + " RTSP/1.0\r\nContent-Type: application/sdp\r\n" + this.addHeaders() + "Content-Length: " + body.length() + "\r\n\r\n" + body;
        Log.i((String)TAG, (String)announce);
        return announce;
    }

    @NotNull
    public final String createAnnounceWithAuth(@NotNull String authResponse) {
        Intrinsics.checkNotNullParameter((Object)authResponse, (String)"authResponse");
        authorization = this.createAuth(authResponse);
        Log.i((String)"Auth", (String)String.valueOf(authorization));
        return this.createAnnounce();
    }

    @NotNull
    public final String createTeardown() {
        String teardown = "TEARDOWN rtsp://" + this.host + ":" + this.port + this.path + " RTSP/1.0\r\n" + this.addHeaders() + "\r\n";
        Log.i((String)TAG, (String)teardown);
        return teardown;
    }

    @NotNull
    public final Command getResponse(@NotNull BufferedReader reader, @NotNull Method method) throws IOException {
        Command command;
        String string;
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)((Object)method), (String)"method");
        Object response = "";
        String line = null;
        do {
            String string2;
            String it = string2 = reader.readLine();
            boolean bl = false;
            line = it;
            if (string2 == null) break;
            String string3 = line;
            if (string3 == null) {
                string3 = "";
            }
            response = (String)response + string3 + "\n";
            string = line;
        } while ((string != null ? string.length() : 0) >= 3);
        Log.i((String)TAG, (String)response);
        if (method == Method.UNKNOWN) {
            command = this.commandParser.parseCommand((String)response);
        } else {
            Command command2 = this.commandParser.parseResponse(method, (String)response);
            this.sessionId = this.commandParser.getSessionId(command2);
            if (command2.getMethod() == Method.SETUP && this.protocol == Protocol.UDP) {
                this.commandParser.loadServerPorts(command2, this.protocol, this.audioClientPorts, this.videoClientPorts, this.audioServerPorts, this.videoServerPorts);
            }
            command = command2;
        }
        return command;
    }

    public static /* synthetic */ Command getResponse$default(CommandsManager commandsManager, BufferedReader bufferedReader, Method method, int n, Object object) throws IOException {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getResponse");
        }
        if ((n & 2) != 0) {
            method = Method.UNKNOWN;
        }
        return commandsManager.getResponse(bufferedReader, method);
    }

    @NotNull
    public final String createPause() {
        return "";
    }

    @NotNull
    public final String createPlay() {
        return "";
    }

    @NotNull
    public final String createGetParameter() {
        return "";
    }

    @NotNull
    public final String createSetParameter() {
        return "";
    }

    @NotNull
    public final String createRedirect() {
        return "";
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/pedro/rtsp/rtsp/commands/CommandsManager$Companion;", "", "<init>", "()V", "TAG", "", "authorization", "rtsp_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[VideoCodec.values().length];
            try {
                nArray[VideoCodec.H264.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VideoCodec.H265.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VideoCodec.AV1.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[AudioCodec.values().length];
            try {
                nArray[AudioCodec.G711.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AudioCodec.AAC.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AudioCodec.OPUS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

