/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtsp.rtp.sockets;

import android.util.Log;
import com.pedro.rtsp.rtp.sockets.BaseRtpSocket;
import com.pedro.rtsp.rtsp.RtpFrame;
import com.pedro.rtsp.utils.RtpConstants;
import java.io.IOException;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/pedro/rtsp/rtp/sockets/RtpSocketUdp;", "Lcom/pedro/rtsp/rtp/sockets/BaseRtpSocket;", "videoSourcePort", "", "audioSourcePort", "(II)V", "datagramPacket", "Ljava/net/DatagramPacket;", "multicastSocketAudio", "Ljava/net/MulticastSocket;", "multicastSocketVideo", "close", "", "sendFrame", "rtpFrame", "Lcom/pedro/rtsp/rtsp/RtpFrame;", "isEnableLogs", "", "sendFrameUDP", "setDataStream", "outputStream", "Ljava/io/OutputStream;", "host", "", "rtsp_release"})
public class RtpSocketUdp
extends BaseRtpSocket {
    @Nullable
    private MulticastSocket multicastSocketVideo;
    @Nullable
    private MulticastSocket multicastSocketAudio;
    @NotNull
    private final DatagramPacket datagramPacket;

    public RtpSocketUdp(int videoSourcePort, int audioSourcePort) {
        byte[] byArray = new byte[]{0};
        this.datagramPacket = new DatagramPacket(byArray, 1);
        MulticastSocket multicastSocket = this.multicastSocketVideo = new MulticastSocket(videoSourcePort);
        if (multicastSocket != null) {
            multicastSocket.setTimeToLive(64);
        }
        MulticastSocket multicastSocket2 = this.multicastSocketAudio = new MulticastSocket(audioSourcePort);
        if (multicastSocket2 != null) {
            multicastSocket2.setTimeToLive(64);
        }
    }

    @Override
    public void setDataStream(@NotNull OutputStream outputStream, @NotNull String host) throws IOException {
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        this.datagramPacket.setAddress(InetAddress.getByName(host));
    }

    @Override
    public void sendFrame(@NotNull RtpFrame rtpFrame, boolean isEnableLogs) throws IOException {
        Intrinsics.checkNotNullParameter((Object)rtpFrame, (String)"rtpFrame");
        this.sendFrameUDP(rtpFrame, isEnableLogs);
    }

    @Override
    public void close() {
        block1: {
            MulticastSocket multicastSocket = this.multicastSocketVideo;
            if (multicastSocket != null) {
                multicastSocket.close();
            }
            MulticastSocket multicastSocket2 = this.multicastSocketAudio;
            if (multicastSocket2 == null) break block1;
            multicastSocket2.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void sendFrameUDP(RtpFrame rtpFrame, boolean isEnableLogs) throws IOException {
        Object object = RtpConstants.lock;
        synchronized (object) {
            boolean bl = false;
            this.datagramPacket.setData(rtpFrame.getBuffer());
            this.datagramPacket.setPort(rtpFrame.getRtpPort());
            this.datagramPacket.setLength(rtpFrame.getLength());
            if (rtpFrame.isVideoFrame()) {
                MulticastSocket multicastSocket = this.multicastSocketVideo;
                if (multicastSocket != null) {
                    multicastSocket.send(this.datagramPacket);
                }
            } else {
                MulticastSocket multicastSocket = this.multicastSocketAudio;
                if (multicastSocket != null) {
                    multicastSocket.send(this.datagramPacket);
                }
            }
            if (isEnableLogs) {
                Log.i((String)this.getTAG(), (String)("wrote packet: " + (rtpFrame.isVideoFrame() ? "Video" : "Audio") + ", size: " + rtpFrame.getLength() + ", port: " + rtpFrame.getRtpPort()));
            }
            Unit unit = Unit.INSTANCE;
        }
    }
}

