/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtsp.rtsp;

import android.util.Base64;
import android.util.Log;
import com.pedro.rtsp.rtsp.Body;
import com.pedro.rtsp.rtsp.Protocol;
import com.pedro.rtsp.utils.AuthUtil;
import com.pedro.rtsp.utils.ConnectCheckerRtsp;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CommandsManager {
    private static final String TAG = "CommandsManager";
    private static String authorization = null;
    private String host;
    private int port;
    private String path;
    private byte[] sps;
    private byte[] pps;
    private int cSeq = 0;
    private String sessionId;
    private long timeStamp;
    private int sampleRate = 32000;
    private boolean isStereo = true;
    private int trackAudio = 0;
    private int trackVideo = 1;
    private Protocol protocol;
    private int[] audioPorts = new int[]{5000, 5001};
    private int[] videoPorts = new int[]{5002, 5003};
    private byte[] vps;
    private String user;
    private String password;
    private final String defaultSps = "Z0KAHtoHgUZA";
    private final String defaultPps = "aM4NiA==";

    public CommandsManager() {
        this.protocol = Protocol.TCP;
        long uptime = System.currentTimeMillis();
        this.timeStamp = uptime / 1000L << 32 & (uptime - uptime / 1000L * 1000L >> 32) / 1000L;
    }

    private byte[] getData(ByteBuffer byteBuffer) {
        if (byteBuffer != null) {
            byte[] bytes = new byte[byteBuffer.capacity() - 4];
            byteBuffer.position(4);
            byteBuffer.get(bytes, 0, bytes.length);
            return bytes;
        }
        return null;
    }

    private String encodeToString(byte[] bytes) {
        return Base64.encodeToString((byte[])bytes, (int)0, (int)bytes.length, (int)2);
    }

    public void setVideoInfo(ByteBuffer sps, ByteBuffer pps, ByteBuffer vps) {
        this.sps = this.getData(sps);
        this.pps = this.getData(pps);
        this.vps = this.getData(vps);
    }

    public void setSampleRate(int sampleRate) {
        this.sampleRate = sampleRate;
    }

    public void setIsStereo(boolean isStereo) {
        this.isStereo = isStereo;
    }

    public void setAuth(String user, String password) {
        this.user = user;
        this.password = password;
    }

    public void setUrl(String host, int port, String path) {
        this.host = host;
        this.port = port;
        this.path = path;
    }

    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getPath() {
        return this.path;
    }

    public byte[] getSps() {
        return this.sps;
    }

    public byte[] getPps() {
        return this.pps;
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public boolean isStereo() {
        return this.isStereo;
    }

    public int getTrackAudio() {
        return this.trackAudio;
    }

    public int getTrackVideo() {
        return this.trackVideo;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public byte[] getVps() {
        return this.vps;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public int[] getAudioPorts() {
        return this.audioPorts;
    }

    public int[] getVideoPorts() {
        return this.videoPorts;
    }

    public void clear() {
        this.cSeq = 0;
        this.sps = null;
        this.pps = null;
        this.sessionId = null;
    }

    private String getSpsString() {
        return this.sps != null ? this.encodeToString(this.sps) : "Z0KAHtoHgUZA";
    }

    private String getPpsString() {
        return this.pps != null ? this.encodeToString(this.pps) : "aM4NiA==";
    }

    private String getVpsString() {
        return this.encodeToString(this.vps);
    }

    private String addHeaders() {
        return "CSeq: " + ++this.cSeq + "\r\n" + (this.sessionId != null ? "Session: " + this.sessionId + "\r\n" : "") + (authorization != null ? "Authorization: " + authorization + "\r\n" : "") + "\r\n";
    }

    private String createBody() {
        String videoBody = this.vps == null ? Body.createH264Body(this.trackVideo, this.getSpsString(), this.getPpsString()) : Body.createH265Body(this.trackVideo, this.getSpsString(), this.getPpsString(), this.getVpsString());
        return "v=0\r\no=- " + this.timeStamp + " " + this.timeStamp + " IN IP4 127.0.0.1\r\ns=Unnamed\r\ni=N/A\r\nc=IN IP4 " + this.host + "\r\nt=0 0\r\na=recvonly\r\n" + videoBody + Body.createAacBody(this.trackAudio, this.sampleRate, this.isStereo);
    }

    private String createAuth(String authResponse) {
        Pattern authPattern = Pattern.compile("realm=\"(.+)\",\\s+nonce=\"(\\w+)\"", 2);
        Matcher matcher = authPattern.matcher(authResponse);
        if (matcher.find()) {
            Log.i((String)TAG, (String)"using digest auth");
            String realm = matcher.group(1);
            String nonce = matcher.group(2);
            String hash1 = AuthUtil.getMd5Hash(this.user + ":" + realm + ":" + this.password);
            String hash2 = AuthUtil.getMd5Hash("ANNOUNCE:rtsp://" + this.host + ":" + this.port + this.path);
            String hash3 = AuthUtil.getMd5Hash(hash1 + ":" + nonce + ":" + hash2);
            return "Digest username=\"" + this.user + "\",realm=\"" + realm + "\",nonce=\"" + nonce + "\",uri=\"rtsp://" + this.host + ":" + this.port + this.path + "\",response=\"" + hash3 + "\"";
        }
        Log.i((String)TAG, (String)"using basic auth");
        String data = this.user + ":" + this.password;
        String base64Data = Base64.encodeToString((byte[])data.getBytes(), (int)0);
        return "Basic " + base64Data;
    }

    public String createOptions() {
        String options = "OPTIONS rtsp://" + this.host + ":" + this.port + this.path + " RTSP/1.0\r\n" + this.addHeaders();
        Log.i((String)TAG, (String)options);
        return options;
    }

    public String createSetup(int track) {
        String params = this.protocol == Protocol.UDP ? "UDP;unicast;client_port=" + (5000 + 2 * track) + "-" + (5000 + 2 * track + 1) + ";mode=record" : "TCP;interleaved=" + 2 * track + "-" + (2 * track + 1) + ";mode=record";
        String setup = "SETUP rtsp://" + this.host + ":" + this.port + this.path + "/trackID=" + track + " RTSP/1.0\r\nTransport: RTP/AVP/" + params + "\r\n" + this.addHeaders();
        Log.i((String)TAG, (String)setup);
        return setup;
    }

    public String createRecord() {
        String record = "RECORD rtsp://" + this.host + ":" + this.port + this.path + " RTSP/1.0\r\nRange: npt=0.000-\r\n" + this.addHeaders();
        Log.i((String)TAG, (String)record);
        return record;
    }

    public String createAnnounce() {
        String body = this.createBody();
        String announce = "ANNOUNCE rtsp://" + this.host + ":" + this.port + this.path + " RTSP/1.0\r\nCSeq: " + ++this.cSeq + "\r\nContent-Length: " + body.length() + "\r\n" + (authorization == null ? "" : "Authorization: " + authorization + "\r\n") + "Content-Type: application/sdp\r\n\r\n" + body;
        Log.i((String)TAG, (String)announce);
        return announce;
    }

    public String createAnnounceWithAuth(String authResponse) {
        authorization = this.createAuth(authResponse);
        Log.i((String)"Auth", (String)authorization);
        String body = this.createBody();
        String announceAuth = "ANNOUNCE rtsp://" + this.host + ":" + this.port + this.path + " RTSP/1.0\r\nCSeq: " + ++this.cSeq + "\r\nContent-Length: " + body.length() + "\r\nAuthorization: " + authorization + "\r\nContent-Type: application/sdp\r\n\r\n" + body;
        Log.i((String)TAG, (String)announceAuth);
        return announceAuth;
    }

    public String createTeardown() {
        String teardown = "TEARDOWN rtsp://" + this.host + ":" + this.port + this.path + " RTSP/1.0\r\n" + this.addHeaders();
        Log.i((String)TAG, (String)teardown);
        return teardown;
    }

    public static String createPause() {
        return "";
    }

    public static String createPlay() {
        return "";
    }

    public static String createGetParameter() {
        return "";
    }

    public static String createSetParameter() {
        return "";
    }

    public static String createRedirect() {
        return "";
    }

    public String getResponse(BufferedReader reader, ConnectCheckerRtsp connectCheckerRtsp, boolean isAudio, boolean checkStatus) {
        try {
            String line;
            String response = "";
            while ((line = reader.readLine()) != null) {
                Matcher matcher;
                Pattern rtspPattern;
                if (line.contains("Session")) {
                    rtspPattern = Pattern.compile("Session: (\\w+)");
                    matcher = rtspPattern.matcher(line);
                    if (matcher.find()) {
                        this.sessionId = matcher.group(1);
                    }
                    this.sessionId = line.split(";")[0].split(":")[1].trim();
                }
                if (line.contains("server_port") && (matcher = (rtspPattern = Pattern.compile("server_port=([0-9]+)-([0-9]+)")).matcher(line)).find()) {
                    if (isAudio) {
                        this.audioPorts[0] = Integer.parseInt(matcher.group(1));
                        this.audioPorts[1] = Integer.parseInt(matcher.group(2));
                    } else {
                        this.videoPorts[0] = Integer.parseInt(matcher.group(1));
                        this.videoPorts[1] = Integer.parseInt(matcher.group(2));
                    }
                }
                response = response + line + "\n";
                if (line.length() >= 3) continue;
            }
            if (checkStatus && this.getResponseStatus(response) != 200) {
                connectCheckerRtsp.onConnectionFailedRtsp("Error configure stream, " + response);
            }
            Log.i((String)TAG, (String)response);
            return response;
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"read error", (Throwable)e);
            return null;
        }
    }

    public int getResponseStatus(String response) {
        Matcher matcher = Pattern.compile("RTSP/\\d.\\d (\\d+) (\\w+)", 2).matcher(response);
        if (matcher.find()) {
            return Integer.parseInt(matcher.group(1));
        }
        return -1;
    }
}

