/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtsp.rtp.sockets;

import java.util.concurrent.Semaphore;

public abstract class BaseRtpSocket
implements Runnable {
    protected final String TAG = "RtpSocket";
    protected byte[][] buffers = new byte[this.bufferCount][];
    protected long[] timestamps;
    protected Semaphore bufferRequested;
    protected Semaphore bufferCommitted;
    protected Thread thread;
    protected int bufferOut;
    protected long clock = 0L;
    protected int seq = 0;
    protected int bufferCount = 300;
    protected int bufferIn;
    protected boolean running = true;

    public BaseRtpSocket() {
        this.resetFifo();
        for (int i = 0; i < this.bufferCount; ++i) {
            this.buffers[i] = new byte[1300];
            this.buffers[i][0] = (byte)Integer.parseInt("10000000", 2);
            this.buffers[i][1] = 96;
        }
    }

    protected void resetFifo() {
        this.bufferIn = 0;
        this.bufferOut = 0;
        this.timestamps = new long[this.bufferCount];
        this.bufferRequested = new Semaphore(this.bufferCount);
        this.bufferCommitted = new Semaphore(0);
    }

    public void reset(boolean running) {
        this.running = running;
        this.bufferCommitted.drainPermits();
        this.bufferRequested.drainPermits();
        this.resetFifo();
    }

    public abstract void setSSRC(int var1);

    protected void setLongSSRC(int ssrc) {
        for (int i = 0; i < this.bufferCount; ++i) {
            this.setLong(this.buffers[i], ssrc, 8, 12);
        }
    }

    public void setClockFrequency(long clock) {
        this.clock = clock;
    }

    public byte[] requestBuffer() {
        try {
            this.bufferRequested.acquire();
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
            try {
                Thread.currentThread().join(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        byte[] byArray = this.buffers[this.bufferIn];
        byArray[1] = (byte)(byArray[1] & 0x7F);
        return this.buffers[this.bufferIn];
    }

    public void updateTimestamp(long timestamp) {
        long ts;
        this.timestamps[this.bufferIn] = ts = timestamp * this.clock / 1000000000L;
        this.setLong(this.buffers[this.bufferIn], ts, 4, 8);
    }

    public void commitBuffer(int length) {
        this.setLong(this.buffers[this.bufferIn], ++this.seq, 2, 4);
        this.implementCommitBuffer(length);
        if (++this.bufferIn >= this.bufferCount) {
            this.bufferIn = 0;
        }
        this.bufferCommitted.release();
        if (this.thread == null) {
            this.thread = new Thread(this);
            this.thread.start();
        }
    }

    protected abstract void implementCommitBuffer(int var1);

    public void markNextPacket() {
        byte[] byArray = this.buffers[this.bufferIn];
        byArray[1] = (byte)(byArray[1] | 0x80);
    }

    protected void setLong(byte[] buffer, long n, int begin, int end) {
        --end;
        while (end >= begin) {
            buffer[end] = (byte)(n % 256L);
            n >>= 8;
            --end;
        }
    }
}

