/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtmp.rtmp.message;

import com.pedro.rtmp.rtmp.chunk.ChunkType;
import java.io.IOException;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005J\b\u0010\r\u001a\u00020\u000eH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0010"}, d2={"Lcom/pedro/rtmp/rtmp/message/BasicHeader;", "", "chunkType", "Lcom/pedro/rtmp/rtmp/chunk/ChunkType;", "chunkStreamId", "", "(Lcom/pedro/rtmp/rtmp/chunk/ChunkType;I)V", "getChunkStreamId", "()I", "getChunkType", "()Lcom/pedro/rtmp/rtmp/chunk/ChunkType;", "getHeaderSize", "timestamp", "toString", "", "Companion", "rtmp_release"})
public final class BasicHeader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ChunkType chunkType;
    private final int chunkStreamId;

    public BasicHeader(@NotNull ChunkType chunkType, int chunkStreamId) {
        Intrinsics.checkNotNullParameter((Object)((Object)chunkType), (String)"chunkType");
        this.chunkType = chunkType;
        this.chunkStreamId = chunkStreamId;
    }

    @NotNull
    public final ChunkType getChunkType() {
        return this.chunkType;
    }

    public final int getChunkStreamId() {
        return this.chunkStreamId;
    }

    public final int getHeaderSize(int timestamp) {
        int n;
        switch (WhenMappings.$EnumSwitchMapping$0[this.chunkType.ordinal()]) {
            case 1: {
                n = 12;
                break;
            }
            case 2: {
                n = 8;
                break;
            }
            case 3: {
                n = 4;
                break;
            }
            case 4: {
                n = 0;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        int size = n;
        if (timestamp >= 0xFFFFFF) {
            size += 4;
        }
        return size;
    }

    @NotNull
    public String toString() {
        return "BasicHeader chunkType: " + (Object)((Object)this.chunkType) + ", chunkStreamId: " + this.chunkStreamId;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/pedro/rtmp/rtmp/message/BasicHeader$Companion;", "", "()V", "parseBasicHeader", "Lcom/pedro/rtmp/rtmp/message/BasicHeader;", "input", "Ljava/io/InputStream;", "rtmp_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BasicHeader parseBasicHeader(@NotNull InputStream input) {
            ChunkType chunkType;
            int chunkTypeValue;
            byte by;
            block7: {
                Intrinsics.checkNotNullParameter((Object)input, (String)"input");
                by = (byte)input.read();
                chunkTypeValue = (0xFF & by) >>> 6;
                ChunkType[] chunkTypeArray = ChunkType.values();
                int n = chunkTypeArray.length;
                for (int i = 0; i < n; ++i) {
                    ChunkType chunkType2;
                    ChunkType it = chunkType2 = chunkTypeArray[i];
                    boolean bl = false;
                    if (!(it.getMark() == chunkTypeValue)) continue;
                    chunkType = chunkType2;
                    break block7;
                }
                chunkType = null;
            }
            if (chunkType == null) {
                throw new IOException("Unknown chunk type value: " + chunkTypeValue);
            }
            ChunkType chunkType3 = chunkType;
            int chunkStreamIdValue = by & 0x3F;
            if (chunkStreamIdValue > 63) {
                throw new IOException("Unknown chunk stream id value: " + chunkStreamIdValue);
            }
            switch (chunkStreamIdValue) {
                case 0: {
                    chunkStreamIdValue = input.read() - 64;
                    break;
                }
                case 1: {
                    int a = input.read();
                    int b = input.read();
                    int value = (b & 0xFF) << 8 & a;
                    chunkStreamIdValue = value - 64;
                }
            }
            return new BasicHeader(chunkType3, chunkStreamIdValue);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ChunkType.values().length];
            nArray[ChunkType.TYPE_0.ordinal()] = 1;
            nArray[ChunkType.TYPE_1.ordinal()] = 2;
            nArray[ChunkType.TYPE_2.ordinal()] = 3;
            nArray[ChunkType.TYPE_3.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

