/*
 * Decompiled with CFR 0.152.
 */
package com.github.faucamp.simplertmp.packets;

import com.github.faucamp.simplertmp.io.ChunkStreamInfo;
import com.github.faucamp.simplertmp.packets.ContentData;
import com.github.faucamp.simplertmp.packets.RtmpHeader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class RtmpPacket {
    protected RtmpHeader header;

    public RtmpPacket(RtmpHeader header) {
        this.header = header;
    }

    public RtmpHeader getHeader() {
        return this.header;
    }

    public abstract void readBody(InputStream var1) throws IOException;

    protected abstract void writeBody(OutputStream var1) throws IOException;

    protected abstract byte[] array();

    protected abstract int size();

    public void writeTo(OutputStream out, int chunkSize, ChunkStreamInfo chunkStreamInfo) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.writeBody(baos);
        byte[] body = this instanceof ContentData ? this.array() : baos.toByteArray();
        int length = this instanceof ContentData ? this.size() : body.length;
        this.header.setPacketLength(length);
        this.header.writeTo(out, RtmpHeader.ChunkType.TYPE_0_FULL, chunkStreamInfo);
        int pos = 0;
        while (length > chunkSize) {
            out.write(body, pos, chunkSize);
            length -= chunkSize;
            pos += chunkSize;
            this.header.writeTo(out, RtmpHeader.ChunkType.TYPE_3_RELATIVE_SINGLE_BYTE, chunkStreamInfo);
        }
        out.write(body, pos, length);
    }
}

