/*
 * Decompiled with CFR 0.152.
 */
package com.github.faucamp.simplertmp.amf;

import com.github.faucamp.simplertmp.amf.AmfArray;
import com.github.faucamp.simplertmp.amf.AmfBoolean;
import com.github.faucamp.simplertmp.amf.AmfData;
import com.github.faucamp.simplertmp.amf.AmfMap;
import com.github.faucamp.simplertmp.amf.AmfNull;
import com.github.faucamp.simplertmp.amf.AmfNumber;
import com.github.faucamp.simplertmp.amf.AmfObject;
import com.github.faucamp.simplertmp.amf.AmfString;
import com.github.faucamp.simplertmp.amf.AmfType;
import com.github.faucamp.simplertmp.amf.AmfUndefined;
import java.io.IOException;
import java.io.InputStream;

public class AmfDecoder {
    public static AmfData readFrom(InputStream in) throws IOException {
        AmfData amfData;
        byte amfTypeByte = (byte)in.read();
        AmfType amfType = AmfType.valueOf(amfTypeByte);
        switch (amfType) {
            case NUMBER: {
                amfData = new AmfNumber();
                break;
            }
            case BOOLEAN: {
                amfData = new AmfBoolean();
                break;
            }
            case STRING: {
                amfData = new AmfString();
                break;
            }
            case OBJECT: {
                amfData = new AmfObject();
                break;
            }
            case NULL: {
                return new AmfNull();
            }
            case UNDEFINED: {
                return new AmfUndefined();
            }
            case MAP: {
                amfData = new AmfMap();
                break;
            }
            case ARRAY: {
                amfData = new AmfArray();
                break;
            }
            default: {
                throw new IOException("Unknown/unimplemented AMF data type: " + (Object)((Object)amfType));
            }
        }
        amfData.readFrom(in);
        return amfData;
    }
}

