/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.library.base;

import android.content.Context;
import android.media.AudioTrack;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.net.Uri;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.pedro.common.AudioCodec;
import com.pedro.common.TimeUtils;
import com.pedro.common.VideoCodec;
import com.pedro.encoder.CodecErrorCallback;
import com.pedro.encoder.TimestampMode;
import com.pedro.encoder.audio.AudioEncoder;
import com.pedro.encoder.audio.GetAudioData;
import com.pedro.encoder.input.audio.GetMicrophoneData;
import com.pedro.encoder.input.decoder.AudioDecoder;
import com.pedro.encoder.input.decoder.AudioDecoderInterface;
import com.pedro.encoder.input.decoder.BaseDecoder;
import com.pedro.encoder.input.decoder.DecoderInterface;
import com.pedro.encoder.input.decoder.Extractor;
import com.pedro.encoder.input.decoder.VideoDecoder;
import com.pedro.encoder.input.decoder.VideoDecoderInterface;
import com.pedro.encoder.utils.CodecUtil;
import com.pedro.encoder.video.FormatVideoEncoder;
import com.pedro.encoder.video.GetVideoData;
import com.pedro.encoder.video.VideoEncoder;
import com.pedro.library.base.recording.BaseRecordController;
import com.pedro.library.base.recording.RecordController;
import com.pedro.library.util.AndroidMuxerRecordController;
import com.pedro.library.util.FpsListener;
import com.pedro.library.util.IORunnable;
import com.pedro.library.util.streamclient.StreamBaseClient;
import com.pedro.library.view.GlInterface;
import com.pedro.library.view.GlStreamInterface;
import com.pedro.library.view.OpenGlView;
import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;

@RequiresApi(api=18)
public abstract class FromFileBase {
    private static final String TAG = "FromFileBase";
    protected VideoEncoder videoEncoder;
    private AudioEncoder audioEncoder;
    private GlInterface glInterface;
    private boolean streaming = false;
    protected BaseRecordController recordController;
    private final FpsListener fpsListener = new FpsListener();
    private VideoDecoder videoDecoder;
    private AudioDecoder audioDecoder;
    protected boolean videoEnabled = false;
    private boolean audioEnabled = false;
    private AudioTrack audioTrackPlayer;
    private VideoDecoderInterface videoDecoderInterface;
    private AudioDecoderInterface audioDecoderInterface;
    private final GetMicrophoneData getMicrophoneData = frame -> {
        if (this.audioTrackPlayer != null) {
            this.audioTrackPlayer.write(frame.getBuffer(), frame.getOffset(), frame.getSize());
        }
        this.audioEncoder.inputPCMData(frame);
    };
    private final GetAudioData getAudioData = new GetAudioData(){

        public void getAudioData(@NonNull ByteBuffer audioBuffer, @NonNull MediaCodec.BufferInfo info) {
            FromFileBase.this.recordController.recordAudio(audioBuffer, info);
            if (FromFileBase.this.streaming) {
                FromFileBase.this.getAudioDataImp(audioBuffer, info);
            }
        }

        public void onAudioFormat(@NonNull MediaFormat mediaFormat) {
            FromFileBase.this.recordController.setAudioFormat(mediaFormat);
        }
    };
    private final GetVideoData getVideoData = new GetVideoData(){

        public void onVideoInfo(@NonNull ByteBuffer sps, @Nullable ByteBuffer pps, @Nullable ByteBuffer vps) {
            FromFileBase.this.onVideoInfoImp(sps.duplicate(), pps != null ? pps.duplicate() : null, vps != null ? vps.duplicate() : null);
        }

        public void getVideoData(@NonNull ByteBuffer videoBuffer, @NonNull MediaCodec.BufferInfo info) {
            FromFileBase.this.fpsListener.calculateFps();
            FromFileBase.this.recordController.recordVideo(videoBuffer, info);
            if (FromFileBase.this.streaming) {
                FromFileBase.this.getVideoDataImp(videoBuffer, info);
            }
        }

        public void onVideoFormat(@NonNull MediaFormat mediaFormat) {
            FromFileBase.this.recordController.setVideoFormat(mediaFormat);
        }
    };
    private final DecoderInterface decoderInterfaceVideo = new DecoderInterface(){

        public void onLoop() {
            if (FromFileBase.this.videoDecoder.isRunning()) {
                FromFileBase.this.videoDecoder.reset(FromFileBase.this.glInterface.getSurface());
            }
        }
    };
    private final DecoderInterface decoderInterfaceAudio = new DecoderInterface(){

        public void onLoop() {
            if (FromFileBase.this.audioDecoder.isRunning()) {
                FromFileBase.this.audioDecoder.reset(null);
            }
        }
    };

    public FromFileBase(VideoDecoderInterface videoDecoderInterface, AudioDecoderInterface audioDecoderInterface) {
        this.init(videoDecoderInterface, audioDecoderInterface);
    }

    public FromFileBase(Context context, VideoDecoderInterface videoDecoderInterface, AudioDecoderInterface audioDecoderInterface) {
        this.glInterface = new GlStreamInterface(context);
        this.init(videoDecoderInterface, audioDecoderInterface);
    }

    public FromFileBase(OpenGlView openGlView, VideoDecoderInterface videoDecoderInterface, AudioDecoderInterface audioDecoderInterface) {
        this.glInterface = openGlView;
        this.init(videoDecoderInterface, audioDecoderInterface);
    }

    private void init(VideoDecoderInterface videoDecoderInterface, AudioDecoderInterface audioDecoderInterface) {
        this.videoDecoderInterface = videoDecoderInterface;
        this.audioDecoderInterface = audioDecoderInterface;
        this.videoEncoder = new VideoEncoder(this.getVideoData);
        this.audioEncoder = new AudioEncoder(this.getAudioData);
        this.videoDecoder = new VideoDecoder(videoDecoderInterface, this.decoderInterfaceVideo);
        this.audioDecoder = new AudioDecoder(this.getMicrophoneData, audioDecoderInterface, this.decoderInterfaceAudio);
        this.recordController = new AndroidMuxerRecordController();
    }

    public void setTimestampMode(TimestampMode timestampModeVideo, TimestampMode timestampModeAudio) {
        this.videoEncoder.setTimestampMode(timestampModeVideo);
        this.audioEncoder.setTimestampMode(timestampModeAudio);
    }

    public void setFpsListener(FpsListener.Callback callback) {
        this.fpsListener.setCallback(callback);
    }

    public boolean prepareVideo(String filePath, int bitRate, int rotation, int profile, int level) throws IOException {
        if (!this.videoDecoder.initExtractor(filePath)) {
            return false;
        }
        return this.finishPrepareVideo(bitRate, rotation, profile, level);
    }

    public boolean prepareVideo(FileDescriptor fileDescriptor, int bitRate, int rotation, int profile, int level) throws IOException {
        if (!this.videoDecoder.initExtractor(fileDescriptor)) {
            return false;
        }
        return this.finishPrepareVideo(bitRate, rotation, profile, level);
    }

    public boolean prepareVideo(Context context, Uri uri, int bitRate, int rotation, int profile, int level) throws IOException {
        if (!this.videoDecoder.initExtractor(context, uri)) {
            return false;
        }
        return this.finishPrepareVideo(bitRate, rotation, profile, level);
    }

    public boolean prepareVideo(String filePath, int bitRate, int rotation) throws IOException {
        return this.prepareVideo(filePath, bitRate, rotation, -1, -1);
    }

    public boolean prepareVideo(FileDescriptor fileDescriptor, int bitRate, int rotation) throws IOException {
        return this.prepareVideo(fileDescriptor, bitRate, rotation, -1, -1);
    }

    public boolean prepareVideo(String filePath) throws IOException {
        return this.prepareVideo(filePath, 1228800, 0);
    }

    public boolean prepareVideo(Context context, Uri uri, int bitRate, int rotation) throws IOException {
        return this.prepareVideo(context, uri, bitRate, rotation, -1, -1);
    }

    public boolean prepareVideo(Context context, Uri uri) throws IOException {
        return this.prepareVideo(context, uri, 1228800, 0);
    }

    public boolean prepareVideo(FileDescriptor fileDescriptor) throws IOException {
        return this.prepareVideo(fileDescriptor, 1228800, 0);
    }

    private boolean finishPrepareVideo(int bitRate, int rotation, int profile, int level) {
        boolean result = this.videoEncoder.prepareVideoEncoder(this.videoDecoder.getWidth(), this.videoDecoder.getHeight(), this.videoDecoder.getFps(), bitRate, rotation, 2, FormatVideoEncoder.SURFACE, profile, level);
        if (!result) {
            return false;
        }
        this.videoEnabled = result = this.videoDecoder.prepareVideo(this.videoEncoder.getInputSurface());
        return result;
    }

    public boolean prepareAudio(String filePath, int bitRate) throws IOException {
        if (!this.audioDecoder.initExtractor(filePath)) {
            return false;
        }
        return this.finishPrepareAudio(bitRate);
    }

    public boolean prepareAudio(FileDescriptor fileDescriptor, int bitRate) throws IOException {
        if (!this.audioDecoder.initExtractor(fileDescriptor)) {
            return false;
        }
        return this.finishPrepareAudio(bitRate);
    }

    public boolean prepareAudio(Context context, Uri uri, int bitRate) throws IOException {
        if (!this.audioDecoder.initExtractor(context, uri)) {
            return false;
        }
        return this.finishPrepareAudio(bitRate);
    }

    private boolean finishPrepareAudio(int bitRate) {
        this.audioDecoder.prepareAudio();
        boolean result = this.audioEncoder.prepareAudioEncoder(bitRate, this.audioDecoder.getSampleRate(), this.audioDecoder.isStereo());
        this.onAudioInfoImp(this.audioDecoder.isStereo(), this.audioDecoder.getSampleRate());
        this.audioEnabled = result;
        return result;
    }

    public boolean isAudioDeviceEnabled() {
        return this.audioTrackPlayer != null && this.audioTrackPlayer.getPlayState() == 3;
    }

    public void setEncoderErrorCallback(CodecErrorCallback encoderErrorCallback) {
        this.videoEncoder.setEncoderErrorCallback(encoderErrorCallback);
        this.audioEncoder.setEncoderErrorCallback(encoderErrorCallback);
    }

    public void playAudioDevice() {
        if (this.audioEnabled) {
            if (this.isAudioDeviceEnabled()) {
                this.audioTrackPlayer.stop();
            }
            int channel = this.audioDecoder.isStereo() ? 12 : 4;
            int buffSize = AudioTrack.getMinBufferSize((int)this.audioDecoder.getSampleRate(), (int)channel, (int)2);
            this.audioTrackPlayer = new AudioTrack(3, this.audioDecoder.getSampleRate(), channel, 2, buffSize, 1);
            this.audioTrackPlayer.play();
        }
    }

    public void stopAudioDevice() {
        if (this.audioEnabled && this.isAudioDeviceEnabled()) {
            this.audioTrackPlayer.stop();
            this.audioTrackPlayer = null;
        }
    }

    public boolean prepareAudio(String filePath) throws IOException {
        return this.prepareAudio(filePath, 65536);
    }

    public boolean prepareAudio(Context context, Uri uri) throws IOException {
        return this.prepareAudio(context, uri, 65536);
    }

    protected abstract void onAudioInfoImp(boolean var1, int var2);

    public void forceCodecType(CodecUtil.CodecType codecTypeVideo, CodecUtil.CodecType codecTypeAudio) {
        if (this.videoEnabled) {
            this.videoEncoder.forceCodecType(codecTypeVideo);
        }
        if (this.audioEnabled) {
            this.audioEncoder.forceCodecType(codecTypeAudio);
        }
    }

    public void startRecord(@NonNull String path, @Nullable RecordController.Listener listener) throws IOException {
        RecordController.RecordTracks tracks = RecordController.RecordTracks.ALL;
        if (!this.videoEnabled) {
            tracks = RecordController.RecordTracks.AUDIO;
        } else if (!this.audioEnabled) {
            tracks = RecordController.RecordTracks.VIDEO;
        }
        this.recordController.startRecord(path, listener, tracks);
        if (!this.streaming) {
            this.startEncoders();
        } else if (this.videoEncoder.isRunning()) {
            this.requestKeyFrame();
        }
    }

    public void startRecord(@NonNull String path) throws IOException {
        this.startRecord(path, null);
    }

    @RequiresApi(api=26)
    public void startRecord(@NonNull FileDescriptor fd, @Nullable RecordController.Listener listener) throws IOException {
        RecordController.RecordTracks tracks = RecordController.RecordTracks.ALL;
        if (!this.videoEnabled) {
            tracks = RecordController.RecordTracks.AUDIO;
        } else if (!this.audioEnabled) {
            tracks = RecordController.RecordTracks.VIDEO;
        }
        this.recordController.startRecord(fd, listener, tracks);
        if (!this.streaming) {
            this.startEncoders();
        } else if (this.videoEncoder.isRunning()) {
            this.requestKeyFrame();
        }
    }

    @RequiresApi(api=26)
    public void startRecord(@NonNull FileDescriptor fd) throws IOException {
        this.startRecord(fd, null);
    }

    public void stopRecord() {
        this.recordController.stopRecord();
        if (!this.streaming) {
            this.stopStream();
        }
    }

    protected abstract void startStreamImp(String var1);

    public void startStream(String url) {
        this.streaming = true;
        if (!this.recordController.isRunning()) {
            this.startEncoders();
        } else if (this.videoEnabled) {
            this.requestKeyFrame();
        }
        this.startStreamImp(url);
    }

    private void startEncoders() {
        long startTs = TimeUtils.getCurrentTimeMicro();
        if (this.videoEnabled) {
            this.videoEncoder.start(startTs);
        }
        if (this.audioTrackPlayer != null) {
            this.audioTrackPlayer.play();
        }
        if (this.audioEnabled) {
            this.audioEncoder.start(startTs);
        }
        if (this.videoEnabled) {
            this.prepareGlView();
        }
        if (this.videoEnabled) {
            this.videoDecoder.start();
        }
        if (this.audioEnabled) {
            this.audioDecoder.start();
        }
    }

    public void setDecoderErrorCallback(CodecErrorCallback codecErrorCallback) {
        this.audioDecoder.setCodecErrorCallback(codecErrorCallback);
        this.videoDecoder.setCodecErrorCallback(codecErrorCallback);
    }

    public void replaceView(Context context) {
        this.replaceGlInterface(new GlStreamInterface(context));
    }

    public void replaceView(OpenGlView openGlView) {
        this.replaceGlInterface(openGlView);
    }

    private void replaceGlInterface(GlInterface glInterface) {
        if (this.glInterface != null && this.videoEnabled) {
            if (this.isStreaming() || this.isRecording()) {
                this.videoDecoder.pauseRender();
                this.glInterface.removeMediaCodecSurface();
                this.glInterface.stop();
                this.glInterface = glInterface;
                this.prepareGlView();
                this.videoDecoder.resumeRender();
            } else {
                this.glInterface = glInterface;
            }
        }
    }

    private void prepareGlView() {
        if (this.glInterface != null) {
            int w = this.videoEncoder.getWidth();
            int h = this.videoEncoder.getHeight();
            boolean isPortrait = false;
            if (this.videoEncoder.getRotation() == 90 || this.videoEncoder.getRotation() == 270) {
                h = this.videoEncoder.getWidth();
                w = this.videoEncoder.getHeight();
                isPortrait = true;
            }
            this.glInterface.setEncoderSize(w, h);
            GlInterface glInterface = this.glInterface;
            if (glInterface instanceof GlStreamInterface) {
                GlStreamInterface glStreamInterface = (GlStreamInterface)glInterface;
                glStreamInterface.setPreviewResolution(w, h);
                glStreamInterface.setIsPortrait(isPortrait);
            }
            this.glInterface.setRotation(0);
            this.glInterface.start();
            if (this.videoEncoder.getInputSurface() != null) {
                this.videoDecoder.changeOutputSurface(this.glInterface.getSurface());
                this.glInterface.addMediaCodecSurface(this.videoEncoder.getInputSurface());
            }
        }
    }

    public void requestKeyFrame() {
        if (this.videoEncoder.isRunning()) {
            if (Build.VERSION.SDK_INT >= 19) {
                this.videoEncoder.requestKeyframe();
            } else {
                if (this.glInterface != null) {
                    this.glInterface.removeMediaCodecSurface();
                }
                this.videoEncoder.reset();
                if (this.glInterface != null) {
                    this.glInterface.addMediaCodecSurface(this.videoEncoder.getInputSurface());
                } else {
                    this.videoDecoder.changeOutputSurface(this.videoEncoder.getInputSurface());
                }
            }
        }
    }

    protected abstract void stopStreamImp();

    public void stopStream() {
        if (this.streaming) {
            this.streaming = false;
            this.stopStreamImp();
        }
        if (!this.recordController.isRecording()) {
            if (this.glInterface != null) {
                this.glInterface.removeMediaCodecSurface();
                this.glInterface.stop();
            }
            if (this.videoEnabled) {
                this.videoDecoder.stop();
            }
            if (this.audioEnabled) {
                this.audioDecoder.stop();
            }
            if (this.audioEnabled && this.isAudioDeviceEnabled()) {
                this.audioTrackPlayer.stop();
            }
            this.audioTrackPlayer = null;
            if (this.videoEnabled) {
                this.videoEncoder.stop();
            }
            if (this.audioEnabled) {
                this.audioEncoder.stop();
            }
            this.recordController.resetFormats();
            this.videoEnabled = false;
            this.audioEnabled = false;
        }
    }

    public void setLoopMode(boolean loopMode) {
        this.videoDecoder.setLoopMode(loopMode);
        this.audioDecoder.setLoopMode(loopMode);
    }

    public void reSyncFile() {
        if (this.isStreaming() && this.videoEnabled && this.audioEnabled) {
            this.audioDecoder.moveTo(this.videoDecoder.getTime());
        }
    }

    public GlInterface getGlInterface() {
        if (this.glInterface != null) {
            return this.glInterface;
        }
        throw new RuntimeException("You can't do it. You are not using Opengl");
    }

    public int getBitrate() {
        return this.videoEncoder.getBitRate();
    }

    public int getResolutionValue() {
        return this.videoEncoder.getWidth() * this.videoEncoder.getHeight();
    }

    public int getStreamWidth() {
        return this.videoEncoder.getWidth();
    }

    public int getStreamHeight() {
        return this.videoEncoder.getHeight();
    }

    @RequiresApi(api=19)
    public void setVideoBitrateOnFly(int bitrate) {
        this.videoEncoder.setVideoBitrateOnFly(bitrate);
    }

    public void forceFpsLimit(boolean enabled) {
        int fps = enabled ? this.videoEncoder.getFps() : 0;
        this.videoEncoder.setForceFps(fps);
        if (this.glInterface != null) {
            this.glInterface.forceFpsLimit(fps);
        }
    }

    public boolean resetVideoEncoder() {
        if (this.glInterface != null) {
            this.glInterface.removeMediaCodecSurface();
            boolean result = this.videoEncoder.reset();
            if (!result) {
                return false;
            }
            this.glInterface.addMediaCodecSurface(this.videoEncoder.getInputSurface());
        } else {
            boolean result = this.videoEncoder.reset();
            if (!result) {
                return false;
            }
            if (this.videoDecoder.isRunning()) {
                this.videoDecoder.changeOutputSurface(this.videoEncoder.getInputSurface());
            }
        }
        return true;
    }

    public boolean resetAudioEncoder() {
        return this.audioEncoder.reset();
    }

    public boolean isStreaming() {
        return this.streaming;
    }

    public boolean isRecording() {
        return this.recordController.isRunning();
    }

    public void pauseRecord() {
        this.recordController.pauseRecord();
    }

    public void resumeRecord() {
        this.recordController.resumeRecord();
    }

    public RecordController.Status getRecordStatus() {
        return this.recordController.getStatus();
    }

    public double getVideoTime() {
        return this.videoDecoder.getTime();
    }

    public double getAudioTime() {
        return this.audioDecoder.getTime();
    }

    public double getVideoDuration() {
        return this.videoDecoder.getDuration();
    }

    public double getAudioDuration() {
        return this.audioDecoder.getDuration();
    }

    public void replaceAudioFile(String filePath) throws IOException {
        this.resetAudioDecoder(decoder -> {
            if (!decoder.initExtractor(filePath)) {
                throw new IOException("Extraction failed");
            }
        });
    }

    public void replaceAudioFile(Context context, Uri uri) throws IOException {
        this.resetAudioDecoder(decoder -> {
            if (!decoder.initExtractor(context, uri)) {
                throw new IOException("Extraction failed");
            }
        });
    }

    public void replaceAudioFile(FileDescriptor fileDescriptor) throws IOException {
        this.resetAudioDecoder(decoder -> {
            if (!decoder.initExtractor(fileDescriptor)) {
                throw new IOException("Extraction failed");
            }
        });
    }

    public void replaceVideoFile(String filePath) throws IOException {
        this.resetVideoDecoder(decoder -> {
            if (!decoder.initExtractor(filePath)) {
                throw new IOException("Extraction failed");
            }
        });
    }

    public void replaceVideoFile(Context context, Uri uri) throws IOException {
        this.resetVideoDecoder(decoder -> {
            if (!decoder.initExtractor(context, uri)) {
                throw new IOException("Extraction failed");
            }
        });
    }

    public void replaceVideoFile(FileDescriptor fileDescriptor) throws IOException {
        this.resetVideoDecoder(decoder -> {
            if (!decoder.initExtractor(fileDescriptor)) {
                throw new IOException("Extraction failed");
            }
        });
    }

    private void resetVideoDecoder(IORunnable runnable) throws IOException {
        int width = this.videoDecoder.getWidth();
        int height = this.videoDecoder.getHeight();
        boolean wasRunning = this.videoDecoder.isRunning();
        VideoDecoder videoDecoder = new VideoDecoder(this.videoDecoderInterface, this.decoderInterfaceVideo);
        videoDecoder.setExtractor(this.videoDecoder.getExtractor());
        runnable.run((BaseDecoder)videoDecoder);
        if (width != videoDecoder.getWidth() || height != videoDecoder.getHeight()) {
            throw new IOException("Resolution must be the same that the previous file");
        }
        this.videoDecoder.stop();
        this.videoDecoder = videoDecoder;
        videoDecoder.prepareVideo(this.glInterface.getSurface());
        if (wasRunning) {
            videoDecoder.start();
        }
    }

    private void resetAudioDecoder(IORunnable runnable) throws IOException {
        int sampleRate = this.audioDecoder.getSampleRate();
        boolean isStereo = this.audioDecoder.isStereo();
        boolean wasRunning = this.audioDecoder.isRunning();
        AudioDecoder audioDecoder = new AudioDecoder(this.getMicrophoneData, this.audioDecoderInterface, this.decoderInterfaceAudio);
        audioDecoder.setExtractor(this.audioDecoder.getExtractor());
        runnable.run((BaseDecoder)audioDecoder);
        if (sampleRate != audioDecoder.getSampleRate()) {
            throw new IOException("SampleRate must be the same that the previous file");
        }
        if (isStereo != audioDecoder.isStereo()) {
            throw new IOException("Channels must be the same that the previous file");
        }
        this.audioDecoder.stop();
        this.audioDecoder = audioDecoder;
        audioDecoder.prepareAudio();
        if (wasRunning) {
            audioDecoder.start();
        }
    }

    public void moveTo(double time) {
        if (this.videoEnabled) {
            this.videoDecoder.moveTo(time);
        }
        if (this.audioEnabled) {
            this.audioDecoder.moveTo(time);
        }
    }

    public void setVideoExtractor(Extractor extractor) {
        this.videoDecoder.setExtractor(extractor);
    }

    public void setAudioExtractor(Extractor extractor) {
        this.audioDecoder.setExtractor(extractor);
    }

    protected abstract void onVideoInfoImp(ByteBuffer var1, ByteBuffer var2, ByteBuffer var3);

    protected abstract void getVideoDataImp(ByteBuffer var1, MediaCodec.BufferInfo var2);

    protected abstract void getAudioDataImp(ByteBuffer var1, MediaCodec.BufferInfo var2);

    public void setRecordController(BaseRecordController recordController) {
        if (!this.isRecording()) {
            this.recordController = recordController;
        }
    }

    public abstract StreamBaseClient getStreamClient();

    public void setVideoCodec(VideoCodec codec) {
        this.setVideoCodecImp(codec);
        this.recordController.setVideoCodec(codec);
        String type = switch (codec) {
            default -> throw new IncompatibleClassChangeError();
            case VideoCodec.H264 -> "video/avc";
            case VideoCodec.H265 -> "video/hevc";
            case VideoCodec.AV1 -> "video/av01";
        };
        this.videoEncoder.setType(type);
    }

    public void setAudioCodec(AudioCodec codec) {
        this.setAudioCodecImp(codec);
        this.recordController.setAudioCodec(codec);
        String type = switch (codec) {
            default -> throw new IncompatibleClassChangeError();
            case AudioCodec.G711 -> "audio/g711-alaw";
            case AudioCodec.AAC -> "audio/mp4a-latm";
            case AudioCodec.OPUS -> "audio/opus";
        };
        this.audioEncoder.setType(type);
    }

    protected abstract void setVideoCodecImp(VideoCodec var1);

    protected abstract void setAudioCodecImp(AudioCodec var1);
}

