/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.library.util.streamclient;

import com.pedro.common.socket.base.SocketType;
import com.pedro.library.util.streamclient.RtmpStreamClient;
import com.pedro.library.util.streamclient.RtspStreamClient;
import com.pedro.library.util.streamclient.SrtStreamClient;
import com.pedro.library.util.streamclient.StreamBaseClient;
import com.pedro.library.util.streamclient.UdpStreamClient;
import com.pedro.rtsp.rtsp.Protocol;
import com.pedro.srt.srt.packets.control.handshake.EncryptionType;
import javax.net.ssl.TrustManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u0007\n\u0002\b\u0019\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u000e\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u0017\u001a\u00020\u000e2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019J\u0016\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u001cJ\u000e\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010 \u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\"J\u000e\u0010#\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020%J\u001c\u0010&\u001a\u00020\u000e2\b\u0010'\u001a\u0004\u0018\u00010\u00162\b\u0010(\u001a\u0004\u0018\u00010\u0016H\u0016J\u0010\u0010)\u001a\u00020\u000e2\u0006\u0010*\u001a\u00020%H\u0016J\"\u0010+\u001a\u00020\"2\u0006\u0010,\u001a\u00020\u00132\u0006\u0010-\u001a\u00020\u00162\b\u0010.\u001a\u0004\u0018\u00010\u0016H\u0016J\u0010\u0010/\u001a\u00020\"2\u0006\u00100\u001a\u000201H\u0016J\u0010\u00102\u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u00103\u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u00104\u001a\u00020\u000e2\u0006\u00105\u001a\u00020%H\u0016J\b\u00106\u001a\u00020\u000eH\u0016J\b\u00107\u001a\u00020%H\u0016J\b\u00108\u001a\u00020%H\u0016J\b\u00109\u001a\u00020\u0013H\u0016J\b\u0010:\u001a\u00020\u0013H\u0016J\b\u0010;\u001a\u00020\u0013H\u0016J\b\u0010<\u001a\u00020\u0013H\u0016J\b\u0010=\u001a\u00020\u000eH\u0016J\b\u0010>\u001a\u00020\u000eH\u0016J\b\u0010?\u001a\u00020\u000eH\u0016J\b\u0010@\u001a\u00020\u000eH\u0016J\u0010\u0010A\u001a\u00020\u000e2\u0006\u0010B\u001a\u00020\"H\u0016J\u0010\u0010C\u001a\u00020\u000e2\u0006\u0010D\u001a\u00020\"H\u0016J\u000e\u0010E\u001a\u00020\u000e2\u0006\u0010F\u001a\u00020\u0016J\u0010\u0010G\u001a\u00020\u000e2\u0006\u0010H\u001a\u000201H\u0016J\b\u0010I\u001a\u000201H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006J"}, d2={"Lcom/pedro/library/util/streamclient/GenericStreamClient;", "Lcom/pedro/library/util/streamclient/StreamBaseClient;", "rtmpClient", "Lcom/pedro/library/util/streamclient/RtmpStreamClient;", "rtspClient", "Lcom/pedro/library/util/streamclient/RtspStreamClient;", "srtClient", "Lcom/pedro/library/util/streamclient/SrtStreamClient;", "udpClient", "Lcom/pedro/library/util/streamclient/UdpStreamClient;", "<init>", "(Lcom/pedro/library/util/streamclient/RtmpStreamClient;Lcom/pedro/library/util/streamclient/RtspStreamClient;Lcom/pedro/library/util/streamclient/SrtStreamClient;Lcom/pedro/library/util/streamclient/UdpStreamClient;)V", "connectedStreamClient", "setSocketType", "", "type", "Lcom/pedro/common/socket/base/SocketType;", "setDelay", "millis", "", "setFlashVersion", "flashVersion", "", "addCertificates", "certificates", "Ljavax/net/ssl/TrustManager;", "setPassphrase", "passphrase", "Lcom/pedro/srt/srt/packets/control/handshake/EncryptionType;", "setProtocol", "protocol", "Lcom/pedro/rtsp/rtsp/Protocol;", "forceIncrementalTs", "enabled", "", "setWriteChunkSize", "chunkSize", "", "setAuthorization", "user", "password", "setReTries", "reTries", "reTry", "delay", "reason", "backupUrl", "hasCongestion", "percentUsed", "", "setLogs", "setCheckServerAlive", "resizeCache", "newSize", "clearCache", "getCacheSize", "getItemsInCache", "getSentAudioFrames", "getSentVideoFrames", "getDroppedAudioFrames", "getDroppedVideoFrames", "resetSentAudioFrames", "resetSentVideoFrames", "resetDroppedAudioFrames", "resetDroppedVideoFrames", "setOnlyAudio", "onlyAudio", "setOnlyVideo", "onlyVideo", "connecting", "url", "setBitrateExponentialFactor", "factor", "getBitrateExponentialFactor", "library_release"})
public final class GenericStreamClient
extends StreamBaseClient {
    @NotNull
    private final RtmpStreamClient rtmpClient;
    @NotNull
    private final RtspStreamClient rtspClient;
    @NotNull
    private final SrtStreamClient srtClient;
    @NotNull
    private final UdpStreamClient udpClient;
    @Nullable
    private StreamBaseClient connectedStreamClient;

    public GenericStreamClient(@NotNull RtmpStreamClient rtmpClient, @NotNull RtspStreamClient rtspClient, @NotNull SrtStreamClient srtClient, @NotNull UdpStreamClient udpClient) {
        Intrinsics.checkNotNullParameter((Object)rtmpClient, (String)"rtmpClient");
        Intrinsics.checkNotNullParameter((Object)rtspClient, (String)"rtspClient");
        Intrinsics.checkNotNullParameter((Object)srtClient, (String)"srtClient");
        Intrinsics.checkNotNullParameter((Object)udpClient, (String)"udpClient");
        this.rtmpClient = rtmpClient;
        this.rtspClient = rtspClient;
        this.srtClient = srtClient;
        this.udpClient = udpClient;
    }

    @Override
    public void setSocketType(@NotNull SocketType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        this.rtmpClient.setSocketType(type);
        this.rtspClient.setSocketType(type);
        this.srtClient.setSocketType(type);
        this.udpClient.setSocketType(type);
    }

    @Override
    public void setDelay(long millis) {
        this.rtmpClient.setDelay(millis);
        this.rtspClient.setDelay(millis);
        this.srtClient.setDelay(millis);
        this.udpClient.setDelay(millis);
    }

    public final void setFlashVersion(@NotNull String flashVersion) {
        Intrinsics.checkNotNullParameter((Object)flashVersion, (String)"flashVersion");
        this.rtmpClient.setFlashVersion(flashVersion);
    }

    public final void addCertificates(@Nullable TrustManager certificates) {
        this.rtmpClient.addCertificates(certificates);
        this.rtspClient.addCertificates(certificates);
    }

    public final void setPassphrase(@NotNull String passphrase, @NotNull EncryptionType type) {
        Intrinsics.checkNotNullParameter((Object)passphrase, (String)"passphrase");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        this.srtClient.setPassphrase(passphrase, type);
    }

    public final void setProtocol(@NotNull Protocol protocol) {
        Intrinsics.checkNotNullParameter((Object)protocol, (String)"protocol");
        this.rtspClient.setProtocol(protocol);
    }

    public final void forceIncrementalTs(boolean enabled) {
        this.rtmpClient.forceIncrementalTs(enabled);
    }

    public final void setWriteChunkSize(int chunkSize) {
        this.rtmpClient.setWriteChunkSize(chunkSize);
    }

    @Override
    public void setAuthorization(@Nullable String user, @Nullable String password) {
        this.rtmpClient.setAuthorization(user, password);
        this.rtspClient.setAuthorization(user, password);
        this.srtClient.setAuthorization(user, password);
    }

    @Override
    public void setReTries(int reTries) {
        this.rtmpClient.setReTries(reTries);
        this.rtspClient.setReTries(reTries);
        this.srtClient.setReTries(reTries);
        this.udpClient.setReTries(reTries);
    }

    @Override
    public boolean reTry(long delay, @NotNull String reason, @Nullable String backupUrl) {
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        StreamBaseClient streamBaseClient = this.connectedStreamClient;
        return streamBaseClient != null ? streamBaseClient.reTry(delay, reason, backupUrl) : false;
    }

    @Override
    public boolean hasCongestion(float percentUsed) {
        StreamBaseClient streamBaseClient = this.connectedStreamClient;
        return streamBaseClient != null ? streamBaseClient.hasCongestion(percentUsed) : false;
    }

    @Override
    public void setLogs(boolean enabled) {
        this.rtmpClient.setLogs(enabled);
        this.rtspClient.setLogs(enabled);
        this.srtClient.setLogs(enabled);
        this.udpClient.setLogs(enabled);
    }

    @Override
    public void setCheckServerAlive(boolean enabled) {
        this.rtmpClient.setCheckServerAlive(enabled);
        this.rtspClient.setCheckServerAlive(enabled);
        this.srtClient.setCheckServerAlive(enabled);
    }

    @Override
    public void resizeCache(int newSize) {
        this.rtmpClient.resizeCache(newSize);
        this.rtspClient.resizeCache(newSize);
        this.srtClient.resizeCache(newSize);
        this.udpClient.resizeCache(newSize);
    }

    @Override
    public void clearCache() {
        this.rtmpClient.clearCache();
        this.rtspClient.clearCache();
        this.srtClient.clearCache();
        this.udpClient.clearCache();
    }

    @Override
    public int getCacheSize() {
        StreamBaseClient streamBaseClient = this.connectedStreamClient;
        return streamBaseClient != null ? streamBaseClient.getCacheSize() : 0;
    }

    @Override
    public int getItemsInCache() {
        StreamBaseClient streamBaseClient = this.connectedStreamClient;
        return streamBaseClient != null ? streamBaseClient.getItemsInCache() : 0;
    }

    @Override
    public long getSentAudioFrames() {
        StreamBaseClient streamBaseClient = this.connectedStreamClient;
        return streamBaseClient != null ? streamBaseClient.getSentAudioFrames() : 0L;
    }

    @Override
    public long getSentVideoFrames() {
        StreamBaseClient streamBaseClient = this.connectedStreamClient;
        return streamBaseClient != null ? streamBaseClient.getSentVideoFrames() : 0L;
    }

    @Override
    public long getDroppedAudioFrames() {
        StreamBaseClient streamBaseClient = this.connectedStreamClient;
        return streamBaseClient != null ? streamBaseClient.getDroppedAudioFrames() : 0L;
    }

    @Override
    public long getDroppedVideoFrames() {
        StreamBaseClient streamBaseClient = this.connectedStreamClient;
        return streamBaseClient != null ? streamBaseClient.getDroppedVideoFrames() : 0L;
    }

    @Override
    public void resetSentAudioFrames() {
        this.rtmpClient.resetSentAudioFrames();
        this.rtspClient.resetSentAudioFrames();
        this.srtClient.resetSentAudioFrames();
        this.udpClient.resetSentAudioFrames();
    }

    @Override
    public void resetSentVideoFrames() {
        this.rtmpClient.resetSentVideoFrames();
        this.rtspClient.resetSentVideoFrames();
        this.srtClient.resetSentVideoFrames();
        this.udpClient.resetSentVideoFrames();
    }

    @Override
    public void resetDroppedAudioFrames() {
        this.rtmpClient.resetDroppedAudioFrames();
        this.rtspClient.resetDroppedAudioFrames();
        this.srtClient.resetDroppedAudioFrames();
        this.udpClient.resetDroppedAudioFrames();
    }

    @Override
    public void resetDroppedVideoFrames() {
        this.rtmpClient.resetDroppedVideoFrames();
        this.rtspClient.resetDroppedVideoFrames();
        this.srtClient.resetDroppedVideoFrames();
        this.udpClient.resetDroppedVideoFrames();
    }

    @Override
    public void setOnlyAudio(boolean onlyAudio) {
        this.rtmpClient.setOnlyAudio(onlyAudio);
        this.rtspClient.setOnlyAudio(onlyAudio);
        this.srtClient.setOnlyAudio(onlyAudio);
        this.udpClient.setOnlyAudio(onlyAudio);
    }

    @Override
    public void setOnlyVideo(boolean onlyVideo) {
        this.rtmpClient.setOnlyVideo(onlyVideo);
        this.rtspClient.setOnlyVideo(onlyVideo);
        this.srtClient.setOnlyVideo(onlyVideo);
        this.udpClient.setOnlyVideo(onlyVideo);
    }

    public final void connecting(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.connectedStreamClient = StringsKt.startsWith((String)url, (String)"rtmp", (boolean)true) ? (StreamBaseClient)this.rtmpClient : (StringsKt.startsWith((String)url, (String)"rtsp", (boolean)true) ? (StreamBaseClient)this.rtspClient : (StringsKt.startsWith((String)url, (String)"srt", (boolean)true) ? (StreamBaseClient)this.srtClient : (StringsKt.startsWith((String)url, (String)"udp", (boolean)true) ? (StreamBaseClient)this.udpClient : null)));
    }

    @Override
    public void setBitrateExponentialFactor(float factor) {
        this.rtmpClient.setBitrateExponentialFactor(factor);
        this.rtspClient.setBitrateExponentialFactor(factor);
        this.srtClient.setBitrateExponentialFactor(factor);
        this.udpClient.setBitrateExponentialFactor(factor);
    }

    @Override
    public float getBitrateExponentialFactor() {
        StreamBaseClient streamBaseClient = this.connectedStreamClient;
        return streamBaseClient != null ? streamBaseClient.getBitrateExponentialFactor() : 1.0f;
    }
}

