/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.library.util.streamclient;

import com.pedro.library.util.streamclient.StreamBaseClient;
import com.pedro.library.util.streamclient.StreamClientListener;
import com.pedro.udp.UdpClient;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0018\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001c\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u000bH\u0016J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\"\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000b2\b\u0010\u0015\u001a\u0004\u0018\u00010\u000bH\u0016J\u0010\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u0011H\u0016J\u0010\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u0011H\u0016J\u0010\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u000fH\u0016J\b\u0010\u001e\u001a\u00020\tH\u0016J\b\u0010\u001f\u001a\u00020\u000fH\u0016J\b\u0010 \u001a\u00020\u000fH\u0016J\b\u0010!\u001a\u00020\u0013H\u0016J\b\u0010\"\u001a\u00020\u0013H\u0016J\b\u0010#\u001a\u00020\u0013H\u0016J\b\u0010$\u001a\u00020\u0013H\u0016J\b\u0010%\u001a\u00020\tH\u0016J\b\u0010&\u001a\u00020\tH\u0016J\b\u0010'\u001a\u00020\tH\u0016J\b\u0010(\u001a\u00020\tH\u0016J\u0010\u0010)\u001a\u00020\t2\u0006\u0010*\u001a\u00020\u0011H\u0016J\u0010\u0010+\u001a\u00020\t2\u0006\u0010,\u001a\u00020\u0011H\u0016J\u0010\u0010-\u001a\u00020\t2\u0006\u0010.\u001a\u00020\u0018H\u0016J\b\u0010/\u001a\u00020\u0018H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/pedro/library/util/streamclient/UdpStreamClient;", "Lcom/pedro/library/util/streamclient/StreamBaseClient;", "udpClient", "Lcom/pedro/udp/UdpClient;", "streamClientListener", "Lcom/pedro/library/util/streamclient/StreamClientListener;", "<init>", "(Lcom/pedro/udp/UdpClient;Lcom/pedro/library/util/streamclient/StreamClientListener;)V", "setAuthorization", "", "user", "", "password", "setReTries", "reTries", "", "reTry", "", "delay", "", "reason", "backupUrl", "hasCongestion", "percentUsed", "", "setLogs", "enabled", "setCheckServerAlive", "resizeCache", "newSize", "clearCache", "getCacheSize", "getItemsInCache", "getSentAudioFrames", "getSentVideoFrames", "getDroppedAudioFrames", "getDroppedVideoFrames", "resetSentAudioFrames", "resetSentVideoFrames", "resetDroppedAudioFrames", "resetDroppedVideoFrames", "setOnlyAudio", "onlyAudio", "setOnlyVideo", "onlyVideo", "setBitrateExponentialFactor", "factor", "getBitrateExponentialFactor", "library_release"})
public final class UdpStreamClient
extends StreamBaseClient {
    @NotNull
    private final UdpClient udpClient;
    @Nullable
    private final StreamClientListener streamClientListener;

    public UdpStreamClient(@NotNull UdpClient udpClient, @Nullable StreamClientListener streamClientListener2) {
        Intrinsics.checkNotNullParameter((Object)udpClient, (String)"udpClient");
        this.udpClient = udpClient;
        this.streamClientListener = streamClientListener2;
    }

    @Override
    public void setAuthorization(@Nullable String user, @Nullable String password) {
    }

    @Override
    public void setReTries(int reTries) {
        this.udpClient.setReTries(reTries);
    }

    @Override
    public boolean reTry(long delay, @NotNull String reason, @Nullable String backupUrl) {
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        boolean result = this.udpClient.shouldRetry(reason);
        if (result) {
            StreamClientListener streamClientListener2 = this.streamClientListener;
            if (streamClientListener2 != null) {
                streamClientListener2.onRequestKeyframe();
            }
            this.udpClient.reConnect(delay, backupUrl);
        }
        return result;
    }

    @Override
    public boolean hasCongestion(float percentUsed) {
        return this.udpClient.hasCongestion(percentUsed);
    }

    @Override
    public void setLogs(boolean enabled) {
        this.udpClient.setLogs(enabled);
    }

    @Override
    public void setCheckServerAlive(boolean enabled) {
    }

    @Override
    public void resizeCache(int newSize) {
        this.udpClient.resizeCache(newSize);
    }

    @Override
    public void clearCache() {
        this.udpClient.clearCache();
    }

    @Override
    public int getCacheSize() {
        return this.udpClient.getCacheSize();
    }

    @Override
    public int getItemsInCache() {
        return this.udpClient.getItemsInCache();
    }

    @Override
    public long getSentAudioFrames() {
        return this.udpClient.getSentAudioFrames();
    }

    @Override
    public long getSentVideoFrames() {
        return this.udpClient.getSentVideoFrames();
    }

    @Override
    public long getDroppedAudioFrames() {
        return this.udpClient.getDroppedAudioFrames();
    }

    @Override
    public long getDroppedVideoFrames() {
        return this.udpClient.getDroppedVideoFrames();
    }

    @Override
    public void resetSentAudioFrames() {
        this.udpClient.resetSentAudioFrames();
    }

    @Override
    public void resetSentVideoFrames() {
        this.udpClient.resetSentVideoFrames();
    }

    @Override
    public void resetDroppedAudioFrames() {
        this.udpClient.resetDroppedAudioFrames();
    }

    @Override
    public void resetDroppedVideoFrames() {
        this.udpClient.resetDroppedVideoFrames();
    }

    @Override
    public void setOnlyAudio(boolean onlyAudio) {
        this.udpClient.setOnlyAudio(onlyAudio);
    }

    @Override
    public void setOnlyVideo(boolean onlyVideo) {
        this.udpClient.setOnlyVideo(onlyVideo);
    }

    @Override
    public void setBitrateExponentialFactor(float factor) {
        this.udpClient.setBitrateExponentialFactor(factor);
    }

    @Override
    public float getBitrateExponentialFactor() {
        return this.udpClient.getBitrateExponentialFactor();
    }
}

